@Echo off
 REM ===========================================================================
 REM BasisSkript fr PLM Performance Analyse V3
 REM (c) J.Feuerstein/S.Gueth 14.12.2015
 rem
 REM Aenderungs Info:
 REM Date/Time  User     Infotext:
 REM 14.12.2015 S.Gueth  Ersterstellung
 REM 18.12.2023 J.Fes    add Paramter -IgnoreMultipleLoggedInUsers
 REM ===========================================================================

 Echo **************************************************************************
 Echo * Excuting PLMPerformace Analyse V4 Script                               *
 Echo * Version: 18.12.20230 addPLM GmbH (c)                                   *
 Echo **************************************************************************

setlocal
 REM -- #Step: Farbe setzen IsIdel
 call :ColorSet IsIdel

REM  call Echo "--- #Step: Set Up Base ---------------------------------------------------"
REM  if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"

 if not defined NxPLMPerfClient_CustomSetEnv_cmd set NxPLMPerfClient_CustomSetEnv_cmd=%CmdCurRoot_DP%\NxPLMPerfClient_CustomSetEnv.cmd

 call Echo "--- #Step: ExecutePLMPerfViaJournal --------------------------------------"


 if not defined JobTemp_TP set JobTemp_TP=JobTemp
 call :ExecutePLMPerfViaJournal "%CmdCurRoot_DP%\%JobTemp_TP%"

 endlocal& set PrgExitCode=%PrgExitCode%
goto :end


rem ============================================================================
:ExecutePLMPerfViaJournal
 rem #Doc: Main Function to run PLMPerf vie NX Journal
 rem #Doc get File Params
 set temp=%~1
 if not exist "%temp%" md "%temp%"

 set tmp=%temp%
 set HOME=%temp%

 REM -- set Custom.Environ
 if exist "%NxPLMPerfClient_CustomSetEnv_cmd%" call "%NxPLMPerfClient_CustomSetEnv_cmd%"

 if "%fccCache_Clear_DO%" neq "YES" goto :fccCache_Clear_DO_JumpOver
   setlocal
   set fccCache_Clear_log_DPNE=%temp%\zzfccCache_Clear_log.txt
   Call Echo "do fccCache clear on............: \\%ComputerName%"
   call Echo "fccCache_Clear_log_DPNE.........: %fccCache_Clear_log_DPNE%"
   REM call fccstat -restart
   call fccstat -status>>"%fccCache_Clear_log_DPNE%"
   call fccstat -clear>>"%fccCache_Clear_log_DPNE%"
   call fccstat -purge>>"%fccCache_Clear_log_DPNE%"
   call fccstat -status>>"%fccCache_Clear_log_DPNE%"

   if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
    REM set toRun=%toRun% -verbose -pauseOnEnd
    call Echo "---------------------------------------------------------------------------"
    call Echo "#Debug..........................: fccCache_Clear done"
    pause
   :JumbOverDebug
   endlocal
:fccCache_Clear_DO_JumpOver

REM  set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
REM  title %titleTxt%

 call :ColorSet IsExecuting
 Echo.
REM  Echo %titleTxt%
 call Echo "----------------------------------------------------------------------------"
 Call Echo "Journal Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.........................: %JobName%"
 Call Echo "Computer........................: %ComputerName%"
 Call Echo "JobDir..........................: %temp%"
 Call Echo "TcSide..........................: %TcSiteId%"
 Call Echo "TcUser..........................: %JobMgr_TcUser%"
 Call Echo "FMS_HOME........................: %FMS_HOME%"
 Call Echo "TC_ROOT.........................: %TC_ROOT%"
 Call Echo "TC_DATA.........................: %TC_DATA%"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "UGII_LOAD_OPTIONS...............: %UGII_LOAD_OPTIONS%"
 Call Echo "UGII_SITE_DIR...................: %UGII_SITE_DIR%"
 Call Echo "UGII_LOCAL_USER_DEF.............: %UGII_LOCAL_USER_DEFAULTS%"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "fccCache_Clear_DO...............: %fccCache_Clear_DO%"
 Call Echo "PLMPerf ImportConfigName........: %ImportConfigName%"

 cd /d "%temp%"

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "NxDataProcessing_2013_09"
 set toRun=%toRun% -SubAction "NXJournalExecute"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
REM  set toRun=%toRun% -ShellExecProg_DPNE "%UGII_ROOT_DIR%\run_journal.exe"
 set toRun=%toRun% -ShellExecProg_DPNE "%UGII_NXBIN_DIR%\run_journal.exe"
 rem set toRun=%toRun% -ShellExecArguments "-arg1 -arg2"
 set toRun=%toRun% -ShellExecMaxDuration_min %NXJournalMaxDuration_min%
 set toRun=%toRun% -NXJournalTemplate_DPNE "%NXJournalTemplate_DPNE%"
 set toRun=%toRun% -JobParaDoPrint
 set toRun=%toRun% -JobTemp_DP "%temp%"
 set toRun=%toRun% -NXCB_UGII_LOAD_OPTIONS_NE "%UGII_LOAD_OPTIONS_NE%"

 if "%TC_ROOT%" equ "" goto :NextStep
   set toRun=%toRun% -u "%JobMgr_TcUser%" -p "%JobMgr_TcPw%"
   if defined JobMgr_TcGroup set toRun=%toRun% -g "%JobMgr_TcGroup%"
:NextStep

 if "%UGII_UGMGR_HTTP_URL%" equ "" goto :NextStep
   set toRun=%toRun% -u "%JobMgr_TcUser%" -p "%JobMgr_TcPw%"
   if defined JobMgr_TcGroup set toRun=%toRun% -g "%JobMgr_TcGroup%"
:NextStep

 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -JobData2ResultsDoPrint

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  REM set toRun=%toRun% -verbose -pauseOnEnd
  set toRunForPrint=%toRun:"='%
  call Echo "---------------------------------------------------------------------------"
  call Echo "#Debug..........................: BeforeProcess"
  call Echo "#toRun..........................: %toRunForPrint%"
  pause
 :JumbOverDebug

 set >>"%temp%\zzEnvBeforeProcess.txt"
 call %toRun%
 set PrgExitCode=%errorlevel%

 call Echo "--- #Res.: PrgExitCode.: [%PrgExitCode%] ---------------------------------------------"
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  call Echo "---------------------------------------------------------------------------"
  call Echo "#Debug..........................: "
  call Echo "#PrgExitCode....................: %PrgExitCode%"
  pause
 :JumbOverDebug

 call Echo "--- #Evaluate PLMPerf Result -----------------------------------------------------------------"

 set ImportConfigXml_DPNE=%PLMPerf_Custom_DP%\ImportConfig.x*
 set ImportConfigXmlL_DPNE=%temp%\ImportConfig.xml
 set toRun=copy "%ImportConfigXml_DPNE%" "%temp%\*.*"
 call %toRun%
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  REM set toRun=%toRun% -verbose -pauseOnEnd
  set toRunForPrint=%toRun:"='%
  call Echo "---------------------------------------------------------------------------"
  call Echo "#Debug..........................: "
  call Echo "#toRun..........................: %toRunForPrint%"
  pause
 :JumbOverDebug
 set ReturnResultCmdFile_DPNE=%temp%\PLMPerfResult_Vaules.cmd

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "PLMPerfSyslogParser_2012_01"
 set toRun=%toRun% -SubAction "ViaNxSyslog"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -SyslogFindMask "%temp%\%UserName%*.syslog"
 set toRun=%toRun% -ImportConfigXml "%ImportConfigXmlL_DPNE%"
 set toRun=%toRun% -ImportConfigName "%ImportConfigName%"
 set toRun=%toRun% -IgnoreMultipleLoggedInUsers
 if defined TcSiteIdTarget set toRun=%toRun% -extract_FromSiteID "%TcSiteIdTarget%"
 set toRun=%toRun% -ReturnResultCmdFile "%ReturnResultCmdFile_DPNE%"
REM  set toRun=%toRun% -TotalReal_SendMail_IFGT "%MailToUserIfValueGT%"
REM  set toRun=%toRun% -LoadUpdCpuReal_SendMail_IFGT "%MailToUserIfValueGT%"
REM  set toRun=%toRun% -LoadUpdCpu_SendMail_IFGT "%MailToUserIfValueGT%"
 rem new 27.05.2016 S.Gueth added support for 4 tier list users
REM  if defined ListUsers_4Tier_prog set toRun=%toRun% -ShellExecProg_DPNE "%ListUsers_4Tier_prog%"
REM  if defined ListUsers_4Tier_args set toRun=%toRun% -ShellExecArguments "%ListUsers_4Tier_args%"
 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -JobData2ResultsDoPrint
 set toRun=%toRun% -JobParaDoPrint
REM  if /I "%UserCount_Custom%" equ "YES"  set toRun=%toRun% -UserCount

 if "%TC_ROOT%" equ "" goto :NextStep
   set toRun=%toRun% -u "%JobMgr_TcUser%" -p "%JobMgr_TcPw%"
   if defined JobMgr_TcGroup set toRun=%toRun% -g "%JobMgr_TcGroup%"
:NextStep


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_02NXJournalEval.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo #Debug.: before: [PLMPerfSyslogParser]
   Echo %toRun% >>"%Debug_DPNE%"
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
   pause
:JumbOverDebug

 call %toRun%

 Call Echo "End NxPLMPerfClient_Execute" "" "NOECHO"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo #Debug: Job Results Info:
   Echo #Debug: PrgExitCode: %PrgExitCode%
   pause
:JumbOver


goto :eof

REM ####### ------------ Standard Subroutines ---------------------- ###########
REM ============================================================================


REM ============================================================================
:ColorSet
Rem Stand 25.06.2011
 REM call :ColorSet Standard
 REM call :ColorSet IsExecuting
 REM call :ColorSet IsIdel
 REM call :ColorSet End
 REM call :ColorSet Ende
 REM call :ColorSet Ok
 REM call :ColorSet Err

 if /I "%~1" equ "Standard"    set JobColorLast=70
 if /I "%~1" equ "IsExecuting" set JobColorLast=E0
 if /I "%~1" equ "ExtractLi"   set JobColorLast=B0
 if /I "%~1" equ "EvalResult"  set JobColorLast=B1
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 if /I "%~1" equ "Err"         set JobColorLast=C0

 REM set color
 if "%JobColorLast%" neq "" color %JobColorLast%
 goto :eof

REM ============================================================================
:end

