 @Echo off
REM ===========================================================================
REM CustomSkript fr PLMPerformanceAnalyseV3
REM (c) addPLM - GmbH
rem
REM Aenderungs Info:
REM Date       User    Infotext:
REM 28.10.2020 J.Fes   Created
REM 22.11.2023 J.Fes   Cleand
REM 13.02.2024 J.Fes   Optim
REM ===========================================================================

 set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 Call Echo "***************************************************************************"
 Call Echo "* Excuting PLMPerf Analyse Script V6                                      *"
 Call Echo "* Version: 13.02.2024 addPLM GmbH (c)                                     *"
 Call Echo "***************************************************************************"
 Call Echo "%titleTxt%"
 Call Echo "***************************************************************************"

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 REM -- Basiseinstellungen fuer das Verhalten des Scriptes ---------------------
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 REM -- #Doc: Inits all Basics of Job
 Call "%~dp0_JobInitial.cmd" "PLMPerf" "YES" "NO" "YES" "NO" "NO"

 rem #todo: set PLMPerf.Custom DP to get the PLMPerf Settings
 set PLMPerf_Custom_DP=J:\PLMPerfV3\01-PLMPerf.Custom.addPLM

 rem set Waittime ater perf messaument is done default=120 sec
 set PLMPerf_WaitAfterJobDone=120
 set PLMPerf_WaitAfterJobDone=5

 call :PLMPerfExecute

 rem #LUp:13.10.2020/J.Fes using _JobFinish at JobEnd
 Call "%~dp0_JobFinish.cmd"

goto :eof

rem ----------------------------------------------------------------------------
:PLMPerfExecute
 setlocal
 rem -- #Doc: check if TCPrompt.cmd is available
 if not exist "%TCPrompt_Custom_DPNE%" goto :TcPromtCmdError

 REM -- #New: 23.08.2018/J.Fes Disable/Enable usage of: fccCheck
 set JobMgr_fccCheck_USE=true
 set toRun=
 rem -- #Doc: define default JobMgr_PLMPerfScenario if not set
 rem -- #Exa: JobMgr_PLMPerfScenario=TC14p+NX2306 (see values at JS:Scripts/Param JC.Script(cmd).ParamExt)
 if not defined JobMgr_PLMPerfScenario set JobMgr_PLMPerfScenario=SC01

 rem --#Doc:04.02.2024 do in case SC01_K10+NX11 also  SC01_P10+NX11
 rem #Doc: #P1=TCPrompt_Custom_Opt(NX2306) #P2=TC_use_tier(2tier/4tier) #P3=PLMPerf_ScenarioSubKey('TC14i+NX2306') #P4=TcSiteIdTarget
 if "%JobMgr_PLMPerfScenario%" equ "SC01_#Custom1-Key#" call :PLMPerf_ScenarioSC01 "NXv1xx"   "4tier" "#PLMPerf_ScenarioSubKey1#"   "#TcSiteId1#"
 if "%JobMgr_PLMPerfScenario%" equ "SC01_#Custom1-Key#" call :PLMPerf_ScenarioSC01 "NXv1xx"   "4tier" "#PLMPerf_ScenarioSubKey2#"   "#TcSiteId2#"
 if /i "%JobMgr_Test%" equ "ON" set JobMgr_Test=OFF
 if "%JobMgr_PLMPerfScenario%" equ "SC01_#Custom2-Key#" call :PLMPerf_ScenarioSC01 "NXv2xxx" "4tier" "#PLMPerf_ScenarioSubKey3#" "#TcSiteId3#"


 rem --#Doc: wait time after PerfJobDone
 if not defined PLMPerf_WaitAfterJobDone set PLMPerf_WaitAfterJobDone=120
 timeout /T:%PLMPerf_WaitAfterJobDone%
 endlocal
goto :eof

REM #-- SUB Routines ----------------------------------------------------------#
:PLMPerf_ScenarioSC01
 REM #New: 11.11.2020/J.Fes
 REM #Doc: Controls PLMPerf for SC01 Load Assemlies

 rem -- #Doc: set TC Prompt for Custom %1 = NX Version
 set TCPrompt_Custom_Opt=%~1
 set JobMgr_TC_use_tier=%~2
 set JobMgr_TC_tier_ModeUse=%~2
 set PLMPerf_ScenarioSubKey=%~3
 if "%~4" neq "" set TcSiteIdTarget=%~4

 if not defined TcSiteIdTarget set TcSiteIdTarget=%TcSiteId%

 call Echo "--- #Step:Get NX-TC Environment ------------------------------------------"
 Call "%TCPrompt_Custom_DPNE%"

 call Echo "--- #Step:fcc check ------------------------------------------------------"
 call TC_tempSet.cmd "%CmdCurRoot_DP%\..\zzTCtmpfcctmp"
 set JobMgr_fccCheck_parentfsc_address_tryRestart=true
 call fccCheck.cmd

:JumbToTest
 rem -- #Doc: define load condition CLCY = ClearCache=YES PLLDN = Partial Load Lightwight display:NO
 rem -- #Step: do run PLMPerf with fully-load ClearCache:Yes
 call :PLMPerf_Scenario_setCondion "%TcSiteIdTarget%-01" "1/4" "YES" "*%PLMPerf_ScenarioSubKey%*-FL-CLCY" "PLMPerfSC01_load_options1.def" "Latest Revision" "60"
 call "%CmdCurRoot_DP%\NxPLMPerfClient_ExecuteViaJournal.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOverTest
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Test..........................: ML-CLCY"
 call Echo "#JobMgr_PLMPerfScenario........: %JobMgr_PLMPerfScenario%"
 goto :MyEnd
:JumbOverTest


 rem -- #Step: do run PLMPerf with fully-load ClearCache:No
 call :PLMPerf_Scenario_setCondion "%TcSiteIdTarget%-02" "2/4" "OFF" "*%PLMPerf_ScenarioSubKey%*-FL-CLCN" "PLMPerfSC01_load_options1.def" "Latest Revision" "60"
 call "%CmdCurRoot_DP%\NxPLMPerfClient_ExecuteViaJournal.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

 rem -- #Step: do run PLMPerf with partial-load ClearCache:Yes
 call :PLMPerf_Scenario_setCondion "%TcSiteIdTarget%-03" "3/4" "YES" "*%PLMPerf_ScenarioSubKey%*-PL-CLCY" "PLMPerfSC01_load_options2.def" "Latest Revision" "60"
 call "%CmdCurRoot_DP%\NxPLMPerfClient_ExecuteViaJournal.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

 rem -- #Step: do run PLMPerf with partial-load ClearCache:No
 call :PLMPerf_Scenario_setCondion "%TcSiteIdTarget%-04" "4/4" "OFF" "*%PLMPerf_ScenarioSubKey%*-PL-CLCN" "PLMPerfSC01_load_options2.def" "Latest Revision" "60"
 call "%CmdCurRoot_DP%\NxPLMPerfClient_ExecuteViaJournal.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

 rem -- #Doc: if JobMgr_PLMPerfScenario=SC01_K10+NX11 then goto end because Minimal load not used for NX11
 if "%JobMgr_PLMPerfScenario%" equ "SC01_#Custom1-Key#" goto :MyEnd


:JumbToMinimalLoad
rem -- #Step: do run PLMPerf with minimal-load ClearCache:Yes
 call :PLMPerf_Scenario_setCondion "%TcSiteIdTarget%-05" "5/6" "YES" "*%PLMPerf_ScenarioSubKey%*-ML-CLCY" "PLMPerfSC01_load_options3.def" "Latest Revision" "60"
 call "%CmdCurRoot_DP%\NxPLMPerfClient_ExecuteViaJournal.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"
REM
rem -- #Step: do run PLMPerf with minimal-load ClearCache:No
 call :PLMPerf_Scenario_setCondion "%TcSiteIdTarget%-06" "6/6" "OFF" "*%PLMPerf_ScenarioSubKey%*-ML-CLCN" "PLMPerfSC01_load_options3.def" "Latest Revision" "60"
 call "%CmdCurRoot_DP%\NxPLMPerfClient_ExecuteViaJournal.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"


:MyEnd

goto :eof

 rem ---------------------------------------------------------------------------------
:PLMPerf_Scenario_setCondion

 rem #Doc: sets PLMPerf condition P1..P9
 set JobMgr_PLMPerfJobNo=%~1
 set JobMgr_PLMPerfStepNo=%~2
 set fccCache_Clear_DO=%~3
 set JobMgr_PLMPerfNXCond=%~4
 set UGII_LOAD_OPTIONS_NE=%~5
 set TC_CONFIG_RULE_NAME=%~6
 rem #Doc: define Perf Process max time
 set NXJournalMaxDuration_min=%~7

 set TC_NX_NAVIGATOR_OVERRIDE_NX_LOAD_OPTION=None

 rem set NXJournalTemplate file
 if not defined NXJournalTemplate_NE set NXJournalTemplate_NE=journal_load_close_part.vb
 if defined NXJournalTemplate_NE set NXJournalTemplate_DPNE=%CmdCurRoot_DP%\NXJournal\%NXJournalTemplate_NE%
 if defined NXMacroTemplate_NE set NXMacroTemplate_DPNE=%CmdCurRoot_DP%\NXJournal\%NXMacroTemplate_NE%

 rem -- #Doc: define mapper to import config definition see also PLMPerfAnalyse Register: 'Setup Data Import' DataColume:'Import Name'
 set ImportConfigName=%JobMgr_PLMPerfNXCond%*#IR.ItemNameRev#*
 rem -- #Doc: define JobTemp Top Path see NXPLMPerfClient_Execute.cmd

 set JobTemp_TP=JobTmp_%JobMgr_PLMPerfJobNo%
 call Echo "--- #Step:%JobMgr_PLMPerfStepNo% ExecutePLMPerfViaJournal %JobMgr_PLMPerfScenario%:%JobMgr_PLMPerfNXCond% -------------------"
 set titleTxt=Job:[%JobName%][Step:%JobMgr_PLMPerfStepNo%:%TCPrompt_Custom_Opt%:%JobMgr_PLMPerfScenario%:%JobMgr_PLMPerfNXCond%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 set titleTxt=PLMPerfJob:[%JobMgr_PLMPerfJobNo%:%JobMgr_PLMPerfStepNo%][%JobRuleName%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%
 Call Banner %JobMgr_PLMPerfJobNo%:%JobMgr_PLMPerfStepNo%

 Call Echo "--# #Step:Activate PMON --------------------------------------------"
 Call :SetPmon "%CmdCurRoot_DP%\%JobTemp_TP%"
  if /i "%JobMgr_WIMode%" equ "Normal" (
    start "PMon Job:[%JobName%][%TcSiteId%]" %toMon%
  ) else (
    start "PMon Job:[%JobName%][%TcSiteId%]" %toMon%
  )


:myExit
goto :eof

rem ---------------------------------------------------------------------------
:SetPmon
 set temp=%~1
 set tmp=%temp%
 if not exist "%temp%" md "%temp%"

 set PMon_exeL_DPNE=%BinL_DP%\JFProcessMonitor.exe
 set PMon_SysLog_DPNE=%temp%\zzPLMPerf1_PMon_SysLog.syslog
 set PMon_ResultXml_DPNE=%temp%\zzPLMPerf2_PMon_Result.xml

	set toMon=%PMon_exeL_DPNE%
 set toMon=%toMon% --titlePrefix "JobMon:[%JobName%][Step:%JobMgr_PLMPerfStepNo%][Start:%Date%/%time:~0,8%]"
 set toMon=%toMon% --processName run_journal
 set toMon=%toMon% --waitForProcess 15000
 set toMon=%toMon% --parentProcessId 0
	set toMon=%toMon% --killChildProcesses
REM 	set toMon=%toMon% --killChildProcesses
 set toMon=%toMon% --fileLastWriteTime "%temp%\*.*;600"
 set toMon=%toMon% --tailTextFile "%temp%\%username%*.syslog"
 set toMon=%toMon% --duraTimeSpanIfGreaterThen 1000
 set toMon=%toMon% --tailForceMilliseconds "500"
 set toMon=%toMon% --tailTextFile_log "%PMon_SysLog_DPNE%"
	set toMon=%toMon% --saveResultsTo "%PMon_ResultXml_DPNE%"
 rem set toMon=%toMon% --runtimeLimitSeconds 600
 Call Echo "Perf.P.Mon use setting..........: 29.08.2023"
goto :eof

REM ###### ------------ Standard Subroutines ---------------------- ##########
REM ============================================================================
:TcPromtCmdError
 Call ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_MissingTcPromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start Job on:\\%ComputerName% missing TcPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TcPromtCmd:=%TcPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_Debug%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
goto :end


REM ============================================================================
:ErrLogHeaderWrite
REM schreibt die erweiterten Infos an einen ErrLogFile
REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
Echo User:     %UserName% >>"%ErrLog_DPNE%"
Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
goto :eof

REM ============================================================================
:ErrLogFooterWrite
REM schreibt die erweiterten Infos an einen ErrLogFile
REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
Echo.>>"%ErrLog_DPNE%"
Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
Echo.>>"%ErrLog_DPNE%"
Echo -- Path Environ ---------------------------------------------------------->>"%ErrLog_DPNE%"
set PATH>>"%ErrLog_DPNE%"

Echo -- UG* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
set UG>>"%ErrLog_DPNE%"
Echo -- IMAN* Environ --------------------------------------------------------->>"%ErrLog_DPNE%"
set IMAN>>"%ErrLog_DPNE%"
Echo -- All Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
set>>"%ErrLog_DPNE%"
goto :eof



REM ============================================================================
:end

