﻿' Journal created NX 10.0.2.6
'
Option Strict Off
Imports System
Imports NXOpen

Module NXJournal
 Sub Main (ByVal args() As String)

  Dim theSession As NXOpen.Session = NXOpen.Session.GetSession()
  Dim NxSyslog As LogFile = theSession.LogFile
  Dim MainAssemblyIR as String = "2240_HRD_003_999/00"
  Dim MainAssemblyCLI as String = "@DB@2240_HRD_003_999@00"
  Dim PLMPerfSW As New System.Diagnostics.Stopwatch()
  Dim PLMAllPerfSW As New System.Diagnostics.Stopwatch()

  '-- #Doc:Set ItemRev Data
  MainAssemblyIR = "#ItemNameRev#"
  MainAssemblyCLI = "#ObjectCliName#"

  PLMAllPerfSW.start()
  NxSyslog.WriteLine("##PLMAllPerfTimeStartJournal: " + Now.ToString())
  
  
  rem set LoadOptions
  Dim configurationContextBuilder1 As NXOpen.PDM.ConfigurationContextBuilder = Nothing
	configurationContextBuilder1 = theSession.ConfigurationManager.CreateConfigurationContextBuilder()

	configurationContextBuilder1.ConfigType = NXOpen.PDM.ConfigurationContextBuilder.ConfigContextType.DefineorLoadContext

	configurationContextBuilder1.ConfigDetail = NXOpen.PDM.ConfigurationContextBuilder.ConfigurationDetail.DefineinNX

	configurationContextBuilder1.RevisionRule = "ALPLA_precise_rev_order"
  
	theSession.Parts.LoadOptions.ComponentsToLoad = NXOpen.LoadOptions.LoadComponents.All

	theSession.Parts.LoadOptions.PartLoadOption = NXOpen.LoadOptions.LoadOption.PartiallyLoad

	theSession.Parts.LoadOptions.SetInterpartData(False, NXOpen.LoadOptions.Parent.Partial)

	theSession.Parts.LoadOptions.AllowSubstitution = False

	theSession.Parts.LoadOptions.GenerateMissingPartFamilyMembers = False

	theSession.Parts.LoadOptions.AbortOnFailure = False

	theSession.Parts.LoadOptions.OptionUpdateSubsetOnLoad = NXOpen.LoadOptions.UpdateSubsetOnLoad.None
  
  Dim nXObject01 As NXOpen.NXObject = Nothing
	nXObject01 = configurationContextBuilder1.Commit()

	configurationContextBuilder1.Destroy()
  
  
  ' ----------------------------------------------
  '  Menu: File ->open...
  ' ----------------------------------------------
  Dim markId1 As NXOpen.Session.UndoMarkId
  markId1 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Invisible, "Start")
	
  
  theSession.SetUndoMarkName(markId1, "Part open")
  theSession.DeleteUndoMark(markId1, Nothing)
  
  

  NxSyslog.WriteLine("##PLMPerfTimeStartLoad_2240_HRD_003_999/00: " + Now.ToString())
  NxSyslog.WriteLine("##PLMPerfLoadTopLevelAP_2240_HRD_003_999/00: " + MainAssemblyIR)
  PLMPerfSW.Start()

  theSession.Parts.SetNonmasterSeedPartData(MainAssemblyCLI)

  Dim basePart1 As NXOpen.BasePart
  Dim partLoadStatus1 As NXOpen.PartLoadStatus = nothing
  basePart1 = theSession.Parts.OpenBaseDisplay(MainAssemblyCLI, partLoadStatus1)
  rem basePart1 = theSession.Parts.OpenBase(MainAssemblyCLI, partLoadStatus1)

  Dim workPart As NXOpen.Part = theSession.Parts.Work
  Dim displayPart As NXOpen.Part = theSession.Parts.Display

  partLoadStatus1.Dispose()
  
	 PLMPerfSW.Stop()
  NxSyslog.WriteLine("##PLMPerf1DurationLoadTopLevelAP_2240_HRD_003_999/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
  NxSyslog.WriteLine("##PLMPerfTDS_KEY1:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationToLoadTopLevelAP_2240_HRD_003_999/00")
  NxSyslog.WriteLine("##PLMPerf1TimeEndLoadTopLevelAP_2240_HRD_003_999/00: " + Now.ToString())
  PLMPerfSW.reset()
  PLMPerfSW.start()

 '-- bn SelectParts and load ComponentFully
  NxSyslog.WriteLine("##PLMPerf2TimeStartSelectComponentLoadFully_2240_HRD_003_999/00: " + Now.ToString())

rem  '-- bn aufruf Subroutine zum ermitteln aller Teile in AP und rekursives laden
   CALL BaugruppenStrukturErmitteln()

   
   NxSyslog.WriteLine("##PLMPerf2DurationSelectComponentLoadFully_2240_HRD_003_999/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
   NxSyslog.WriteLine("##PLMPerfTDS_KEY2:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationSelectComponentAndLoadFully_2240_HRD_003_999/00") 
   NxSyslog.WriteLine("##PLMPerf2TimeEndSelectComponentLoadFully_2240_HRD_003_999/00: " + Now.ToString())
   PLMPerfSW.reset()
   PLMPerfSW.start()

rem '-- Aufrufen von den Unterbaugruppen 2240_HRD_003_990/00, 2240_HRD_003_980/00 und 2240_HRD_003_160/00 + _160 make Workpart

'-- Aufruf von Unterbaugruppe 2240_HRD_003_990/00 -> SubAP1
   NxSyslog.WriteLine("##PLMPerf3TimeStartOpenSubAP1_2240_HRD_003_990/00: " + Now.ToString())
	
	Dim markId2 As NXOpen.Session.UndoMarkId = Nothing
	markId2 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Change Displayed Part")

	Dim SubAP1 As NXOpen.Part = CType(theSession.Parts.FindObject("@DB/2240_HRD_003_990/00"), NXOpen.Part)

	Dim partLoadStatusSubAP1 As NXOpen.PartLoadStatus = Nothing
	Dim statusSubAP1 As NXOpen.PartCollection.SdpsStatus = Nothing
	statusSubAP1 = theSession.Parts.SetActiveDisplay(SubAP1, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatusSubAP1)

	PLMPerfSW.stop()
	NxSyslog.WriteLine("##PLMPerf3DurationOpenSubAP1_2240_HRD_003_990/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
    NxSyslog.WriteLine("##PLMPerfTDS_KEY3:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationOpenSubAP1_2240_HRD_003_990/00")
	NxSyslog.WriteLine("##PLMPerf3TimeEndOpenSubAP1_2240_HRD_003_990/00: " + Now.ToString())
    PLMPerfSW.reset()	
	PLMPerfSW.start()

'-- Aufruf von Unterbaugruppe 2240_HRD_003_980/00 -> SubAP2
   NxSyslog.WriteLine("##PLMPerf4TimeStartOpenSubAP2_2240_HRD_003_980/00: " + Now.ToString())
	
	Dim markId3 As NXOpen.Session.UndoMarkId = Nothing
	markId3 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Change Displayed Part")

	Dim SubAP2 As NXOpen.Part = CType(theSession.Parts.FindObject("@DB/2240_HRD_003_980/00"), NXOpen.Part)

	Dim partLoadStatusSubAP2 As NXOpen.PartLoadStatus = Nothing
	Dim statusSubAP2 As NXOpen.PartCollection.SdpsStatus = Nothing
	statusSubAP2 = theSession.Parts.SetActiveDisplay(SubAP2, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatusSubAP2)

	PLMPerfSW.stop()
	NxSyslog.WriteLine("##PLMPerf4DurationOpenSubAP2_2240_HRD_003_980/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
	NxSyslog.WriteLine("##PLMPerfTDS_KEY4:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationOpenSubAP2_2240_HRD_003_980/00")
	NxSyslog.WriteLine("##PLMPerf4TimeEndOpenSubAP2_2240_HRD_003_980/00: " + Now.ToString())
	PLMPerfSW.reset()
	PLMPerfSW.start()

'-- Aufruf von Unterbaugruppe 2240_HRD_003_160/00 -> SubAP3
   NxSyslog.WriteLine("##PLMPerf5TimeStartOpenSubAP3_2240_HRD_003_160/00: " + Now.ToString())
	
	Dim markId4 As NXOpen.Session.UndoMarkId = Nothing
	markId4 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Change Displayed Part")

	Dim SubAP3 As NXOpen.Part = CType(theSession.Parts.FindObject("@DB/2240_HRD_003_160/00"), NXOpen.Part)

	Dim partLoadStatusSubAP3 As NXOpen.PartLoadStatus = Nothing
	Dim statusSubAP3 As NXOpen.PartCollection.SdpsStatus = Nothing
	statusSubAP3 = theSession.Parts.SetActiveDisplay(SubAP3, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatusSubAP3)

	
	workPart = theSession.Parts.Work ' 2240_HRD_003_160/00
	displayPart = theSession.Parts.Display ' 2240_HRD_003_160/00
	
	PLMPerfSW.stop()
	NxSyslog.WriteLine("##PLMPerf5DurationOpenSubAP3_2240_HRD_003_160/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
	NxSyslog.WriteLine("##PLMPerfTDS_KEY5:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationOpenSubAP3_2240_HRD_003_160/00")
	NxSyslog.WriteLine("##PLMPerf5TimeEndOpenSubAP3_2240_HRD_003_160/00: " + Now.ToString())
    PLMPerfSW.reset()	
	PLMPerfSW.start()

rem '--> Beginn 2240_HRD_003_160/00 Workpart -> Step Expressions für Schraubenwechsel M5 x 0.8 usw. anpassen

   NxSyslog.WriteLine("##PLMPerf6TimeStartEditExpressionScrewsAndLength_2240_HRD_003_160/00: " + Now.ToString())

	theSession.Preferences.Modeling.UpdatePending = False


 rem Abfrage Welcher Wert ist gesetzt M5 x 0.8 vs M6 x 1.0
 
	Dim expressionNameToFind As String = "ALP2_160_ScrewSize"
	Dim myExpression As Expression

	Dim expression1 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP2_160_ScrewSize"), NXOpen.Expression)
	Dim expression2 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP3_160_ThreadDepth"), NXOpen.Expression)
	Dim expression3 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP3_160_PilotHoleDepth"), NXOpen.Expression)
	Dim expression4 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP3_160_NoThreadLength"), NXOpen.Expression)
	Dim expression5 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP3_160_ScrewID"), NXOpen.Expression)
	Dim expression6 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP3_160_CounterDiameter"), NXOpen.Expression)
	Dim expression7 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP3_160_CounterHoleDiameter"), NXOpen.Expression)
	
	Dim expression8 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP1_160_ScrewPos_X1"), NXOpen.Expression)
	rem ALP1_160_ScrewPos_X1

	
	Dim unit1 As NXOpen.Unit = CType(workPart.UnitCollection.FindObject("MilliMeter"), NXOpen.Unit)
	

	myExpression = workPart.Expressions.FindObject(expressionNameToFind)	

 rem Abfrage Welcher Wert ist gesetzt M5 x 0.8 vs M6 x 1.0
 
	If myExpression.RightHandSide="""M6 x 1.0""" then
		
		workPart.Expressions.EditExpression(expression1, """M5 x 0.8""")
		workPart.Expressions.EditExpressionWithUnits(expression2, unit1, "11")
		workPart.Expressions.EditExpressionWithUnits(expression3, unit1, "14")	
		workPart.Expressions.EditExpressionWithUnits(expression4, unit1, "2.4")
		workPart.Expressions.EditExpression(expression5, """16002806-0000045""")
		workPart.Expressions.EditExpressionWithUnits(expression6, unit1, "10")
		workPart.Expressions.EditExpressionWithUnits(expression7, unit1, "5.5")

	Else	
	
		workPart.Expressions.EditExpression(expression1, """M6 x 1.0""")
		workPart.Expressions.EditExpressionWithUnits(expression2, unit1, "13")
		workPart.Expressions.EditExpressionWithUnits(expression3, unit1, "17")	
		workPart.Expressions.EditExpressionWithUnits(expression4, unit1, "3")
		workPart.Expressions.EditExpression(expression5, """16002806-0000069""")
		workPart.Expressions.EditExpressionWithUnits(expression6, unit1, "11.5")
		workPart.Expressions.EditExpressionWithUnits(expression7, unit1, "6.5")
	
	End if


Rem Abfrage nach ALP1_160_ScrewPos_X1 = 130mm / 135mm und setzten der entsprechenden Variable
	
	expressionNameToFind  = "ALP1_160_ScrewPos_X1"
	
	myExpression = workPart.Expressions.FindObject(expressionNameToFind)	
	
	If myExpression.RightHandSide="130" then
	
		workPart.Expressions.EditExpressionWithUnits(expression8, unit1, "135")
	
	Else
	
		workPart.Expressions.EditExpressionWithUnits(expression8, unit1, "130")
		
	End If
	


Dim markId7 As NXOpen.Session.UndoMarkId = Nothing
markId7 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Invisible, "Make Up to Date")

rem Make Up to Date

theSession.UpdateManager.InterpartDelay = False

Dim objects1(7) As NXOpen.NXObject
objects1(0) = expression1
objects1(1) = expression3
objects1(2) = expression2
objects1(3) = expression4
objects1(4) = expression5
objects1(5) = expression6
objects1(6) = expression7
objects1(7) = expression8

theSession.UpdateManager.MakeUpToDate(objects1, markId7)

Dim markId8 As NXOpen.Session.UndoMarkId = Nothing
markId8 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Invisible, "NX update")

Dim nErrs1 As Integer = Nothing
nErrs1 = theSession.UpdateManager.DoUpdate(markId8)

theSession.DeleteUndoMark(markId8, "NX update")

theSession.DeleteUndoMark(markId7, Nothing)

   PLMPerfSW.stop()
   NxSyslog.WriteLine("##PLMPerf6DurationEditExpressionScrewsAndLength_2240_HRD_003_160/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
   NxSyslog.WriteLine("##PLMPerfTDS_KEY6:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationEditExpressionScrewsAndLength_2240_HRD_003_160/00+Update")
   NxSyslog.WriteLine("##PLMPerf6TimeEndEditExpressionScrewsAndLength_2240_HRD_003_160/00: " + Now.ToString())
   PLMPerfSW.reset()
   PLMPerfSW.start()

		rem Make Up to Date Save and close
		'--> StartTimer 2240_HRD_003_160/00 Anpassen Expressions
		NxSyslog.WriteLine("##PLMPerf7TimeStartSave_2240_HRD_003_160: " + Now.ToString()) '--> StartTimer 2240_HRD_003_160/00 Workpart
		
		
		Dim markId160 As NXOpen.Session.UndoMarkId = Nothing
		markId160 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Save")

		Dim smartSaveContext160 As NXOpen.PDM.SmartSaveContext = Nothing	
		smartSaveContext160 = theSession.PdmSession.CreateSmartSaveContext(NXOpen.PDM.SmartSaveBuilder.SaveType.SaveAndClose)

		Dim smartSaveBuilder160 As NXOpen.PDM.SmartSaveBuilder = Nothing
		smartSaveBuilder160 = theSession.PdmSession.CreateSmartSaveBuilderWithContext(smartSaveContext160)

		Dim smartsaveobjects160() As NXOpen.PDM.SmartSaveObject
		smartSaveBuilder160.GetSmartSaveObjects(smartsaveobjects160)

		smartSaveBuilder160.ValidateSmartSaveObjects()

		Dim errorMessageHandler160 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler160 = smartSaveBuilder160.GetErrorMessageHandler(True)

		Dim nXObject160 As NXOpen.NXObject = Nothing
		nXObject160 = smartSaveBuilder160.Commit()

		Dim errorMessageHandler1601 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler1601 = smartSaveBuilder160.GetErrorMessageHandler(True)

		rem martSaveBuilder921.Destroy()

		rem smartSaveContext921.Dispose()
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf7DurationSave_2240_HRD_003_160: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
        NxSyslog.WriteLine("##PLMPerfTDS_KEY7:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationSave_2240_HRD_003_160")		
		NxSyslog.WriteLine("##PLMPerf7TimeEndSave_2240_HRD_003_160: " + Now.ToString())
		PLMPerfSW.reset()
		PLMPerfSW.start()





rem '--> Ende 2240_HRD_003_160/00 Workpart -> Step Expressions für Schraubenwechsel M5 x 0.8 usw. anpassen



rem '--> Start oeffne 2240_HRD_003_100/00 Workpart -> Step Expressions für ALP2_100_G_dim 1.7 vs 1.9 und ALP2_100_CapturedNeck Yes / No anpassen

	

	rem '--> Start oeffne 2240_HRD_003_100/00 Workpart ->
		
		'--> StartTimer 2240_HRD_003_100/00 Workpart
		NxSyslog.WriteLine("##PLMPerf8TimeStartOpenSubAP4_2240_HRD_003_100/00: " + Now.ToString()) '--> StartTimer 2240_HRD_003_100/00 Workpart
		
		
		Dim part4 As NXOpen.Part = CType(theSession.Parts.FindObject("@DB/2240_HRD_003_100/00"), NXOpen.Part)


		Dim partLoadStatus4 As NXOpen.PartLoadStatus = Nothing
		Dim status4 As NXOpen.PartCollection.SdpsStatus = Nothing
		status4 = theSession.Parts.SetActiveDisplay(part4, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatus4)

		workPart = theSession.Parts.Work ' 2240_HRD_003_100/00
		displayPart = theSession.Parts.Display ' 2240_HRD_003_100/00

		'--> EndTimer 2240_HRD_003_100/00 Workpart
		PLMPerfSW.stop()
		NxSyslog.WriteLine("##PLMPerf8DurationOpenSubAP4_2240_HRD_003_100/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY8:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationOpenSubAP4_2240_HRD_003_100/00")
		NxSyslog.WriteLine("##PLMPerf8TimeEndOpenSubAP4_2240_HRD_003_100/00: " + Now.ToString())
		PLMPerfSW.reset()
		PLMPerfSW.start()
		
	rem '--> Start Update Expressions für ALP2_100_G_dim 1.7 vs 1.9 und ALP2_100_CapturedNeck Yes / No anpassen
		
		'--> StartTimer 2240_HRD_003_100/00 Anpassen Expressions
		
		NxSyslog.WriteLine("##PLMPerf9TimeStartEditExpressionGdimAndCaptNeck_2240_HRD_003_100/00: " + Now.ToString()) '--> StartTimer 2240_HRD_003_100/00 Workpart
		
		Dim expression9 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP2_100_G_dim"), NXOpen.Expression)
		Dim expression10 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP2_100_CapturedNeck"), NXOpen.Expression)
		
		rem Anpassen Expressions in _100

		expressionNameToFind = "ALP2_100_G_dim"
		myExpression = workPart.Expressions.FindObject(expressionNameToFind)

		If myExpression.RightHandSide="1.9" then
			workPart.Expressions.EditExpressionWithUnits(expression9, unit1, "1.7")
		Else
			workPart.Expressions.EditExpressionWithUnits(expression9, unit1, "1.9")
		end if


		expressionNameToFind = "ALP2_100_CapturedNeck"
		myExpression = workPart.Expressions.FindObject(expressionNameToFind)

		If myExpression.RightHandSide="""No""" then
			workPart.Expressions.EditExpression(expression10, """No""")
		Else
			workPart.Expressions.EditExpression(expression10, """Yes""")
		End if

		
		Dim markId10 As NXOpen.Session.UndoMarkId = Nothing
		markId10 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Invisible, "Make Up to Date")

		rem Make Up to Date

		Dim objects2(1) As NXOpen.NXObject
		objects2(0) = expression9
		objects2(1) = expression10

		theSession.UpdateManager.MakeUpToDate(objects2, markId10)

		Dim markId11 As NXOpen.Session.UndoMarkId = Nothing
		markId11 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Invisible, "NX update")

		Dim nErrs2 As Integer = Nothing
		nErrs2 = theSession.UpdateManager.DoUpdate(markId10)

		theSession.DeleteUndoMark(markId11, "NX update")
		
		'--> EndTimer 2240_HRD_003_100/00 Anpassen Expressions
		
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf9DurationEditExpressionGdimAndCaptNeck_2240_HRD_003_100/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY9:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationEditExpressionGdimAndCaptNeck_2240_HRD_003_100/00+Update")
		NxSyslog.WriteLine("##PLMPerf9TimeEndEditExpressionGdimAndCaptNeck_2240_HRD_003_100/00: " + Now.ToString())
	    PLMPerfSW.reset()	
		PLMPerfSW.start()

		rem Make Up to Date Save and close
		'--> StartTimer 2240_HRD_003_100/00 Anpassen Expressions
		NxSyslog.WriteLine("##PLMPerf10TimeStartSave_2240_HRD_003_100: " + Now.ToString()) '--> StartTimer 2240_HRD_003_100/00 Workpart
		
		
		Dim markId100 As NXOpen.Session.UndoMarkId = Nothing
		markId100 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Save")

		Dim smartSaveContext100 As NXOpen.PDM.SmartSaveContext = Nothing	
		smartSaveContext100 = theSession.PdmSession.CreateSmartSaveContext(NXOpen.PDM.SmartSaveBuilder.SaveType.SaveAndClose)

		Dim smartSaveBuilder100 As NXOpen.PDM.SmartSaveBuilder = Nothing
		smartSaveBuilder100 = theSession.PdmSession.CreateSmartSaveBuilderWithContext(smartSaveContext100)

		Dim smartsaveobjects100() As NXOpen.PDM.SmartSaveObject
		smartSaveBuilder100.GetSmartSaveObjects(smartsaveobjects100)

		smartSaveBuilder100.ValidateSmartSaveObjects()

		Dim errorMessageHandler100 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler100 = smartSaveBuilder100.GetErrorMessageHandler(True)

		Dim nXObject100 As NXOpen.NXObject = Nothing
		nXObject100 = smartSaveBuilder100.Commit()

		Dim errorMessageHandler1001 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler1001 = smartSaveBuilder100.GetErrorMessageHandler(True)

		rem martSaveBuilder921.Destroy()

		rem smartSaveContext921.Dispose()
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf10DurationSave_2240_HRD_003_100: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY10:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationSave_2240_HRD_003_100") 
		NxSyslog.WriteLine("##PLMPerf10TimeEndSave_2240_HRD_003_100: " + Now.ToString())
	   PLMPerfSW.reset()	
		PLMPerfSW.start()

rem '-->Ende Update Expressions für ALP2_100_G_dim 1.7 vs 1.9 und ALP2_100_CapturedNeck Yes / No anpassen
rem '--> Ende 2240_HRD_003_100/00 Workpart -> Step Expressions für ALP2_100_G_dim 1.7 vs 1.9 und ALP2_100_CapturedNeck Yes / No anpassen


rem '--> Start oeffne 2240_HRD_003_200/00 Workpart -> Step Expressions Size of ALP_GuidingUnit_NX85(56)

	

	rem '--> Start oeffne 2240_HRD_003_200/00 Workpart ->
		
		'--> StartTimer 2240_HRD_003_200/00 Workpart
		NxSyslog.WriteLine("##PLMPerf11TimeStartOpenSubAP5_2240_HRD_003_200/00: " + Now.ToString()) '--> StartTimer 2240_HRD_003_200/00 Workpart
		
		'--> first change display to _990
		Dim part5 As NXOpen.Part = CType(theSession.Parts.FindObject("@DB/2240_HRD_003_990/00"), NXOpen.Part)


		Dim partLoadStatus5 As NXOpen.PartLoadStatus = Nothing
		Dim status5 As NXOpen.PartCollection.SdpsStatus = Nothing
		status5 = theSession.Parts.SetActiveDisplay(part5, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatus5)

		
		'--> first change display to _200		
		Dim part6 As NXOpen.Part = CType(theSession.Parts.FindObject("@DB/2240_HRD_003_200/00"), NXOpen.Part)


		Dim partLoadStatus6 As NXOpen.PartLoadStatus = Nothing
		Dim status6 As NXOpen.PartCollection.SdpsStatus = Nothing
		status6 = theSession.Parts.SetActiveDisplay(part6, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatus6)
		
		workPart = theSession.Parts.Work ' 2240_HRD_003_200/00/00
		displayPart = theSession.Parts.Display ' 2240_HRD_003_200/00
		

		'--> EndTimer 2240_HRD_003_200/00 Workpart
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf11DurationOpenSubAP5_2240_HRD_003_200/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY11:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationOpenSubAP5_2240_HRD_003_200/00") 
		NxSyslog.WriteLine("##PLMPerf11TimeEndOpenSubAP5_2240_HRD_003_200/00: " + Now.ToString())
	   PLMPerfSW.reset()	
		PLMPerfSW.start()
		
rem '--> Start Update Step Expressions Size of ALP_GuidingUnit_NX85(56)
	
	
	NxSyslog.WriteLine("##PLMPerf12TimeStartEditExpressionSize_52_2240_HRD_003_200/00: " + Now.ToString()) '--> StartTimer 2240_HRD_003_921/00 Workpart	
	
	
		Dim expression11 As NXOpen.Expression = CType(workPart.Expressions.FindObject("Size_52"), NXOpen.Expression)
		
		rem Anpassen Expressions in _200

		expressionNameToFind = "Size_52"
		myExpression = workPart.Expressions.FindObject(expressionNameToFind)

		If myExpression.RightHandSide="12" then
			workPart.Expressions.EditExpressionWithUnits(expression11, unit1, "16")
		Else
			workPart.Expressions.EditExpressionWithUnits(expression11, unit1, "12")
		end if
		
		Dim markId12 As NXOpen.Session.UndoMarkId = Nothing
		markId12 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Invisible, "Make Up to Date")

		rem Make Up to Date

		rem theSession.UpdateManager.InterpartDelay = False

		Dim objects3(0) As NXOpen.NXObject
		objects3(0) = expression11
		


		theSession.UpdateManager.MakeUpToDate(objects3, markId12)

		Dim markId13 As NXOpen.Session.UndoMarkId = Nothing
		markId13 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Invisible, "NX update")

		Dim nErrs3 As Integer = Nothing
		nErrs3 = theSession.UpdateManager.DoUpdate(markId12)

		theSession.DeleteUndoMark(markId12, "NX update")

		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf12DurationEditExpressionSize_52_2240_HRD_003_200/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY12:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationEditExpressionSize_52_2240_HRD_003_200/00+Update") 
		NxSyslog.WriteLine("##PLMPerf12TimeEndEditExpressionSize_52_2240_HRD_003_200/00: " + Now.ToString())		
		PLMPerfSW.reset()
		PLMPerfSW.start()
		
		rem Make Up to Date Save and close
		'--> StartTimer 2240_HRD_003_200/00 Anpassen Expressions
		NxSyslog.WriteLine("##PLMPerf13TimeStartSave_2240_HRD_003_200: " + Now.ToString()) '--> StartTimer 2240_HRD_003_200/00 Workpart
		
		
		Dim markId200 As NXOpen.Session.UndoMarkId = Nothing
		markId200 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Save")

		Dim smartSaveContext200 As NXOpen.PDM.SmartSaveContext = Nothing	
		smartSaveContext200 = theSession.PdmSession.CreateSmartSaveContext(NXOpen.PDM.SmartSaveBuilder.SaveType.SaveAndClose)

		Dim smartSaveBuilder200 As NXOpen.PDM.SmartSaveBuilder = Nothing
		smartSaveBuilder200 = theSession.PdmSession.CreateSmartSaveBuilderWithContext(smartSaveContext200)

		Dim smartsaveobjects200() As NXOpen.PDM.SmartSaveObject
		smartSaveBuilder200.GetSmartSaveObjects(smartsaveobjects200)

		smartSaveBuilder200.ValidateSmartSaveObjects()

		Dim errorMessageHandler200 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler200 = smartSaveBuilder200.GetErrorMessageHandler(True)

		Dim nXObject200 As NXOpen.NXObject = Nothing
		nXObject200 = smartSaveBuilder200.Commit()

		Dim errorMessageHandler2001 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler2001 = smartSaveBuilder200.GetErrorMessageHandler(True)

		rem martSaveBuilder921.Destroy()

		rem smartSaveContext921.Dispose()
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf13DurationSave_2240_HRD_003_200: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY13:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationSave_2240_HRD_003_200")
		NxSyslog.WriteLine("##PLMPerf13TimeEndSave_2240_HRD_003_200: " + Now.ToString())
		PLMPerfSW.reset()
		PLMPerfSW.start()


rem '--> Ende Update Step Expressions Size of ALP_GuidingUnit_NX85(56)

	'--> first change display to _921		
	rem '--> Start oeffne 2240_HRD_003_921/00 Workpart ->
		
		'--> StartTimer 2240_HRD_003_200/00 Workpart
		'NxSyslog.WriteLine("##PLMPerf13TimeStartOpenSubAP7: " + Now.ToString()) '--> StartTimer 2240_HRD_003_921/00 Workpart
		

	'--> Go Back to  2240_HRD_003_990/00 Workpart
		
		status5 = theSession.Parts.SetActiveDisplay(part5, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatus5)
		
		'workPart = theSession.Parts.Work ' 2240_HRD_003_921/00/00
		'displayPart = theSession.Parts.Display ' 2240_HRD_003_921/00
	
		'Dim part7 As NXOpen.Part = CType(theSession.Parts.FindObject("@DB/2240_HRD_003_980/00"), NXOpen.Part)

		'Dim partLoadStatus7 As NXOpen.PartLoadStatus = Nothing
		'Dim status7 As NXOpen.PartCollection.SdpsStatus = Nothing
		'status7 = theSession.Parts.SetActiveDisplay(part7, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatus7)

	
	'--> Open  2240_HRD_003_921/00 Workpart
	
		Dim part8 As NXOpen.Part = CType(theSession.Parts.FindObject("@DB/2240_HRD_003_921/00"), NXOpen.Part)


		Dim partLoadStatus8 As NXOpen.PartLoadStatus = Nothing
		Dim status8 As NXOpen.PartCollection.SdpsStatus = Nothing
		status8 = theSession.Parts.SetActiveDisplay(part8, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatus8)
		
		workPart = theSession.Parts.Work ' 2240_HRD_003_921/00/00
		displayPart = theSession.Parts.Display ' 2240_HRD_003_921/00


	'--> EndTimer 2240_HRD_003_921/00 Workpart
	PLMPerfSW.Stop()
	NxSyslog.WriteLine("##PLMPerf14DurationOpenSubAP7_2240_HRD_003_921/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
	NxSyslog.WriteLine("##PLMPerfTDS_KEY14:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationChangeTo_980andOpenSubAP7_2240_HRD_003_921/00")
	NxSyslog.WriteLine("##PLMPerf114TimeEndOpenSubAP7_2240_HRD_003_921/00: " + Now.ToString())
	PLMPerfSW.reset()
	PLMPerfSW.start()	
	'Start Step Expressions Size of ALP2_921_WeldShapeBase_F 2.2500 -> 2.200 viceVersa
		
		NxSyslog.WriteLine("##PLMPerf15TimeStartEditExpressionWeldShapeBase_F_2240_HRD_003_921/00: " + Now.ToString()) '--> StartTimer 2240_HRD_003_921/00 Workpart
		
		Dim expression12 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP2_921_WeldShapeBase_F"), NXOpen.Expression)
		
		rem Dim expression10 As NXOpen.Expression = CType(workPart.Expressions.FindObject("ALP2_100_CapturedNeck"), NXOpen.Expression)
		
	
		expressionNameToFind = "ALP2_921_WeldShapeBase_F"
		myExpression = workPart.Expressions.FindObject(expressionNameToFind)

		If myExpression.RightHandSide="2.2500" then
			workPart.Expressions.EditExpressionWithUnits(expression12, unit1, "2.2000")
		Else
			workPart.Expressions.EditExpressionWithUnits(expression12, unit1, "2.2500")
		end if

	
		Dim markId14 As NXOpen.Session.UndoMarkId = Nothing
		markId14 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Invisible, "Make Up to Date")

		rem Make Up to Date

		rem theSession.UpdateManager.InterpartDelay = False

		Dim objects4(0) As NXOpen.NXObject
		objects4(0) = expression12
	

		theSession.UpdateManager.MakeUpToDate(objects4, markId13)

		Dim markId15 As NXOpen.Session.UndoMarkId = Nothing
		markId15 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Invisible, "NX update")

		Dim nErrs4 As Integer = Nothing
		nErrs4 = theSession.UpdateManager.DoUpdate(markId14)

		theSession.DeleteUndoMark(markId15, "NX update")


		'--> EndTimer 2240_HRD_003_921/00 Anpassen Expressions
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf15DurationEditExpressionWeldShapeBase_F_2240_HRD_003_921/00: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY15:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationEditExpressionWeldShapeBase_F_2240_HRD_003_921/00+Update")
		NxSyslog.WriteLine("##PLMPerf15TimeEndEditExpressionWeldShapeBase_F_2240_HRD_003_921/00: " + Now.ToString())
		PLMPerfSW.reset()
		PLMPerfSW.start()
		
		rem Make Up to Date Save and close
		'--> StartTimer 2240_HRD_003_921/00 Anpassen Expressions
		NxSyslog.WriteLine("##PLMPerf16TimeStartSave_2240_HRD_003_921: " + Now.ToString()) '--> StartTimer 2240_HRD_003_921/00 Workpart
		
		
		Dim markId921 As NXOpen.Session.UndoMarkId = Nothing
		markId921 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Save")

		Dim smartSaveContext921 As NXOpen.PDM.SmartSaveContext = Nothing	
		smartSaveContext921 = theSession.PdmSession.CreateSmartSaveContext(NXOpen.PDM.SmartSaveBuilder.SaveType.SaveAndClose)

		Dim smartSaveBuilder921 As NXOpen.PDM.SmartSaveBuilder = Nothing
		smartSaveBuilder921 = theSession.PdmSession.CreateSmartSaveBuilderWithContext(smartSaveContext921)

		Dim smartsaveobjects921() As NXOpen.PDM.SmartSaveObject
		smartSaveBuilder921.GetSmartSaveObjects(smartsaveobjects921)

		smartSaveBuilder921.ValidateSmartSaveObjects()

		Dim errorMessageHandler921 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler921 = smartSaveBuilder921.GetErrorMessageHandler(True)

		Dim nXObject921 As NXOpen.NXObject = Nothing
		nXObject921 = smartSaveBuilder921.Commit()

		Dim errorMessageHandler922 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler922 = smartSaveBuilder921.GetErrorMessageHandler(True)

		rem martSaveBuilder921.Destroy()

		rem smartSaveContext921.Dispose()
		
		
			workPart = Nothing
			displayPart = Nothing
			
			
		PLMPerfSW.Stop()	
		NxSyslog.WriteLine("##PLMPerf16DurationSave_2240_HRD_003_921: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY16:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationSave_2240_HRD_003_921")
		NxSyslog.WriteLine("##PLMPerf16TimeEndSave_2240_HRD_003_921: " + Now.ToString())
	   PLMPerfSW.reset()	
		PLMPerfSW.start()
		
	rem '-->Expressions Size of ALP2_921_WeldShapeBase_F 2.2500 -> 2.200 viceVersa
rem '--> Ende 2240_HRD_003_921/00 Workpart -> Expressions Size of ALP2_921_WeldShapeBase_F 2.2500 -> 2.200 viceVersa




rem Make Up to Date Save and close




	'-- Aufruf von Unterbaugruppe 2240_HRD_003_980/00 -> SubAP2
		NxSyslog.WriteLine("##PLMPerf17TimeStartSwitchAndUpdate_2240_HRD_003_980: " + Now.ToString()) '--> StartTimer 2240_HRD_003_980/00 Workpart

		statusSubAP2 = theSession.Parts.SetActiveDisplay(SubAP2, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatusSubAP2)
		
		
		workPart = theSession.Parts.Work ' 2240_HRD_003_980
		displayPart = theSession.Parts.Display ' 2240_HRD_003_980
		
		
		CALL BaugruppenStrukturErmitteln
		
		
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf17DurationSwitchAndUpdate_2240_HRD_003_980: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY17:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec"+ "#Description: DurationSwitchToAndUpdate_2240_HRD_003_980")
		NxSyslog.WriteLine("##PLMPerf17TimeEndSwitchAndUpdate_2240_HRD_003_980: " + Now.ToString())	
	    PLMPerfSW.reset()	
		PLMPerfSW.start()

		NxSyslog.WriteLine("##PLMPerf18TimeStartSave_2240_HRD_003_980: " + Now.ToString()) '--> StartTimer 2240_HRD_003_980/00 Workpart
	
		Dim markId980 As NXOpen.Session.UndoMarkId = Nothing
		markId980 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Save")

		Dim smartSaveContext980 As NXOpen.PDM.SmartSaveContext = Nothing	
		smartSaveContext980 = theSession.PdmSession.CreateSmartSaveContext(NXOpen.PDM.SmartSaveBuilder.SaveType.SaveAndClose)

		Dim smartSaveBuilder980 As NXOpen.PDM.SmartSaveBuilder = Nothing
		smartSaveBuilder980 = theSession.PdmSession.CreateSmartSaveBuilderWithContext(smartSaveContext980)

		Dim smartsaveobjects980() As NXOpen.PDM.SmartSaveObject
		smartSaveBuilder980.GetSmartSaveObjects(smartsaveobjects980)

		smartSaveBuilder980.ValidateSmartSaveObjects()

		Dim errorMessageHandler980 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler980 = smartSaveBuilder980.GetErrorMessageHandler(True)

		Dim nXObject980 As NXOpen.NXObject = Nothing
		nXObject980 = smartSaveBuilder980.Commit()

		Dim errorMessageHandler9801 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler9801 = smartSaveBuilder980.GetErrorMessageHandler(True)

		rem martSaveBuilder921.Destroy()

		rem smartSaveContext921.Dispose()
			workPart = Nothing
			displayPart = Nothing
			
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf18DurationSave_2240_HRD_003_980: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY18:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationSave_2240_HRD_003_980")
		NxSyslog.WriteLine("##PLMPerf18TimeEndSave_2240_HRD_003_980: " + Now.ToString())
	    PLMPerfSW.reset()	
		PLMPerfSW.start()

	'--> StartTimer 2240_HRD_003_990/00 Aufruf Baugruppe und Struktur aktualisieren
		NxSyslog.WriteLine("##PLMPerf19TimeStartSwitchAndUpdate_2240_HRD_003_990: " + Now.ToString()) '--> StartTimer 2240_HRD_003_990/00 Workpart
		
		
		statusSubAP1 = theSession.Parts.SetActiveDisplay(SubAP1, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatusSubAP1)
		workPart = theSession.Parts.Work ' 2240_HRD_003_990
		displayPart = theSession.Parts.Display ' 2240_HRD_003_990
		
		
		CALL BaugruppenStrukturErmitteln
		
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf19DurationSwitchAndUpdate_2240_HRD_003_990: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY19:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationSwitchAndUpdate_2240_HRD_003_990")
		NxSyslog.WriteLine("##PLMPerf19TimeEndSwitchAndUpdate_2240_HRD_003_990: " + Now.ToString())	
	   PLMPerfSW.reset()	
		PLMPerfSW.start()
		
		
		NxSyslog.WriteLine("##PLMPerf20TimeStartSave_2240_HRD_003_990: " + Now.ToString()) '--> StartTimer 2240_HRD_003_990/00 Workpart
	
		Dim markId990 As NXOpen.Session.UndoMarkId = Nothing
		markId990 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Save")

		Dim smartSaveContext990 As NXOpen.PDM.SmartSaveContext = Nothing	
		smartSaveContext990 = theSession.PdmSession.CreateSmartSaveContext(NXOpen.PDM.SmartSaveBuilder.SaveType.SaveAndClose)

		Dim smartSaveBuilder990 As NXOpen.PDM.SmartSaveBuilder = Nothing
		smartSaveBuilder990 = theSession.PdmSession.CreateSmartSaveBuilderWithContext(smartSaveContext990)

		Dim smartsaveobjects990() As NXOpen.PDM.SmartSaveObject
		smartSaveBuilder990.GetSmartSaveObjects(smartsaveobjects990)

		smartSaveBuilder990.ValidateSmartSaveObjects()

		Dim errorMessageHandler990 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler990 = smartSaveBuilder990.GetErrorMessageHandler(True)

		Dim nXObject990 As NXOpen.NXObject = Nothing
		nXObject990 = smartSaveBuilder990.Commit()

		Dim errorMessageHandler9901 As NXOpen.PDM.ErrorMessageHandler = Nothing
		errorMessageHandler9901 = smartSaveBuilder990.GetErrorMessageHandler(True)

		rem martSaveBuilder921.Destroy()

		rem smartSaveContext921.Dispose()
			workPart = Nothing
			displayPart = Nothing
			
		PLMPerfSW.Stop()
		NxSyslog.WriteLine("##PLMPerf20DurationSave_2240_HRD_003_990: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
		NxSyslog.WriteLine("##PLMPerfTDS_KEY20:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationSave_2240_HRD_003_990")
		NxSyslog.WriteLine("##PLMPerf20TimeEndSave_2240_HRD_003_990: " + Now.ToString())
		PLMPerfSW.reset()
		PLMPerfSW.start()

  ' ----------------------------------------------
  '  Menu: Datei->close->all parts
  ' ----------------------------------------------
  
 rem basePart1 = theSession.Parts.OpenBase(MainAssemblyCLI, partLoadStatus1)


	NxSyslog.WriteLine("##PLMPerf21TimeStartSaveCloseAllParts: " + Now.ToString()) '--> StartTimer 2240_HRD_003_999/00 Workpart

		Dim part9 As NXOpen.Part = CType(theSession.Parts.FindObject("@DB/2240_HRD_003_999/00"), NXOpen.Part)
		Dim partLoadStatus9 As NXOpen.PartLoadStatus = Nothing
		Dim status9 As NXOpen.PartCollection.SdpsStatus = Nothing
		status9 = theSession.Parts.SetActiveDisplay(part9, NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatus9)
		
		workPart = theSession.Parts.Work ' 2240_HRD_003_999
		displayPart = theSession.Parts.Display ' 2240_HRD_003_999

Dim markId2002 As NXOpen.Session.UndoMarkId = Nothing
markId2002 = theSession.SetUndoMark(NXOpen.Session.MarkVisibility.Visible, "Save")

Dim smartSaveContext1 As NXOpen.PDM.SmartSaveContext = Nothing
smartSaveContext1 = theSession.PdmSession.CreateSmartSaveContext(NXOpen.PDM.SmartSaveBuilder.SaveType.SaveAndClose)

Dim smartSaveBuilder1 As NXOpen.PDM.SmartSaveBuilder = Nothing
smartSaveBuilder1 = theSession.PdmSession.CreateSmartSaveBuilderWithContext(smartSaveContext1)

Dim smartsaveobjects1() As NXOpen.PDM.SmartSaveObject
smartSaveBuilder1.GetSmartSaveObjects(smartsaveobjects1)

smartSaveBuilder1.ValidateSmartSaveObjects()

Dim errorMessageHandler1 As NXOpen.PDM.ErrorMessageHandler = Nothing
errorMessageHandler1 = smartSaveBuilder1.GetErrorMessageHandler(True)

Dim nXObject1 As NXOpen.NXObject = Nothing
nXObject1 = smartSaveBuilder1.Commit()

Dim errorMessageHandler2 As NXOpen.PDM.ErrorMessageHandler = Nothing
errorMessageHandler2 = smartSaveBuilder1.GetErrorMessageHandler(True)

smartSaveBuilder1.Destroy()

smartSaveContext1.Dispose()

theSession.ApplicationSwitchImmediate("UG_APP_NOPART")

rem workPart = Nothing
rem displayPart = Nothing

		 
		 
	rem	basePart1 = theSession.Parts.OpenBase(MainAssemblyCLI, partLoadStatus1)
	' ----------------------------------------------

	theSession.ApplicationSwitchImmediate("UG_APP_NOPART")
   
	theSession.Parts.CloseAll(NXOpen.BasePart.CloseModified.CloseModified, Nothing)

	workPart = Nothing
	displayPart = Nothing

	PLMPerfSW.Stop()
	NxSyslog.WriteLine("##PLMPerf21DurationSaveCloseAll_999: " + PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec")
	NxSyslog.WriteLine("##PLMPerfTDS_KEY21:#Time:"+ Now.ToString() + "#Dura:"+ PLMPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationSwitchSaveClose_2240_HRD_003_999")
	NxSyslog.WriteLine("##PLMPerf20TimeEndSaveCloseAll_999: " + Now.ToString())
    
   PLMAllPerfSW.stop()
   NxSyslog.WriteLine("##PLMPerfTDS_KEY22:#Time:"+ Now.ToString() + "#Dura:"+ PLMAllPerfSW.Elapsed.TotalSeconds.ToString().Replace(",", ".") + " sec" + "#Description: DurationAllStepsInJournal")
   
   

 End Sub




REM Funktionen zum Durchrouten aller Teile inkl Baugruppen
' Zum Aktiviern aller Teile


 Private Sub BaugruppenStrukturErmitteln()
	Dim theSession As NXOpen.Session = NXOpen.Session.GetSession()
	Dim workPart As NXOpen.Part = theSession.Parts.Work
	Dim displayPart As NXOpen.Part = theSession.Parts.Display

     Dim TopKomponente As NXOpen.Assemblies.Component = theSession.Parts.Display.ComponentAssembly.RootComponent

        If TopKomponente IsNot Nothing Then
			TopKomponente.OwningPart.LoadThisPartFully()
            DurchsucheBaugruppe(TopKomponente)
            Dim partLoadStatus As PartLoadStatus = Nothing
            Dim status As PartCollection.SdpsStatus
            status = theSession.Parts.SetActiveDisplay(CType(TopKomponente.OwningPart, Part), NXOpen.DisplayPartOption.AllowAdditional, NXOpen.PartDisplayPartWorkPartOption.UseLast, partLoadStatus)


		End If

End Sub


Private Sub DurchsucheBaugruppe(ByRef AktuelleKomponente As NXOpen.Assemblies.Component)
    Dim Kinder As NXOpen.Assemblies.Component() = AktuelleKomponente.GetChildren()
	Dim theSession As NXOpen.Session = NXOpen.Session.GetSession()
	Dim workPart As NXOpen.Part = theSession.Parts.Work
        For i As Integer = 0 To Kinder.Length - 1

            If GetType(Part) = Kinder(i).Prototype.[GetType]() Then
                DurchsucheBaugruppe(Kinder(i))
                rem Dim PrtZUrKomp As Part = CType(Kinder(i).Prototype, Part)
				Dim openStatus10() As Assemblies.ComponentAssembly.OpenComponentStatus = Nothing
				Dim partLoadStatus10 As PartLoadStatus = Nothing

				partLoadStatus10 = workPart.ComponentAssembly.OpenComponents(Assemblies.ComponentAssembly.OpenOption.ComponentOnly, Kinder, openStatus10)

             rem       PrtZUrKomp.Undisplay()
             rem   End If
            End If
        Next
End Sub


Private Sub wait(ByVal seconds As Integer)
     For i As Integer = 0 To seconds * 100
       System.Threading.Thread.Sleep(10)
       rem Application.DoEvents()
     Next
   End Sub





End Module








