@Echo off
 REM ===========================================================================
 REM JobMgr Script for Customer (c)addPLM 2006..2017
 REM Date/Time  Name    Details:
 REM 22.08.2017 J.Fes   date of template version
 REM 07.01.2021 S.Gueth updated for NxToTc
 REM ===========================================================================

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 Call Echo "**************************************************************************"
 Call Echo "* Excuting Script for PLMJobManager                                      *"
 Call Echo "* Based on template Version: 08.02.2017 (c)addPLM GmbH                   *"
 Call Echo "**************************************************************************"

 REM -- define incudes #New: 05.07.2016/J.Fes
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 rem -- #Doc: 07.07.2016/J.Fes Use to refile 'SO SiteObjects' as 'RO ReplicaObjects'
 rem if not defined JobMgr_RfUse_for_SO_RO set JobMgr_RfUse_for_SO_RO=YES

 REM -- #Doc: Inits all Basics of Job
 Call "%~dp0_JobInitial.cmd" "NxToTc" "YES" "NO" "YES" "YES"

 rem -- TC Prompt for Custom
 rem set TCPrompt_Custom_Opt=NX110

 set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"

 if defined UGII_LOAD_OPTIONS_NE set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\startup\%UGII_LOAD_OPTIONS_NE%
 set UGII_KEEP_SYSTEM_LOG=TRUE
 rem set SPLM_LICENSE_SERVER=%UGS_LICENSE_SERVER%
 rem set UGII_LICENSE_SERVER=%UGS_LICENSE_SERVER%
 set NR_BYPASS=true
 set UGII_ALLOW_NGC_IN_UGOPEN=yes

 set TC_MFK_DEFAULT_DOMAIN=AS5AEngPart

 set BYPASS_RULES=ON
 set NR_BYPASS=ON
 set BMF_BYPASS_ALL_EXTENSION_RULES=ON



 if "%JobMgr_TCPromptGet_ResCode%" equ "0" Call "%CmdCurRoot_DP%\NxToTc_ExecuteProcess.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

goto :end

REM ============================================================================
:end
 REM -- #Doc:26.02.2021/J.Fes add cleanup and finish the process
 Call "%~dp0_JobFinish.cmd"


