@Echo off
 REM ===========================================================================
 REM Change Info:
 REM User    Date/Time  Infotext:
 REM J.Fes   24.11.2006 first setup
 REM J.Fes   14.07.2013 Skript is now using JCT Tools
 REM J.Fes   31.01.2017 %CmdCurRoot_DP%\TCPrompt_Custom.cmd
 REM J.Fes   07.02.2017 #LUp: add _JobInitial.cmd
 REM J.Fes   22.12.2020 #LUp: add _JobFinish.cmd
 REM ===========================================================================
 
 Call Echo "**************************************************************************"
 Call Echo "* Excuting JobMgr Script NX Data Processing                              *"
 Call Echo "* Based on Version: 21.12.2021 (c)addPLM GmbH                            *"
 Call Echo "**************************************************************************"

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 REM -- #Doc: define incudes
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 REM -- #Doc: Inits all Basics of Job
 Call "%~dp0_JobInitial.cmd" "NXDP" "YES" "YES" "YES" "NO"

 set titleTxt=[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 rem -- #Doc: Get TC Prompt for Custom
 rem set TCPrompt_Custom_Opt=NX12
 rem set TC_SHARED_MEMORY_DIR_Disable=false
 if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"

 rem -- #Doc: start excuting NX Data Processing action
 if "%JobMgr_TCPromptGet_ResCode%" equ "0" Call "%CmdCurRoot_DP%\NXDP10_Main.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

goto :end

REM ============================================================================
:end
 REM -- #Doc: clean up and finish the process
 Call "%~dp0_JobFinish.cmd"
