REM #Doc: Script for setup Environment for PartUpdate process
REM #New: 09.04.2018/J.Fes
REM #LUp: 17.01.2019/J.Fes
REM #LUp: 06.10.2022/J.Fes add UseCBdll
REM #LUp: 23.07.2023/J.Fes Check Status

call :ProcessDefaults
if /I "%JobMgr_NxPartUtilReplica%"      equ "YES" Call :ProcessRO
if /I "%JobMgr_NxPartUtilReplica%"      neq "YES" Call :ProcessSO
if /I "%JobMgr_NxPartUtil_UseCBdll_NE%" neq ""    Call :JobMgr_NxPartUtil_UseCBdll

goto :eof

REM ----------------------------------------------------------------------------
:ProcessDefaults
 if /I "%NxPartUtilPara%" equ "%NxPartUtilPara: -update_mod_props=no=%" goto :JumbOver
   REM #Doc: 01.06.2011 Info from Phil.K
   set TC_UPDATE_MOD_PROPS=NO
 :JumbOver
 set NxPartUtilPara=-managed_mode=yes %NxPartUtilPara%
 goto :eof

REM ----------------------------------------------------------------------------
:ProcessSO
 REM set's Custom environ IF SO Side Objects is refiled
 set UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS=
 set IMAN_UG_REFILE_REPLACE_FILE=
 REM UGII_DISABLE_PREVIEW nicht bei OwingSite Object's
 set UGII_DISABLE_PREVIEW=
 REM UGII_DISABLE_QAF_NAMED_REFS nicht bei OwingSite Object's
 set UGII_DISABLE_QAF_NAMED_REFS=
 goto :eof

REM ----------------------------------------------------------------------------
:ProcessRO
 REM #Doc: Set Multisite EnvironmentRO Replica Objects is refiled
 if /I "%NxPartUtilPara%" EQU "%NxPartUtilPara: -replica_bypass=yes=%" set NxPartUtilPara=%NxPartUtilPara% -replica_bypass=yes

 REM #Doc: 09/10/2014/J.Fes add new see: IR1996966
 if /I "%NxPartUtilPara%" EQU "%NxPartUtilPara: -replace_file=yes=%" set NxPartUtilPara=%NxPartUtilPara% -replace_file=yes
 set UGII_UGMGR_REFILE_REPLACE_FILE=yes

 set UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS=true
 REM 18.05.2010/J.Fes ad see E-Mail David Geisler 15. Mai 2010 00:19
 set IMAN_UG_REFILE_REPLACE_FILE=true
 REM umgestellt von set UGII_DISABLE_PREVIEW=on auf set UGII_DISABLE_PREVIEW=
 set UGII_DISABLE_PREVIEW=ON
 REM umgestellt von set UGII_DISABLE_QAF_NAMED_REFS=ON auf set UGII_DISABLE_QAF_NAMED_REFS
 set UGII_DISABLE_QAF_NAMED_REFS=ON

 if /i "%JobMgr_Debug%" neq "ON"  goto :JumbOver
  Call Echo "#Debug..........................: please check"
  Call Echo "Check if NxPartUtilPara contains: [-replica_bypass=yes]"
  Call Echo "NxPartUtil Para.................: [%NxPartUtilPara%]"
  Call Echo "Process Replica.................: [%JobMgr_NxPartUtilReplica%]"
  Call Echo "UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS: [%UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS%]"
  Call Echo "UGII_UGMGR_REFILE_REPLACE_FILE..: [%UGII_UGMGR_REFILE_REPLACE_FILE%]"
  Call Echo "IMAN_UG_REFILE_REPLACE_FILE.....: [%IMAN_UG_REFILE_REPLACE_FILE%]"
  pause
:JumbOver
 goto :eof


rem ----------------------------------------------------------------------------
:JobMgr_NxPartUtil_UseCBdll
 REM #New: 06.10.2022/J.Fes
 REM #Doc: activates for PartUpdate NXCB integration


 set UGII_VENDOR_DIR=%CmdCurRoot_DP%\UGII_VENDOR_DIR

 set NXCB_DLL_S_NE=%JobMgr_NxPartUtil_UseCBdll_NE%
 set NXCB_DLL_S_DP=%JobScriptTemplateMinus1_DP%\UGII_VENDOR_DIR\udo
 set NXCB_DLL_S_DPNE=%NXCB_DLL_S_DP%\%NXCB_DLL_S_NE%
 set NXCB_DLL_L_DP=%UGII_VENDOR_DIR%\udo

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  call Echo "---------------------------------------------------------------------------"
  call Echo "#Debug..........................: %0"
  call Echo "#NXCB_DLL_S_DPNE................: %NXCB_DLL_S_DPNE%"
  call Echo "---------------------------------------------------------------------------"
  dir %NXCB_DLL_S_DPNE%
  call Echo "---------------------------------------------------------------------------"
  Echo List NXCB_DLL* Env Vars
  set NXCB_DLL
  call Echo "---------------------------------------------------------------------------"
  pause
 :JumbOverDebug

 if not exist "%NXCB_DLL_S_DPNE%" Call :JobMgr_NxPartUtil_UseCBdll_ISSUE& goto :myEnd


 rem --#Doc: OK no Issue happend - - - - - - - - - - - - - - - - - - - - - - - -
 rem --#Doc: Now copy all files from NXCB_DLL_S_DP to NXCB_DLL_L_DP
 robocopy %robocopy_opt% /S /NP /NJS /NJH /NDL /NFL "%NXCB_DLL_S_DP%" "%NXCB_DLL_L_DP%" *.*

 rem --#Doc: set now all NXCB variables
 set NXCB_outdir=%CmdCurRoot_DP%\CBData
 if not exist "%NXCB_outdir%" md "%NXCB_outdir%"
 set NXCB_MAXASSEMBLYLEVEL=1
 set NXCB_detail_option=25,26

 rem :: Neue Funktionalitten ber den Callback
 rem :: Der Callback Change Workpart wird scharf geschaltet ==> xml CB1 Ausgabe
 set CHECKBOX_CHANGE_WORKPART_ACTION=TRUE
 rem Der Callback Save Callback wird scharf geschaltet ==> xml CB2 Ausgabe
 set CHECKBOX_SAVE_CALLBACK_ACTION=TRUE

 rem Set NXCB_ACTION=ModelGetData,AssemblyGetData,DrawingGetData
 REM  Set NXCB_LOG=%NXCB_outdir%\_NXCB_NxPartUtil_log.txt
 REM  Set NXCB_Result=%NXCB_outdir%\_NXCB_NxPartUtil_Result.csv
 REM  Set NXCB_ExtractCGM_toDir=%NXCB_outdir%
 set NXCB_Accuracy=0.9999

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  call Echo "---------------------------------------------------------------------------"
  call Echo "#Debug..........................: %0"
  call Echo "#NXCB_DLL_S_DPNE................: %NXCB_DLL_S_DPNE%"
  call Echo "---------------------------------------------------------------------------"
  dir %NXCB_DLL_L_DP%\*.*
  call Echo "---------------------------------------------------------------------------"
  Echo List NXCB_* env
  set NXCB_
  call Echo "---------------------------------------------------------------------------"
  pause
 :JumbOverDebug


 goto :myEnd
 :myEnd
goto :eof

:JobMgr_NxPartUtil_UseCBdll_ISSUE
  Call Echo "PartUpdate with NXCB interation.: is active but cannot find"
  Call Echo "ISSUE:fnf NXCheckBox.dll via....: %NXCB_DLL_S_DPNE%"
goto :eof

