@Echo off

 Echo **************************************************************************
 Echo * Excuting NX12-PartUpdate Native Script for  PLMJobManager Environ      *
 Echo * Version: 21.03.2018 addPLM GmbH (c)                                    *
 Echo **************************************************************************

setlocal
 REM -- #Step: Farbe setzen IsIdel
 call ColorSet "IsIdel"

 call Echo "--- #Step: Nx-PartUpdate Nativ Set Up Base ---------------------------------"

 REM -- temp dir Organiesieren -------------------------------------------------
 set JobTemp=%CmdCurRoot_DP%\01-JobTemp
 if not exist "%JobTemp%" md "%JobTemp%"

 rem #New: 16.03.2016 set default NXPuMaxDuration
 if not defined NXPuMaxDuration set NXPuMaxDuration=-1

 REM -- define cmd files to set variables --------------------------------------
 set NxPartUtilNativCustomSetEnv_cmd=%CmdCurRoot_DP%\NxPartUpdateNativ2_CustomSetEnv.cmd

 Rem -- define ResultClassification_DPNE JobMgr --------------------------------
 set ResultClassification_DPNE=%CmdCurRoot_DP%\Resources\NxPartUtilNativSylog_ResClRules.xml

 call Echo "--- #Step: Execute Nx-PartUpdate Nativ -------------------------------------"
 rem #Doc: JobParameter is to set on this line
 call :ExecutePartUpdate "%JobTemp%"
 endlocal& set NXPuPrgExitCode=%NXPuPrgExitCode%
goto :end


rem ============================================================================
:ExecutePartUpdate
 rem #Doc: Main Script to run part_utility.exe

 rem #Doc get File Params
 set temp=%~1
 rem #New 15.04.2014 13:48
 set tmp=%temp%
 set HOME=%temp%

 set PartUpdateErrLog_DPNE=%temp%\_PartUpdateErrLog.txt
 set UGII_TMP_DIR=%temp%
 SET UGII_KEEP_SYSTEM_LOG=TRUE
 set UGII_UGSOLIDS_TMP=%UGII_TMP_DIR%


 REM -- Symetric Multi-Processing (SMP) disable
 REM diabled 07.02.2011
 set UGII_SMP_ENABLE=

 REM -- CGM erstellung deaktiveren eingefuegt 09.02.10 J.fes
 set UGII_IMAGE_CREATE_CGM=
 set UGII_IMAGE_CREATE_CGM_DRAW=
 set UGII_IMAGE_CREATE_CGM_OPTIONS=
 set UGII_IMAGE_CREATE_NAME=
 set UGII_IMAGE_CREATE_ORIGINAL_BACKGROUND=


 REM -- define Load_options ----------------------------------------------------
 if defined UGII_LOAD_OPTIONS_NE set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\startup\%UGII_LOAD_OPTIONS_NE%

 REM -- define nx.dpv ----------------------------------------------------------
 if defined UGII_LOCAL_USER_DEFAULTS_NE set UGII_LOCAL_USER_DEFAULTS=%CmdCurRoot_DP%\startup\%UGII_LOCAL_USER_DEFAULTS_NE%
 set UGII_USER_DIR=%CmdCurRoot_DP%
 set UGII_GROUP_DIR=


 rem 21.01.2014
 rem  - mit max 2 Std Laufzeit
 rem  - mit max 6gb Memory usage fr 5 min
 rem  - mit max 5 min ohne das neue files im JobTemp entstehen oder editiert werden
 set toMon=%JFProcessMonitorL_exe%
 set toMon=%toMon% --waitForProcess 15000
 set toMon=%toMon% --processName part_utility
 set toMon=%toMon% --parentProcessId 0
 REM  set toMon=%toMon% --runtimeLimitSeconds 7200
 set toMon=%toMon% --killChildProcesses
 set toMon=%toMon% --fileLastWriteTime "%temp%\*.*;600"
 rem #New 23/11/2014 19:21 / J.Fes
 set toMon=%toMon% --fileContainsString "%temp%\%username%*.syslog;This is most likely the result of a crash of the Teamcenter server, or the Teamcenter server encountering an unrecoverable error"
 rem set toMon=%toMon% --monitorExistingFiles
 REM  set toMon=%toMon% --memoryUsageHigh 6000;300
 set toMon=%toMon% --saveResultsTo "%temp%\zzJFProcessMonitor_log.xml"
 set toMon=%toMon% --tailTextFile "%temp%\*part_utility*.syslog"
 set toMon=%toMon% --titlePrefix "Job:[%JobName%][%TcSiteId%]"

 REM -- set Pu Parameter ----------------
 set NXPuPrgExitCode=

 REM -- set Pu.Contol defaults ----------
 set JobMgr_PuPMon_USE=true

 REM -- set Custom.Environ
 if exist "%NxPartUtilNativCustomSetEnv_cmd%" call "%NxPartUtilNativCustomSetEnv_cmd%"

 REM -- part_utility.exe Programm ----------------------------------------------
 set part_utility_exe_DPNE=%UGII_BASE_DIR%\nxbin\part_utility.exe

 call :Parse_NE %UGII_LOAD_OPTIONS%        UGII_LOAD_OPTIONS
 call :Parse_NE %UGII_LOCAL_USER_DEFAULTS% UGII_LOCAL_USER_DEFAULTS

 set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 Echo.                                                                               .
 call ColorSet "IsExecuting"
 Echo %titleTxt%
 call Echo "----------------------------------------------------------------------------"
 Call Echo "NXPart Utility Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.........................: %JobName%"
 Call Echo "Computer........................: %ComputerName%"
 Call Echo "Process Dir.....................: %temp%"
 Call Echo "Site............................: #TcSiteId#"
 Call Echo "EvalExtOpt......................: %JobMgr_PuExtEvalROpt%"
 Call Echo "Proc.Monitor....................: %JobMgr_PuPMon_USE%"
 Call Echo "UGII_BASE_DIR...................: %UGII_BASE_DIR%"
 Call Echo "UGII_SITE_DIR...................: %UGII_SITE_DIR%"
 Call Echo "UGII_LOAD_OPTIONS...............: ..\%UGII_LOAD_OPTIONS_NE%"
 Call Echo "UGII_LOCAL_USER_DEFAULTS........: ..\%UGII_LOCAL_USER_DEFAULTS_NE%"
 Call Echo "Using Program...................: %part_utility_exe_DPNE%"
 Call Echo "Using Parameter.................: %JobParameter%"


 cd /d "%temp%"
 set >>"%temp%\zzEnvironBeforRunPart_utility.txt"

 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Nativ part_utility.exe Protocol:"

 set NXPuPrgExitCode=0
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "PartUtility_2018_04"
 set toRun=%toRun% -SubAction "PartUpdateNativeViaFromToDir"
 rem -d Convert all parts/UDFs in directory <dirname>.
 rem #New: Option after 09.09.2019
 rem set toRun=%toRun% -SubAction "viaConvertAllPartsInDir"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobTemp_DP "%temp%"
 set toRun=%toRun% -PuProg_DPNE "%part_utility_exe_DPNE%"

 rem -- #Doc: add additional parameters
 if defined PuTarget_DP                 set toRun=%toRun% -PuTarget_DP "%PuTarget_DP%"
 if defined PuTargetReplSource_DP       set toRun=%toRun% -PuTargetReplSource_DP "%PuTargetReplSource_DP%"
 if defined PuTargetReplSourceWith_DP   set toRun=%toRun% -PuTargetReplSourceWith_DP "%PuTargetReplSourceWith_DP%"
 rem 18.07.2023/J.Fes removed because iparameter is set in JobMgrCMDTools
REM  if defined JobParameter                set toRun=%toRun% -PuParam "''-managed_mode=no %JobParameter%''"
 if defined PuEnv_JobMgr_nPuNXcash_DP   set toRun=%toRun% -PuEnv_JobMgr_nPuNXcash_DP "%PuEnv_JobMgr_nPuNXcash_DP%"
 rem -- #Doc: #New: 19.02.2020 add JobMgr_ConvertMcs_Archiv_DP
 if defined JobMgr_ConvertMcs_Archiv_DP set toRun=%toRun% -ConvertMcs_Archiv_DP "%JobMgr_ConvertMcs_Archiv_DP%"

 set toRun=%toRun% -ShellMaxDurationSEC "%NXPuMaxDuration%"
 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -JobData2ResultsDoPrint

 if exist "%ResultClassification_DPNE%" set toRun=%toRun% -ResultClassification_DPNE "%ResultClassification_DPNE%"
 if defined ResultClassificationCustom_DPNE set toRun=%toRun% -ResultClassificationCustom_DPNE "%ResultClassificationCustom_DPNE%"
 if defined JobMgr_PuExtEvalROpt set toRun=%toRun% %JobMgr_PuExtEvalROpt%

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 set toRun=%toRun% -verbose -pauseOnEnd
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug..........................: before NxPuJob (%~0)"
 pause
:JumbOverDebug

 rem --#Step: Now run JobMgrCmdTool for Nativ part_utility.exe
 call %toRun%
 set NXPuPrgExitCode=%errorlevel%


if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 set toRun=%toRun% -verbose -pauseOnEnd
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug..........................: before NxPuJob (%~0)"
 pause
:JumbOverDebug

 call Echo "--- #Res.: NXPuPrgExitCode.: [%NXPuPrgExitCode%] ---------------------------------------------"

 REM  Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 Call Echo "before NxPu:End" "" "NOECHO"
 call "%BinPublic_DP%\Banner.exe" "NxPu:End"

 Call ColorSet "END"

goto :eof

REM ####### ------------ Standard Subroutines ---------------------- ###########
:Parse_NE
 set %2_NE=%~nx1
 goto :eof

:end

