@Echo off
 Call Echo "****************************************************************************"
 Call Echo "* Excuting Script for PLMJobManager Environ                                *"
 Call Echo "* Version: 25.01.2021  (c)addPLM GmbH                                      *"
 Call Echo "****************************************************************************"

setlocal

 REM -- #Step: Farbe setzen IsIdel
 call ColorSet IsIdel
 call Echo "--- #Step: Setup Base -----------------------------------------------------"

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3
 if not defined JobMgr_TcGroup  set JobMgr_TcGroup=dba
 if not defined JobMgr_PMon_USE set JobMgr_PMon_USE=OFF

 rem --#Doc: define JobDir and JobFiles
 set JobTemp_DP=%CmdCurRoot_DP%\JobTemp
 if not exist "%JobTemp_DP%" md "%JobTemp_DP%"

 rem --#Doc: define JobFiles
 set JobInputList_NE=_F01_JobInputList.txt
 set JobInputList_DPNE=%JobTemp_DP%\%JobInputList_NE%
 set JobCmdOutPutLog_NE=_F02_CMDLog.txt
 set JobCmdOutPutLog_DPNE=%JobTemp_DP%\%JobCmdOutPutLog_NE%
 set JobLogFile_NE=_F03_Joblog.txt
 set JobLogFile_DPNE=%JobTemp_DP%\%JobLogFile_NE%
 set JobResultFile_NE=_F04_Joblog.txt
 set JobResultFile_DPNE=%JobTemp_DP%\%JobResultFile_NE%%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  call Echo "----------------------------------------------------------------------------"
  call Echo "#Debug..........................: %~0"
  call Echo "#Step...........................: Before Job"
  pause
:JumbOverDebug

 rem --#Steps: from: 'Extract' -to- 'Excute' -to- 'Evaluate' ------------------
 call :JobExtractList
REM  call :TCDataExtract
 call :JobExecuting "%JobTemp_DP%"
 Echo.
 Echo Wait:%WaitTime% (sec) after JobExecuting
 Call timeout /T %WaitTime%

 call :JobResEvaluateGeneric
 rem call :JobResEvaluate

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  call Echo "----------------------------------------------------------------------------"
  call Echo "#Debug..........................: %~0"
  call Echo "#Step...........................: after Job"
  pause
 :JumbOverDebug

endlocal& set Program_ExitCode=%Program_ExitCode%
goto :eof

REM ============================================================================
:JobExtractList
 rem #Doc: Extracts the IR lists for Process input
 rem #New: 22.08.2017 14:27

 call ColorSet ExtractLi
 call Echo "--- #Step: Extract Job Input List -----------------------------------------"
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "JobDataExtract_2013_10"
 set toRun=%toRun% -SubAction "InputListExtract"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -inputList_DPNE "%JobInputList_DPNE%"
REM  set toRun=%toRun% -objectClass "I"
REM  set toRun=%toRun% -format "#ItemId#"
REM set toRun=%toRun% -objectClass "DS"
 set toRun=%toRun% -format "#ItemId#~#Rev#~#ObjectPuid#"
 set toRun=%toRun% -JobData1ToProcessDoPrint

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_01_ExtractList.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Debug:.........................: before: [%~0]"
   call Echo "#ToRun..........................: %toRunForPrint%"
   Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug

 call %toRun%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   Call Echo "#Debug:.........................: after: [%~0]"
   Call TypeFile "%JobInputList_DPNE%"  "program output.log"
   Call Type
   Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug

 set toRun=
goto :eof

rem ============================================================================
:JobExecuting
 rem #Doc: Main Script to run process

 set temp=%~1
 set tmp=%temp%

 call ColorSet IsExecuting
 call Echo "--- #Step: Extract Job Executing ------------------------------------------"

 REM -- Job Programm --------------------------------------------------------
 set Program_N=banner
 set Program_E=.exe
 set Program_NE=%Program_N%%Program_E%
 set Program_DP=%BinPublic_DP%


 set robocopy_opt=/R:5 /W:1
 Call Echo "Program BIN copy to BinL_DP.....: [%JobScriptTemplateMinus1_DP%\Bin]"
 Call Echo "Process BIN copy from...........: [%JobScriptTemplateMinus1_DP%\Bin]"
 Call Echo "Process BIN copy to BinL_DP.....: [%BinL_DP%]"
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobScriptTemplateMinus1_DP%\Bin" "%BinL_DP%" "*.*">nul

 set Program_DPNE=%Program_DP%\%Program_NE%
 set Program_L=%BinL_DP%\%Program_NE%
 if not exist "%Program_DPNE%"  call ErrorHandel "PS" "%Program_NE% fnf" "File not found:[%Program_DPNE%]"
 if not exist "%Program_L%"  call ErrorHandel "PS" "%Program_NE% fnf" "File not found:[%Program_L%]"


rem -- #New: 05.05.2017/J.Fes toMon also for Process
if /i "%JobMgr_PMon_USE%" NEQ "ON" goto :Next
 rem #LUp: 05.05.2017/J.Fes
 set toMon=%JFProcessMonitorL_DPNE%
 set toMon=%toMon% --titlePrefix "Job:[%JobName%][%TcSiteId%]"
 set toMon=%toMon% --waitForProcess 15000
 set toMon=%toMon% --processName %Program_N%
 set toMon=%toMon% --parentProcessId 0
 REM  set toMon=%toMon% --runtimeLimitSeconds 7200
 set toMon=%toMon% --killChildProcesses
 set toMon=%toMon% --fileLastWriteTime "%toMonSearchPath%\*.*;600"
 set toMon=%toMon% --saveResultsTo "%temp%\zzJFProcessMonitor_log.xml"
 set toMon=%toMon% --tailTextFile "%toMonSearchPath%\*ugmanager_Process_program*.syslog"
:Next

 REM -- set Parameter ----------------
 set JobParameter=#JobParameter#
 if not defined JobParameter set  JobParameter=-No_Paramter

 REM -- Run fccCheck
 if /I "%JobMgr_fccCheck_USE%" equ "true" call fccCheck.cmd

 set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 Echo.                                                                               .
 Echo %titleTxt%
 call Echo "----------------------------------------------------------------------------"
 Call Echo "Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.........................: %JobName%"
 Call Echo "Computer........................: %ComputerName%"
 Call Echo "JobDir..........................: %temp:~-50%"
 Call Echo "##- - - - TC settings: - - - -##"
 Call Echo "TcSide..........................: #TcSite.SiteInfoWith_SiteId_and_pName#"
 Call Echo "TcUser..........................: %JobMgr_TcUser%"
 Call Echo "TC_ROOT.........................: %TC_ROOT%"
 Call Echo "TC_DATA.........................: %TC_DATA%"
 Call Echo "TC_SHARED_MEMORY Disable........: %TC_SHARED_MEMORY_DIR_Disable%"
 Call Echo "FMS FMS_HOME....................: %FMS_HOME%"
 if /I "%JobMgr_fccCheck_USE%" equ "true" Call Echo "FCC CHK.........................: %JobMgr_fccCheck_USE%//ParentFscAdr:%JobMgr_fccCheck_parentfsc_address%"
 Call Echo "##- - - - NX settings: - - - -##"
 Call Echo "UGII_ROOT_DIR...................: %UGII_ROOT_DIR%"
 Call Echo "UGII_LOAD_OPTIONS...............: ..\%UGII_LOAD_OPTIONS_NE%"
 Call Echo "UGII_SITE_DIR...................: %UGII_SITE_DIR%"
 Call Echo "UGII_LOCAL_USER_DEF.............: ..\%UGII_LOCAL_USER_DEFAULTS_NE%"
 Call Echo "##- - - - Job settings:  - - -##"
 Call Echo "Executing programm..............: %Program_DPNE%"
 Call JobParam_List "with Parameter..................:" "%JobParameter%"
 Call Echo "Use Proc.Monitor................: %JobMgr_PMon_USE%"

 cd /d "%temp%"
 set >>"%temp%\zzEnvironBeforeJob.txt"

 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 call Echo "JobExecuting....................: Protocol"

 IF /i "%JobMgr_Debug%" EQU "ON" (
  Call Echo "#Debug:........................: Before start Job"
  pause
 )
 REM -- Start JobMgr PMon #LUp21.03.17 start min based on JobMgr_WIMode
 if /i "%JobMgr_PMon_USE%" EQU "ON" (
  if /i "%JobMgr_WIMode%" equ "Normal" (
    start "PMon Job:[%JobName%][%TcSiteId%]" %toMon%
  ) else (
    start "PMon Job:[%JobName%][%TcSiteId%]" /min %toMon%
  )
 )

 Call Echo "Using cmd log file..............: %JobCmdOutPutLog_DPNE%"
 rem #Exa paramters -i="%JobInputList_DPNE%" -log="%JobLogFile_DPNE%" -resultFile="%JobResultFile_DPNE%" -u=%JobMgr_TcUser% -p=%JobMgr_TcPw% -g=%JobMgr_TcGroup%
 call RunLogged.exe "%JobCmdOutPutLog_DPNE%" "%Program_L%" %JobParameter%
 set Program_ExitCode=%errorlevel%

 IF /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Call Echo "#Debug:.........................: Results Info"
  Call Echo "Process Prg.....................: %Program_L%"
  Call Echo "Process Exit Code...............: %Program_ExitCode%"
  Call TypeFile "%JobCmdOutPutLog_DPNE%"  "program output.log"
  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
  Call Echo "#Debug..........................: %~0 Job:Execute END"
  pause
:JumbOverDebug

goto :eof

rem ============================================================================
:JobResEvaluate
 rem #Doc: Evaluate the Process results
 rem #New: 21.01.2021 14:31/J.Fes
 call ColorSet EvalResult
 call Echo "--- #Step: Job Result Evaluate --------------------------------------------"

 set toRun=%JobManagerCmdTools_L%
 rem set toRun=%toRun% -Action "CustomCmdTools_2016_04"
 rem set toRun=%toRun% -SubAction "ASMLTCACResultEval"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -SubActionSettingsXml "%JobMgr_ResultEvalSubActionSettingsXml%"
 set toRun=%toRun% -inputList_DPNE
 set toRun=%toRun% -JobData2ResultsDoPrint

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set toRun=%toRun% -verbose -pauseOnEnd
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_03_EvaluateResult.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Debug:.........................: Before: [%~0]"
   call Echo "#ToRun..........................: %toRunForPrint%"
   Echo %toRun% >>"%Debug_DPNE%"
   pause
:JumbOverDebug

 rem #Step: --- Run JCT ---
 call  %toRun%

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 REM set toRun=%toRun% -verbose -pauseOnEnd
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug..........................: After"
 pause
:JumbOverDebug

goto :eof

rem ============================================================================
:JobResEvaluateGeneric
 rem #Doc: Evaluate the Process results
 rem #New: 22.08.2017 14:31/J.Fes
 call ColorSet EvalResult
 call Echo "--- #Step: Job Result Evaluate --------------------------------------------"

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "JobDataEdit_2012_09"
 set toRun=%toRun% -SubAction "JobData2ResultsSetProcessValue"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -ObjProcessResultCode "0"
 set toRun=%toRun% -ObjProcessState  "D.OK"
 set toRun=%toRun% -ObjProcessResultMsg "[Res:GenericScript Process Done]"
 set toRun=%toRun% -ResultLink "%JobCmdOutPutLog_DPNE%"
 set toRun=%toRun% -JobData2ResultsDoPrint

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_03_EvaluateProcessResult.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Debug:.........................: Before: [%~0]"
   call Echo "#ToRun..........................: %toRunForPrint%"
   Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug

 rem #Step: --- Run JCT ---
 call  %toRun%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_03_EvaluateProcessResult.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Debug:.........................: after: [%~0]"
   call Echo "#ToRun..........................: %toRunForPrint%"
   Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug

goto :eof

REM ============================================================================
:TCDataExtract
 REM #New: 08.08.2017 S.Gueth
 REM #LUp: 08.03.2018 J.Fes now via SubActionSettings

 set JobMgr_eXtract_prePost=%~1

REM  if not defined TcData_eXtract_DP set TcData_eXtract_DP=%temp%\TcData
REM  if not exist "%TcData_eXtract_DP%" md "%TcData_eXtract_DP%"

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "TcExtractData_2013_10"
 set toRun=%toRun% -SubAction "DS_of_IR"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -ResultFile_DPNE "#JobRoot_DP#\01-TcExtractData_2013_10-DS_of_IR-resultfile.xml"
 rem set toRun=%toRun% -SubActionSettingsXml "%JobMgr_ExtractSettingsXml%"
 rem set toRun=%toRun% -eXtract_prePost "%JobMgr_eXtract_prePost%"
 rem set toRun=%toRun% -TcData_eXtract_DP "%TcData_eXtract_DP%"
 set toRun=%toRun% -TcSQL_DP "#TcSQL_DP#"

  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_04_BOM1ExtractPre.cmd.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Debug:.........................: Before: [%~0]"
   call Echo "#ToRun..........................: %toRunForPrint%"
   Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug

 call %toRun%
 set toRun=
goto :eof

