@Echo off
 REM ===========================================================================
 REM JobMgr Script for Customer (c)addPLM 2006..2017
 REM Date/Time  Name   Details:
 REM 22.08.2017 J.Fes  date of template version
 REM ===========================================================================

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 Call Echo "**************************************************************************"
 Call Echo "* Excuting Script for PLMJobManager                                      *"
 Call Echo "* Based on template Version: 25.01.2021 (c)addPLM GmbH                   *"
 Call Echo "**************************************************************************"

 REM -- define JobScript include Dirs
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 REM -- #Doc: Inits all Basics of Job
 Call "%~dp0_JobInitial.cmd" "GenScript" "YES" "YES" "YES" "NO" "NO"

 set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 rem -- #toDo: Setup TC Prompt for Custom
REM  set TCPrompt_Custom_Opt=NXCR
REM  set TCPrompt_Custom_Opt_NXEnv=NO
REM  if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"
REM
REM  if "%JobMgr_TCPromptGet_ResCode%" equ "0" call :StartProcess
REM  if "%JobMgr_TCPromptGet_ResCode%" neq "0" call :TcPromptERROR

 call :StartProcess

 rem #LUp:21.01.2021/J.Fes using _JobFinish at JobEnd
 Call "%~dp0_JobFinish.cmd"

goto :end

rem --- SUBROUTINES ------------------------------------------------------------
:StartProcess
 rem -- #Doc: Start your Process
 rem set JobMgr_PMon_USE=ON
 rem set JobMgr_fccCheck_USE=true
 rem -- #Doc: set TC_ROOT\Bin as first entry
 rem set path=%TC_ROOT%\bin;%path%
REM  Echo #Debug LI:48 %~nx0&Pause
REM call ErrorHandel "S"  "#DEBUG.ERR L49"  "#DEBUG Please check if JC Stops %~nx0"
 Call "%CmdCurRoot_DP%\GenericJob2_ExecuteProcess.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"
goto :eof

:TcPromptERROR
 rem -- #Doc: Call Error Handel because TC Prompt is incorrect
 call ErrorHandel "PS" "TCPromptGet Issue" "[TC-PromptRCode:%JobMgr_TCPromptGet_ResCode%] [TCPrompt:RMsg:%JobMgr_TCPromptGet_ResMsg%]"
goto :eof


REM ============================================================================
:end
 cd /d "%tempOrig_DP%"
 Call Echo "--------------------------------------------------------------------------"
 Call Echo "Info: all files in...............: %temp%"
 Call Echo "Info: will be zipt by JobClient..: and send to JobServer"
 EXIT /B 0


