-- set serveroutput on format wrapped;

-- define Cursor
DECLARE CURSOR cursorValue IS
      SELECT puid, rowning_siteu, rowning_sitec 
      FROM infodba.PPOM_OBJECT
      WHERE rowning_siteu is not null;
      -- define fetch datarow  
      ppom_object_rec cursorValue%ROWTYPE; 
      i NUMBER := 0;
      i_tp NUMBER := 0;

BEGIN
   -- get value of i_tp (i_tp=i_ToProcess) 
    SELECT COUNT(*) into i_tp FROM infodba.PPOM_OBJECT WHERE rowning_siteu is not null;
    OPEN cursorValue;
    -- Get First Data via cursor
    FETCH cursorValue INTO ppom_object_rec;
    -- Print Start Info
    DBMS_OUTPUT.put_line('Start: Update infodba.PPOM_OBJECT.rowning_siteu=null  infodba.PPOM_OBJECT.rowning_sitec=null');
  
    WHILE (cursorValue%FOUND) LOOP
      i := i + 1;
      -- Print Detail Data
      DBMS_OUTPUT.put_line('Update:' || i || '/' || i_tp || ' [' || ppom_object_rec.puid || '] [' || ppom_object_rec.rowning_siteu || '] [' || ppom_object_rec.rowning_sitec || ']');
      -- Update Data
      Update infodba.PPOM_OBJECT set rowning_siteu=null ,rowning_sitec=null where puid = ppom_object_rec.puid;   
      -- Commit Changes
      COMMIT;
      -- Get Next Data via cursor
      FETCH cursorValue INTO ppom_object_rec;
    END LOOP;
    -- Print End Info
    DBMS_OUTPUT.put_line('End..: Update infodba.PPOM_OBJECT.rowning_siteu=null  infodba.PPOM_OBJECT.rowning_sitec=null');
    CLOSE cursorValue;
END ; 
 
