-- TCUA:Read all IRs Data for IR sync
-- #New 08.03.2021/J.Fes
SELECT  /* #ORA.HINT# */
  i.puid               AS ItemPuid,
  i.pitem_id           AS ItemId,
  paoI.plast_mod_date  AS ItemLastModDate,
  ir.puid              AS IrPuid,
  ir.pitem_revision_id AS IrId,
  paoIr.plast_mod_date AS IrLastModDate,
  o.plsd               AS IrLastSavDate,
  pwo.pdate_released   AS IrReleaseDate,

  s.psite_id           AS IrOwningSite_TC_pSite_ID,
  s.pname              AS IrOwningSite,

  pgIr.pname           AS IrOwningGroup,
  pgIr.puid            AS IrOwningGroupPuid

FROM infodba.PITEM i
 LEFT JOIN infodba.PITEMREVISION           ir    ON (ir.ritems_tagu = i.puid)
 LEFT JOIN infodba.PPOM_APPLICATION_OBJECT paoI  ON (i.puid = paoI.puid)
 LEFT JOIN infodba.PPOM_APPLICATION_OBJECT paoIr ON (ir.puid = paoIr.puid)
 LEFT JOIN infodba.PPOM_OBJECT             o     ON (o.puid = ir.puid)
 LEFT JOIN infodba.PPOM_IMC                s     ON (s.puid = o.rowning_siteu)
 LEFT JOIN infodba.PPOM_GROUP              pgIr  ON (paoIr.rowning_groupu = pgIr.puid)
 LEFT JOIN infodba.PWORKSPACEOBJECT        pwo   ON (pwo.puid = ir.puid)
WHERE
 pwo.pactive_seq = 1
