-- TCUA:IRs L.Up 27.05.2014 on Update see IRs_TCUA.sql
-- 04.03.2021/ add IrLastSavDate
SELECT /* #ORA.HINT# */
  i.puid               AS ItemPuid,
  i.pitem_id           AS ItemId,
  paoI.plast_mod_date  AS ItemLastModDate,
  ir.puid              AS IrPuid,
  ir.pitem_revision_id AS IrId,
  paoIr.plast_mod_date AS IrLastModDate,
  o.plsd               AS IrLastSavDate,
  s.psite_id           AS OwningSite_TC_pSite_ID
FROM infodba.PITEM i
 LEFT JOIN infodba.PITEMREVISION ir on (i.puid = ir.ritems_tagu)
 LEFT JOIN infodba.PPOM_OBJECT o on (ir.puid = o.puid)
 LEFT JOIN infodba.PPOM_IMC s ON (o.rowning_siteu = s.puid)
 LEFT JOIN infodba.PPOM_APPLICATION_OBJECT paoIr ON (ir.puid = paoIr.puid)
 LEFT JOIN infodba.PPOM_APPLICATION_OBJECT paoI ON (i.puid = paoI.puid)
 LEFT JOIN infodba.PWORKSPACEOBJECT pwo On (ir.puid = pwo.puid)
Where
     pwo.pactive_seq = 1
 and paoIr.plast_mod_date >= TO_DATE(:para_plast_mod_date_min, 'DD.MM.YYYY HH24:MI')
 and paoIr.plast_mod_date <= TO_DATE(:para_plast_mod_date_max, 'DD.MM.YYYY HH24:MI')
