/* IR DS 28.10.09 J.Fes/T.Nestler */
Select
  pd.puid               As DataSetPuid,
  s.psite_id            As OwningSite_TC_pSite_ID,
  wso.pobject_name      As DataSetName,
  wso.pobject_desc      As DataSetDescription,
  pdt.pdatasettype_name As DataSetType,
  ptype.ptype_name      As DataSetPTYPE_NAME,
  pu_owni_ds.puser_id   As DataSetOwningUser,
  pg_owni_ds.pname      As DataSetOwningGroup,
  pao.pcreation_date    As DataSetCreateDate,
  pu_lmod_ds.puser_id   As DataSetLastModUser,
  pao.plast_mod_date    As DataSetLastModDate
--  imv.pvolume_name      As imv_pvolume_name,
--  imv.pmachine_type     As imv_pmachine_type,
--  imv.punix_path_name   As imv_punix_path_name,
--  imv.pwnt_path_name    As imv_pwnt_path_name,
--  imf.psd_path_name     As imf_psd_path_name,
--  imf.pfile_name        As imf_pfile_name
From
  infodba.PDATASET pd
Inner Join infodba.PIMANRELATION pr            On (pr.rsecondary_objectu = pd.puid)
Inner Join infodba.PIMANTYPE ptype             On (ptype.puid = pr.rrelation_typeu)
Inner Join infodba.PDATASETTYPE pdt            On (pd.rdataset_typeu = pdt.puid)
Inner Join infodba.PWORKSPACEOBJECT wso        On (pd.puid = wso.puid)
Inner Join infodba.PREF_LIST_0 rl                On (rl.puid = pd.puid)
Inner Join infodba.PREF_NAMES_0 rn               On (rl.pseq = rn.pseq)
Inner Join infodba.PREVISIONS rev              On (pd.rrev_chain_anchoru = rev.puid) and (rev.pvalu_0 = rn.puid)
Inner Join infodba.PPOM_APPLICATION_OBJECT pao On (pao.puid = rev.pvalu_0)
Inner Join infodba.PPOM_USER pu_owni_ds        On (pu_owni_ds.puid = pao.rowning_useru)
Inner Join infodba.PPOM_USER pu_lmod_ds        On (pu_lmod_ds.puid = pao.rlast_mod_useru)
Inner Join infodba.PPOM_GROUP pg_owni_ds       On (pg_owni_ds.puid = pao.rowning_groupu)
Left Join infodba.PPOM_OBJECT o                On (pd.puid = o.puid)
Left Join infodba.PPOM_IMC s                   On (o.rowning_siteu = s.puid)
-- Inner Join infodba.PIMANFILE imf               On (imf.puid = rl.pvalu_0)
-- Inner Join infodba.PIMANVOLUME imv             On (imf.rvolume_tagu = imv.puid)
Where 
    rev.pseq = 0 -- n.last DS
    and pr.rprimary_objectu = :para_puid
    -- and ptype.ptype_name like 'IMAN%'
    and pdt.pdatasettype_name like 'UG%'
    -- and pdt.pdatasettype_name like 'IMAN%' 
    -- and rn.pval_0 in ('UGPART','IdeasPart','IdeasAssembly','IdeasDrawing','AsmFile','PrtFile','DrwFile') -- UGPART, Ideas* (new 13.09.13 JF)  Pro*(New 05.02.14 JF)
    -- or rn.pval_0 is null
