/* DS.FS 04.03.2014 J.Fes */
Select 
 pd.puid As DataSetPuid,
 pwo.pobject_name      As pd_name,
 imv.pmachine_type     As imv_pmachine_type,
 imv.pvolume_name      As imv_pvolume_name,
 imv.punix_path_name   As imv_punix_path_name,
 imv.pwnt_path_name    As imv_pwnt_path_name,
 imf.psd_path_name     As imf_psd_path_name,
 imf.pfile_name        As imf_pfile_name,
 pao.plast_mod_date    As imf_lastmoddat,
 rev.puid              As revPuid,
 ra.phighest_rev       As pdVerMax,
 ra.pkeep_limit        As pdKeepLimit,
 rev.PSEQ              As pd_RevSeq,
 ra.phighest_rev - rev.PSEQ As pdVersion
From
 infodba.PDATASET pd
 Left Join infodba.PREVISIONS       rev On (rev.puid = pd.rrev_chain_anchoru)
 Left Join infodba.PREVISIONANCHOR  ra  On (ra.puid =  pd.rrev_chain_anchoru)  
 Left Join infodba.PREF_LIST_0      rl  On (rl.puid = rev.pvalu_0)
 Left Join infodba.PWORKSPACEOBJECT pwo On (pwo.puid = rev.pvalu_0) 
 Left Join infodba.PREF_NAMES_0     rn  On (rl.puid = rn.puid And rl.pseq = rn.pseq)
 Left Join infodba.PIMANFILE        imf On (imf.puid = rl.pvalu_0)
 Left Join infodba.PIMANVOLUME      imv On (imv.puid = imf.rvolume_tagu)
 Left Join infodba.PPOM_APPLICATION_OBJECT pao On (pao.puid = imf.puid)
where
 pd.puid = :para_puid
 and (rev.PSEQ < ra.pkeep_limit and rev.PSEQ <= :para_PSEQ)
 and rn.pval_0 In (
 'UGPART',
 'IdeasPart','IdeasAssembly','IdeasDrawing',
 'AsmFile', 'PrtFile', 'DrwFile',
 'catpart','catproduct','catdrawing'
 )