Option Compare Text
Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections.Generic
Imports System.Data
Imports System.Diagnostics

Imports JF.PlmJobManager.JobServer
Imports JF.Tools
Imports JF.PlmJobManager
Imports JF.InfoSys


'' --------------------------------------------------------------------------------------------------------
'' Script for Importing Data via TaskSheduler:
''  Date         Person   Info
''  22.05.2018   J.Fes    createt
''  22.05.2018   J.Fes    #Doc: add Parameter
''  23.05.2018   J.Fes    #Doc: add process 
''  04.06.2018   S.Gueth  #Doc: added parameter /PrintDefaultVolOnly
''  05.06.2024   J.Fes    #Doc: added parameter /RevokeGrandDoForUserGroupNames +  /RevokeGrandDoForUserGroupNames
''  16.06.2024   J.Fes    #Doc: VolumeRevokeGrandInfo.sql returns now TCUserID (see Table:PPOM_USER.puser_id)
'' --------------------------------------------------------------------------------------------------------
'' 
'' #Doc: Parameter usage:
'' Required Parameters
'' /TcSiteID=TcSite1                     #Doc: Defines TC-SiteId to Check for Revoke Grand needs 
'' /RevokeGrandeDoIfMoreThenNFiles=32000 #Doc: Defines N files Limit when Revoke Grand process need to be processed
'' /TC_RevokeGrandVolTemp=VolTemp        #Doc: Defines 'Temp Volume' used during Revoke Grand Process 
'' /Mode=ListOnly/eXecute                #Doc: Defines execution Mode default = ListOnly
''                                       #Doc: /Mode=ListOnly defines to list VolumenRevokeGrand Info no Action will be done
''                                       #Doc: /Mode=eXcecute defines to eXecute Revoke Grand Process if RevokeGrand condition is found in Volume Report
'' Optional Parameters
'' /RevokeGrandScript_TPNE=VolumeRevokeGrant_TC\VolumeRevokeGrant_CustomRun.cmd
''                                       #Doc:  Defines Custom Revoke Grand Script
''                                             |->  [Optinal default = /RevokeGrandScript_TPNE=VolumeRevokeGrant_TC\VolumeRevokeGrant_CustomRun.cmd)
'' TC authentication                     #Doc: if not set is using JobComputer settings 
'' /JobMgr_TcUser=TcDBAUserName          #Doc: Defines TC User for revoke grand script process 
'' /JobMgr_TcPw=TcUserPw                 #Doc: Defines TC User password  
'' /JobMgr_TcGroup=TCDBAGroupName        #Doc: Defines TC Group
'' /JobMgr_Debug=ON/OFF                  #Doc: Defines if RevokeGrands Script is running in Debug mode Default=OFF
'' /JobMgr_Test=ON/OFF                   #Doc: Defines if RevokeGrands Script is running in Test mode  Default=OFF
'' /PrintDefaultVolOnly=true/false       #Doc: Defines if every volume info or only default volume info should be printet to infosys

'' RevokeGrand Check conditions
'' /RevokeGrandDoForUserGroupNames       #Doc: Defines if RevokeGrand will be done only for specific users
''                                             |-> #Exa: /RevokeGrandDoForUserGroupNames=CustomFunc1User0*;CustomFunc2User0*...
'' /RevokeGrandDoUserOnAllVols           #Doc: Defines if RevokeGrand will be done RevokeGrand will be done also on all volumes where user has alrady one subdir
''                                             |-> [Default=false] /RevokeGrandDoUserOnAllVols=false meeans that RevokGrand will be only on Users default done

'' #Examples: List Only
'' /TcSiteID=TC10 /RevokeGrandeDoIfMoreThenNFiles=1 /TC_RevokeGrandVolTemp=volumeRevokeGrandTemp /Mode=ListOnly 
'' /TcSiteID=TC10 /RevokeGrandeDoIfMoreThenNFiles=25000 /TC_RevokeGrandVolTemp=volumeRevokeGrandTemp /Mode=eXecute

'' /RevokeGrandDoForUserGroupNames=refileusr01;refileusr02;refileusr0[3-4]

Namespace JS_ScriptingVolumeRevokeGrand


    ''' <summary>
    ''' Processes Volume Revoke Grand
    ''' </summary>
    ''' <remarks> 
    ''' #New: 3.1465;22.05.2018;J.Fes
    ''' </remarks>
    Public Class VolumeRevokeGrand

        Public Shared ReadOnly Property MyName As String
            Get
                Return "VolumeRevokeGrand_TC.vb"
            End Get
        End Property

        Dim DataSource_Obj As New MyAppl_DataSource_cls(MyName)
        '-- #Doc: ScriptResult_r required Object for returning script results
        Dim ScriptReturn_r As New JF_Return_cls
        Dim InfoSys_Obj As JF_InfoSys

        '-- Class share variables
        Private TcSiteId As String
        Private SiteDef_Obj As New SiteDef_cls
        Private EndOfProcessDoWait_msec As Integer
        Private RevokeGrandeXecuteDone As Boolean = False
        Private Mode As Mode_enum

        Private TC_RevokeGrandVolTemp As String
        Private TC_VolDefault As String
        Private TC_VolRevokeGrand As String

        Private RevokeGrandeDoIfMoreThenNFiles As Integer = 0
        Private RevokeGrandScript_TPNE As String
        Private RevokeGrandScript_S_fp As New JF.Tools.JF_FileDef_cls
        Private RevokeGrandScript_L_fp As New JF.Tools.JF_FileDef_cls

        ''' <summary>
        ''' 
        ''' </summary>
        Private RevokeGrandDoForUserGroupNames As String


        ''' <summary>
        ''' 
        ''' </summary>
        Private RevokeGrandDoForUserOnAllVols As Boolean


        Private JobMgr_Log_DP As String
        Private JobMgr_ProcessResultData As New JF.PlmJobManager.JobServer.JobData_cls
        Private PrintDefaultVolOnly As Boolean = False

        Private JobMgr_TcUser As String = "Unkown"
        Private JobMgr_TcPw As String = ""
        Private JobMgr_TcPwOutput As String = ""
        Private JobMgr_TcGroup As String = ""
        Private JobMgr_Debug As String
        Private JobMgr_Test As String
        Private JS_ScriptingInterface_lp As JobServer.ScriptingInterface.Methodes

        Private ReadOnly Property JobMgr_DebugIsOn As Boolean
            Get
                Return Me.JobMgr_Debug = "ON"
            End Get
        End Property


        Private Enum Mode_enum
            ListOnly
            eXecute
        End Enum

        Private ScriptOutput_frm As JobServer_ScriptRun_frm

        ''' <summary>
        ''' Mainsript for processing TC - Volumen revoke grand 
        ''' </summary>
        ''' <param name="JS_ScriptingInterface_p"></param>
        ''' <remarks> 
        ''' #New: 3.1465;23.05.2018;J.Fes
        ''' #LUp: 3.2000;05.06.2024;J.Fes
        ''' </remarks>
        Public Function ScriptMain(ByVal JS_ScriptingInterface_p As JobServer.ScriptingInterface.Methodes) As JF_Return_cls

            '-- #Doc: Mapp info Sys to TaskShedulerInfoSysGet
            Me.InfoSys_Obj = JS_ScriptingInterface_p.TaskShedulerInfoSysGet()
            Me.JS_ScriptingInterface_lp = JS_ScriptingInterface_p

            Try

                Me.InfoSys_Obj.PrintInfoLine(MyName)
                Me.InfoSys_Obj.PrintObject("Run Script", JS_ScriptingInterface_p.ScriptDef.NameDescription)
                Me.InfoSys_Obj.PrintObject("with parameters", JS_ScriptingInterface_p.ScriptDef.cmdPara)

                '-- #Step: Get Parameters
                Me.TcSiteId = JS_ScriptingInterface_p.ParameterValueGet("TcSiteID")
                Me.TC_RevokeGrandVolTemp = JS_ScriptingInterface_p.ParameterValueGet("TC_RevokeGrandVolTemp")

                Me.RevokeGrandScript_TPNE = JS_ScriptingInterface_p.ParameterValueGet("RevokeGrandScript_TPNE")
                Me.RevokeGrandeDoIfMoreThenNFiles = CTypeTryDefault(Of Integer)(JS_ScriptingInterface_p.ParameterValueGet("RevokeGrandeDoIfMoreThenNFiles"), -1)
                Me.RevokeGrandDoForUserGroupNames = JS_ScriptingInterface_p.ParameterValueGet("RevokeGrandDoForUserGroupNames", "*")
                Me.RevokeGrandDoForUserOnAllVols = If(JS_ScriptingInterface_p.ParameterValueGet("RevokeGrandDoUserOnAllVols") = "true", True, False)

                Me.PrintDefaultVolOnly = If(JS_ScriptingInterface_p.ParameterValueGet("PrintDefaultVolOnly") = "true", True, False)

                Me.EndOfProcessDoWait_msec = CTypeTryDefault(Of Integer)(JS_ScriptingInterface_p.ParameterValueGet("EndOfProcessDoWait_msec"), -1)

                Me.JobMgr_TcUser = JS_ScriptingInterface_p.ParameterValueGet("JobMgr_TcUser")
                Me.JobMgr_TcPw = JS_ScriptingInterface_p.ParameterValueGet("JobMgr_TcPw")
                Me.JobMgr_TcGroup = JS_ScriptingInterface_p.ParameterValueGet("JobMgr_TcGroup")
                Me.Mode = Mode_enum.ListOnly
                If JS_ScriptingInterface_p.ParameterValueGet("Mode").ToUpper = Mode_enum.eXecute.ToString.ToUpper Then
                    Me.Mode = Mode_enum.eXecute
                End If
                Me.JobMgr_Debug = JS_ScriptingInterface_p.ParameterValueGet("JobMgr_Debug").ToUpper
                Me.JobMgr_Test = JS_ScriptingInterface_p.ParameterValueGet("JobMgr_Test").ToUpper

                '-- #Doc: Interpret and set defaults -----------------------------------
                If Me.RevokeGrandScript_TPNE = "" Then
                    Me.RevokeGrandScript_TPNE = IO.Path.Combine("VolumeRevokeGrant_TC", "VolumeRevokeGrant_CustomRun.cmd")
                End If
                If Me.JobMgr_Debug = "" Then Me.JobMgr_Debug = "OFF"
                If Me.JobMgr_Test = "" Then Me.JobMgr_Test = "OFF"


                '-- #Doc: Get and Check RevokeGrand Scripts Server ----------------------
                Me.RevokeGrandScript_S_fp.File_DPNE = IO.Path.Combine(JS_ScriptingInterface_p.ServerSettings.Dir_DataRoot_DP_Customer_SettingsGlobal_10JobScripts, Me.RevokeGrandScript_TPNE)
                '-- #Doc: Get and Check RevokeGrand Scripts Local -----------------------
                Me.RevokeGrandScript_L_fp.File_DPNE = IO.Path.Combine(Me.JS_ScriptingInterface_lp.ServerSettings.Dir_JobClientJobProcessRootLocal_DP, "VolumeRevokeGrand_TC", Me.RevokeGrandScript_S_fp.File_NE)


                '-- #Doc: set process log directory
                Me.JobMgr_Log_DP = Path.Combine(Me.RevokeGrandScript_S_fp.File_DP, "LogVRG", "PLog_" + JF.Tools.DateTimeForFileExtend(Now, DateTimeFormat_enum.Format_YYMMDDHM))
                Me.JobMgr_ProcessResultData.ProcessResultLink = Path.Combine(Me.JobMgr_Log_DP, "00-ProcessResult_log.txt")

                '-- #Doc: Get TcUser TcPw TcGroup ---------------------------------------
                Dim JobComputer_Obj As New JF.PlmJobManager.JobServer.JobComputer_cls
                JobComputer_Obj = Me.DataSource_Obj.JobComputers_tbl_Get_JobComputer_Obj_by_ComputerName(My.Computer.Name, True)
                If JobComputer_Obj IsNot Nothing Then
                    '-- #Doc: get Tc User PW from JobComputer 
                    '-- If TcUser = '' 
                    '---    and JobComputer found 
                    '--     and JobComputer_Obj.TcSiteId_Default = SiteId_p.ToUpper 
                    If Me.JobMgr_TcUser = "" And JobComputer_Obj.TcSiteId_Default.ToUpper = Me.TcSiteId.ToUpper Then
                        Me.InfoSys_Obj.PrintObject("TCUser+Pw from JobComputer", JobComputer_Obj.ComputerNameAndDescription)
                        Me.JobMgr_TcUser = JobComputer_Obj.TcUser
                        Me.JobMgr_TcPw = JobComputer_Obj.TcPassword_Plaintext
                    End If
                End If

                If Me.JobMgr_TcUser = "" Then
                    Me.JobMgr_TcUser = "ISSUE TC User is UnKown"
                End If

                If Me.JobMgr_TcPw = "" Then
                    Me.JobMgr_TcPwOutput = "ISSUE TC password is UnKown"
                Else
                    Me.JobMgr_TcPwOutput = "********"
                End If

                If Me.JobMgr_TcGroup = "" Then
                    Me.JobMgr_TcGroup = "dba"
                End If


                '-- #Setp: List Interpreted paramters -----------------------------------
                Me.InfoSys_Obj.PrintTrennPunkteLinie()
                Me.InfoSys_Obj.PrintObject("Parmaters", "Interpreted values")
                Me.InfoSys_Obj.PrintObject("SiteId", Me.TcSiteId)
                Me.InfoSys_Obj.PrintObject("TC_RevokeGrandVolTemp", Me.TC_RevokeGrandVolTemp)

                Me.InfoSys_Obj.PrintObject("Mode", Me.Mode.ToString)
                Me.InfoSys_Obj.PrintObject("RevokeGrandeDoIfMoreThenNFiles", Me.RevokeGrandeDoIfMoreThenNFiles)
                Me.InfoSys_Obj.PrintObject("RevokeGrandUserFilter", Me.RevokeGrandDoForUserGroupNames)
                Me.InfoSys_Obj.PrintObject("RevokeGrandDoForUserOnAllVols", Me.RevokeGrandDoForUserOnAllVols)

                Me.InfoSys_Obj.PrintObject("RevokeGrand", "Script")
                Me.InfoSys_Obj.PrintObject("RevokeGrandScript_TPNE", Me.RevokeGrandScript_TPNE)
                Me.InfoSys_Obj.PrintObject("RevokeGrandScript Server", Me.RevokeGrandScript_S_fp.File_DPNE)
                Me.InfoSys_Obj.PrintObject("RevokeGrandScript Local fullpath", Me.RevokeGrandScript_L_fp.File_DPNE)

                Me.InfoSys_Obj.PrintObject("RevokeGrand done by", "TC.User")
                Me.InfoSys_Obj.PrintObject("TC User", Me.JobMgr_TcUser)
                Me.InfoSys_Obj.PrintObject("TC Passw", Me.JobMgr_TcPwOutput)
                Me.InfoSys_Obj.PrintObject("TC Group", Me.JobMgr_TcGroup)

                If Me.RevokeGrandeDoIfMoreThenNFiles <= 0 Then
                    Me.ScriptReturn_r.ErrMsg = "ISSUE in Task:" + JS_ScriptingInterface_p.ScriptDef.NameDescription
                    Me.InfoSys_Obj.PrintObject("Result", ScriptReturn_r.ErrMsg)
                    Me.InfoSys_Obj.PrintObject("Value to low for", "please check parameter /RevokeGrandeDoIfMoreThenNFiles='" + Me.RevokeGrandeDoIfMoreThenNFiles.ToString + "'")
                    Me.ScriptReturn_r.ResultMsgAdd(InfoSys_Obj.PrintTextLineLast_r)
                    Exit Try
                End If

                If Me.TC_RevokeGrandVolTemp = "" Then
                    Me.ScriptReturn_r.ErrMsg = "ISSUE in Task:" + JS_ScriptingInterface_p.ScriptDef.NameDescription
                    Me.InfoSys_Obj.PrintObject("Result", ScriptReturn_r.ErrMsg)
                    Me.InfoSys_Obj.PrintObject("Missing req par /VolTemp", "please check parameter /VolTemp=")
                    Me.ScriptReturn_r.ResultMsgAdd(InfoSys_Obj.PrintTextLineLast_r)
                    Exit Try
                End If

                '-- #Step: Get Site Def Data
                Me.InfoSys_Obj.PrintObject("Check SiteDef for SiteID", Me.TcSiteId)
                Me.ScriptReturn_r.ResultMsgAdd(InfoSys_Obj.PrintTextLineLast_r)
                Me.SiteDef_Obj = DataSource_Obj.Sites_tbl_SiteDefGet_by_SiteId(Me.TcSiteId)


                '-- #Doc: Check if SiteDef is found for SiteID 
                If Not Me.SiteDef_Obj.SiteDefFound_bol Then
                    Me.ScriptReturn_r.ErrMsg = "ISSUE in Task:" + JS_ScriptingInterface_p.ScriptDef.NameDescription
                    Me.InfoSys_Obj.PrintObject("Result", ScriptReturn_r.ErrMsg)
                    Me.InfoSys_Obj.PrintObject("SiteDef not found for SiteID", Me.TcSiteId + "' please check parameter /SiteID='" + Me.TcSiteId + "'")
                    Me.ScriptReturn_r.ResultMsgAdd(InfoSys_Obj.PrintTextLineLast_r)
                    Exit Try
                End If

                '-- #Doc: Check if SiteDef is active
                If Not Me.SiteDef_Obj.SiteAktive_bol Then
                    Me.ScriptReturn_r.ErrMsg = "ISSUE in Task: " + JS_ScriptingInterface_p.ScriptDef.NameDescription
                    Me.InfoSys_Obj.PrintObject("SiteDef found OK", Me.SiteDef_Obj.SiteID)
                    Me.ScriptReturn_r.ResultMsgAdd(InfoSys_Obj.PrintTextLineLast_r)
                    Me.InfoSys_Obj.PrintObject("SiteDef ISSUE happend", "Site is not active please check settings in Sites/Data Site:ID='" + Me.SiteDef_Obj.SiteID + "'")
                    Me.ScriptReturn_r.ResultMsgAdd(InfoSys_Obj.PrintTextLineLast_r)
                    Exit Try
                End If

                If Me.InfoSys_Obj.StopCurActionState Then
                    Me.InfoSys_Obj.PrintObject("Script stop", "by user")
                    Exit Try
                End If

                '-- #Step: start run revoke grand process
                Me.InfoSys_Obj.PrintTrennPunkteLinie()
                Me.InfoSys_Obj.PrintObject("Start Revoke Grand CHK for Site", Me.SiteDef_Obj.SiteInfoWith_SiteId_and_pName)

                '-- #Step: Get TC Volume Info
                '-- #LUp: 3.2000;20.06.2024;A.Stein added Me.RevokeGrandeDoIfMoreThenNFiles as parameter in JobServer_TcData_VolumeRevokeGrandInfo_cls
                Dim JobServer_TcData_VolumeRevokeGrandInfo_Obj As _
                    New JobServer_TcData_VolumeRevokeGrandInfo_cls(Me.SiteDef_Obj, Me.InfoSys_Obj, DataSource_Obj, Me.RevokeGrandDoForUserGroupNames, Me.RevokeGrandeDoIfMoreThenNFiles, Me.JobMgr_DebugIsOn)

                '-- #Step: do read vol Info from TC.DB 
                JobServer_TcData_VolumeRevokeGrandInfo_Obj.VolInfoReadFromTcDB(PrintDefaultVolOnly)

                '-- #Step: do process 
                For Each VolInfo_Obj_c As JobServer_TcData_VolumeRevokeGrandInfo_cls.VolInfo_cls In JobServer_TcData_VolumeRevokeGrandInfo_Obj.VolInfos

                    If Me.InfoSys_Obj.StopCurActionState Then
                        Me.InfoSys_Obj.PrintObject("Script stop", "by user")
                        Exit Try
                    End If

                    '-- do process if Me.Mode = Mode_enum.ListOnly
                    If Me.Mode = Mode_enum.ListOnly Then
                        Continue For
                    End If

                    '-- Check if VolInfo_Obj_c.Name is includet in Me.RevokeGrandDoForUserGroupNames
                    If Not JobServer_TcData_VolumeRevokeGrandInfo_cls.VolInfoNameIsIncludetInUserOrGroupName(VolInfo_Obj_c, Me.RevokeGrandDoForUserGroupNames, Me.JobMgr_DebugIsOn, Me.InfoSys_Obj) Then
                        Continue For
                    End If

                    With VolInfo_Obj_c
                        ' ApplDokuIntern: 3.2000;05.06.2024;J.Fes;#Doc: add Me.RevokeGrandDoUserOnAllVols
                        If .IsDefaultVol Or Me.RevokeGrandDoForUserOnAllVols Then

                            If .NFiles > Me.RevokeGrandeDoIfMoreThenNFiles Then
                                Me.InfoSys_Obj.PrintTrennPunkteLinie()
                                Me.InfoSys_Obj.PrintObject("Revoke-Grand is needed", VolInfo_Obj_c.VolInfoHeaderForOutput)
                                Me.InfoSys_Obj.PrintObject("for", VolInfo_Obj_c.VolInfoDataForOutput(VolInfo_Obj_c))
                                Me.InfoSys_Obj.PrintObject("Process Mode", Me.Mode.ToString)
                                Me.InfoSys_Obj.PrintObject("uses Revoke Grand Script" + Me.Mode.ToString, Me.RevokeGrandScript_S_fp.File_DPNE)

                                Select Case Me.Mode
                                    Case Mode_enum.eXecute
                                        Call Me.RevokeGrand_eXecute(VolInfo_Obj_c)

                                    Case Mode_enum.ListOnly

                                End Select
                            End If
                        End If
                    End With
                Next

            Catch ex As Exception
                Me.ScriptReturn_r.Ex = ex
                Me.ScriptReturn_r.ExMsg = "Exception in Script:" + JS_ScriptingInterface_p.ScriptDef.NameDescription
                Me.ScriptReturn_r.ResultMsgAdd(JF.Tools.JF_ErrHandler_cls.MyAppl_ExToStr(JF_ErrHandler_cls.Appl_ErrMsg_Enum.err0001_NotSpec, ex, "TaskShedule:" + JS_ScriptingInterface_p.ScriptDef.NameDescription))
                Me.InfoSys_Obj.PrintEx(ex, MyName)
            End Try

            Me.InfoSys_Obj.PrintTrennPunkteLinie()
            If Not Me.RevokeGrandeXecuteDone Then
                Me.InfoSys_Obj.PrintObject("Process End", "Without doing any action's")
                ' Me.ScriptReturn_r.ResultMsgAdd(InfoSys_Obj.PrintTextLineLast_r)
            Else
                Me.InfoSys_Obj.PrintObject("Process End", "With processing 'Revoke Grand' Check")
                Me.ScriptReturn_r.ResultMsgAdd(InfoSys_Obj.PrintTextLineLast_r)
            End If

            '-- #Step: Wait n sec before end
            If Me.EndOfProcessDoWait_msec > 0 Then
                Me.InfoSys_Obj.PrintObject_and_StatusBarSetCurrActionStatusInfo_Panel3("wait", (Me.EndOfProcessDoWait_msec / 1000).ToString("#.#") + " sec")
                System.Threading.Thread.Sleep(Me.EndOfProcessDoWait_msec)
            End If


            Return ScriptReturn_r
        End Function



        ''' <summary>
        ''' function copy all required scripts to local directory
        ''' </summary>
        Private Sub RevokeGrand_eXecute_prepare()

            Static RevokeGrand_eXecute_prepare_st As Boolean = False

            '-- #Doc: Check if Revoke Grand Prepare is Done
            If RevokeGrand_eXecute_prepare_st Then
                Exit Sub
            End If

            Dim Result_Obj_R As New JF_Return_cls

            Me.InfoSys_Obj.PrintObject("VolRG prepare Scripts RG", Me.RevokeGrandScript_S_fp.File_DP)

            '-- #Doc: Copy RevokeGrand scripts to local computer 
            Result_Obj_R = JF.Tools.DirCopyUpdate(Me.RevokeGrandScript_S_fp.File_DP, Me.RevokeGrandScript_L_fp.File_DP, ".*?", "((.*?).bak$)|((.*?).tmp$)|(.*Archiv)|(.*Documentation)")

            Me.InfoSys_Obj.PrintObject("VolRG prepare Scripts TCPrompt", Me.JS_ScriptingInterface_lp.ServerSettings.Dir_DataRoot_DP_Customer_SettingsGlobal_10JobScripts_CustomDefaults_TcPrompt)
            '-- #Doc: Copy 10JobScripts_JobMgrDefaults scripts to local computer 
            Result_Obj_R = JF.Tools.DirCopyUpdate(Me.JS_ScriptingInterface_lp.ServerSettings.Dir_DataRoot_DP_Customer_SettingsGlobal_10JobScripts_CustomDefaults_TcPrompt,
                                                  Me.RevokeGrandScript_L_fp.File_DP, ".*?", "((.*?).bak$)|((.*?).tmp$)")

            Me.InfoSys_Obj.PrintObject("VolRG prepare Scripts JobMgrDef", Me.JS_ScriptingInterface_lp.ServerSettings.Dir_DataRoot_DP_Customer_SettingsGlobal_10JobScripts_JobMgrDefaults)
            '-- #Doc: Copy 10JobScripts_JobMgrDefaults scripts to local computer 
            Result_Obj_R = JF.Tools.DirCopyUpdate(Me.JS_ScriptingInterface_lp.ServerSettings.Dir_DataRoot_DP_Customer_SettingsGlobal_10JobScripts_JobMgrDefaults,
                                                  Me.RevokeGrandScript_L_fp.File_DP, ".*?", "((.*?).bak$)|((.*?).tmp$)")
            RevokeGrand_eXecute_prepare_st = True
        End Sub

        ''' <summary>
        ''' eXcutes Revoke Grand process via RevokeGrand script
        ''' </summary>
        ''' <remarks> 
        ''' #New: 3.1465;23.05.2018;J.Fes
        ''' </remarks>
        Private Sub RevokeGrand_eXecute(volInfo_Obj_p As JobServer_TcData_VolumeRevokeGrandInfo_cls.VolInfo_cls)


            Dim cmdProg_p As String
            Dim cmdArgs_p As String
            Dim StandardOutput_r As String = ""
            Call RevokeGrand_eXecute_prepare()

            cmdProg_p = Me.RevokeGrandScript_L_fp.File_DPNE
            cmdArgs_p = ""

            Dim ProcessStartInfo_Obj As New ProcessStartInfo(cmdProg_p, cmdArgs_p)
            'ProcessStartInfo_Obj.UseShellExecute = False
            'ProcessStartInfo_Obj.CreateNoWindow = True
            'ProcessStartInfo_Obj.RedirectStandardOutput = True

            Try
                '-- Set environ variables 
                Call System.Environment.SetEnvironmentVariable("JobMgr_Debug", Me.JobMgr_Debug, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("JobMgr_Test", Me.JobMgr_Test, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("JobMgr_Log_DP", Me.JobMgr_Log_DP, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("JobMgr_ProcessResult_Log_DPNE", Me.JobMgr_ProcessResultData.ProcessResultLink, EnvironmentVariableTarget.Process)

                Call System.Environment.SetEnvironmentVariable("TCSiteID", Me.TcSiteId, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("JobMgr_TcUser", Me.JobMgr_TcUser, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("JobMgr_TcPw", Me.JobMgr_TcPw, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("JobMgr_TcGroup", Me.JobMgr_TcGroup, EnvironmentVariableTarget.Process)

                Call System.Environment.SetEnvironmentVariable("TC_RevokeGrandVolTemp", Me.TC_RevokeGrandVolTemp, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("TC_RevokeGrandVol", volInfo_Obj_p.Volume, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("TC_RevokeGrandType", volInfo_Obj_p.Type, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("TC_RevokeGrandName", volInfo_Obj_p.Name, EnvironmentVariableTarget.Process)

                Call System.Environment.SetEnvironmentVariable("BinPublic_DP", Me.JS_ScriptingInterface_lp.ServerSettings.Dir_03_BinPublic_DP, EnvironmentVariableTarget.Process)
                Call System.Environment.SetEnvironmentVariable("TCPrompt_Custom_DP", Me.JS_ScriptingInterface_lp.ServerSettings.Dir_DataRoot_DP_Customer_SettingsGlobal_10JobScripts_CustomDefaults_TcPrompt, EnvironmentVariableTarget.Process)


                Dim Process_Obj As New Process()
                Process_Obj.StartInfo = ProcessStartInfo_Obj
                Process_Obj.Start()
                Process_Obj.WaitForExit()
            Catch ex As Exception
                Me.ScriptReturn_r.Ex = ex
            End Try

            Dim ProcessResult_fp As New JF.Tools.JF_FileProcessing_cls(Me.JobMgr_ProcessResultData.ProcessResultLink)
            If ProcessResult_fp.FileDef.File_Exists Then
                ProcessResult_fp.FileReadAllText()
                Me.InfoSys_Obj.PrintObject("Process result log OK", Me.JobMgr_ProcessResultData.ProcessResultLink)
                Me.ScriptReturn_r.ResultMsgAdd("Process resutls")
                For Each ProcessResult As String In ProcessResult_fp.ListOfString
                    Me.ScriptReturn_r.ResultMsgAdd(ProcessResult)
                    Me.InfoSys_Obj.PrintObject("Process result", ProcessResult)
                Next
            Else
                Me.InfoSys_Obj.PrintObject("Process result log WRN fnf", Me.JobMgr_ProcessResultData.ProcessResultLink)
            End If

            '-- finaly set 
            Me.RevokeGrandeXecuteDone = True

        End Sub

        ''' <summary>
        ''' Returns Description and Version Info for ths script
        ''' </summary>
        Public Shared ReadOnly Property ScriptDescVers As String
            Get
                Return "VolumeRevokeGrand Check V05.06.2024.02/J.Fes"
            End Get
        End Property

    End Class
End Namespace