﻿Option Compare Text
Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections.Generic
Imports System.Data

Imports JF.PlmJobManager.JobServer
Imports JF.Tools
Imports JF.PlmJobManager
' Imports JF.ScriptingEngine


'' # ---------------------------------------------------------------------------------------
'' # Documentation:
'' # Script Doc......: Sets the status of the PDMPerf objects so that this triggers a new measurement

'' # Task............: Definitions
'' # Task Name.......: PLMPerf Reset
'' # Task Description: Task for resetting the PLMPerf assembly status to RUN values

'' # Parameter Base..: /TcSiteID=CustomSite /PerfPGr=CustomPGr
'' # Doc.............: Parameter Data1+2 shows examples to reset status for specific datasets
'' # Doc ............: Minimum 1 Parameter Data1 mus be set
'' # Doc ............: you can add /I1= /R1=  /I2= /R2= ... /I(n)= /R(n)= but need to follow 1..2..3
'' # Parameter Data1.: /I1=4711 /R1=A [/T1=UGMASTER /ST1=RUN.AP1 (Optional)]
'' # Parameter Data2.: /I2=4712 /R2=A [/T2=UGMASTER /ST2=RUN.AP2 (Optional)]

'' # Parameter Exa1.: /TcSiteID=TC14P TcSiteID 
'' # Result is......: ItemRef at TCSite=TC14P ItemRev:'4711/A' 'UGMASTER' at Process Group:'10' Status is set to Status:'RUN.AP1'
'' # Parameter Exa2.: /TcSiteID=TC14P /PerfPGr=10 /I1=4711 /R1=A /ST1=RUN.AP1 /I2=4712 /R2=A /ST2=RUN.AP2
'' # addPLM Exa.....: /TcSiteID=TC11ADDPLM /PerfPGr=08 /I1=000024 /R1=A /ST1=RUN.P.W /I2=000079 /R2=A /ST2=RUN.P.W

'' # History:
'' # Date         Person        ChangeInfo
'' # 29.08.2020   S.Gueth       Updated
'' # 24.06.2024   J.Fes         Trigger Time Shift for eatch oart / site
'' # 02.07.2024   J.Fes         add Paramter + add in to JobServerDefault Scripts
'' # ---------------------------------------------------------------------------------------

Namespace JS_PDMPerfSetStatusOnObjects

	Public Class PLMPerfResetState_cls

		Private InfoSysHeader As JF.InfoSys.JF_InfoSys = Nothing
		Private InfoSysProtocol As JF.InfoSys.JF_InfoSys = Nothing
		Dim TimePoint_min_c As Integer = Now().Minute


		Public Function ScriptMain(ByVal JS_ScriptingInterface As ScriptingInterface.Methodes) As JF_Return_cls

			InfoSysHeader = JS_ScriptingInterface.TaskShedulerInfoSysGet
			InfoSysProtocol = JS_ScriptingInterface.TaskShedulerInfoSysGet

			' Required class for returning script results
			Dim MyScriptReturn As New JF_Return_cls
			Dim MyCallReturn As New JF_Return_cls
			Dim TextStr As String = ""
			Dim I As Integer = 1
			Dim TimeShift_n As Integer = 1
			Dim TcSiteID As String = JS_ScriptingInterface.ParameterValueGet("TcSiteID", "UNK")
			Dim PerfPGr As String = JS_ScriptingInterface.ParameterValueGet("PerfPGr", "UNK")
			Dim ObjecCounter As Integer = 0



			'-- printing Informations to the header textbox
			'Me.InfoSysHeader.PrintInfoLine("Step - 1 Script started!")

			'-- handling Exeptions
			Try
				Dim DSEdit_Objs As New List(Of JobServer.DSEdit_cls)
				Dim DSEdit_new_OBJ As DSEdit_cls

				DSEdit_Objs.Clear()

				Me.InfoSysProtocol.PrintObject("Step - 1.0", "Get Paramter Data")
				Do

					ObjecCounter += 1
					Dim ItemId_c As String = JS_ScriptingInterface.ParameterValueGet("I" + ObjecCounter.ToString, "")
					Dim RevId_c As String = JS_ScriptingInterface.ParameterValueGet("R" + ObjecCounter.ToString, "")
					Dim Type_c = JS_ScriptingInterface.ParameterValueGet("T" + ObjecCounter.ToString, "UGMASTER")
					Dim RunStatus_c = JS_ScriptingInterface.ParameterValueGet("ST" + ObjecCounter.ToString, "RUN.AP" + ObjecCounter.ToString)

					If ItemId_c = "" Or RevId_c = "" Then
						'-- Doc exit if ItemId or RevId is not set
						Exit Do
					End If

					'-- Assembly 1
					DSEdit_new_OBJ = New DSEdit_cls()
					With DSEdit_new_OBJ
						.DS.Ir.ItemName = ItemId_c
						.DS.Ir.Rev = RevId_c
						.DS.DatasetObjectType = Type_c
						.EditValue.ValueNew = RunStatus_c
						.DS.Ir.ObjectFromSiteID = TcSiteID

						.ColumeNameEditTarget_SetBy_ProcStateColNum = PerfPGr
						DSEdit_Objs.Add(DSEdit_new_OBJ)
						' If Me.TimeShiftCheck(TimeShift_n) Then
						' -- #Doc: in case TimeShift is used please look e.TimeShiftCheck
						' End If
					End With
				Loop

				MyScriptReturn.ResultMsgAdd("Edit P.Status for: " + DSEdit_Objs.Count.ToString + "(n) Datasets")

				Me.InfoSysProtocol.PrintObject("Step - 2.1", "Edit P.Status:Start")
				For Each DSEdit_Obj As DSEdit_cls In DSEdit_Objs
					With DSEdit_Obj
						'-- #toDo: Set Process Status 01..02...
						MyCallReturn = JS_ScriptingInterface.DS_Edit_ProcessState(DSEdit_Obj)
						' JS_ScriptingInterface.IR_GetDatsets 
						Call Me.InfoSysProtocol.PrintObject("Edit Result:", MyCallReturn.ResultMsg)
						Call MyScriptReturn.ResultMsgAdd("Reset Status:" + JF.Tools.BoolToTxt(MyCallReturn.ResultIsEverythingOk, BoolToTxtType_enum.OkErr) + " // Dataset:" + DSEdit_Obj.DS.Ir.ObjectFromSiteID + ":" + DSEdit_Obj.DS.Ir.ItemNameRev + "/" + DSEdit_Obj.DS.DatasetObjectType + " PGr:" + DSEdit_Obj.ColumeNameEditTarget_SetBy_ProcStateColNum + " P.Stat to:" + DSEdit_Obj.EditValue.ValueNew)
					End With
				Next
				Me.InfoSysProtocol.PrintObject("Step - 2.2", "Edit P.Status:End")

			Catch ex As Exception
				MyScriptReturn.Ex = ex
				MyScriptReturn.ExUp = True
				MyScriptReturn.ExMsg = "JS_PDMPerfSetStatusOnObjects"
				Me.InfoSysProtocol.PrintEx(ex, MyScriptReturn.ExMsg)
				GoTo EndOfScript
			End Try

			'-- returning results
			' MyScriptReturn.ResultMsgAdd(String.Format("PDM.Perf:[OK:Schript:[{0}] ends with no Exception.]", JF_ToolsFile.ParsePath_NE(JS_ScriptingInterface.ScriptDef.Script_DPNE)))
			Me.InfoSysProtocol.PrintInfoLine("Edit P.Status:End")

			'-- setting the progress bar to idel
			Call Me.InfoSysProtocol.StatusBarProgressBarSetIdle()
EndOfScript:

			MyScriptReturn.ResultCode = 0
			Return MyScriptReturn
		End Function


		''' <summary>
		''' Checks if for TimeShift_n_p hist into Me.TimePoint_min_c
		''' #New:24.06.2024 / J.Fes
		''' </summary>
		Private Function TimeShiftCheck(ByRef TimeShift_n_p As Integer) As Boolean
			Dim TimeShiftCheck_r As Boolean = False
			Dim TimeShift_n_TP_chk_min As Integer = 0
			Dim TimeShift_dif_min As Integer = 2
			Dim TimeShift_sequence_min As Integer = 20
			Dim TimeShift_sequence_status As Integer = 0

			' Zeitschema Stand vom 6.6.2012
			' [WD=* TP=06:00][WD=* TP=06:15][WD=* TP=06:30][WD=* TP=06:45][WD=* TP=07:00][WD=* TP=07:07][WD=* TP=07:15][WD=* TP=07:22][WD=* TP=07:30][WD=* TP=07:37][WD=* TP=07:45][WD=* TP=07:52][WD=* TP=08:00][WD=* TP=08:15][WD=* TP=08:30][WD=* TP=08:45][WD=* TP=09:00][WD=* TP=09:15][WD=* TP=09:30][WD=* TP=09:45][WD=* TP=10:00][WD=* TP=10:15][WD=* TP=10:30][WD=* TP=10:45][WD=* TP=11:00][WD=* TP=11:15][WD=* TP=11:30][WD=* TP=11:45][WD=* TP=12:00][WD=* TP=12:07][WD=* TP=12:15][WD=* TP=12:22][WD=* TP=12:30][WD=* TP=12:37][WD=* TP=12:45][WD=* TP=12:52][WD=* TP=13:00][WD=* TP=13:07][WD=* TP=13:15][WD=* TP=13:30][WD=* TP=13:45][WD=* TP=14:00][WD=* TP=14:15][WD=* TP=14:30][WD=* TP=14:45][WD=* TP=15:00][WD=* TP=15:15][WD=* TP=15:30][WD=* TP=15:45][WD=* TP=16:00][WD=* TP=16:15][WD=* TP=16:30][WD=* TP=16:45][WD=* TP=17:00][WD=* TP=17:15][WD=* TP=17:30][WD=* TP=17:45][WD=* TP=18:00][WD=* TP=18:15][WD=* TP=18:30][WD=* TP=18:45][WD=* TP=19:00][WD=* TP=19:15][WD=* TP=19:30][WD=* TP=19:45]

			'-- #Doc: Calulate Time Squence '1=0..19' -or- '2=20..39' -or- '3=40..59'
			TimeShift_sequence_status = Me.TimePoint_min_c \ TimeShift_sequence_min

			'-- #Doc: Calulate for 'TimeShift_n_p' sequence minutes #Exa: 0 2 4 6 .. 20 22 24 ... 40 42 44
			'-- #Doc: #Exa: 20 * 0 + (1-1)*2  =  0
			'-- #Doc: #Exa: 20 * 1 + (1-1)*2  = 20
			'-- #Doc: #Exa: 20 * 0 + (2-1)*2  =  2
			'-- #Doc: #Exa: 20 * 1 + (2-1)*2  = 22
			TimeShift_n_TP_chk_min = TimeShift_sequence_min * TimeShift_sequence_status + (TimeShift_n_p - 1) * TimeShift_dif_min

			'-- #Doc: Check if miniutes from current timpoint = TimeShift_n_TP_chk_min
			If Me.TimePoint_min_c = TimeShift_n_TP_chk_min Then
				'-- #Doc: OK it fits into time
				TimeShiftCheck_r = True
			Else
				'-- #Doc: NO it fits not into time
				TimeShiftCheck_r = False
			End If

			'-- #Doc: increase + 1 for next TimeShift
			TimeShift_n_p += 1
			Return TimeShiftCheck_r
		End Function

		'-- #Doc: TimeShift_n Examples
		'------------------------------------------------------------------
		'TimeShift_n:01 -> TP:00 (TP=min)
		'TimeShift_n:02 -> TP:02 (TP=min)
		'TimeShift_n:03 -> TP:04 (TP=min)
		'TimeShift_n:04 -> TP:06 (TP=min)
		'TimeShift_n:05 -> TP:08 (TP=min)
		'TimeShift_n:06 -> TP:10 (TP=min)
		'TimeShift_n:07 -> TP:12 (TP=min)
		'TimeShift_n:08 -> TP:14 (TP=min)
		'TimeShift_n:09 -> TP:16 (TP=min)
		'TimeShift_n:10 -> TP:18 (TP=min)
		'--------------
		'TimeShift_n:01 -> TP:20 (TP=min)
		'TimeShift_n:02 -> TP:22 (TP=min)
		'TimeShift_n:03 -> TP:24 (TP=min)
		'TimeShift_n:04 -> TP:26 (TP=min)
		'TimeShift_n:05 -> TP:28 (TP=min)
		'TimeShift_n:06 -> TP:30 (TP=min)
		'TimeShift_n:07 -> TP:32 (TP=min)
		'TimeShift_n:08 -> TP:34 (TP=min)
		'TimeShift_n:09 -> TP:36 (TP=min)
		'TimeShift_n:10 -> TP:38 (TP=min)
		'--------------
		'TimeShift_n:01 -> TP:40 (TP=min)
		'TimeShift_n:02 -> TP:42 (TP=min)
		'TimeShift_n:03 -> TP:44 (TP=min)
		'TimeShift_n:04 -> TP:46 (TP=min)
		'TimeShift_n:05 -> TP:48 (TP=min)
		'TimeShift_n:06 -> TP:50 (TP=min)
		'TimeShift_n:07 -> TP:52 (TP=min)
		'TimeShift_n:08 -> TP:54 (TP=min)
		'TimeShift_n:09 -> TP:56 (TP=min)
		'TimeShift_n:10 -> TP:58 (TP=min)


	End Class
End Namespace

