Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections.Generic
Imports JF.PlmJobManager
Imports JF.PlmJobManager.JobServer
Imports JF.Tools
Imports JF.InfoSys

'' Script For MSC MultiSite Check via TaskSheduler: 
''  Date         Person        ChangeInfo
''  14.04.2016   S.Gueth       created
''  06.10.2016   J.Fes         Update
''  01.12.2016   J.Fes         Update
''  

'' #Doc: Parameter usage:
'' Parameter                           Description   
'' /SiteGroupName=MySiteGroup          SiteGroupName to use by MultiSite Check see Setting Site/Imp.Upd 
'' /PauseOnEnd=true/false              enables / disables  pause on end 		

Namespace JobMgrScript
	
    Public Class MultiSiteCheck
		
        Public Function ScriptMain(ByVal JS_ScriptingInterface As JobServer.ScriptingInterface.Methodes) As JF_Return_cls

            ' Required class for returning script results
            Dim ScriptReturn_r As New JF_Return_cls
			Dim WaitTimeIn_MSec As Integer
			Dim SiteGroupName as String = nothing
			Dim PauseOnEnd As Boolean = false
			Dim SchriptParameter As String = JS_ScriptingInterface.ScriptDef.cmdPara
			Dim InfoSys_Obj as JF_InfoSys = JS_ScriptingInterface.TaskShedulerInfoSysGet()

            '-- for printing Informations to the header textbox 
            InfoSys_Obj.PrintObject("Script file", JS_ScriptingInterface.ScriptDef.Script_DPNE)
			InfoSys_Obj.PrintObject("Script description", jf.Tools.JF_ToolsFile.ParsePath_NE(JS_ScriptingInterface.ScriptDef.NameDescription))
            InfoSys_Obj.PrintObject("TC.MSC", "TeamCenter MultiSite Consistent Check")
            InfoSys_Obj.PrintObject("using Paramter", SchriptParameter)

            Try
				SiteGroupName = JS_ScriptingInterface.ParameterValueGet("SiteGroupName")
				PauseOnEnd = if(JS_ScriptingInterface.ParameterValueGet("PauseOnEnd")="true",true,false)
				ScriptReturn_r.ResetToDefaultValues()
                InfoSys_Obj.Print("TC.MSC for SiteGroup: " + SiteGroupName)
                ScriptReturn_r = JS_ScriptingInterface.Objects_tbl_TeamCenterMultiSiteCheck_RunforSiteGroup(InfoSys_Obj, SiteGroupName)
                ScriptReturn_r.ResultMsg = "Result TC.MSC for SiteGroup: " + SiteGroupName +
                                            vbCrLf +
                                            ScriptReturn_r.ResultMsgEvaluate
                ScriptReturn_r.ResultMsg = ScriptReturn_r.ResultMsg.TrimEnd(CChar(vbLf)).TrimEnd(CChar(vbCr))

            Catch ex As Exception
                ScriptReturn_r.Ex = ex
                ScriptReturn_r.ExMsg = "Exeption in script:" + JS_ScriptingInterface.ScriptDef.NameDescription
                InfoSys_Obj.PrintEx(ex, "MultiSiteCheck.ScriptMain")
            End Try

			If PauseOnEnd Then
				'WaitTimeIn_MSec = 2500
				'InfoSys_Obj.Print_and_StatusBarSetCurrActionStatusInfo_Panel3("wait:" + (WaitTimeIn_MSec / 1000).ToString("#.#") + " sec")
				'System.Threading.Thread.Sleep(WaitTimeIn_MSec)
				' ScriptOutput_frm.Pause()
			else
				WaitTimeIn_MSec = 2500
				InfoSys_Obj.Print_and_StatusBarSetCurrActionStatusInfo_Panel3("wait:" + (WaitTimeIn_MSec / 1000).ToString("#.#") + " sec")
				System.Threading.Thread.Sleep(WaitTimeIn_MSec)
			End If

            Return ScriptReturn_r
        End Function
    End Class
End Namespace















