Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections.Generic
Imports JF.PlmJobManager
Imports JF.PlmJobManager.JobServer
Imports JF.Tools
Imports JF.InfoSys

'' --------------------------------------------------------------------------------------------------------
'' Script for Importing Data via TaskSheduler:
''  Date         Person        ChangeInfo
''  12.04.2007   J.Feuerstein  createt
''  29.08.2007   J.Feuerstein  #Doc: add Parameter /SiteList
''  07.03.2013   J.Feuerstein  #Doc: add Parameter /SyncSiteData 
''  07.11.2015   J.Feuerstein  #Doc: add Parameter /Methode=#MethodeType#
''  19.04.2016   J.Feuerstein  #Doc: add Parameter /ImpUpdCond=#ImpUpdCond#
''  07.03.2013   J.Feuerstein  #Doc: add Parameter /SyncSiteData --> Obsolate since 07.11.2015
''  06.12.2016   J.Feuerstein  #Doc: add Parameter /Methode=Sync_NeedUpdateAndEnd
''  23.03.2017   J.Feuerstein  #Doc: add Parameter /EndOfProcessDoWait_msec=
''  20.03.2018   S.Gueth       #Doc: add Task Sheduler Infom Sys Object, removed scripting form
''  25.03.2021   J.Feuerstein  #Doc: add Parameter /Methode=Sync_Items Obsolate incl in /Methode=Sync_IrAll 
''  25.03.2021   J.Feuerstein  #Doc: add Parameter Reorg and update dokumentation 
''  26.03.2021   J.Feuerstein  #Doc: remove Parameter /Methode=Sync_IrAll_ImportUpdate and /Methode=Sync_Ir_ImportUpdate  
'' --------------------------------------------------------------------------------------------------------
'' #Doc: Parameter usage:
'' 
'' /SiteList=TcSite1;TCSite2         Defines Sites to process  
'' -----------------------           --------------------------------------------
''                                   #Doc: (*1) see appl 'Sites/Data Import'  -> 'Sync.Site.Data' + ...

'' /Methode=ImportUpdate             Defines to run ImportUpdate controled by LastMod Date
''                                   (*1) -> 'Sites/Data Import'->Button:'Import.Site.Data'"

'' /Methode=Sync_Ir                  Defines to Sync TC-JobMgr via IR Data
''                                   (*1) -> '10 - Sync.Site [IRs Only in JM.DB]'

'' /Methode=Sync_IrAll               Defines to Sync TC-JobMgr  via read all IR in TC and JM compare them and do: 'delete' / 'addNew' / 'update' IRS in JobMgr DB
''                                   (*1) -> '20 - Sync.Site [Ir all TC.DB <-> JM.DB]'

'' /Methode=Sync_NeedUpdateAndEnd    Defines to refresh JM.DB Data that has O.Need.Upd flag and finisch Import process
''                                   (*1) -> '30 - Sync.Site [Data with O.Need.Upd>0]'

'' /Methode=Sync_CheckOutRunAndStop  Defines to refresh JM.DB Data that is checked out in TC and finisch Import process
''                                   (*1) -> '31 - Sync.Site [Checked Out Objects Only]'

'' /Methode=Sync_NeedUpdateCheckOutRunAndStop 
''                                   Defines To refresh JM.DB Data that has O.Need.Upd flag And Is checked out In TC And finisch Import process
''                                   (*1) -> '32 - Sync.Site [Data O.NeedUpd>0 + Checked Out Obj]'


'' -----------------------
'' /ImpUpdCond=LastModDate           #Doc: Defines to Use LastModDate for Import Update Condition [Default]
''                                         |-> works like:'Sites/Data Import'->Button:'Import.Site.Data'"
'' /ImpUpdCond=ReleaseDate           #Doc: Defines to Use ReleaseDate for Import Update Condition
''                                         |-> works like:'Sites/Data Import'->Button:'Import Extended'->Import.Site.Data 'control by ReleaseDate'" 
'' /ImpUpdStartDeltaTime=00.00.00    #Doc: Defines timeSpann that will be substracted from "IContr:Ir.ModDateBegin" or "IContr:Ir.ReleaseDateBegin"
''                                            
'' -----------------------                    
'' /EndOfProcessDoWait_msec=1000     #Doc: Defines im msec how long to wait after 'Import' is done (Default=0 no wait) (#New: 3.1309;23.03.2017;J.Fes)
''                                         |-> #Exa: /EndOfProcessDoWait_msec=10000 ' wait 10 sec after end of import action



Namespace JS_ScriptingDataImport

	Public Class ScriptingEngineClass
		Public Function ScriptMain(ByVal JS_ScriptingInterface As JobServer.ScriptingInterface.Methodes) As JF_Return_cls

			'-- #Doc: Mapp info Sys to TaskShedulerInfoSysGet
			Dim InfoSys_Obj as JF_InfoSys = JS_ScriptingInterface.TaskShedulerInfoSysGet()
			'-- #Doc: ScriptResult_r required Object for returning script results
			Dim ScriptReturn_r As New JF_Return_cls
			Dim ImportResult_Obj As New JF_Return_cls

			Dim SyncSiteData_Do As Boolean = False
			Dim SiteList As String()
			Dim ImportControlSettings_Obj As New ImportControlSettings_cls
			Dim ImportMethode_para As String
			Dim ImpUpdCond_para As String
			Dim ImpUpdStartDeltaTime_para As New TimeSpan
			' #New: 3.1309;23.03.2017;J.Fes
			Dim EndOfProcessDoWait_msec As Integer

			Try

				' InfoSys_Obj.PrintInfoLine("SiteImport")
				' InfoSys_Obj.Print(JS_ScriptingInterface.ScriptDef.cmdPara)

				'-- #Step: Get Parameters
				ImportMethode_para = JS_ScriptingInterface.ParameterValueGet("Methode").Trim
				ImpUpdCond_para = JS_ScriptingInterface.ParameterValueGet("ImpUpdCond").Trim

				SiteList = JS_ScriptingInterface.ParameterValueGet("SiteList").Split(New Char() {","c, ";"c})
				If JS_ScriptingInterface.ParameterValueGet("ImpUpdStartDeltaTime") <> "" Then
					ImportControlSettings_Obj.ImpUpdStartDeltaTime = TimeSpan.Parse(JS_ScriptingInterface.ParameterValueGet("ImpUpdStartDeltaTime"))
				End If

				If JS_ScriptingInterface.ParameterValueGet("EndOfProcessDoWait_msec") <> "" Then
					EndOfProcessDoWait_msec = CTypeTryDefault(Of Integer)(JS_ScriptingInterface.ParameterValueGet("EndOfProcessDoWait_msec"), -1)
				End If


				Select Case ImportMethode_para

					Case "ImportUpdate"
						ImportControlSettings_Obj.ImportMethode = ImportMethode_enum.ImportUpdate

                    '-- ApplDokuIntern: 3.1503;19.03.2021;J.Fes;#New: 'Case "Sync_Items" removed because methodes is incudes/replaced by 'Sync_IrAll' Methode
                    'Case "Sync_Items"
                    '    ImportControlSettings_Obj.ImportMethode = ImportMethode_enum.Sync_Items

                    '-- #New: 3.1503;19.03.2021;J.Fes
                    Case "Sync_IrAll"
                        ImportControlSettings_Obj.ImportMethode = ImportMethode_enum.Sync_IrAll

                    Case "Sync_Ir"
                        ImportControlSettings_Obj.ImportMethode = ImportMethode_enum.Sync_Ir

                    '-- #New: 3.1291;06.12.2016;J.Fes
                    Case "Sync_NeedUpdateAndEnd"
                        ImportControlSettings_Obj.ImportMethode = ImportMethode_enum.Sync_NeedUpdateRunAndStop

                    '-- #New: 3.1493;02.07.2020;S.Gueth
                    Case "Sync_CheckOutRunAndStop"
                        ImportControlSettings_Obj.ImportMethode = ImportMethode_enum.Sync_CheckOutRunAndStop

                    '-- #New: 3.1493;02.07.2020;S.Gueth
                    Case "Sync_NeedUpdateCheckOutRunAndStop"
                        ImportControlSettings_Obj.ImportMethode = ImportMethode_enum.Sync_NeedUpdateCheckOutRunAndStop

                    Case Else
						Throw New System.Exception(String.Format("ERR: Paramter /Methode={0} value invalid or is missing", ImportMethode_para))
				End Select

				Select Case ImpUpdCond_para.Trim

					Case "", "LastModDate"
						ImportControlSettings_Obj.ImpUpdCond = ImpUpdCond_enum.LastModDate

					Case "ReleaseDate"
						ImportControlSettings_Obj.ImpUpdCond = ImpUpdCond_enum.ReleaseDate

					Case Else
						Throw New System.Exception(String.Format("ERR: Paramter /ImpUpdCond={0} value invalid or is missing", ImpUpdCond_para))
				End Select

				For Each SiteId As String In SiteList
					ImportResult_Obj.ResetToDefaultValues()
                    ImportResult_Obj = JS_ScriptingInterface.Irs_and_Datasets_ImportFromTcDB(InfoSys_Obj, SiteId, ImportControlSettings_Obj)
                    ScriptReturn_r.ResultMsgAdd("Result import update data of site: " + SiteId)
                    ScriptReturn_r.ResultMsgAdd(ImportResult_Obj.ResultMsgEvaluate)
				Next

			Catch ex As Exception
				ScriptReturn_r.Ex = ex
				ScriptReturn_r.ExMsg = "Exception in Script:" + JS_ScriptingInterface.ScriptDef.NameDescription
				ScriptReturn_r.ResultMsgAdd(JF.Tools.JF_ErrHandler_cls.MyAppl_ExToStr(JF_ErrHandler_cls.Appl_ErrMsg_Enum.err0001_NotSpec, ex, "TaskShedule:S:Dataimport_Tc_DataSetsAndIrs.vb Task:" + JS_ScriptingInterface.ScriptDef.NameDescription))
				InfoSys_Obj.PrintEx(ex, "Dataimport_Tc_DataSetsAndIrs.vb")
			End Try

			' Call InfoSys_Obj.Print(ScriptReturn_r.ResultMsgEvaluate)
			'-- #Step: Wait n sec before end
			If EndOfProcessDoWait_msec > 0 Then
				InfoSys_Obj.PrintObject_and_StatusBarSetCurrActionStatusInfo_Panel3("wait", (EndOfProcessDoWait_msec / 1000).ToString("#.#") + " sec")
				System.Threading.Thread.Sleep(EndOfProcessDoWait_msec)
			End If

			Return ScriptReturn_r
		End Function
	End Class
End Namespace








