Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Action        : JobMgr_90_MaintainDatabase.sql'
Print ' Creation Date : 24.02.2009 /J.Fes'
Print ' LastUpdate    : 24.11.2022 /J.Fes Objects_tbl_Update_ChkPStatus'
Print '-------------------------------------------------------------------------'

use [#DB_N#]


Print '-- [Objects_tbl_MT_UpdateProcStateCol] ----------------------------------'
If Exists (select Name
           from sysobjects
           where Name = 'Objects_tbl_MT_UpdateProcStateCol' and type = 'P')
Drop Procedure Objects_tbl_MT_UpdateProcStateCol
GO

CREATE PROCEDURE Objects_tbl_MT_UpdateProcStateCol @ObjectId  nvarchar(128) , -- ID des zu bearbeitenden Datensatzes in Objects_tbl, 25.10.2017 changed to 128
                                                   @ProcStateColID nvarchar(4) , -- Last chars after ProcStateCol Name des ProcStateCol 01 ... 40 Columes
                                                   @ValueNew  nvarchar(MAX) , -- neuer Wert
                                                   @ObjectFromSiteID nvarchar(32),
                                                   @ObjectClass nvarchar(10),
                                                   @ObjectCliName nvarchar(255),
                                                   @PMessagestr_p nvarchar(max) Output
AS
BEGIN
  DECLARE @ExecuteSQLstr nvarchar(max)
  if  @PMessagestr_p = ''
  begin
     set @PMessagestr_p = 'P' + @ProcStateColID + '=' + @ValueNew
  end
  else
  begin
     set @PMessagestr_p = @PMessagestr_p + '/P' + @ProcStateColID + '=' + @ValueNew
  end

  set @ExecuteSQLstr = 'UPDATE Objects_tbl SET [ProcStateCol' + @ProcStateColID + ']=''' + @ValueNew + ''' where Objects_tbl.Id=''' + CONVERT(nvarchar(128), @ObjectId) + ''''
--   print(' @PMessagestr_p=' +  @PMessagestr_p )
-- print(' |-> Upd:[O.P.' +  @ProcStateColID + ' #Obj:' + @ObjectFromSiteID + ':' + @ObjectClass + ':' + @ObjectCliName + ' ProcStateCol' +  @ProcStateColID + '=' + @ValueNew + ']' )
  execute sp_executesql @ExecuteSQLstr
end
Go

--------------------------------------------------------------------------------
DECLARE @Name nvarchar(64)
DECLARE @ValueCurr nvarchar(max)
DECLARE @ValueDesired nvarchar(max)
DECLARE @ValueCompareStat int
DECLARE @ExecuteSQLstr nvarchar(max)
DECLARE @PMessagestr nvarchar(max)
DECLARE @UpdateDone bit
DECLARE @UpdateCounter int

DECLARE @Id uniqueidentifier,
        @ObjectFromSiteID nvarchar(32),
        @ObjectCliName    nvarchar(255),
        @ObjectClass      nvarchar(10),
        @DoAction         bit,
        @DoPrint          bit,
        @DoneCounter      int,
        @ToProcessN       int,
        @PrintEvery       int

     DECLARE
          @ProcStateCol01Val nvarchar(32),
          @ProcStateCol02Val nvarchar(32),
          @ProcStateCol03Val nvarchar(32),
          @ProcStateCol04Val nvarchar(32),
          @ProcStateCol05Val nvarchar(32),
          @ProcStateCol06Val nvarchar(32),
          @ProcStateCol07Val nvarchar(32),
          @ProcStateCol08Val nvarchar(32),
          @ProcStateCol09Val nvarchar(32),
          @ProcStateCol10Val nvarchar(32),
          @ProcStateCol11Val nvarchar(32),
          @ProcStateCol12Val nvarchar(32),
          @ProcStateCol13Val nvarchar(32),
          @ProcStateCol14Val nvarchar(32),
          @ProcStateCol15Val nvarchar(32),
          @ProcStateCol16Val nvarchar(32),
          @ProcStateCol17Val nvarchar(32),
          @ProcStateCol18Val nvarchar(32),
          @ProcStateCol19Val nvarchar(32),
          @ProcStateCol20Val nvarchar(32),

          -- #New:07.11.2022
          @ProcStateCol21Val nvarchar(32),
          @ProcStateCol22Val nvarchar(32),
          @ProcStateCol23Val nvarchar(32),
          @ProcStateCol24Val nvarchar(32),
          @ProcStateCol25Val nvarchar(32),
          @ProcStateCol26Val nvarchar(32),
          @ProcStateCol27Val nvarchar(32),
          @ProcStateCol28Val nvarchar(32),
          @ProcStateCol29Val nvarchar(32),
          @ProcStateCol30Val nvarchar(32),

          @ProcStateCol31Val nvarchar(32),
          @ProcStateCol32Val nvarchar(32),
          @ProcStateCol33Val nvarchar(32),
          @ProcStateCol34Val nvarchar(32),
          @ProcStateCol35Val nvarchar(32),
          @ProcStateCol36Val nvarchar(32),
          @ProcStateCol37Val nvarchar(32),
          @ProcStateCol38Val nvarchar(32),
          @ProcStateCol39Val nvarchar(32),
          @ProcStateCol40Val nvarchar(32),

          @ProcStateColRfVal nvarchar(32),
          @ProcStateColMcVal nvarchar(32),
          @ProcStateColUnVal nvarchar(32)



Print 'Maintain Database: #DB_N# !Start!'
Print '.........................................................................'

-- exec sp_dboption N'#DB_N#', N'read only', N'false'
-- ALTER DATABASE #DB_N# SET READ_WRITE
-- exec sp_dboption N'#DB_N#', N'dbo use', N'false'
-- exec sp_dboption N'#DB_N#', N'single', N'false'
-- exec sp_dboption N'#DB_N#', N'autoshrink', N'true'
-- 30.08.2019/J.Fes A.Becker set to OFF
-- see https://techyaz.com/sql-server/performance-tuning/always-turn-off-database-auto-shrink/
Print 'Database basic settings (#LUp: 30.08.2019) ALTER DATABASE #DB_N# SET AUTO_SHRINK OFF'
ALTER DATABASE #DB_N# SET AUTO_SHRINK OFF

Print '.........................................................................'
Print 'Delete Temp Tables'
if (object_id('zztmpClean1_tbl') is not null)  Drop table zztmpClean1_tbl
if (object_id('zztmpClean2_tbl') is not null)  Drop table zztmpClean2_tbl
if (object_id('zztmpClean3_tbl') is not null)  Drop table zztmpClean3_tbl
if (object_id('zztmpClean4_tbl') is not null)  Drop table zztmpClean4_tbl
if (object_id('zztmpClean5_tbl') is not null)  Drop table zztmpClean5_tbl
-- 14.01.2015/J.Fes removed
-- if (object_id('ReportPageNames_temp_tbl') is not null)  Drop table ReportPageNames_temp_tbl
if (object_id('zztmp_Report_810_ProcessPerHoure') is not null)  Drop table zztmp_Report_810_ProcessPerHoure


set @Name='ObjectsUpdate_ProcessStatus_Mark_LastRes__MaintainDB'
set @ValueCurr=''
set @ValueDesired='2009-02-23-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print 'execute [ObjectsUpdate_ProcessStatus_Mark_LastRes__MaintainDB] Set to Stat:' + @ValueDesired + ' Start!'
   Execute ObjectsUpdate_ProcessStatus_Mark_LastRes__MaintainDB
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print 'execute [ObjectsUpdate_ProcessStatus_Mark_LastRes__MaintainDB] Set to Stat:' + @ValueDesired + ' DONE!'
 end

set @Name='JobControl_ObjectsProcessData_tbl_Update_ProcessResultHasWarning__MaintainDB'
set @ValueCurr=''
set @ValueDesired='2009-07-12-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobControl_ObjectsProcessData_tbl set ProcessResultHasWarning = 0 where ProcessResultHasWarning is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

set @Name='JobControl_ObjectsProcessData_tbl_Update_ProcessResultLink__MaintainDB'
set @ValueCurr=''
set @ValueDesired='2009-07-12-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobControl_ObjectsProcessData_tbl set ProcessResultLink=' + '''' + '''' + ' where ProcessResultLink is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='JobControlRules_tbl_Update_SelObjectsBy_PFM'
set @ValueCurr=''
set @ValueDesired='2009-10-21-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set SelObjectsBy_PFM=1 where SelObjectsBy_PFM is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

-- stellt sicher das ObjectUgMaster_PartFamMemName = '' und nicht NULL ist
set @Name='Objects_tbl_Update_ObjectUgMaster_PartFamMemName'
set @ValueCurr=''
set @ValueDesired='2009-10-21-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE Objects_tbl set ObjectUgMaster_PartFamMemName=' + '''' + '''' + ' where ObjectUgMaster_PartFamMemName is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

-- resets System_CPUUtilization_activ to 0 where it is null (New 14.07.2022 S.Gueth)
set @Name='Sites_tbl_Update_System_CPUUtilization_activ'
set @ValueCurr=''
set @ValueDesired='2022-07-14'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE Sites_tbl set System_CPUUtilization_activ=0 where System_CPUUtilization_activ is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

set @Name='Sites_tbl_Update_DbConnectionTimeout'
set @ValueCurr=''
set @ValueDesired='2009-11-02-02'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE Sites_tbl set DbConnectionTimeout=60 where DbConnectionTimeout is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

-- remove change info from Notes in JobScript_tbl JobRule_tbl and Sites_tbl  (New 19.12.2023 A.Stein)
set @Name='JobControl_JobScript_JobRule_Sites_ResetNotes'
set @ValueCurr=''
set @ValueDesired='2023-12-19'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='update JobControlRules_tbl set Note = Replace(Note, ''Change Info:
- 
- '', '''')
update Sites_tbl set Note = Replace(Note, ''Change Info:
- 
- '', '''')
update JobScript_tbl set Note = Replace(Note, ''Change Info:
- 
- '', '''')'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

 
set @Name='Sites_tbl_Update_DbCommandTimeout'
set @ValueCurr=''
set @ValueDesired='2009-11-02-02'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE Sites_tbl set DbCommandTimeout=120 where DbCommandTimeout is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='Sites_tbl_Update_ImportTc'
set @ValueCurr=''
set @ValueDesired='2010-07-08-04'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'

   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportTcIrSearchMethode=1 where ImportTcIrSearchMethode is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/3:->DONE!] ' + @ExecuteSQLstr

   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportTcObjectFs_DPNE=1 where ImportTcObjectFs_DPNE is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 2/3:->DONE!] ' + @ExecuteSQLstr

   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportTcObjectFs_NE=1 where ImportTcObjectFs_NE is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 3/3:->DONE!] ' + @ExecuteSQLstr

   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

-- rem wichtig @Name muss eindeutig sein
set @Name='Sites_tbl_Update_ImportApWithCompCound0AsSp'
set @ValueCurr=''
set @ValueDesired='2010-08-10-02'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportApWithCompCound0AsSp=0 where ImportApWithCompCound0AsSp is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


 -- rem wichtig @Name muss eindeutig sein
 set @Name='DataBase_BaseSettings'
 set @ValueCurr=''
 set @ValueDesired='2010-09-03-01'
 EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
 if @ValueCompareStat <> 1
 begin
 IF EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'#DB_N#')
   BEGIN
      -- neu 2.11.2009 einstellen nicht case sensitive
      ALTER DATABASE [#DB_N#] COLLATE Latin1_General_CI_AS
      Print '------------------------------------------------------------------'
      Print 'OK:Db:#DB_N#'
      Print '    set COLLATE = Latin1_General_CI_AS'

--       --  neu 03.09.2010
--       ALTER DATABASE [#DB_N#] SET ALLOW_SNAPSHOT_ISOLATION ON
--       Print '------------------------------------------------------------------'
--       Print 'OK:Db:#DB_N#'
--       Print '    set allow_snapshot_isolation on (03.09.2010)'
--
--       ALTER DATABASE [#DB_N#] SET READ_COMMITTED_SNAPSHOT ON
--       Print '------------------------------------------------------------------'
--       Print 'OK:Db:#DB_N#'
--       Print '    set READ_COMMITTED_SNAPSHOT ON (03.09.2010)'
      --------------- SQL ---------------
      EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
      print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   END
 end

 -- rem wichtig @Name muss eindeutig sein
 -- ItemsTbl CleanUp Aktion erstellt 11.01.2011 12:04 J.Fes
 set @Name='ItemsTbl_DeleteAllObjects'
 set @ValueCurr=''
 set @ValueDesired='2011-01-11-01'
 EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
 if @ValueCompareStat <> 1
 begin
  Print '-- [delete function: ItemsTbl_ItemNameRev_GetDS] -------------------------------'
  If Exists (select Name from sysobjects where Name = 'ItemsTbl_ItemNameRev_GetDS' and type = 'P') Drop Procedure ItemsTbl_ItemNameRev_GetDS

  Print '-- [delete function: ItemsTbl_ItemNameRev_GetId] -------------------------------'
  If Exists (select Name from sysobjects where Name = 'ItemsTbl_ItemNameRev_GetId' and type = 'P') Drop Procedure ItemsTbl_ItemNameRev_GetId

  Print '-- [delete function: ItemsTblAddDataSet] -------------------------------'
  If Exists (select Name from sysobjects where Name = 'ItemsTblAddDataSet' and type = 'P') Drop Procedure ItemsTblAddDataSet

--         20: Drop Procedure ItemsTbl_ItemNameRev_GetDS
--      41: Drop Procedure ItemsTbl_ItemNameRev_GetId
--      93: Drop Procedure ItemsTblAddDataSet
  Print '-- [delete View: RefiledItemAndDataSets_View] ------------------------------'
  If Exists (select Name
           from sysobjects
            where Name = 'RefiledItemAndDataSets_View' and type = 'V')
  Drop View RefiledItemAndDataSets_View

  Print '-- [delete function: Items_tbl_DeleteDataRow_By_ID] ----------------------------'
  If Exists (select Name
             from sysobjects
             where Name = 'items_tbl_DeleteDataRow_By_ID' and type = 'P')
  Drop Procedure items_tbl_DeleteDataRow_By_ID

  Print '-- [delete function: ItemTblItemsToListView] -----------------------------------'
  If Exists (select Name
             from sysobjects
             where Name = 'ItemTblItemsToListView' and type = 'P')
  Drop Procedure ItemTblItemsToListView


  Print '-- [delete function: ItemsRefileResultsAddDataSet] -----------------------------'
  If Exists (select Name
             from sysobjects
             where Name = 'ItemsRefileResultsAddDataSet' and type = 'P')
  Drop Procedure ItemsRefileResultsAddDataSet


  Print '-- [delete function: ItemsRev_RefileProcessState_Set] --------------------------'
  If Exists (select Name
             from sysobjects
             where Name = 'ItemsRev_RefileProcessState_Set' and type = 'P')
  Drop Procedure ItemsRev_RefileProcessState_Set

  Print '-- [delete function: ItemsRefileResults_GetId] ---------------------------------'
  If Exists (select Name
             from sysobjects
             where Name = 'ItemsRefileResults_GetId' and type = 'P')
  Drop Procedure ItemsRefileResults_GetId

  --  delete Items_tbl 11.01.2011
  if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Items_tbl]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   Print '-- [delete: Table:Items_tbl] -----------------------------------------'
   DROP TABLE [dbo].[Items_tbl]
  END


  --  delete ItemsRefileResults_tbl 11.01.2011
  if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ItemsRefileResults_tbl]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   Print '-- [delete: Table:ItemsRefileResults_tbl] ---------------------------------'
   DROP TABLE [dbo].[ItemsRefileResults_tbl]
  END

  EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
  print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


 -- rem wichtig @Name muss eindeutig sein
 -- ItemsTbl CleanUp Aktion erstellt 11.01.2011 12:04 J.Fes
 set @Name='Objects_tbl_DeleteDataRow_By_ID-Remove'
 set @ValueCurr=''
 set @ValueDesired='2011-03-04-01'
 EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
 if @ValueCompareStat <> 1
 begin
  Print '-- [Objects_tbl_DeleteDataRow_By_ID] ------------------------------------'
  If Exists (select Name
             from sysobjects
             where Name = 'Objects_tbl_DeleteDataRow_By_ID' and type = 'P')
             Drop Procedure Objects_tbl_DeleteDataRow_By_ID

  EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
  print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='Sites_tbl_Update_OracleTblNameInfodbaReplace'
set @ValueCurr=''
set @ValueDesired='2011-03-07-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE Sites_tbl set OracleTblNameInfodbaReplace=' + ''''  + '''' + ' where OracleTblNameInfodbaReplace is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

set @Name='Sites_tbl_Update_Tns_Admin_Add_TnsNames.Ora'
set @ValueCurr=''
set @ValueDesired='2011-10-30-02'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE dbo.Sites_tbl set Tns_Admin=[Tns_Admin] + ' + '''' + '\tnsnames.ora'  + ''''  +
                      ' WHERE' +
                       ' dbo.Sites_tbl.Tns_Admin <> ' + '''' + '''' + ' AND' +
                       ' dbo.Sites_tbl.Tns_Admin NOT LIKE ' + '''' + '%\%.ora' + '''' + ' AND' +
                       ' dbo.Sites_tbl.Tns_Admin IS NOT NULL'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='JobControlRules_tbl_Update_SelObjectsBy_FsHitCount_YN'
set @ValueCurr=''
set @ValueDesired='2011-10-31-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set SelObjectsBy_FsHitCount_YN=0 where SelObjectsBy_FsHitCount_YN is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='JobControlRules_tbl_Update_JobResourcePoints'
set @ValueCurr=''
set @ValueDesired='2011-10-31-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set JobResourcePoints=0 where JobResourcePoints is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

set @Name='JobControlRules_tbl_Update_JobResult_ProcStateValueRule'
set @ValueCurr=''
set @ValueDesired='2011-10-31-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set [JobResult_ProcStateValueRule]=' + '''' + '''' + ' where [JobResult_ProcStateValueRule] is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

-- entnommen 18.07.2014/J.Fes
-- set @Name='ImportTcApBomLineUgGometryNo_DoCount'
-- set @ValueCurr=''
-- set @ValueDesired='2011-08-11-01'
-- EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
-- if @ValueCompareStat <> 1
--  begin
--    print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
--    print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
--    set @ExecuteSQLstr='UPDATE Sites_tbl set ImportTcApBomLineUgGometryNo_DoCount=1 where ImportTcApBomLineUgGometryNo_DoCount is null'
--    execute sp_executesql @ExecuteSQLstr
--    print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr
--    EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
--    print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
--  end


-- Reset ObjectType for Dataset from Objects_tbl where ObjectClass = 'IR'
set @Name='Objects_tbl_Update_IRS_ObjectType_RESET'
set @ValueCurr=''
set @ValueDesired='2012-02-03-02'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE Objects_tbl set ObjectType=' + '''~''' + ' where ObjectClass=''IR'' and ObjectType in (''~'',''UGMASTER'',''UGPART'',''UGALTREP'',''UGMANIFESTATION'',''UGSCENARIO'',''NXSIMULATION'',''CAEGEOM'',''CAEMESH'',''CAESOLUTION'')'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

-- #New: 13.10.2012 J.Fes
set @Name='JobControlRules_tbl_Update_JobPacket_ContainOnlyObjOfDiffrentI'
set @ValueCurr=''
set @ValueDesired='2012-10-13-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set [JobPacket_ContainOnlyObjOfDiffrentI]=0 where [JobPacket_ContainOnlyObjOfDiffrentI] is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


-- #New: 13.10.2012 J.Fes
-- set @Name='JobControlRules_tbl_Update_JobPacket_ContainOnlyObjOfDiffrentIR'
-- set @ValueCurr=''
-- set @ValueDesired='2012-10-13-02'
-- EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
-- if @ValueCompareStat <> 1
--  begin
--    print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
--    set @ExecuteSQLstr='UPDATE JobControlRules_tbl set [JobPacket_ContainOnlyObjOfDiffrentIR]=0 where [JobPacket_ContainOnlyObjOfDiffrentIR] is null'
--    print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
--    execute sp_executesql @ExecuteSQLstr
--    EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
--    print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
--  end


-- #New: 13.10.2012 J.Fes
set @Name='JobControlRules_tbl_Update_JobPacket_JobSumObjectCount'
set @ValueCurr=''
set @ValueDesired='2011-10-31-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set JobPacket_JobSumObjectCount=0 where JobPacket_JobSumObjectCount is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

-- #New: 13.10.2012 J.Fes
set @Name='JobControlRules_tbl_Update_SelObjectsBy_Status'
set @ValueCurr=''
set @ValueDesired='2011-10-31-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set [SelObjectsBy_Status]=' + '''' + '''' + ' where [SelObjectsBy_Status] is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


-- #New: 27.03.2013 21:26 J.Fes
set @Name='ImportDataCleanup'
set @ValueCurr=''
set @ValueDesired='2013-03-27-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportDataCleanup=1 where ImportDataCleanup is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

-- #New: 27.03.2013 21:26 J.Fes
set @Name='TCArchitecture'
set @ValueCurr=''
set @ValueDesired='2013-03-29-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set TCArchitecture=' + '''' + 'TCUA' + '''' + ' where TCArchitecture is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end




set @Name='ImportPrjData'
set @ValueCurr=''
set @ValueDesired='2013-04-02-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportPrjData=0 where ImportPrjData is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


-- #New: 27.03.2013 21:26 J.Fes
set @Name='SelObjectsBy_ObjectSpecSelRule'
set @ValueCurr=''
set @ValueDesired='2013-07-19-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set [SelObjectsBy_ObjectSpecSelRule]=' + '''DS_of_IR'''
   set @ExecuteSQLstr=@ExecuteSQLstr + ' where [ProcStateCol] = ' + '''' + 'ProcStateColRf'  + ''''
   set @ExecuteSQLstr=@ExecuteSQLstr + '       and [SelObjectsBy_ObjectSpecSelRule] is null'
   print @Name + ' [Update 1/2:->Do Update!] ' + @ExecuteSQLstr
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/2:->Done!] '

   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set [SelObjectsBy_ObjectSpecSelRule]=' + '''NotInUse'''
   set @ExecuteSQLstr=@ExecuteSQLstr + ' where [SelObjectsBy_ObjectSpecSelRule] is null'
   print @Name + ' [Update 2/2:->Do Update!] ' + @ExecuteSQLstr
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 2/2:->Done!] '

   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired

 end

set @Name='ImportItemDataAll'
set @ValueCurr=''
set @ValueDesired='2013-08-16-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportItemDataAll=0 where ImportItemDataAll is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

set @Name='ImportMultiSiteData'
set @ValueCurr=''
set @ValueDesired='2013-08-21-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportMultiSiteData=1 where ImportMultiSiteData is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='ImportFs_Properties'
set @ValueCurr=''
set @ValueDesired='2013-08-26-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportFs_Properties=0 where ImportFs_Properties is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='PLMPerfTblsRemove'
set @ValueCurr=''
set @ValueDesired='2014-08-06-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   Print 'Delete PLMPerf Tabels #New 06.08.2014 11:00 #Info now we use a seperated Database'
   if (object_id('tblStartzeiten') is not null)  Drop table tblStartzeiten
   if (object_id('tblChartTypes') is not null)  Drop table tblChartTypes
   if (object_id('tblComputer') is not null)  Drop table tblComputer
   if (object_id('tblComputerDetails') is not null)  Drop table tblComputerDetails
   if (object_id('tblEvents') is not null)  Drop table tblEvents
   if (object_id('tblFilter') is not null)  Drop table tblFilter
   if (object_id('tblImports') is not null)  Drop table tblImports
   if (object_id('tblImportTypes') is not null)  Drop table tblImportTypes
   if (object_id('tblLineStyles') is not null)  Drop table tblLineStyles
   if (object_id('tblMesslinien') is not null)  Drop table tblMesslinien
   if (object_id('tblMessungen') is not null)  Drop table tblMessungen
   if (object_id('tblMesswerte') is not null)  Drop table tblMesswerte
   if (object_id('tblMesswerteConfig') is not null)  Drop table tblMesswerteConfig
   if (object_id('tblPerfMess') is not null)  Drop table tblPerfMess
   if (object_id('tblPingMess') is not null)  Drop table tblPingMess
   if (object_id('tblUserCount') is not null)  Drop table tblUserCount
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='Objects_tbl_Update_add_ProcStateCol11..20'
set @ValueCurr=''
set @ValueDesired='2014-08-08-04'
set @UpdateDone=0
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'


   SET @ToProcessN = 0
   SET @DoneCounter = 0


   -- #ToDo: Setup: print del ervery n'times
   set @PrintEvery=1000
   -- #ToDo: Setup: @DoAction Action
   --  if @DoAction = 1 then Data is deleted
   --  if @DoAction = 0 then only Print is done
   set @DoAction=1

   select @ToProcessN=count(*)
     from dbo.Objects_tbl
     WHERE ProcStateCol20 is null

   -- Cursor to process all Objects
   declare tbl_Cursor cursor fast_forward for
   select Id, ObjectCliName, ObjectClass
     from dbo.Objects_tbl
     where ProcStateCol20 is null

   set nocount on
   open tbl_Cursor
    -- alle Objekte durchlaufen die durch den Cursor durchlaufen
    while 1=1
     begin
       SET @DoneCounter = @DoneCounter + 1
       fetch next from tbl_Cursor into @Id, @ObjectCliName, @ObjectClass
       -- Ausstieg wenn nichts zu lschen ist
       if (@ToProcessN =0)
       begin
         print('Result...........: No Data found to Update')
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
         end
         break
       end
       -- exit if last element is processed
       if (@@fetch_status <> 0)
       begin
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
        end
        break
       end

       -- #Debug: Austieg fr test
       -- if (@DoneCounter >=2) break

       if (@DoneCounter = 1) or (@DoneCounter = @ToProcessN) or (@DoneCounter % @PrintEvery = 0)
       begin
          print('Update:[' + CONVERT(nvarchar(64),@DoneCounter) + '/' + CONVERT(nvarchar(64),@ToProcessN) + ':' + Str((100.00*@DoneCounter/@ToProcessN),6,2)  + '%]' +
                ' Obj:[' + @ObjectClass + ':' + @ObjectCliName + ']')
       end

       if @DoAction = 1
       begin
          -- Step: Do the Update
        	 UPDATE Objects_tbl
        	        set ProcStateCol11= 'N',
                 				ProcStateCol12= 'N',
                 				ProcStateCol13= 'N',
                 				ProcStateCol14= 'N',
                 				ProcStateCol15= 'N',
                 				ProcStateCol16= 'N',
                 				ProcStateCol17= 'N',
                 				ProcStateCol18= 'N',
                 				ProcStateCol19= 'N',
                 				ProcStateCol20= 'N'
        	  where Objects_tbl.Id = @Id
       end
     end
   close tbl_Cursor
   deallocate tbl_Cursor

   if @UpdateDone = 1
   begin
     -- set UpdateDone true see actions below
     EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
     print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   end
   ELSE
   BEGIN
     print @Name + ' [Update:' + @ValueDesired + ' -> !! -- NOT DONE -- !!]'
   end
end


-- #New: 15.09.2014 J.Fes
set @Name='AddAdditional_Data'
set @ValueCurr=''
set @ValueDesired='2014-09-15-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'

   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set [AddAdditional_Data]=' + '''NotInUse'''
   set @ExecuteSQLstr=@ExecuteSQLstr + ' where [AddAdditional_Data] is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
 end



-- #New: 15.09.2014 J.Fes
set @Name='SelObjectsBy_SQLScript_YN'
set @ValueCurr=''
set @ValueDesired='2014-09-15-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'

   set @ExecuteSQLstr='UPDATE JobControlRules_tbl set SelObjectsBy_SQLScript_YN=0 where SelObjectsBy_SQLScript_YN is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
 end

-- #New 03.06.2015 16:43
set @Name='IrAndBOMSettings'
set @ValueCurr=''
set @ValueDesired='2015-06-03-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set Config_IrRevLatestRule=''Rul1_LatestByCreationDate'' where Config_IrRevLatestRule is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/2:->DONE!] ' + @ExecuteSQLstr

   set @ExecuteSQLstr='UPDATE Sites_tbl set Config_BOMPreciseRule=''Rul1_UsePreciseYes'' where Config_BOMPreciseRule is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 2/2:->DONE!] ' + @ExecuteSQLstr


   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='Item_IrLatestRank_UpdateAll'
set @ValueCurr=''
set @ValueDesired='2015-06-03-03'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='Item_IrLatestRank_UpdateAll'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr

   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

set @Name='Objects_tbl_Update_add_ProcStateColMc'
set @ValueCurr=''
set @ValueDesired='2016-02-26-02'
set @UpdateDone=0
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'


   SET @ToProcessN = 0
   SET @DoneCounter = 0
   set @PrintEvery=1000
   set @DoAction=1
   select @ToProcessN=count(*)
     from dbo.Objects_tbl
     WHERE ProcStateColMc is null

   -- Cursor to process all Objects
   declare tbl_Cursor cursor fast_forward for
   select Id, ObjectCliName, ObjectClass
     from dbo.Objects_tbl
     where ProcStateColMc is null

   set nocount on
   open tbl_Cursor
    -- alle Objekte durchlaufen die durch den Cursor durchlaufen
    while 1=1
     begin
       SET @DoneCounter = @DoneCounter + 1
       fetch next from tbl_Cursor into @Id, @ObjectCliName, @ObjectClass
       -- Ausstieg wenn nichts zu lschen ist
       if (@ToProcessN =0)
       begin
         print('Result...........: No Data found to Update')
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
         end
         break
       end
       -- exit if last element is processed
       if (@@fetch_status <> 0)
       begin
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
        end
        break
       end

       if (@DoneCounter = 1) or (@DoneCounter = @ToProcessN) or (@DoneCounter % @PrintEvery = 0)
       begin
          print('Update:[' + CONVERT(nvarchar(64),@DoneCounter) + '/' + CONVERT(nvarchar(64),@ToProcessN) + ':' + Str((100.00*@DoneCounter/@ToProcessN),6,2)  + '%]' +
                ' Obj:[' + @ObjectClass + ':' + @ObjectCliName + ']')
       end

       if @DoAction = 1
       begin
          -- Step: Do the Update
        	 UPDATE Objects_tbl
        	        set ProcStateColMc= 'N'
        	  where Objects_tbl.Id = @Id
       end
     end
   close tbl_Cursor
   deallocate tbl_Cursor

   if @UpdateDone = 1
   begin
     -- set UpdateDone true see actions below
     EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
     print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   end
   ELSE
   BEGIN
     print @Name + ' [Update:' + @ValueDesired + ' -> !! -- NOT DONE -- !!]'
   end
end

set @Name='Objects_tbl_Update_add_ProcStateColUn'
set @ValueCurr=''
set @ValueDesired='2021-11-26-01'
set @UpdateDone=0
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'


   SET @ToProcessN = 0
   SET @DoneCounter = 0
   set @PrintEvery=1000
   set @DoAction=1
   select @ToProcessN=count(*)
     from dbo.Objects_tbl
     WHERE ProcStateColUn is null

   -- Cursor to process all Objects
   declare tbl_Cursor cursor fast_forward for
   select Id, ObjectCliName, ObjectClass
     from dbo.Objects_tbl
     where ProcStateColUn is null

   set nocount on
   open tbl_Cursor
    -- alle Objekte durchlaufen die durch den Cursor durchlaufen
    while 1=1
     begin
       SET @DoneCounter = @DoneCounter + 1
       fetch next from tbl_Cursor into @Id, @ObjectCliName, @ObjectClass
       -- Ausstieg wenn nichts zu lschen ist
       if (@ToProcessN =0)
       begin
         print('Result...........: No Data found to Update')
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
         end
         break
       end
       -- exit if last element is processed
       if (@@fetch_status <> 0)
       begin
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
        end
        break
       end

       if (@DoneCounter = 1) or (@DoneCounter = @ToProcessN) or (@DoneCounter % @PrintEvery = 0)
       begin
          print('Update:[' + CONVERT(nvarchar(64),@DoneCounter) + '/' + CONVERT(nvarchar(64),@ToProcessN) + ':' + Str((100.00*@DoneCounter/@ToProcessN),6,2)  + '%]' +
                ' Obj:[' + @ObjectClass + ':' + @ObjectCliName + ']')
       end

       if @DoAction = 1
       begin
          -- Step: Do the Update
        	 UPDATE Objects_tbl
        	        set ProcStateColUn= 'N'
        	  where Objects_tbl.Id = @Id
       end
     end
   close tbl_Cursor
   deallocate tbl_Cursor

   if @UpdateDone = 1
   begin
     -- set UpdateDone true see actions below
     EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
     print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   end
   ELSE
   BEGIN
     print @Name + ' [Update:' + @ValueDesired + ' -> !! -- NOT DONE -- !!]'
   end
end


set @Name='Objects_tbl X.TC.Struc to X.PLM Update'
set @ValueCurr=''
set @ValueDesired='2017-07-06-01'
set @UpdateDone=0
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'

   set @UpdateCounter = 0
   -- Step: Do the Update
   print '-- Update ProcStateCol01 -- values X.TC.Struc.ERR to: X.PLM.ERR'
 	 UPDATE Objects_tbl set Objects_tbl.ProcStateCol01 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol01 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol02 -- values X.TC.Struc.ERR to: X.PLM.ERR'
 	 UPDATE Objects_tbl set Objects_tbl.ProcStateCol02 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol02 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol03 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol03 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol03 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol04 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol04 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol04 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol05 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol05 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol05 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol06 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol06 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol06 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol07 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol07 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol07 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol08 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol08 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol08 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol09 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol09 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol09 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol10 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol10 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol10 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol11 -- values X.TC.Struc.ERR to: X.PLM.ERR'
 	 UPDATE Objects_tbl set Objects_tbl.ProcStateCol11 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol11 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol12 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol12 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol12 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol13 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol13 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol13 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol14 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol14 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol14 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol15 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol15 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol15 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol16 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol16 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol16 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol17 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol17 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol17 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol18 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol18 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol18 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol19 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol19 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol19 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateCol20 -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateCol20 = 'X.PLM.ERR' where Objects_tbl.ProcStateCol20 = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateColMc -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateColMc = 'X.PLM.ERR' where Objects_tbl.ProcStateColMc = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

   print '-- Update ProcStateColRf -- values X.TC.Struc.ERR to: X.PLM.ERR'
 	 UPDATE Objects_tbl set Objects_tbl.ProcStateColRf = 'X.PLM.ERR' where Objects_tbl.ProcStateColRf = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT
   print @Name + ' [MSG Update: values from:X.TC.Struc.MSG to: X.PLM.ERR Done:' + convert(varchar(10),@UpdateCounter) + ' (n) times]'

   print '-- Update ProcStateColUn -- values X.TC.Struc.ERR to: X.PLM.ERR'
   UPDATE Objects_tbl set Objects_tbl.ProcStateColUn = 'X.PLM.ERR' where Objects_tbl.ProcStateColMc = 'X.TC.Struc.ERR'
   set @UpdateCounter = @UpdateCounter + @@ROWCOUNT

    select @UpdateCounter=count(*)
         from dbo.Objects_tbl
     WHERE    ProcStateCol01 = 'X.TC.Struc.ERR'
           or ProcStateCol02 = 'X.TC.Struc.ERR'
           or ProcStateCol03 = 'X.TC.Struc.ERR'
           or ProcStateCol04 = 'X.TC.Struc.ERR'
           or ProcStateCol05 = 'X.TC.Struc.ERR'
           or ProcStateCol06 = 'X.TC.Struc.ERR'
           or ProcStateCol07 = 'X.TC.Struc.ERR'
           or ProcStateCol08 = 'X.TC.Struc.ERR'
           or ProcStateCol09 = 'X.TC.Struc.ERR'
           or ProcStateCol10 = 'X.TC.Struc.ERR'
           or ProcStateCol11 = 'X.TC.Struc.ERR'
           or ProcStateCol12 = 'X.TC.Struc.ERR'
           or ProcStateCol13 = 'X.TC.Struc.ERR'
           or ProcStateCol14 = 'X.TC.Struc.ERR'
           or ProcStateCol15 = 'X.TC.Struc.ERR'
           or ProcStateCol16 = 'X.TC.Struc.ERR'
           or ProcStateCol17 = 'X.TC.Struc.ERR'
           or ProcStateCol18 = 'X.TC.Struc.ERR'
           or ProcStateCol19 = 'X.TC.Struc.ERR'
           or ProcStateCol20 = 'X.TC.Struc.ERR'
           or ProcStateColMc = 'X.TC.Struc.ERR'
           or ProcStateColRf = 'X.TC.Struc.ERR'
           or ProcStateColUn = 'X.TC.Struc.ERR'

    if @UpdateCounter <> 0
    BEGIN
     print @Name + ' [ERR Update: values from:X.TC.Struc.ERR to: X.PLM.ERR found:' + convert(varchar(10),@UpdateCounter) + ' (n) with value X.TC.Struc.ERR]'
    END
    ELSE
    BEGIN
     print @Name + ' [OK Update: values from:X.TC.Struc.ERR to: X.PLM.ERR]'
     set @UpdateDone = 1
    END

   if @UpdateDone = 1
   begin
     -- set UpdateDone true see actions below
     EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
     print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   end
   ELSE
   BEGIN
     print @Name + ' [Update:' + @ValueDesired + ' -> !! -- NOT DONE -- !!]'
   end
end


-- 21.11.2017 16:44  TC / NativFileSys / SAP
set @Name='DataSourceType'
set @ValueCurr=''
set @ValueDesired='2017-11-21-01'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set DataSourceType=''NativFileSys'' where NativeRoot_DP <> '''''
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr

   set @ExecuteSQLstr='UPDATE Sites_tbl set DataSourceType=''SAP'' where SAPSystemSettings_xml is not Null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr

   set @ExecuteSQLstr='UPDATE Sites_tbl set DataSourceType=''TC'' where DataSourceType is Null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr

   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

 ------   03.07.2020

set @Name='Objects_tbl_Update_CheckOut'
set @ValueCurr=''
set @ValueDesired='2020-07-03-01'
set @UpdateDone=0
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'

   SET @ToProcessN = 0
   SET @DoneCounter = 0
   set @PrintEvery=100
   set @DoAction=1
   select @ToProcessN=count(*)
     from dbo.Objects_tbl
     where ObjectIsCheckedOut is NULL

   -- Cursor to process all Objects
   declare tbl_Cursor cursor fast_forward for
   select Id, ObjectCliName, ObjectClass
     from dbo.Objects_tbl
     where ObjectIsCheckedOut is NULL

   set nocount on
   open tbl_Cursor
    -- alle Objekte durchlaufen die durch den Cursor durchlaufen
    while 1=1
     begin
       SET @DoneCounter = @DoneCounter + 1
       fetch next from tbl_Cursor into @Id, @ObjectCliName, @ObjectClass
       -- Ausstieg wenn nichts zu lschen ist
       if (@ToProcessN =0)
       begin
         print('Result...........: No Data found to Update')
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
         end
         break
       end
       -- exit if last element is processed
       if (@@fetch_status <> 0)
       begin
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
        end
        break
       end

       if (@DoneCounter = 1) or (@DoneCounter = @ToProcessN) or (@DoneCounter % @PrintEvery = 0)
       begin
          print('Update:[' + CONVERT(nvarchar(64),@DoneCounter) + '/' + CONVERT(nvarchar(64),@ToProcessN) + ':' + Str((100.00*@DoneCounter/@ToProcessN),6,2)  + '%]' +
                ' Obj:[' + @ObjectClass + ':' + @ObjectCliName + ']')
       end

       if @DoAction = 1
       begin
          -- Step: Do the Update
       	 UPDATE Objects_tbl set ObjectIsCheckedOut=0 where Objects_tbl.Id = @Id
       end
     end
   close tbl_Cursor
   deallocate tbl_Cursor

   if @UpdateDone = 1
   begin
     -- set UpdateDone true see actions below
     EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
     print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   end
   ELSE
   BEGIN
     print @Name + ' [Update:' + @ValueDesired + ' -> !! -- NOT DONE -- !!]'
   end
end


set @Name='Objects_tbl_Update_WhereUsed'
set @ValueCurr=''
set @ValueDesired='2020-07-03-01'
set @UpdateDone=0
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'

   SET @ToProcessN = 0
   SET @DoneCounter = 0
   set @PrintEvery=100
   set @DoAction=1
   select @ToProcessN=count(*)
     from dbo.Objects_tbl
     where ObjectWhereUsedN is NULL

   -- Cursor to process all Objects
   declare tbl_Cursor cursor fast_forward for
   select Id, ObjectCliName, ObjectClass
     from dbo.Objects_tbl
     where ObjectWhereUsedN is NULL

   set nocount on
   open tbl_Cursor
    -- alle Objekte durchlaufen die durch den Cursor durchlaufen
    while 1=1
     begin
       SET @DoneCounter = @DoneCounter + 1
       fetch next from tbl_Cursor into @Id, @ObjectCliName, @ObjectClass
       -- Ausstieg wenn nichts zu lschen ist
       if (@ToProcessN =0)
       begin
         print('Result...........: No Data found to Update')
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
         end
         break
       end
       -- exit if last element is processed
       if (@@fetch_status <> 0)
       begin
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
        end
        break
       end

       if (@DoneCounter = 1) or (@DoneCounter = @ToProcessN) or (@DoneCounter % @PrintEvery = 0)
       begin
          print('Update:[' + CONVERT(nvarchar(64),@DoneCounter) + '/' + CONVERT(nvarchar(64),@ToProcessN) + ':' + Str((100.00*@DoneCounter/@ToProcessN),6,2)  + '%]' +
                ' Obj:[' + @ObjectClass + ':' + @ObjectCliName + ']')
       end

       if @DoAction = 1
       begin
          -- Step: Do the Update
       	 UPDATE Objects_tbl set ObjectWhereUsedN=-1 where Objects_tbl.Id = @Id
       end
     end
   close tbl_Cursor
   deallocate tbl_Cursor

   if @UpdateDone = 1
   begin
     -- set UpdateDone true see actions below
     EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
     print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   end
   ELSE
   BEGIN
     print @Name + ' [Update:' + @ValueDesired + ' -> !! -- NOT DONE -- !!]'
   end
end

--------------------------------------------------------------------------------
-- #New 28.06.2022/J.Fes Set ObjectIsMFKObj
set @Name='Objects_tbl Update->ObjectIsMFKObj'
set @ValueCurr=''
set @ValueDesired='2022-06-28-01'
set @UpdateDone=0
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print ('- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -')
   print (@Name + ':[' + @ValueDesired + ' ->Start!]')

   SET @ToProcessN = 0
   SET @DoneCounter = 0
   set @PrintEvery=100
   set @DoAction=1
   select @ToProcessN=count(*)
     from dbo.Objects_tbl
     where ObjectIsMFKObj is NULL

   -- Cursor to process all Objects
   declare tbl_Cursor cursor fast_forward for
   select Id, ObjectCliName, ObjectClass
     from dbo.Objects_tbl
     where ObjectIsMFKObj is NULL

   set nocount on
   open tbl_Cursor
    -- alle Objekte durchlaufen die durch den Cursor durchlaufen
    while 1=1
     begin
       SET @DoneCounter = @DoneCounter + 1
       fetch next from tbl_Cursor into @Id, @ObjectCliName, @ObjectClass
       -- Ausstieg wenn nichts zu lschen ist
       if (@ToProcessN =0)
       begin
        print(@Name + ':[Result:No Data found to Update]')
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
         end
         break
       end
       -- exit if last element is processed
       if (@@fetch_status <> 0)
       begin
        if @DoAction = 1
        begin
          -- set UpdateDone true see actions below
          set @UpdateDone=1
        end
        break
       end

       if (@DoneCounter = 1) or (@DoneCounter = @ToProcessN) or (@DoneCounter % @PrintEvery = 0)
       begin
          print(@Name + ':[' + CONVERT(nvarchar(64),@DoneCounter) + '/' + CONVERT(nvarchar(64),@ToProcessN) + ':' + Str((100.00*@DoneCounter/@ToProcessN),6,2)  + '%]' +
                ' Obj:[' + @ObjectClass + ':' + @ObjectCliName + ']')
       end

       if @DoAction = 1
       begin
          -- Step: Do the Update
       	 UPDATE Objects_tbl set ObjectIsMFKObj=0 where Objects_tbl.Id = @Id
       end
     end
   close tbl_Cursor
   deallocate tbl_Cursor

   if @UpdateDone = 1
   begin
     -- set UpdateDone true see actions below
     EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
     print @Name + ':[' + @ValueDesired + ' ->DONE!]'
   end
   ELSE
   BEGIN
     print @Name + ':[' + @ValueDesired + ' -> !! -- NOT DONE -- !!]'
   end
end
--------------------------------------------------------------------------------
-- set @Name='Objects_tbl_Update_add_ProcStateCol21..40'
-- set @ValueCurr=''
-- set @ValueDesired='2022-11-16-09'
-- set @UpdateDone=0
-- EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
-- if @ValueCompareStat <> 1
--  begin
--    print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
--    print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
--
--
--    -- DECLARE @DoneCounter INT
--    -- DECLARE @ToProcessN INT
--    SET @ToProcessN = 0
--    SET @DoneCounter = 0
--
--    -- #ToDo: Setup: print del ervery n'times
--    set @PrintEvery=500
--    -- #ToDo: Setup: @DoAction Action
--    --  if @DoAction = 1 then Data is deleted
--    --  if @DoAction = 0 then only Print is done
--    set @DoAction=1
--
--    select @ToProcessN=count(*)
--      from dbo.Objects_tbl with (nolock)
--      WHERE ProcStateCol21 is null or ProcStateCol21 = ''
--         or ProcStateCol22 is null or ProcStateCol22 = ''
--         or ProcStateCol23 is null or ProcStateCol23 = ''
--         or ProcStateCol24 is null or ProcStateCol24 = ''
--         or ProcStateCol25 is null or ProcStateCol25 = ''
--         or ProcStateCol26 is null or ProcStateCol26 = ''
--         or ProcStateCol27 is null or ProcStateCol27 = ''
--         or ProcStateCol28 is null or ProcStateCol28 = ''
--         or ProcStateCol29 is null or ProcStateCol29 = ''
--         or ProcStateCol30 is null or ProcStateCol30 = ''
--         or ProcStateCol31 is null or ProcStateCol31 = ''
--         or ProcStateCol32 is null or ProcStateCol32 = ''
--         or ProcStateCol33 is null or ProcStateCol33 = ''
--         or ProcStateCol34 is null or ProcStateCol34 = ''
--         or ProcStateCol35 is null or ProcStateCol35 = ''
--         or ProcStateCol36 is null or ProcStateCol36 = ''
--         or ProcStateCol37 is null or ProcStateCol37 = ''
--         or ProcStateCol38 is null or ProcStateCol38 = ''
--         or ProcStateCol39 is null or ProcStateCol39 = ''
--         or ProcStateCol40 is null or ProcStateCol40 = ''
--
--
--    -- Cursor to process all Objects
--    declare tbl_Cursor cursor fast_forward for
--    select Id, ObjectCliName, ObjectClass
--      from dbo.Objects_tbl with (nolock)
--      where ProcStateCol21 is null or ProcStateCol21 = ''
--         or ProcStateCol22 is null or ProcStateCol22 = ''
--         or ProcStateCol23 is null or ProcStateCol23 = ''
--         or ProcStateCol24 is null or ProcStateCol24 = ''
--         or ProcStateCol25 is null or ProcStateCol25 = ''
--         or ProcStateCol26 is null or ProcStateCol26 = ''
--         or ProcStateCol27 is null or ProcStateCol27 = ''
--         or ProcStateCol28 is null or ProcStateCol28 = ''
--         or ProcStateCol29 is null or ProcStateCol29 = ''
--         or ProcStateCol30 is null or ProcStateCol30 = ''
--         or ProcStateCol31 is null or ProcStateCol31 = ''
--         or ProcStateCol32 is null or ProcStateCol32 = ''
--         or ProcStateCol33 is null or ProcStateCol33 = ''
--         or ProcStateCol34 is null or ProcStateCol34 = ''
--         or ProcStateCol35 is null or ProcStateCol35 = ''
--         or ProcStateCol36 is null or ProcStateCol36 = ''
--         or ProcStateCol37 is null or ProcStateCol37 = ''
--         or ProcStateCol38 is null or ProcStateCol38 = ''
--         or ProcStateCol39 is null or ProcStateCol39 = ''
--         or ProcStateCol40 is null or ProcStateCol40 = ''
--
--    set nocount on
--    open tbl_Cursor
--     -- alle Objekte durchlaufen die durch den Cursor durchlaufen
--     while 1=1
--      begin
--        SET @DoneCounter = @DoneCounter + 1
--        fetch next from tbl_Cursor into @Id, @ObjectCliName, @ObjectClass
--        -- Ausstieg wenn nichts zu lschen ist
--        if (@ToProcessN =0)
--        begin
--          print('Result...........: No Data found to Update')
--         if @DoAction = 1
--         begin
--           -- set UpdateDone true see actions below
--           set @UpdateDone=1
--          end
--          break
--        end
--        -- exit if last element is processed
--        if (@@fetch_status <> 0)
--        begin
--         if @DoAction = 1
--         begin
--           -- set UpdateDone true see actions below
--           set @UpdateDone=1
--         end
--         break
--        end
--
--        if @DoAction = 1
--        begin
--           -- Step: Do the Update
--         	 UPDATE Objects_tbl
--              set ProcStateCol21 = case WHEN (ProcStateCol21 is NULL or ProcStateCol21 = '') THEN 'N' ELSE ProcStateCol21 END,
--                  ProcStateCol22 = case WHEN (ProcStateCol22 is NULL or ProcStateCol22 = '') THEN 'N' ELSE ProcStateCol22 END,
--                  ProcStateCol23 = case WHEN (ProcStateCol23 is NULL or ProcStateCol23 = '') THEN 'N' ELSE ProcStateCol23 END,
--                  ProcStateCol24 = case WHEN (ProcStateCol24 is NULL or ProcStateCol24 = '') THEN 'N' ELSE ProcStateCol24 END,
--                  ProcStateCol25 = case WHEN (ProcStateCol25 is NULL or ProcStateCol25 = '') THEN 'N' ELSE ProcStateCol25 END,
--                  ProcStateCol26 = case WHEN (ProcStateCol26 is NULL or ProcStateCol26 = '') THEN 'N' ELSE ProcStateCol26 END,
--                  ProcStateCol27 = case WHEN (ProcStateCol27 is NULL or ProcStateCol27 = '') THEN 'N' ELSE ProcStateCol27 END,
--                  ProcStateCol28 = case WHEN (ProcStateCol28 is NULL or ProcStateCol28 = '') THEN 'N' ELSE ProcStateCol28 END,
--                  ProcStateCol29 = case WHEN (ProcStateCol29 is NULL or ProcStateCol29 = '') THEN 'N' ELSE ProcStateCol29 END,
--                  ProcStateCol30 = case WHEN (ProcStateCol30 is NULL or ProcStateCol30 = '') THEN 'N' ELSE ProcStateCol30 END,
--                  ProcStateCol31 = case WHEN (ProcStateCol31 is NULL or ProcStateCol31 = '') THEN 'N' ELSE ProcStateCol31 END,
--                  ProcStateCol32 = case WHEN (ProcStateCol32 is NULL or ProcStateCol32 = '') THEN 'N' ELSE ProcStateCol32 END,
--                  ProcStateCol33 = case WHEN (ProcStateCol33 is NULL or ProcStateCol33 = '') THEN 'N' ELSE ProcStateCol33 END,
--                  ProcStateCol34 = case WHEN (ProcStateCol34 is NULL or ProcStateCol34 = '') THEN 'N' ELSE ProcStateCol34 END,
--                  ProcStateCol35 = case WHEN (ProcStateCol35 is NULL or ProcStateCol35 = '') THEN 'N' ELSE ProcStateCol35 END,
--                  ProcStateCol36 = case WHEN (ProcStateCol36 is NULL or ProcStateCol36 = '') THEN 'N' ELSE ProcStateCol36 END,
--                  ProcStateCol37 = case WHEN (ProcStateCol37 is NULL or ProcStateCol37 = '') THEN 'N' ELSE ProcStateCol37 END,
--                  ProcStateCol38 = case WHEN (ProcStateCol38 is NULL or ProcStateCol38 = '') THEN 'N' ELSE ProcStateCol38 END,
--                  ProcStateCol39 = case WHEN (ProcStateCol39 is NULL or ProcStateCol39 = '') THEN 'N' ELSE ProcStateCol39 END,
--                  ProcStateCol40 = case WHEN (ProcStateCol40 is NULL or ProcStateCol40 = '') THEN 'N' ELSE ProcStateCol40 END
--                where Objects_tbl.Id = @Id
--        end
--
--               -- #Debug: Austieg fr test
--        -- if (@DoneCounter >=2) break
--
--        if (@DoneCounter = 1) or (@DoneCounter = @ToProcessN) or (@DoneCounter % @PrintEvery = 0)
--        begin
--           print('Update:[' + CONVERT(nvarchar(64),@DoneCounter) + '/' + CONVERT(nvarchar(64),@ToProcessN) + ':' + Str((100.00*@DoneCounter/@ToProcessN),6,2)  + '%]' +
--                 ' Obj:[' + @ObjectClass + ':' + @ObjectCliName + ']')
--        end
--
--
--      end
--    close tbl_Cursor
--    deallocate tbl_Cursor
--
--    if @UpdateDone = 1
--    begin
--      -- set UpdateDone true see actions below
--      EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
--      print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
--    end
--    ELSE
--    BEGIN
--      print @Name + ' [Update:' + @ValueDesired + ' -> !! -- NOT DONE -- !!]'
--    end
-- end

---##########################################################################---
set @Name='Objects_tbl_Update_ChkPStatus'
set @ValueCurr=''
set @ValueDesired='2022-11-16-02'
set @UpdateDone=0
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'

   SET @ToProcessN = 0

   -- Define print every n'times
   set @PrintEvery=10
   -- Setup: @DoAction Action
   --  if @DoAction = 1 then Data is deleted
   --  if @DoAction = 0 then only Print is done
   set @DoAction=1

   select @ToProcessN=count(*) from dbo.Objects_tbl with (nolock)
       where
            (ProcStateCol01 is null or ProcStateCol01 = '')
         or (ProcStateCol02 is null or ProcStateCol02 = '')
         or (ProcStateCol03 is null or ProcStateCol03 = '')
         or (ProcStateCol04 is null or ProcStateCol04 = '')
         or (ProcStateCol05 is null or ProcStateCol05 = '')
         or (ProcStateCol06 is null or ProcStateCol06 = '')
         or (ProcStateCol07 is null or ProcStateCol07 = '')
         or (ProcStateCol08 is null or ProcStateCol08 = '')
         or (ProcStateCol09 is null or ProcStateCol09 = '')
         or (ProcStateCol10 is null or ProcStateCol10 = '')
         or (ProcStateCol11 is null or ProcStateCol11 = '')
         or (ProcStateCol12 is null or ProcStateCol12 = '')
         or (ProcStateCol13 is null or ProcStateCol13 = '')
         or (ProcStateCol14 is null or ProcStateCol14 = '')
         or (ProcStateCol15 is null or ProcStateCol15 = '')
         or (ProcStateCol16 is null or ProcStateCol16 = '')
         or (ProcStateCol17 is null or ProcStateCol17 = '')
         or (ProcStateCol18 is null or ProcStateCol18 = '')
         or (ProcStateCol19 is null or ProcStateCol19 = '')
         or (ProcStateCol20 is null or ProcStateCol20 = '')
         or (ProcStateCol21 is null or ProcStateCol21 = '')
         or (ProcStateCol22 is null or ProcStateCol22 = '')
         or (ProcStateCol23 is null or ProcStateCol23 = '')
         or (ProcStateCol24 is null or ProcStateCol24 = '')
         or (ProcStateCol25 is null or ProcStateCol25 = '')
         or (ProcStateCol26 is null or ProcStateCol26 = '')
         or (ProcStateCol27 is null or ProcStateCol27 = '')
         or (ProcStateCol28 is null or ProcStateCol28 = '')
         or (ProcStateCol29 is null or ProcStateCol29 = '')
         or (ProcStateCol30 is null or ProcStateCol30 = '')
         or (ProcStateCol31 is null or ProcStateCol31 = '')
         or (ProcStateCol32 is null or ProcStateCol32 = '')
         or (ProcStateCol33 is null or ProcStateCol33 = '')
         or (ProcStateCol34 is null or ProcStateCol34 = '')
         or (ProcStateCol35 is null or ProcStateCol35 = '')
         or (ProcStateCol36 is null or ProcStateCol36 = '')
         or (ProcStateCol37 is null or ProcStateCol37 = '')
         or (ProcStateCol38 is null or ProcStateCol38 = '')
         or (ProcStateCol39 is null or ProcStateCol39 = '')
         or (ProcStateCol40 is null or ProcStateCol40 = '')
         or (ProcStateColRf is null or ProcStateColRf = '')
         or (ProcStateColMc is null or ProcStateColMc = '')
         or (ProcStateColUn is null or ProcStateColUn = '')

   -- Cursor to process all Objects
   declare tbl_Cursor cursor fast_forward for
   select Id, ObjectCliName, ObjectClass, ObjectFromSiteID,
           ProcStateCol01,
           ProcStateCol02,
           ProcStateCol03,
           ProcStateCol04,
           ProcStateCol05,
           ProcStateCol06,
           ProcStateCol07,
           ProcStateCol08,
           ProcStateCol09,
           ProcStateCol10,
           ProcStateCol11,
           ProcStateCol12,
           ProcStateCol13,
           ProcStateCol14,
           ProcStateCol15,
           ProcStateCol16,
           ProcStateCol17,
           ProcStateCol18,
           ProcStateCol19,
           ProcStateCol20,
           ProcStateCol21,
           ProcStateCol22,
           ProcStateCol23,
           ProcStateCol24,
           ProcStateCol25,
           ProcStateCol26,
           ProcStateCol27,
           ProcStateCol28,
           ProcStateCol29,
           ProcStateCol30,
           ProcStateCol31,
           ProcStateCol32,
           ProcStateCol33,
           ProcStateCol34,
           ProcStateCol35,
           ProcStateCol36,
           ProcStateCol37,
           ProcStateCol38,
           ProcStateCol39,
           ProcStateCol40,
           ProcStateColRf,
           ProcStateColMc,
           ProcStateColUn
     from dbo.Objects_tbl with (nolock)
       where (ProcStateCol01 is null or ProcStateCol01 = '')
         or (ProcStateCol02 is null or ProcStateCol02 = '')
         or (ProcStateCol03 is null or ProcStateCol03 = '')
         or (ProcStateCol04 is null or ProcStateCol04 = '')
         or (ProcStateCol05 is null or ProcStateCol05 = '')
         or (ProcStateCol06 is null or ProcStateCol06 = '')
         or (ProcStateCol07 is null or ProcStateCol07 = '')
         or (ProcStateCol08 is null or ProcStateCol08 = '')
         or (ProcStateCol09 is null or ProcStateCol09 = '')
         or (ProcStateCol10 is null or ProcStateCol10 = '')
         or (ProcStateCol11 is null or ProcStateCol11 = '')
         or (ProcStateCol12 is null or ProcStateCol12 = '')
         or (ProcStateCol13 is null or ProcStateCol13 = '')
         or (ProcStateCol14 is null or ProcStateCol14 = '')
         or (ProcStateCol15 is null or ProcStateCol15 = '')
         or (ProcStateCol16 is null or ProcStateCol16 = '')
         or (ProcStateCol17 is null or ProcStateCol17 = '')
         or (ProcStateCol18 is null or ProcStateCol18 = '')
         or (ProcStateCol19 is null or ProcStateCol19 = '')
         or (ProcStateCol20 is null or ProcStateCol20 = '')
         or (ProcStateCol21 is null or ProcStateCol21 = '')
         or (ProcStateCol22 is null or ProcStateCol22 = '')
         or (ProcStateCol23 is null or ProcStateCol23 = '')
         or (ProcStateCol24 is null or ProcStateCol24 = '')
         or (ProcStateCol25 is null or ProcStateCol25 = '')
         or (ProcStateCol26 is null or ProcStateCol26 = '')
         or (ProcStateCol27 is null or ProcStateCol27 = '')
         or (ProcStateCol28 is null or ProcStateCol28 = '')
         or (ProcStateCol29 is null or ProcStateCol29 = '')
         or (ProcStateCol30 is null or ProcStateCol30 = '')
         or (ProcStateCol31 is null or ProcStateCol31 = '')
         or (ProcStateCol32 is null or ProcStateCol32 = '')
         or (ProcStateCol33 is null or ProcStateCol33 = '')
         or (ProcStateCol34 is null or ProcStateCol34 = '')
         or (ProcStateCol35 is null or ProcStateCol35 = '')
         or (ProcStateCol36 is null or ProcStateCol36 = '')
         or (ProcStateCol37 is null or ProcStateCol37 = '')
         or (ProcStateCol38 is null or ProcStateCol38 = '')
         or (ProcStateCol39 is null or ProcStateCol39 = '')
         or (ProcStateCol40 is null or ProcStateCol40 = '')
         or (ProcStateColRf is null or ProcStateColRf = '')
         or (ProcStateColMc is null or ProcStateColMc = '')
         or (ProcStateColUn is null or ProcStateColUn = '')

   SET @DoneCounter = 0
   set nocount on
   open tbl_Cursor
    -- alle Objekte durchlaufen
    while 1=1
     begin
      -- break
       SET @DoneCounter = @DoneCounter + 1
       fetch next from tbl_Cursor into @Id, @ObjectCliName, @ObjectClass, @ObjectFromSiteID,
          @ProcStateCol01Val,
          @ProcStateCol02Val,
          @ProcStateCol03Val,
          @ProcStateCol04Val,
          @ProcStateCol05Val,
          @ProcStateCol06Val,
          @ProcStateCol07Val,
          @ProcStateCol08Val,
          @ProcStateCol09Val,
          @ProcStateCol10Val,
          @ProcStateCol11Val,
          @ProcStateCol12Val,
          @ProcStateCol13Val,
          @ProcStateCol14Val,
          @ProcStateCol15Val,
          @ProcStateCol16Val,
          @ProcStateCol17Val,
          @ProcStateCol18Val,
          @ProcStateCol19Val,
          @ProcStateCol20Val,
          @ProcStateCol21Val,
          @ProcStateCol22Val,
          @ProcStateCol23Val,
          @ProcStateCol24Val,
          @ProcStateCol25Val,
          @ProcStateCol26Val,
          @ProcStateCol27Val,
          @ProcStateCol28Val,
          @ProcStateCol29Val,
          @ProcStateCol30Val,
          @ProcStateCol31Val,
          @ProcStateCol32Val,
          @ProcStateCol33Val,
          @ProcStateCol34Val,
          @ProcStateCol35Val,
          @ProcStateCol36Val,
          @ProcStateCol37Val,
          @ProcStateCol38Val,
          @ProcStateCol39Val,
          @ProcStateCol40Val,
          @ProcStateColRfVal,
          @ProcStateColMcVal,
          @ProcStateColUnVal


       -- exit if nothing is todo
       if (@ToProcessN =0)
       begin
        print('Result...........: No Data found to Update')
        -- set UpdateDone true see actions below
        if @DoAction = 1 set @UpdateDone=1
        break
       end
       -- exit if last element is processed
       if (@@fetch_status <> 0)
       begin
        -- set UpdateDone true see actions below
        if @DoAction = 1 set @UpdateDone=1
        break
       end

       set @DoPrint = 0
       set @PMessagestr = ''
       if dbo.StringTrim_UDF(@ProcStateCol01Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol02Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol03Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol04Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol05Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol06Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol07Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol08Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol09Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol10Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol11Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol12Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol13Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol14Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol15Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol16Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol17Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol18Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol19Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol20Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol21Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol22Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol23Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol24Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol25Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol26Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol27Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol28Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol29Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol30Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol31Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol32Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol33Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol34Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol35Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol36Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol37Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol38Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol39Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateCol40Val) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateColRfVal) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateColMcVal) = '' set @DoPrint = 1
       if dbo.StringTrim_UDF(@ProcStateColUnVal) = '' set @DoPrint = 1


	  -- EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '40', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output

       if (@DoPrint = 1)
       begin
        if dbo.StringTrim_UDF(@ProcStateCol01Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '01', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol02Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '02', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol03Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '03', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol04Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '04', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol05Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '05', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol06Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '06', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol07Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '07', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol08Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '08', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol09Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '09', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol10Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '10', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol11Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '11', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol12Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '12', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol13Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '13', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol14Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '14', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol15Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '15', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol16Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '16', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol17Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '17', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol18Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '18', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol19Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '19', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol20Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '20', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol21Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '21', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol22Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '22', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol23Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '23', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol24Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '24', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol25Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '25', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol26Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '26', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol27Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '27', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol28Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '28', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol29Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '29', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol30Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '30', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol31Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '31', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol32Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '32', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol33Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '33', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol34Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '34', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol35Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '35', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol36Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '36', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol37Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '37', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol38Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '38', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol39Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '39', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateCol40Val) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, '40', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateColRfVal) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, 'Rf', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateColMcVal) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, 'Mc', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
        if dbo.StringTrim_UDF(@ProcStateColUnVal) = '' EXECUTE Objects_tbl_MT_UpdateProcStateCol @Id, 'Un', 'N', @ObjectFromSiteID, @ObjectClass, @ObjectCliName, @PMessagestr Output
       end

       if (@DoneCounter = 1) or (@DoneCounter = @ToProcessN) or (@DoneCounter % @PrintEvery = 0)
       begin
        if @PMessagestr = '' set @PMessagestr = 'Need no update'
        print('Do:[' + CONVERT(nvarchar(64),@DoneCounter) + '/' + CONVERT(nvarchar(64),@ToProcessN) + ':' + Str((100.00*@DoneCounter/@ToProcessN),6,2)  + '%]' +
             ' Obj:[' + @ObjectFromSiteID + ':' + @ObjectClass + ':' + @ObjectCliName + ']' +
             ' Upd:[' + dbo.StringTrim_UDF(@PMessagestr) + ']'
             )
       end
   end  --- while

   close tbl_Cursor
   deallocate tbl_Cursor

   if @UpdateDone = 1
   begin
     -- set UpdateDone true see actions below
     EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
     print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
   end
   ELSE
   BEGIN
     print @Name + ' [Update:' + @ValueDesired + ' -> !! -- NOT DONE -- !!]'
   end
end


-- resets Client.Reboot to 0 where it is null (New 28.02.2023 A.Stein)
set @Name='Computers_tbl_Update_ComputerReboot'
set @ValueCurr=''
set @ValueDesired='2023-02-27'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobComputers_tbl set ComputerReboot=0 where ComputerReboot is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end

-- resets Client.Reboot to 0 where it is null (New 28.02.2023 A.Stein)
set @Name='Computers_tbl_Update_ComputerAutoRebootActive'
set @ValueCurr=''
set @ValueDesired='2024-02-12'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   set @ExecuteSQLstr='UPDATE JobComputers_tbl set ComputerAutoRebootActive=1 where ComputerAutoRebootActive is null'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   execute sp_executesql @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


set @Name='ImportFs_HashCode'
set @ValueCurr=''
set @ValueDesired='2025-08-15'
EXECUTE zzzzzDbMaintain_valueGet @Name , @ValueCurr Output , @ValueDesired , @ValueCompareStat Output
if @ValueCompareStat <> 1
 begin
   print '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
   print @Name + ' [Update:' + @ValueDesired + ' ->Start!]'
   set @ExecuteSQLstr='UPDATE Sites_tbl set ImportFs_HashCode=0 where ImportFs_HashCode is null'
   execute sp_executesql @ExecuteSQLstr
   print @Name + ' [Update 1/1:->DONE!] ' + @ExecuteSQLstr
   EXECUTE zzzzzDbMaintain_valueSave @Name , @ValueDesired
   print @Name + ' [Update:' + @ValueDesired + ' ->DONE!]'
 end


EndeExit:
 Print '.........................................................................'
 Print ('Maintain Database: #DB_N# !Done!')
 Print '-------------------------------------------------------------------------'
 Print ''
GO
