Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Procedures    : [JobMgr_30_ApplProceduresObjects_Import_Object.sql]'
Print ' Autor         : J.Feuerstein'
Print ' Creation Date : 08.08.2014'
Print ' Last Update   : 06.07.2017/J.Fes'
Print '-------------------------------------------------------------------------'

use [#DB_N#]

Print '-- [Object_Import_GetProcStatFromMask_UDF] -------------------------------'
If Exists (select Name
           from sysobjects
            where Name = "Object_Import_GetProcStatFromMask_UDF")
DROP FUNCTION Object_Import_GetProcStatFromMask_UDF
GO

-- Returns from ProcStateMask value of ProcStateColume
-- #LUp:16.11.2022/J.Fes mask size update  from @ProcStateMask_p nvarchar(220) to @ProcStateMask_p nvarchar(430)
CREATE FUNCTION Object_Import_GetProcStatFromMask_UDF(@ProcStateMask_p nvarchar(430) ,@Num int)
RETURNS varchar(32)
AS
BEGIN
   RETURN rtrim(substring(@ProcStateMask_p,  (@Num -1) * 10 + 1 ,10))
END
GO

Print '-- [Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF #New:06.07.17] -----'
If Exists (select Name
           from sysobjects
            where Name = 'Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF')
DROP FUNCTION Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF
GO


-- returs for @ObjectId_p new value for @ProcStateCol if X_PLM_ERR is requested
-- #LUp:16.11.2022/J.Fes mask size update  from @ProcStateMask_p nvarchar(220) to @ProcStateMask_p nvarchar(430)
CREATE FUNCTION Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId_p uniqueidentifier,
                                                                 @ProcStateColVal_p nvarchar(32),
                                                                 @ProcStateCol_p nvarchar(2),
                                                                 @ProcStateMask_p nvarchar(430),
                                                                 @Num int
                                                                 )
RETURNS nvarchar(32)
AS
BEGIN
    -- Returns final ProcSatCol val
    DECLARE @ProcStateColVal_c nvarchar(32),
            @ProcStateColVal_r nvarchar(32)

    -- #Doc: Get status for @ProcStateCol_p from Objects_tbl via @ObjectId_p
    set @ProcStateColVal_c = dbo.Objects_tbl_Object_Get_ProcessStatus_UDF(@ObjectId_p, @ProcStateCol_p)
    if @ProcStateColVal_c = 'X.PLM.ERR'
    BEGIN
     -- #Doc: set @ProcStateColVal_r to value from @ProcStateMask_p
     -- #Doc: -> it sets value to P.Status from ImportMask ('N')
     SET @ProcStateColVal_r = dbo.Object_Import_GetProcStatFromMask_UDF(@ProcStateMask_p,@Num)
    END
    ELSE
    BEGIN
     -- #Doc: set @ProcStateColVal_r to value @ProcStateColVal_p
     -- #Doc: -> because no change on @ProcStateColVal
     SET @ProcStateColVal_r = @ProcStateColVal_p
    END

    RETURN @ProcStateColVal_r
END
GO




Print '-- [Object_Import] ------------------------------------------------------'
If Exists (select Name
           from sysobjects
           where Name = "Object_Import" and type = "P")
Drop Procedure Object_Import
GO


Create Procedure Object_Import @ObjectPuid                    nvarchar(64),         -- 01 change 22.08.2012 a.becker (size from 15 to 32) #LUp:30.11.17 J.Fes (size from 32 to 64)
                               @ObjectName                    nvarchar(255),        -- 02 25.10.2018 S.Gueth (size from 64 to 128) // 25.08.2023 A.Stein (size from 128 to 255)
                               @ObjectName2                   nvarchar(128),        -- 03 25.10.2018 S.Gueth (size from 64 to 128)
                               @ObjectDescription             nvarchar(255),        -- 04

                               @ObjectFromSiteID              nvarchar(32),         -- 05
                               @ObjectCliName                 nvarchar(255),        -- 06
                               @ObjectClass                   nvarchar(10),         -- 07 ITem IR DS

                               @ObjectOwningSiteID            nvarchar(32),         -- 08
                               @ObjectExportRecord            nvarchar(255) = null, -- 09: #New: 16.08.2013/J.Fes
                               @ObjectExportRecordDate        datetime = null,      -- 10: #New 20.08.2013/J.Fes

                               @ObjectType                    nvarchar(32),         -- 11: UGMASTER UGPART ..

                               @ObjectOwner                   nvarchar(32),         -- 12:
                               @ObjectGroup                   nvarchar(255),        -- 13: #Upd: 16.09.2015/J.Fes size enlarged
                               @ObjectCreateDate              datetime = null,      -- 14:
                               @ObjectLastModUser             nvarchar(32),         -- 15:
                               @ObjectLastModDate             datetime = null,      -- 16:
                               @ObjectLastSavDate             datetime = null,      -- 17: #New: 04.02.2020/J.Fes

                               @ObjectFs_DPNE                 nvarchar(255)= null,  -- 18:
                               @ObjectFs_Vol                  nvarchar(64) = null,  -- 19:
                               @ObjectFs_NE                   nvarchar(64) = null,  -- 20:
                               @ObjectFs_SizeBytes            bigint = null,        -- 21:new 22.08.2012 a.becker angepasst 09.11.2012 10:50

                               @ObjectFs_HashCode             nvarchar(64),         -- 22:new 22.08.2012 a.becker
                               @ObjectFs_LastModDate          datetime = null,      -- 23:new 25.04.2014 J.Fes

                               @ObjectDs_Ver                  int  = null,          -- 24:#New: 27.05.2016 J.Fes
                               @ObjectDs_VerKeepLimt          int  = null,          -- 25:#New: 27.05.2016 J.Fes
                               @ObjectDs_VersN                int  = null,          -- 26:#New: 27.05.2016 J.Fes

                               @ObjectSaveVersion             nvarchar(64),         -- 27:#New 22.08.2012 a.becker

                               @ObjectUgMaster_PartFamMemName  nvarchar(64) = null, -- 28:
                               @ObjectUgMaster_Type            nvarchar(32),        -- 29: SP AP
                               @ObjectUgMaster_APLevels        int,                 -- 30:
                               @ObjectUgMaster_CompCount       int,                 -- 31:
                               @ObjectUgMaster_CompCountUnique int,                 -- 32: new 22.08.2012 a.becker
                               @ObjectUgMaster_FsHitCount      int,                 -- 33:

                               @ObjectReleaseState            nvarchar(255) = null, -- 34: UPd: 11.01.2019/J.Fes upsize 32 -255
                               @ObjectReleaseDate             datetime = null,      -- 35:

                               @ObjectNote                    nvarchar(255),        -- 36:
                               @ObjectPrjIds                  nvarchar(255),        -- 37: #New: 01.04.2013 J.Fes

                               @ImportObjectNewProcStateMask  nvarchar(430),        -- 38: 07.11.2022/JFes+ P.Gr.21..40 + P.Gr.Un // LUp:01.03.2016 + P.Gr Mc /  Up:08.08.2014 / J.Fes je Pgr = 10
                               @ImportObjectUpdProcStateMask  nvarchar(430),        -- 39: 07.11.2022/JFes+ P.Gr.21..40 + P.Gr.Un // LUp:01.03.2016 + P.Gr Mc / J.Fes je Pgr = 10
                               @ImportObjectErr_p             nvarchar(64),         -- 40

                               -- #New: 07.08.2014 Start -------------------------
                               @ObjectUgMaster_Lev1CompN       int = null ,         -- 41
                               @ObjectUgMaster_Lev1CompUniqueN int = null ,         -- 42
                               @ObjectUgMaster_ApBOM_isPrecise bit = null ,         -- 43

                               @ObjectAttr01                   nvarchar(255) = null , -- 44
                               @ObjectAttr02                   nvarchar(255) = null , -- 45
                               @ObjectAttr03                   nvarchar(255) = null , -- 46
                               @ObjectAttr04                   nvarchar(255) = null , -- 47
                               @ObjectAttr05                   nvarchar(255) = null , -- 48
                               @ObjectAttr06                   nvarchar(255) = null , -- 49
                               @ObjectAttr07                   nvarchar(255) = null , -- 50
                               @ObjectAttr08                   nvarchar(255) = null , -- 51
                               @ObjectAttr09                   nvarchar(255) = null , -- 52
                               @ObjectAttr10                   nvarchar(255) = null , -- 53
                               
                               -- #New: 21.08.2019 S.Gueth
                               @MultiCadAP                     nvarchar(255) = null , -- 54
                               -- #New: 21.08.2019 S.Gueth
                               @MultiCadItemRevs               nvarchar(max) = null , -- 55

                               @ObjectIsCheckedOut             bit = null,           -- 56 #New:24.06.2020 S.Gueth
                               @ObjectCheckOutDate             datetime = null,      -- 57 #New:24.06.2020 S.Gueth
                               @ObjectCheckOutUser             nvarchar(128) = null, -- 58 #New:24.06.2020 S.Gueth
                               @ObjectCheckOutChangeId         nvarchar(128) = null, -- 59 #New:24.06.2020 S.Gueth
                               @ObjectRevChainAnchorPuid       nvarchar(128) = null, -- 61 #New:24.06.2020 S.Gueth
                               @ObjectWhereUsedN               int = null,           -- 62 #New:24.06.2020 S.Gueth

                               -- #New: 29.04.2019
                               @DoUpdateRank                   bit,                  -- 63 #New: 29.04.2019/Anton
                               @ObjectIsMFKObj                 bit = null,           -- 64 #New:27.06.2022 J.Fes

                               -- #New: 07.08.2014 Ende -------------------------

                               @IrId                          uniqueidentifier,        -- 57
                               @IrPuid                        nvarchar(32),            -- 58: change A.Becker 22.08.2012: Puid von 15 auf 32 Zeichen erweitert
                               @ObjectId                      uniqueidentifier Output  -- 59:


--  Lastet ein Object in die Datenbank ein wichtig: bei Struktur anpassungen ist immer die .. dazugehrigen View auch zu prfen !!
--  31.12.2008 J.Fes @ImportObjectErr_p
--  12.07.2010 J.Fes Transaction methoden eingefuegt
--  24.02.2011 J.Fes @IrId eingefuegt
--  22.08.2012 A.Becker: @ObjectFs_SizeBytes, @ObjectFs_HashCode, @ObjectSaveVersion und @ObjectUgMaster_CompCountUnique hinzugefgt
--  07.11.2016 J.Fes Update ObjectSyncTrigger = null add
--  07.11.2022 J.Fes add PGr.21..40
As
BEGIN

 DECLARE @DebugPrintOn bit,
         @MyProcName nvarchar(32),
         @ImportObjectErr_c nvarchar(64),
         @StatusXRemove nvarchar(10)

 set @DebugPrintOn = 0
 set @MyProcName='Object_Import'
 set @ImportObjectErr_c = ""

-- #DOC: Updated removed 30.05.2018 15:36
--   if @ObjectType <> 'UGMASTER' and  @ObjectType <> 'UGPART'
--     and  @ObjectType <> 'PROPRT' and  @ObjectType <> 'PROASM' and  @ObjectType <> 'PRODRW'
--     BEGIN
--        set @ObjectUgMaster_PartFamMemName = ""
--     END
  -- set @ObjectUgMaster_PartFamMemName = "#Debug"


 if @DebugPrintOn = 1
 begin
  -- Clear Debug Table
  -- EXECUTE zzzzzDebugTbl_Empty
  EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '###########################' ,    '###################'
  EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '01-@ObjectPuid' ,    @ObjectPuid
  EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '02-@ObjectCliName' , @ObjectCliName
  EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '03-@ObjectType' ,    @ObjectType
  EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '04-@ObjectClass' ,   @ObjectClass
 end


 DECLARE @RetryCounter INT
 SET @RetryCounter = 1
 RETRY:             -- Label RETRY
 BEGIN TRY          -- Begin TRY
 BEGIN TRANSACTION  -- BEGIN Transaction 03.09.2010 14:39 Verlegt J.Fes/A.Becker



  EXECUTE JF_DateResetCheck @ObjectReleaseDate Output

  DECLARE @ProcStateCol01Val nvarchar(32),
          @ProcStateCol02Val nvarchar(32),
          @ProcStateCol03Val nvarchar(32),
          @ProcStateCol04Val nvarchar(32),
          @ProcStateCol05Val nvarchar(32),
          @ProcStateCol06Val nvarchar(32),
          @ProcStateCol07Val nvarchar(32),
          @ProcStateCol08Val nvarchar(32),
          @ProcStateCol09Val nvarchar(32),
          @ProcStateCol10Val nvarchar(32),
          @ProcStateCol11Val nvarchar(32),
          @ProcStateCol12Val nvarchar(32),
          @ProcStateCol13Val nvarchar(32),
          @ProcStateCol14Val nvarchar(32),
          @ProcStateCol15Val nvarchar(32),
          @ProcStateCol16Val nvarchar(32),
          @ProcStateCol17Val nvarchar(32),
          @ProcStateCol18Val nvarchar(32),
          @ProcStateCol19Val nvarchar(32),
          @ProcStateCol20Val nvarchar(32),

          -- #New:07.11.2022
          @ProcStateCol21Val nvarchar(32),
          @ProcStateCol22Val nvarchar(32),
          @ProcStateCol23Val nvarchar(32),
          @ProcStateCol24Val nvarchar(32),
          @ProcStateCol25Val nvarchar(32),
          @ProcStateCol26Val nvarchar(32),
          @ProcStateCol27Val nvarchar(32),
          @ProcStateCol28Val nvarchar(32),
          @ProcStateCol29Val nvarchar(32),
          @ProcStateCol30Val nvarchar(32),

          @ProcStateCol31Val nvarchar(32),
          @ProcStateCol32Val nvarchar(32),
          @ProcStateCol33Val nvarchar(32),
          @ProcStateCol34Val nvarchar(32),
          @ProcStateCol35Val nvarchar(32),
          @ProcStateCol36Val nvarchar(32),
          @ProcStateCol37Val nvarchar(32),
          @ProcStateCol38Val nvarchar(32),
          @ProcStateCol39Val nvarchar(32),
          @ProcStateCol40Val nvarchar(32),

          @ProcStateColRfVal nvarchar(32),
          @ProcStateColMcVal nvarchar(32),
          @ProcStateColUnVal nvarchar(32)

  -- Do not process duplicate items if MFK objects are in use
  DECLARE @ProcessDuplicateItems BIT = CASE WHEN @ObjectIsMFKObj=1 THEN 0 ELSE 1 END
  DECLARE @ObjectsRemapStatusRequired BIT

  -- set @ObjectCliName = @ObjectCliName + 'Debug#:Test'
  -- debug: BgStrukEx-Einzelteil-01_01/A;BgStrukEx-Einzelteil-01_01/B
  -- ermittelt @ObjectId Id der IR in der Objects_tbl
  EXECUTE Objects_tbl_Object_GetId_via_ObjectPuid
          @ObjectPuid, @ObjectName, @ObjectCliName, @ObjectFromSiteID,
          @ObjectClass,
          @IrId,
          @IrPuid,
		        @ProcessDuplicateItems,
          @ObjectId OUTPUT,
		        @ObjectsRemapStatusRequired OUTPUT

  if @ObjectId IS NULL
     BEGIN
      SET @ProcStateCol01Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,01)
      SET @ProcStateCol02Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,02)
      SET @ProcStateCol03Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,03)
      SET @ProcStateCol04Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,04)
      SET @ProcStateCol05Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,05)
      SET @ProcStateCol06Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,06)
      SET @ProcStateCol07Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,07)
      SET @ProcStateCol08Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,08)
      SET @ProcStateCol09Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,09)
      SET @ProcStateCol10Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,10)

      SET @ProcStateCol11Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,11)
      SET @ProcStateCol12Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,12)
      SET @ProcStateCol13Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,13)
      SET @ProcStateCol14Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,14)
      SET @ProcStateCol15Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,15)
      SET @ProcStateCol16Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,16)
      SET @ProcStateCol17Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,17)
      SET @ProcStateCol18Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,18)
      SET @ProcStateCol19Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,19)
      SET @ProcStateCol20Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,20)

      SET @ProcStateCol21Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,21)
      SET @ProcStateCol22Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,22)
      SET @ProcStateCol23Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,23)
      SET @ProcStateCol24Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,24)
      SET @ProcStateCol25Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,25)
      SET @ProcStateCol26Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,26)
      SET @ProcStateCol27Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,27)
      SET @ProcStateCol28Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,28)
      SET @ProcStateCol29Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,29)
      SET @ProcStateCol30Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,30)

      SET @ProcStateCol31Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,31)
      SET @ProcStateCol32Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,32)
      SET @ProcStateCol33Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,33)
      SET @ProcStateCol34Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,34)
      SET @ProcStateCol35Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,35)
      SET @ProcStateCol36Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,36)
      SET @ProcStateCol37Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,37)
      SET @ProcStateCol38Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,38)
      SET @ProcStateCol39Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,39)
      SET @ProcStateCol40Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,40)


      SET @ProcStateColMcVal = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,41)
      SET @ProcStateColRfVal = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,42)
      SET @ProcStateColUnVal = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectNewProcStateMask,43)

      if @DebugPrintOn = 1
      begin
        EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '13-@ObjectId IS:' , 'NULL'
        EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '14-@ImportObjectNewProcStateMask' , @ImportObjectNewProcStateMask
        EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '15-@ProcStateCol01Val' , @ProcStateCol01Val
      end

      -- NEWSEQUENTIALID()
      -- http://sqlpractice.wordpress.com/2010/04/08/sql-server-newid-versus-newsequentialid/ 04.03.2011 21:15 von Alex
      -- last ID get via SCOPE_IDENTITY()
      SET @ObjectId = NEWID()

      if @DebugPrintOn = 1
      begin
        EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '21-@ObjectId nf:do add new' , @ObjectId
      end
      INSERT INTO Objects_tbl (ID ,
                               ObjectPuid ,
                               ObjectName ,
                               ObjectName2 ,
                               ObjectDescription ,

                               ObjectFromSiteID ,
                               ObjectCliName ,
                               ObjectClass ,

                               ObjectOwningSiteID ,
                               ObjectExportRecord ,
                               ObjectExportRecordDate ,
                               ObjectType ,

                               ObjectOwner ,
                               ObjectGroup ,
                               ObjectCreateDate ,
                               ObjectLastModUser ,
                               ObjectLastModDate ,
                               ObjectLastSavDate ,
                               ObjectNote , --  21.10.2009 J.Fes eingefuegt
                               ObjectPrjIds , --  01.04.2013 J.Fes eingefuegt

                               ObjectFs_DPNE ,
                               ObjectFs_Vol ,
                               ObjectFs_NE ,
                               ObjectFs_SizeBytes , -- new 22.08.2012 a.becker
                               ObjectFs_HashCode ,  -- new 22.08.2012 a.becker
                               ObjectFs_LastModDate , -- new 25.04.2014 J.Fes

                               ObjectDs_Ver,          -- #New: 27.05.2016 J.Fes
                               ObjectDs_VerKeepLimt,  -- #New: 27.05.2016 J.Fes
                               ObjectDs_VersN,  -- #New: 27.05.2016 J.Fes

                               ObjectSaveVersion ,   -- new 22.08.2012 a.becker

                               ObjectUgMaster_PartFamMemName ,
                               ObjectUgMaster_Type ,
                               ObjectUgMaster_APLevels ,
                               ObjectUgMaster_CompCount ,
                               ObjectUgMaster_CompCountUnique , -- new 22.08.2012 a.becker
                               ObjectUgMaster_FsHitCount ,

                               ObjectReleaseState ,
                               ObjectReleaseDate ,

                               ProcStateCol01,
                               ProcStateCol02,
                               ProcStateCol03,
                               ProcStateCol04,
                               ProcStateCol05,
                               ProcStateCol06,
                               ProcStateCol07,
                               ProcStateCol08,
                               ProcStateCol09,
                               ProcStateCol10,
                               ProcStateCol11, -- #New: 08.08.2014 / J.fes
                               ProcStateCol12,
                               ProcStateCol13,
                               ProcStateCol14,
                               ProcStateCol15,
                               ProcStateCol16,
                               ProcStateCol17,
                               ProcStateCol18,
                               ProcStateCol19,
                               ProcStateCol20,

                               ProcStateCol21, -- #New: 07.11.2022 / J.fes
                               ProcStateCol22,
                               ProcStateCol23,
                               ProcStateCol24,
                               ProcStateCol25,
                               ProcStateCol26,
                               ProcStateCol27,
                               ProcStateCol28,
                               ProcStateCol29,
                               ProcStateCol30,

                               ProcStateCol31, -- #New: 07.11.2022 / J.fes
                               ProcStateCol32,
                               ProcStateCol33,
                               ProcStateCol34,
                               ProcStateCol35,
                               ProcStateCol36,
                               ProcStateCol37,
                               ProcStateCol38,
                               ProcStateCol39,
                               ProcStateCol40,

                               ProcStateColMc, -- #New:02.03.2016/J.Fes
                               ProcStateColRf,
                               ProcStateColUn, -- #New:21.11.2021/S.Gueth

                               ImportObjectErr,

                               ObjectUgMaster_Lev1CompN,
                               ObjectUgMaster_Lev1CompUniqueN,
                               ObjectUgMaster_ApBOM_isPrecise,

                               ObjectAttr01,
                               ObjectAttr02,
                               ObjectAttr03,
                               ObjectAttr04,
                               ObjectAttr05,
                               ObjectAttr06,
                               ObjectAttr07,
                               ObjectAttr08,
                               ObjectAttr09,
                               ObjectAttr10,
                               MultiCadAP,
                               MultiCadItemRevs,
                               ObjectIsCheckedOut,
                               ObjectCheckoutDate,
                               ObjectCheckoutUser,
                               ObjectCheckOutChangeId,
                               ObjectRevChainAnchorPuid,
                               ObjectWhereUsedN,
                               ObjectSyncTrigger,
                               ObjectIsMFKObj
                               )
                  VALUES      (@ObjectId ,
                               @ObjectPuid ,
                               @ObjectName ,
                               @ObjectName2 ,
                               @ObjectDescription ,

                               @ObjectFromSiteID ,
                               @ObjectCliName ,
                               @ObjectClass ,

                               @ObjectOwningSiteID ,
                               @ObjectExportRecord ,
                               @ObjectExportRecordDate ,
                               @ObjectType ,
--                                entnommen J.Fes/ 10.01.2012
--                                @ObjectIrType ,

                               @ObjectOwner ,
                               @ObjectGroup ,
                               @ObjectCreateDate ,
                               @ObjectLastModUser ,
                               @ObjectLastModDate ,
                               @ObjectLastSavDate ,
                               @ObjectNote ,
                               @ObjectPrjIds ,

                               @ObjectFs_DPNE ,
                               @ObjectFs_Vol ,
                               @ObjectFs_NE ,
                               @ObjectFs_SizeBytes ,   -- new 22.08.2012 a.becker
                               @ObjectFs_HashCode ,    -- new 22.08.2012 a.becker
                               @ObjectFs_LastModDate , -- new 25.04.2014 J.Fes

                               @ObjectDs_Ver ,         -- #New: 27.05.2016/J.Fes
                               @ObjectDs_VerKeepLimt,  -- #New: 27.05.2016/J.Fes
                               @ObjectDs_VersN ,         -- #New: 27.05.2016/J.Fes

                               @ObjectSaveVersion ,    -- new 22.08.2012 a.becker

                               @ObjectUgMaster_PartFamMemName ,
                               @ObjectUgMaster_Type ,
                               @ObjectUgMaster_APLevels ,
                               @ObjectUgMaster_CompCount ,
                               @ObjectUgMaster_CompCountUnique , -- new 22.08.2012 a.becker
                               @ObjectUgMaster_FsHitCount ,

                               @ObjectReleaseState ,
                               @ObjectReleaseDate ,

                               @ProcStateCol01Val,
                               @ProcStateCol02Val,
                               @ProcStateCol03Val,
                               @ProcStateCol04Val,
                               @ProcStateCol05Val,
                               @ProcStateCol06Val,
                               @ProcStateCol07Val,
                               @ProcStateCol08Val,
                               @ProcStateCol09Val,
                               @ProcStateCol10Val,

                               @ProcStateCol11Val,  -- #New: 08.08.2014 / J.fes
                               @ProcStateCol12Val,
                               @ProcStateCol13Val,
                               @ProcStateCol14Val,
                               @ProcStateCol15Val,
                               @ProcStateCol16Val,
                               @ProcStateCol17Val,
                               @ProcStateCol18Val,
                               @ProcStateCol19Val,
                               @ProcStateCol20Val,

                               @ProcStateCol21Val,  -- #New: 07.11.2022 / J.fes
                               @ProcStateCol22Val,
                               @ProcStateCol23Val,
                               @ProcStateCol24Val,
                               @ProcStateCol25Val,
                               @ProcStateCol26Val,
                               @ProcStateCol27Val,
                               @ProcStateCol28Val,
                               @ProcStateCol29Val,
                               @ProcStateCol30Val,

                               @ProcStateCol31Val,  -- #New: 08.08.2014 / J.fes
                               @ProcStateCol32Val,
                               @ProcStateCol33Val,
                               @ProcStateCol34Val,
                               @ProcStateCol35Val,
                               @ProcStateCol36Val,
                               @ProcStateCol37Val,
                               @ProcStateCol38Val,
                               @ProcStateCol39Val,
                               @ProcStateCol40Val,



                               @ProcStateColMcVal, -- #New:02.03.2016/J.Fes
                               @ProcStateColRfVal,
                               @ProcStateColUnVal, -- #New:21.11.2021/S.Gueth

                               @ImportObjectErr_p,

                               @ObjectUgMaster_Lev1CompN,
                               @ObjectUgMaster_Lev1CompUniqueN,
                               @ObjectUgMaster_ApBOM_isPrecise,

                               @ObjectAttr01,
                               @ObjectAttr02,
                               @ObjectAttr03,
                               @ObjectAttr04,
                               @ObjectAttr05,
                               @ObjectAttr06,
                               @ObjectAttr07,
                               @ObjectAttr08,
                               @ObjectAttr09,
                               @ObjectAttr10,
                               @MultiCadAP, 
                               @MultiCadItemRevs,
                               @ObjectIsCheckedOut,
                               @ObjectCheckOutDate,
                               @ObjectCheckOutUser,
                               @ObjectCheckOutChangeId,
                               @ObjectRevChainAnchorPuid,
                               @ObjectWhereUsedN,
                               Null,
                               @ObjectIsMFKObj
                               )
       -- SET @ReturnValue = @ReturnValue + '/DataSet=Add'
     END
  ELSE
     BEGIN
      -- DS.: Exist Update erforderlich'
      -- Now: Edit Datensatz mit @Id:=' + CONVERT(varchar(100), @Id)
      -- #New: 14.06.2017/J.Fes get current of ImportObjectErr
      select @ImportObjectErr_c=ImportObjectErr FROM Objects_tbl WITH (nolock) WHERE Id = @ObjectId

      if @DebugPrintOn = 1
      begin
       EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '21-@ObjectId found YES:do Update' , @ObjectId
       EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '22-@ImportObjectErr_c' , @ImportObjectErr_c
       EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '23-@ImportObjectErr_p' , @ImportObjectErr_p
      end

      UPDATE Objects_tbl
             SET ObjectPuid         = @ObjectPuid ,
                 ObjectName         = @ObjectName ,
                 ObjectName2        = @ObjectName2 ,
                 ObjectDescription  = @ObjectDescription ,

                 ObjectFromSiteID   = @ObjectFromSiteID ,
                 ObjectCliName      = @ObjectCliName ,
                 ObjectClass        = @ObjectClass ,

                 ObjectOwningSiteID = @ObjectOwningSiteID ,
                 ObjectExportRecord = @ObjectExportRecord ,
                 ObjectExportRecordDate = @ObjectExportRecordDate ,
                 ObjectType         = @ObjectType ,
--                 10.01.2012 J.Fes entnommen
--                 ObjectIrType       = @ObjectIrType , -- 20.12.2011 06:27 eingefuegt

                 ObjectOwner        = @ObjectOwner ,
                 ObjectGroup        = @ObjectGroup ,
                 ObjectCreateDate   = @ObjectCreateDate ,
                 ObjectLastModUser  = @ObjectLastModUser ,
                 ObjectLastModDate  = @ObjectLastModDate ,
                 ObjectLastSavDate  = @ObjectLastSavDate , -- #New 04.02.2020 JFes
                 ObjectNote         = @ObjectNote , -- 21.10.2009 eingefuegt JFes
                 ObjectPrjIds       = @ObjectPrjIds , -- 01.04.2013 eingefuegt JFes

                 ObjectFs_DPNE      = @ObjectFs_DPNE ,
                 ObjectFs_Vol       = @ObjectFs_Vol ,
                 ObjectFs_NE        = @ObjectFs_NE ,
                 ObjectFs_SizeBytes = @ObjectFs_SizeBytes ,  -- new 22.08.2012 a.becker
                 ObjectFs_HashCode  = @ObjectFs_HashCode ,   -- new 22.08.2012 a.becker
                 ObjectFs_LastModDate = @ObjectFs_LastModDate ,

                 ObjectDs_Ver         = @ObjectDs_Ver ,        -- #New: 27.05.2016/J.Fes
                 ObjectDs_VerKeepLimt = @ObjectDs_VerKeepLimt, -- #New: 27.05.2016/J.Fes
                 ObjectDs_VersN       = @ObjectDs_VersN ,      -- #New: 27.05.2016/J.Fes

                 ObjectSaveVersion   = @ObjectSaveVersion ,    -- new 22.08.2012 a.becker / Einkommentiert 19.03.2019 S.Gueth

                 ObjectUgMaster_PartFamMemName  = @ObjectUgMaster_PartFamMemName ,
                 ObjectUgMaster_Type            = @ObjectUgMaster_Type ,
                 ObjectUgMaster_APLevels        = @ObjectUgMaster_APLevels ,
                 ObjectUgMaster_CompCount       = @ObjectUgMaster_CompCount ,
                 ObjectUgMaster_CompCountUnique = @ObjectUgMaster_CompCountUnique , -- new 22.08.2012 a.becker
                 ObjectUgMaster_FsHitCount      = @ObjectUgMaster_FsHitCount ,

                 ObjectReleaseState = @ObjectReleaseState ,
                 ObjectReleaseDate  = @ObjectReleaseDate ,

                 ImportObjectErr = @ImportObjectErr_p ,

                 ObjectUgMaster_Lev1CompN = @ObjectUgMaster_Lev1CompN ,
                 ObjectUgMaster_Lev1CompUniqueN = @ObjectUgMaster_Lev1CompUniqueN ,
                 ObjectUgMaster_ApBOM_isPrecise = @ObjectUgMaster_ApBOM_isPrecise ,

                 -- #LUp: 08.06.2019/J.Fes update Object Attr values only if not NULL
                 ObjectAttr01 = ISNULL(@ObjectAttr01, ObjectAttr01),
                 ObjectAttr02 = ISNULL(@ObjectAttr02, ObjectAttr02),
                 ObjectAttr03 = ISNULL(@ObjectAttr03, ObjectAttr03),
                 ObjectAttr04 = ISNULL(@ObjectAttr04, ObjectAttr04),
                 ObjectAttr05 = ISNULL(@ObjectAttr05, ObjectAttr05),
                 ObjectAttr06 = ISNULL(@ObjectAttr06, ObjectAttr06),
                 ObjectAttr07 = ISNULL(@ObjectAttr07, ObjectAttr07),
                 ObjectAttr08 = ISNULL(@ObjectAttr08, ObjectAttr08),
                 ObjectAttr09 = ISNULL(@ObjectAttr09, ObjectAttr09),
                 ObjectAttr10 = ISNULL(@ObjectAttr10, ObjectAttr10),
                 
                 MultiCadAP = @MultiCadAP,
                 MultiCadItemRevs = @MultiCadItemRevs,

                 ObjectIsCheckedOut = @ObjectIsCheckedOut,
                 ObjectCheckoutDate = @ObjectCheckOutDate,
                 ObjectCheckoutUser = @ObjectCheckOutUser,
                 ObjectCheckOutChangeId = @ObjectCheckOutChangeId,
                 ObjectRevChainAnchorPuid = @ObjectRevChainAnchorPuid,
                 ObjectWhereUsedN = @ObjectWhereUsedN,

                 ObjectSyncTrigger = null,
                 ObjectIsMFKObj = @ObjectIsMFKObj

             Where Id = @ObjectId

             -- Updating ProcState
             SET @ProcStateCol01Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,01)
             SET @ProcStateCol02Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,02)
             SET @ProcStateCol03Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,03)
             SET @ProcStateCol04Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,04)
             SET @ProcStateCol05Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,05)
             SET @ProcStateCol06Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,06)
             SET @ProcStateCol07Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,07)
             SET @ProcStateCol08Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,08)
             SET @ProcStateCol09Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,09)
             SET @ProcStateCol10Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,10)

             SET @ProcStateCol11Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,11)
             SET @ProcStateCol12Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,12)
             SET @ProcStateCol13Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,13)
             SET @ProcStateCol14Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,14)
             SET @ProcStateCol15Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,15)
             SET @ProcStateCol16Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,16)
             SET @ProcStateCol17Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,17)
             SET @ProcStateCol18Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,18)
             SET @ProcStateCol19Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,19)
             SET @ProcStateCol20Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,20)

             SET @ProcStateCol21Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,21)
             SET @ProcStateCol22Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,22)
             SET @ProcStateCol23Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,23)
             SET @ProcStateCol24Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,24)
             SET @ProcStateCol25Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,25)
             SET @ProcStateCol26Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,26)
             SET @ProcStateCol27Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,27)
             SET @ProcStateCol28Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,28)
             SET @ProcStateCol29Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,29)
             SET @ProcStateCol30Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,30)

             SET @ProcStateCol31Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,31)
             SET @ProcStateCol32Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,32)
             SET @ProcStateCol33Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,33)
             SET @ProcStateCol34Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,34)
             SET @ProcStateCol35Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,35)
             SET @ProcStateCol36Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,36)
             SET @ProcStateCol37Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,37)
             SET @ProcStateCol38Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,38)
             SET @ProcStateCol39Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,39)
             SET @ProcStateCol40Val = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,40)

             SET @ProcStateColMcVal = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,41)
             SET @ProcStateColRfVal = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,42)
             SET @ProcStateColUnVal = dbo.Object_Import_GetProcStatFromMask_UDF(@ImportObjectUpdProcStateMask,43)

             -- #Doc: behandeln von X. via ImportObjectErr  -----------------------------
             -- CASE @ImportObjectErr_p =  "" and @ImportObjectErr_c  = ""  as now set Status=...
             -- CASE @ImportObjectErr_p <> "" and @ImportObjectErr_c  = ""  as now set Status=...
             -- CASE @ImportObjectErr_p <> "" and @ImportObjectErr_c  = <>  as now set Status=...
             -- CASE @ImportObjectErr_p =  "" and @ImportObjectErr_c <> ""  remove Status=X.
             if charindex('ERR',@ImportObjectErr_c) > 0 and charindex('ERR',@ImportObjectErr_p) = 0
              BEGIN
                -- #Doc: Object Err have a value before and now not anymore
                -- #Doc: then replace Status=X.PLM.ERR = value from @ImportObjectNewProcStateMask
                set @ProcStateCol01Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol01Val,'01',@ImportObjectNewProcStateMask,01)
                set @ProcStateCol02Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol02Val,'02',@ImportObjectNewProcStateMask,02)
                set @ProcStateCol03Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol03Val,'03',@ImportObjectNewProcStateMask,03)
                set @ProcStateCol04Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol04Val,'04',@ImportObjectNewProcStateMask,04)
                set @ProcStateCol05Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol05Val,'05',@ImportObjectNewProcStateMask,05)
                set @ProcStateCol06Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol06Val,'06',@ImportObjectNewProcStateMask,06)
                set @ProcStateCol07Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol07Val,'07',@ImportObjectNewProcStateMask,07)
                set @ProcStateCol08Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol08Val,'08',@ImportObjectNewProcStateMask,08)
                set @ProcStateCol09Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol09Val,'09',@ImportObjectNewProcStateMask,09)
                set @ProcStateCol10Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol10Val,'10',@ImportObjectNewProcStateMask,10)

                set @ProcStateCol11Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol01Val,'11',@ImportObjectNewProcStateMask,11)
                set @ProcStateCol12Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol02Val,'12',@ImportObjectNewProcStateMask,12)
                set @ProcStateCol13Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol03Val,'13',@ImportObjectNewProcStateMask,13)
                set @ProcStateCol14Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol04Val,'14',@ImportObjectNewProcStateMask,14)
                set @ProcStateCol15Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol05Val,'15',@ImportObjectNewProcStateMask,15)
                set @ProcStateCol16Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol06Val,'16',@ImportObjectNewProcStateMask,16)
                set @ProcStateCol17Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol07Val,'17',@ImportObjectNewProcStateMask,17)
                set @ProcStateCol18Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol08Val,'18',@ImportObjectNewProcStateMask,18)
                set @ProcStateCol19Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol09Val,'19',@ImportObjectNewProcStateMask,19)
                set @ProcStateCol20Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol10Val,'20',@ImportObjectNewProcStateMask,20)

                set @ProcStateCol21Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol01Val,'21',@ImportObjectNewProcStateMask,21)
                set @ProcStateCol22Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol02Val,'22',@ImportObjectNewProcStateMask,22)
                set @ProcStateCol23Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol03Val,'23',@ImportObjectNewProcStateMask,23)
                set @ProcStateCol24Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol04Val,'24',@ImportObjectNewProcStateMask,24)
                set @ProcStateCol25Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol05Val,'25',@ImportObjectNewProcStateMask,25)
                set @ProcStateCol26Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol06Val,'26',@ImportObjectNewProcStateMask,26)
                set @ProcStateCol27Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol07Val,'27',@ImportObjectNewProcStateMask,27)
                set @ProcStateCol28Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol08Val,'28',@ImportObjectNewProcStateMask,28)
                set @ProcStateCol29Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol09Val,'29',@ImportObjectNewProcStateMask,29)
                set @ProcStateCol30Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol10Val,'30',@ImportObjectNewProcStateMask,30)

                set @ProcStateCol31Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol01Val,'31',@ImportObjectNewProcStateMask,31)
                set @ProcStateCol32Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol02Val,'32',@ImportObjectNewProcStateMask,32)
                set @ProcStateCol33Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol03Val,'33',@ImportObjectNewProcStateMask,33)
                set @ProcStateCol34Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol04Val,'34',@ImportObjectNewProcStateMask,34)
                set @ProcStateCol35Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol05Val,'35',@ImportObjectNewProcStateMask,35)
                set @ProcStateCol36Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol06Val,'36',@ImportObjectNewProcStateMask,36)
                set @ProcStateCol37Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol07Val,'37',@ImportObjectNewProcStateMask,37)
                set @ProcStateCol38Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol08Val,'38',@ImportObjectNewProcStateMask,38)
                set @ProcStateCol39Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol09Val,'39',@ImportObjectNewProcStateMask,39)
                set @ProcStateCol40Val = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateCol10Val,'40',@ImportObjectNewProcStateMask,40)


                -- #Doc: not for @ProcStateColMcVal
                -- set @ProcStateColMcVal = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateColMcVal,'Mc',@ImportObjectNewProcStateMask,41)
                -- #LUp: @ProcStateColRfVal changed from: @ProcStateCol10Val to:@ProcStateColRfVal
                set @ProcStateColRfVal = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateColRfVal,'Rf',@ImportObjectNewProcStateMask,42)
                set @ProcStateColUnVal = dbo.Object_Import_Get_ProcessStatus_on_X_PLM_ERR_UDF(@ObjectId, @ProcStateColUnVal,'Un',@ImportObjectNewProcStateMask,43)

              END

             if @DebugPrintOn = 1
             begin
              EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '24-@ProcStateCol01Val' , @ProcStateCol01Val
              EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '25-@ProcStateCol02Val' , @ProcStateCol02Val
             end

             -- Update der Processspalten wenn <> '-'  ----------------------------------
             if @ProcStateCol01Val <> '-' UPDATE Objects_tbl SET ProcStateCol01 = @ProcStateCol01Val Where ID = @ObjectId
             if @ProcStateCol02Val <> '-' UPDATE Objects_tbl SET ProcStateCol02 = @ProcStateCol02Val Where ID = @ObjectId
             if @ProcStateCol03Val <> '-' UPDATE Objects_tbl SET ProcStateCol03 = @ProcStateCol03Val Where ID = @ObjectId
             if @ProcStateCol04Val <> '-' UPDATE Objects_tbl SET ProcStateCol04 = @ProcStateCol04Val Where ID = @ObjectId
             if @ProcStateCol05Val <> '-' UPDATE Objects_tbl SET ProcStateCol05 = @ProcStateCol05Val Where ID = @ObjectId
             if @ProcStateCol06Val <> '-' UPDATE Objects_tbl SET ProcStateCol06 = @ProcStateCol06Val Where ID = @ObjectId
             if @ProcStateCol07Val <> '-' UPDATE Objects_tbl SET ProcStateCol07 = @ProcStateCol07Val Where ID = @ObjectId
             if @ProcStateCol08Val <> '-' UPDATE Objects_tbl SET ProcStateCol08 = @ProcStateCol08Val Where ID = @ObjectId
             if @ProcStateCol09Val <> '-' UPDATE Objects_tbl SET ProcStateCol09 = @ProcStateCol09Val Where ID = @ObjectId
             if @ProcStateCol10Val <> '-' UPDATE Objects_tbl SET ProcStateCol10 = @ProcStateCol10Val Where ID = @ObjectId

             if @ProcStateCol11Val <> '-' UPDATE Objects_tbl SET ProcStateCol11 = @ProcStateCol11Val Where ID = @ObjectId
             if @ProcStateCol12Val <> '-' UPDATE Objects_tbl SET ProcStateCol12 = @ProcStateCol12Val Where ID = @ObjectId
             if @ProcStateCol13Val <> '-' UPDATE Objects_tbl SET ProcStateCol13 = @ProcStateCol13Val Where ID = @ObjectId
             if @ProcStateCol14Val <> '-' UPDATE Objects_tbl SET ProcStateCol14 = @ProcStateCol14Val Where ID = @ObjectId
             if @ProcStateCol15Val <> '-' UPDATE Objects_tbl SET ProcStateCol15 = @ProcStateCol15Val Where ID = @ObjectId
             if @ProcStateCol16Val <> '-' UPDATE Objects_tbl SET ProcStateCol16 = @ProcStateCol16Val Where ID = @ObjectId
             if @ProcStateCol17Val <> '-' UPDATE Objects_tbl SET ProcStateCol17 = @ProcStateCol17Val Where ID = @ObjectId
             if @ProcStateCol18Val <> '-' UPDATE Objects_tbl SET ProcStateCol18 = @ProcStateCol18Val Where ID = @ObjectId
             if @ProcStateCol19Val <> '-' UPDATE Objects_tbl SET ProcStateCol19 = @ProcStateCol19Val Where ID = @ObjectId
             if @ProcStateCol20Val <> '-' UPDATE Objects_tbl SET ProcStateCol20 = @ProcStateCol20Val Where ID = @ObjectId

             if @ProcStateCol21Val <> '-' UPDATE Objects_tbl SET ProcStateCol11 = @ProcStateCol21Val Where ID = @ObjectId
             if @ProcStateCol22Val <> '-' UPDATE Objects_tbl SET ProcStateCol12 = @ProcStateCol22Val Where ID = @ObjectId
             if @ProcStateCol23Val <> '-' UPDATE Objects_tbl SET ProcStateCol13 = @ProcStateCol23Val Where ID = @ObjectId
             if @ProcStateCol24Val <> '-' UPDATE Objects_tbl SET ProcStateCol14 = @ProcStateCol24Val Where ID = @ObjectId
             if @ProcStateCol25Val <> '-' UPDATE Objects_tbl SET ProcStateCol15 = @ProcStateCol25Val Where ID = @ObjectId
             if @ProcStateCol26Val <> '-' UPDATE Objects_tbl SET ProcStateCol16 = @ProcStateCol26Val Where ID = @ObjectId
             if @ProcStateCol27Val <> '-' UPDATE Objects_tbl SET ProcStateCol17 = @ProcStateCol27Val Where ID = @ObjectId
             if @ProcStateCol28Val <> '-' UPDATE Objects_tbl SET ProcStateCol18 = @ProcStateCol28Val Where ID = @ObjectId
             if @ProcStateCol29Val <> '-' UPDATE Objects_tbl SET ProcStateCol19 = @ProcStateCol29Val Where ID = @ObjectId
             if @ProcStateCol30Val <> '-' UPDATE Objects_tbl SET ProcStateCol20 = @ProcStateCol30Val Where ID = @ObjectId

             if @ProcStateCol31Val <> '-' UPDATE Objects_tbl SET ProcStateCol11 = @ProcStateCol31Val Where ID = @ObjectId
             if @ProcStateCol32Val <> '-' UPDATE Objects_tbl SET ProcStateCol12 = @ProcStateCol32Val Where ID = @ObjectId
             if @ProcStateCol33Val <> '-' UPDATE Objects_tbl SET ProcStateCol13 = @ProcStateCol33Val Where ID = @ObjectId
             if @ProcStateCol34Val <> '-' UPDATE Objects_tbl SET ProcStateCol14 = @ProcStateCol34Val Where ID = @ObjectId
             if @ProcStateCol35Val <> '-' UPDATE Objects_tbl SET ProcStateCol15 = @ProcStateCol35Val Where ID = @ObjectId
             if @ProcStateCol36Val <> '-' UPDATE Objects_tbl SET ProcStateCol16 = @ProcStateCol36Val Where ID = @ObjectId
             if @ProcStateCol37Val <> '-' UPDATE Objects_tbl SET ProcStateCol17 = @ProcStateCol37Val Where ID = @ObjectId
             if @ProcStateCol38Val <> '-' UPDATE Objects_tbl SET ProcStateCol18 = @ProcStateCol38Val Where ID = @ObjectId
             if @ProcStateCol39Val <> '-' UPDATE Objects_tbl SET ProcStateCol19 = @ProcStateCol39Val Where ID = @ObjectId
             if @ProcStateCol40Val <> '-' UPDATE Objects_tbl SET ProcStateCol20 = @ProcStateCol40Val Where ID = @ObjectId

             if @ProcStateColRfVal <> '-' UPDATE Objects_tbl SET ProcStateColRf = @ProcStateColRfVal Where ID = @ObjectId
             if @ProcStateColMcVal <> '-' UPDATE Objects_tbl SET ProcStateColMc = @ProcStateColMcVal Where ID = @ObjectId
             if @ProcStateColUnVal <> '-' UPDATE Objects_tbl SET ProcStateColUn = @ProcStateColUnVal Where ID = @ObjectId

     END
 -- #doc:29.04.2019 Rank is disabled set RANK to = 0
 if @DoUpdateRank <> 1 UPDATE Objects_tbl SET ObjectIrLatestRank = 0 Where ID = @ObjectId


 -- Added A.Becker 12.09.2023:
 -- Re-Evaluate the process state col values if required (requested by Objects_tbl_Object_GetId_via_ObjectPuid)
 IF @ObjectsRemapStatusRequired=1
 BEGIN
	-- Update all process state columns of the item according to the latest result
	EXEC [Objects_tbl_RemapStatus] @ObjectId
 END



 COMMIT TRANSACTION   -- *************  Commit Transaction **************
 END TRY              -- *************  End TRY **************

 BEGIN CATCH          -- *************  Begin CATCH ************
 	-- PRINT 'Rollback Transaction'
 	ROLLBACK TRANSACTION
 	DECLARE @DoRetry bit; -- Whether to Retry transaction or not
 	DECLARE @ErrorMessage varchar(500)
 	SET @DoRetry = 0;
 	SET @ErrorMessage = ERROR_MESSAGE()
 	IF ERROR_NUMBER() = 1205 -- Deadlock Error Number
 	BEGIN
 		SET @DoRetry = 1; -- Set @doRetry to 1 only for Deadlock
 	END
 	IF @DoRetry = 1
 	BEGIN
 		SET @RetryCounter = @RetryCounter + 1 -- Increment Retry Counter By one
 		IF (@RetryCounter > 3) -- Check whether Retry Counter reached to 3
 		BEGIN
 			RAISERROR(@ErrorMessage, 18, 1) -- Raise Error Message if still deadlock occurred after three retries
 		END
 		ELSE
 		BEGIN
    WAITFOR DELAY '00:00:00.10' -- 02.08.2010 19:35 Wait=01 sec 23.07.2010 01:30 Wait=01 sec --- Wait for 10 ms
 			GOTO RETRY	-- Go to Label RETRY
 		END
 	END
 	ELSE
 	BEGIN
 		RAISERROR(@ErrorMessage, 18, 1)
 	END
 END CATCH    -- *************  End CATCH ************

END
GO

ende:

-- EXECUTE zzzzzDebugTbl_Empty
Print ''
Print '-------------------------------------------------------------------------'
Print ' Procedures imported to #DB_N#'
Print '-------------------------------------------------------------------------'
GO

