Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Procedures    : [JobMgr_30_ApplProceduresDrawingIndexingSearch]'
Print ' Autor         : S.Gueth'
Print ' Creation Date : 22.1.20018'
Print '-------------------------------------------------------------------------'
GO

use [#DB_N#]
GO


Print '-- [DrawingIndexingSearch_tbl_DeleteEntriesOfObject] ----------------------------'
If Exists (select Name
           from sysobjects
           where Name = "DrawingIndexingSearch_tbl_DeleteEntriesOfObject" and type = "P")
Drop Procedure DrawingIndexingSearch_tbl_DeleteEntriesOfObject
GO

CREATE PROCEDURE DrawingIndexingSearch_tbl_DeleteEntriesOfObject
                 @objectId uniqueidentifier
AS
BEGIN

  DELETE FROM DrawingIndexingSearch_tbl WHERE ObjIdRef=@objectId
  DELETE FROM DrawingIndexingSearchFullText_tbl WHERE ObjIdRef=@objectId

END
GO



Print '-- [DISFullTextQuerySearch] ----------------------------'
If Exists (select Name
           from sysobjects
           where Name = "DISFullTextQuerySearch" and type = "P")
Drop Procedure DISFullTextQuerySearch
GO

CREATE PROCEDURE [dbo].[DISFullTextQuerySearch]
	               @query NVARCHAR(2000)
AS
BEGIN

    DECLARE @refs TABLE (id uniqueidentifier, sheetNumber nvarchar(128))
    
    INSERT INTO @refs
      select ObjIdRef, inSheet from DrawingIndexingSearchFullText_tbl
      where CONTAINS(AllValues, @query)
    
    select *
      from dbo.DrawingIndexingSearch_tbl T
      where EXISTS (SELECT 1 FROM @refs WHERE ObjIdRef = T.ObjIdRef AND inSheet = T.inSheet)


END
GO

ende:

Print ''
Print '-------------------------------------------------------------------------'
Print ' Procedures imported to #DB_N#'
Print '-------------------------------------------------------------------------'
-- EXECUTE zzzzzDebugTbl_Empty
GO

