@echo off

rem Startscript fr: JobManagerV3
rem Funktion: startet die Programme des Jobmanagers
rem #New.: 31.05.2007 J.Fes (c) J.Feuerstein 2007..2016
rem #LUp.: 19.01.2016 J.Fes Update V2 to V3
rem #LUp.: 15.08.2018 S.Gueth added JobMgr_StartAsService variabe (when JobClient or JobServer should be started as a service)
rem                   Example:
rem                   set JobMgr_StartAsService=ON
rem                   call \\addPLM\JobManager\ProgEntw\Ver03\JobManagerV3\02-BinClient\JobManagerStart.cmd /Client /ServerSettingsXML TestSystem /JobClientStartMode Automatic
rem #LUp.: 20.02.2019 renamed ENV StartAsService to JobMgr_StartAsService=ON
rem #LUp: 27.02.2019 J.Fes
rem #LUp.: 05.03.2019 S.Gueth check var StartAsService for compatiblity
rem #LUp.: 25.04.2019 J.Fes repair ApplicationInfo
REM #LUp: 25.06.2019/J.Fes repair ApplicationInfo
rem #LUp.: 17.02.2021 S.Gueth added JobClient_StartMinimized -> starts the jobclient in an minimized window
rem                   Example:
rem                   set JobClient_StartMinimized=ON
rem #LUp.: 10.03.2023 J.Fes Make sure that all parameters are send JobServer
rem #LUp.: 15.03.2023 J.Fes refactoring handle Pathes
rem #LUp.: 16.03.2023 J.Fes add :SkipInitalisation
rem #LUp.: 21.03.2023 J.Fes add :Bring start window to front is Issues happend during startup Using nircmd.exe
rem #LUp.: 23.03.2023 J.Fes add :JobClient can now be started paralell see JobClient_is_NtimesActive
rem ----------------------------------------------------------------------------

 set JobMgrStartP1=%~1
 rem -- #Doc:17.03.2023/J.Fes workaround to support all existing ..\03-BinPublic.Custom\JobManagerAutostartCustom.cmd
 if /I "%JobMgrStartP1%" equ "/Server" set JobMgrStartP1=/JobServer
 if /I "%JobMgrStartP1%" equ "/Client" set JobMgrStartP1=/JobClient

 rem -- Application BasePath --------------
 set JobMgrBase_TP=JobManagerV3
 set PLMPerfBase_TP=PLMPerfV3

 set robocopy_opt=/R:5 /W:1
 set JobMgr_StartScr_DP=%~dp0
 set JobMgr_StartScr_DP=%JobMgr_StartScr_DP:~0,-1%


 rem -- #New: 17.03.2023/J.Fes if JobMgr_Root_DP and JobMgr_RootL_DP and JobMgr_01-BinServer_DP is set then we goto :SkipInitalisation
 if defined JobMgr_Root_DP if defined JobMgr_RootL_DP if defined JobMgr_01-BinServer_DP goto :SkipInitalisation

 rem -- #New: 29.12.2014 ?? 24.03.2023/J.Fes yes required because some Clints having the Issue that %temp% not exist
 if not exist "%temp%" md "%temp%"

 rem -- save orig Path
 set path_org=%path%

 rem -- #Doc: 15.03.2023/J.Fes get JobMgr_Root_DP until ..\JobManagerV3 in Path is found
 if defined JobMgr_Root_DP if exist "%JobMgr_Root_DP%" goto :JobMgr_Root_found
 set JobMgr_Root_DP=%~dp0
 set JobMgr_Root_DP=%JobMgr_Root_DP:~0,-1%
 call :Parse_PLast "%JobMgr_Root_DP%" JobMgr_Root_PLast JobMgr_Root_PLast

 rem -- #Doc:15.03.2023/J.Fes special rule when ..\04-CMD\JobManagerStart.cmd is used
 if /I "%JobMgr_Root_PLast%" neq "04-CMD" goto :JobMgr_Root_findNext
 call :Parse_PathCutLastDir "%JobMgr_Root_DP%" JobMgr_Root_DP
 set JobMgr_Root_DP=%JobMgr_Root_DP%\%JobMgrBase_TP%
REM  set JobMgrStartP1=/JobServer
REM  set JobMgrStartP1=/JobMgrCmdTools_CBSettingsMgr
REM  set JobMgrStartP1=/JobPlaner
REM  set JobMgrStartP1=/JobClient
 goto :JobMgr_Root_findNext

:JobMgr_Root_findNext
 rem --#Doc: 15.03.2023/J.Fes find JobMgr_Root_DP dir by interation
 call :Parse_PLast "%JobMgr_Root_DP%" JobMgr_Root_PLast JobMgr_Root_PLast
 if "%JobMgr_Root_PLast%" equ "" (
                                   Call :JobMgrERR_Root_DP_BaseNotFound
                                   Exit /B 3
                                  )

 if "%JobMgr_Root_PLast:~0,12%" equ "%JobMgrBase_TP%" goto :JobMgr_Root_found
 if "%JobMgr_Root_PLast:~0,9%" equ "%PLMPerfBase_TP%" goto :JobMgr_Root_found
 call :Parse_PathCutLastDir "%JobMgr_Root_DP%" JobMgr_Root_DP

 goto :JobMgr_Root_findNext
:JobMgr_Root_found


 REM --- #Doc: get ApplicationInfo -------------------
 set JobMgr_VerFull=UNK
 set JobMgr_VerDateTime=UNK
 set JobMgr_AppInfoFrom=UNK
 if exist "%~dp0ApplicationInfo.cmd" call "%~dp0ApplicationInfo.cmd" GetVerInfo &set JobMgr_AppInfoFrom=%~dp0&goto :Next
 if exist "%JobMgr_Root_DP%\01-BinServer\ApplicationInfo.cmd" call "%JobMgr_Root_DP%\01-BinServer\ApplicationInfo.cmd" GetVerInfo &set JobMgr_AppInfoFrom=%JobMgr_Root_DP%\01-BinServer&goto :Next

:Next
 Title "Start:%JobMgrBase_TP%:[%JobMgr_VerFull%][%JobMgr_VerDateTime%] from:[%JobMgr_AppInfoFrom%]"

 rem -- #New: 24.03.2021/J.Fes copy Application Icons from:JobMgr_ResIcons_S_DP to:JobMgr_ResIcons_L_DP
 if exist "%JobMgr_Root_DP%\99-Install\Application-Startmenu-IconsOrg.cmd" Call "%JobMgr_Root_DP%\99-Install\Application-Startmenu-IconsOrg.cmd"

 rem new 11.10.2012 Verzeichniss: %JobMgr_RootL_DP% verwenden wenn dieses als Umgebunsvariable bereits definiert ist
 rem setx JobMgr_RootL_DP C:\Programs\JobMgrL /M

 if not defined JobMgr_RootL_DP   goto :JobMgr_RootL_DP_usedefault
 if     exist "%JobMgr_RootL_DP%" goto :Next
 if not exist "%JobMgr_RootL_DP%" md "%JobMgr_RootL_DP%"
 if     exist "%JobMgr_RootL_DP%" goto :Next

:JobMgr_RootL_DP_usedefault
 rem -- #Doc: define JobMgr_RootL_DP
 rem -- #LUp: 08.06.2020/J.Fes check first if
 if exist "%JobMgr_Root_DP%\03-BinPublic.Custom\JobManagerStartCustom.cmd" call "%JobMgr_Root_DP%\03-BinPublic.Custom\JobManagerStartCustom.cmd" %*

 rem angepasst 16.07.2009
 rem -- #LUp: 16.03.2023/J.Fes
 if defined JobMgr_RootL_DP goto :Next
 rem if defined JobMgr_RootL_DP if exist "%JobMgr_RootL_DP%" goto :next
 set JobMgr_RootL_DP=%SystemDrive%\tmp
 REM  set JobMgr_RootL_DP=%SystemDrive%\temp
 if exist "%JobMgr_RootL_DP%" md "%JobMgr_RootL_DP%\JM$$TEMP$$TESTDIR">nul
 if exist "%JobMgr_RootL_DP%\JM$$TEMP$$TESTDIR" rd /S /Q "%JobMgr_RootL_DP%\JM$$TEMP$$TESTDIR">nul& goto :Next
 if "%errorlevel%" equ "0" if not exist "%JobMgr_RootL_DP%\JM$$TEMP$$TESTDIR" goto :Next
 if exist "%SystemDrive%\temp" set JobMgr_RootL_DP=%SystemDrive%\temp
 rem 24.09.2011 wenn kein anderes Verzeichniss verfuegbar dann User Temp verwenden
 if not exist "%JobMgr_RootL_DP%" set JobMgr_RootL_DP=%temp%
goto :Next


:Next

 set temp_user=%temp%

 rem --- 03-BinPublic ------------------
 set JobMgr_03-BinPublic_DP=%JobMgr_Root_DP%\03-BinPublic
 set JobMgr_03-BinPublicCustom_DP=%JobMgr_03-BinPublic_DP%.Custom
 rem -- #Doc:24.03.2023/J.Fes BinPublic_DP is needed for compatibility reasons
 REM -- #Doc:08.05.2025/J.Fes BinPublic_DP defaults are defined in Application-Startmenu-IconsOrg.cmd
 if not defined BinPublic_DP set BinPublic_DP=%JobMgr_03-BinPublic_DP%
 set BinPublicCustom_DP=%JobMgr_03-BinPublicCustom_DP%

 rem -- #New: 23.03.2023 Check how many times JobClient is active
 REM -- #LUp: 03.07.2024 deactivated because it is now implemented in JobClient that only 1 Inscane is allowd to start
REM  if /i "%JobMgrStartP1%" neq "/JobClient" goto :Next
REM  call "%JobMgr_StartScr_DP%\ProgIsRunningNtimes.cmd" "JobClient.exe" JobClient_is_NtimesActive
REM  if not "%JobClient_is_NtimesActive%" gtr "0" goto :Next
REM  set /a JobClient_is_NtimesActive=%JobClient_is_NtimesActive% + 1
REM  set JobMgr_RootL_DP=%JobMgr_RootL_DP%%JobClient_is_NtimesActive%

:Next

 rem 23.05.2018 J.Fes add for development
 if /i "%~1" equ "/JobMgr_RootL_DP_get" goto :eof

 set temp=%JobMgr_RootL_DP%
 set tmp=%JobMgr_RootL_DP%

 set JobMgr_AppL_DP=%JobMgr_RootL_DP%\%JobMgrBase_TP%
 if /i "%JobMgrStartP1%" equ "/PLMPerf" set JobMgr_AppL_DP=%JobMgr_RootL_DP%\%PLMPerfBase_TP%

 rem --- 01-BinServer ------------------
 set JobMgr_01-BinServer_TP=01-BinServer
 set JobMgr_01-BinServer_DP=%JobMgr_Root_DP%\%JobMgr_01-BinServer_TP%
 set JobMgr_01-BinServerL_DP=%JobMgr_AppL_DP%\%JobMgr_01-BinServer_TP%%JobMgr_VerNumLdir%
 set JobMgr_ServerSetting_DP=%JobMgr_01-BinServer_DP%.Custom

 rem --- 02-BinClient ------------------
 set JobMgr_02-BinClient_TP=02-BinClient
 set JobMgr_02-BinClient_DP=%JobMgr_Root_DP%\%JobMgr_02-BinClient_TP%
 set JobMgr_02-BinClientL_DP=%JobMgr_AppL_DP%\%JobMgr_02-BinClient_TP%%JobMgr_VerNumLdir%
 set JobMgr_ClientSetting_DP=%JobMgr_02-BinClient_DP%.Custom

 rem --- 03-BinPublic.ClientServer -----
 set JobMgr_03-BinPublicClientServer_TP=03-BinPublic.ClientServer
 set JobMgr_03-BinPublicClientServer_DP=%JobMgr_Root_DP%\%JobMgr_03-BinPublicClientServer_TP%
 set JobMgr_03-BinPublicClientServerL_DP=%JobMgr_AppL_DP%\%JobMgr_03-BinPublicClientServer_TP%%JobMgr_VerNumLdir%

 rem --- 92-Update ---------------------
 set JobMgr_92-Update_TP=92-Update
 set JobMgr_92-Update_DP=%JobMgr_Root_DP%\%JobMgr_92-Update_TP%
 set JobMgr_92-UpdateL_DP=%JobMgr_AppL_DP%\%JobMgr_92-Update_TP%\%JobMgr_92-Update_DP_PLast%%JobMgr_VerNumLdir%


 rem --- 99-Install ---------------------
 set JobMgr_99-Install_TP=99-Install
 set JobMgr_99-Install_DP=%JobMgr_Root_DP%\%JobMgr_99-Install_TP%
 set JobMgr_99-InstallL_DP=%JobMgr_AppL_DP%\%JobMgr_92-Update_TP%\%JobMgr_99-Install_TP%

 rem --- PLMPerf ---------------------
 set PLMPerf_01-PLMPerfS_DP=%JobMgr_Root_DP%\01-PLMPerf
 rem -- #New:16.08.2023/J.Fes
 set PLMPerf_Root_DP=%JobMgr_Root_DP%
REM  Echo #Debug LI:184 %PLMPerf_Root_DP%&Pause

REM  if /I "%JobMgr_Root_PLast%" neq "%JobMgrBase_TP%" goto :Next
REM  rem #Doc:15.03.2023/J.Fes add for Testing
REM REM  call :Parse_PathCutLastDir "%JobMgr_Root_DP%" PLMPerf_01-PLMPerfS_DP
REM REM  set PLMPerf_01-PLMPerfS_DP=%PLMPerf_01-PLMPerfS_DP%\%PLMPerfBase_TP%
REM  goto :Next2
REM :Next
REM  set PLMPerf_01-PLMPerfS_DP=%JobMgr_RootL_DP%\%PLMPerfBase_TP%
REM :Next2

 rem Locale Dirs festlegen
 set PLMPerf_01-PLMPerfL_DP=%JobMgr_AppL_DP%\01-PLMPerf
 set path=%JobMgr_03-BinPublicCustom_DP%;%JobMgr_03-BinPublic_DP%;%Path%

 rem -- #Doc: JumbPoint when Initialisation is done before
:SkipInitalisation

 rem -- #New: 10.03.2023/J.Fes
 set JobMgrStartP2toPn=
 rem #New 10.03.2023/J.Fes enshur get all parameters start from %2 ... %n
:GetParaNext
 shift
  if "%~1" equ "" goto :GetParaDone
  set JobMgrStartP2toPn=%JobMgrStartP2toPn% %1
  goto :GetParaNext
:GetParaDone


REM  set JobMgr_Root_DP=#DebugNotExist
 if not exist "%JobMgr_Root_DP%" (
  rem Issue happend because JobMgr_Root_DP is not found!!
  Call :JobMgrERR_JobMgr_Root_DP_NotExist
  exit /B 2
 )

:Next

 call :ColorSet "OK"
 set JobMgr_StartScr_DP=

 rem -- #Doc: Now start applications
 if /i "%JobMgrStartP1%" equ "/JobServer"                    call :JobServer
 if /i "%JobMgrStartP1%" equ "/JobClient"                    call :JobClient
 if /i "%JobMgrStartP1%" equ "/JobPlaner"                    call :JobPlaner
 if /i "%JobMgrStartP1%" equ "/JobMgrCmdTools_CBSettingsMgr" call :JobMgrCmdTools_CBSettingsMgr
 if /i "%JobMgrStartP1%" equ "/JobMgrCmdTools_DQSettingsMgr" call :JobMgrCmdTools_DQSettingsMgr
 if /i "%JobMgrStartP1%" equ "/JobMgr_Updater"               call :JobMgr_Updater
 if /i "%JobMgrStartP1%" equ "/PLMPerf"                      call :PLMPerf
 if /i "%JobMgrStartP1%" equ "/Screenshot"                   call :Screenshot
 if /i "%JobMgrStartP1%" equ "/JobMgrLocalRoot_Open"         call :JobMgrLocalRoot_Open
 if /i "%JobMgrStartP1%" equ ""                              (
                                                               call :JobMgrERR_Params
                                                               exit /B 1
                                                              )


:MyEnd
goto :eof


:JobMgrLocalRoot_Open
 set toRun=start "" explorer.exe /e, "%JobMgr_RootL_DP%"
 %toRun%
 goto :eof

rem ============================================================================
:JobServer
 rem ------------------------------------------------------------------------
 rem Funktion:
 rem  Starte den JobServer
 rem
 rem  Kopiert die Programme mit allen erf. Komponenten auf den den localen Rechner (JobServer.Exe).
 rem  Anschliessend wird diese lokal kopierter Stand gestartet.
 rem  Die einstellungen ServerSettingsXML_DPNE werden vom Server verwendet
 rem  Hinweis: die Parameter P2..Pn werden an das Programm bergeben
 rem           die Umgebunsvariabale JobMgr_ServerSetting_DP wird fr die bestimmung des pfades fr den Ablageort der Serversettings festgelegt

 rem das locale JobServer_PRG
 set JobServer_EXE_DPNE=%JobMgr_01-BinServerL_DP%\JobServer.exe


:StartProg

  rem -- #Doc: umgestell auf Versions Verzeichnisse am 22.05.2012 J.Fes
  rem -- #LUp: remove /mir not required
  set toRun=robocopy "%JobMgr_01-BinServer_DP%" "%JobMgr_01-BinServerL_DP%" /mir /r:3 /w:1 /XD _svn .svn Resources Archiv
  set toRun=robocopy "%JobMgr_01-BinServer_DP%" "%JobMgr_01-BinServerL_DP%" /r:3 /w:1 /XD _svn .svn Resources Archiv
  Echo Update Local "%JobMgr_01-BinServerL_DP%"
  call %toRun%

  set toRun=robocopy "%JobMgr_01-BinServer_DP%\Progs" "%JobMgr_01-BinServerL_DP%\Progs" /mir /r:3 /w:1 /XD _svn .svn Resources Archiv
  Echo Update Local "%JobMgr_01-BinServerL_DP%\Progs"
  call %toRun%

  rem #LUp 15.03.2023 use now Robocopy
  set toRun=robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobMgr_03-BinPublicClientServer_DP%\JobManagerCmdTools_Resources"  "%JobMgr_01-BinServerL_DP%" "JobManager.CmdToolsLib*.*"
  call %toRun%
  rem path setzen
  set path=%JobMgr_01-BinServerL_DP%;%JobMgr_03-BinPublic_DP%;%path_org%
  cd /D "%JobMgr_01-BinServerL_DP%"

  rem old version set toRun="%JobServer_EXE_DPNE%" %2 %3 %4 %5 %6 %7 %8 %9
  set toRun="%JobServer_EXE_DPNE%" %JobMgrStartP2toPn%

  rem 20.02.2019/J.Fes add for compatiblity
  if defined StartAsService set JobMgr_StartAsService=%StartAsService%
  if defined JobMgr_StartAsService (
     call %toRun%
  ) else (
     start "%JobMgrBase_TP%" /D%JobMgr_01-BinServerL_DP% %toRun%
  )
  set path=%Path_org%

goto :eof

rem ============================================================================
:JobClient
 rem Funktion: Starte den JobClient
 rem -- #New: 06.07.2010 A.Becker J.Feuerstein

 rem das locale JobClient_PRG
 set JobClient_EXE_DPNE=%JobMgr_02-BinClientL_DP%\JobClient.exe

:StartProg
 cd /D %JobMgr_AppL_DP%
 set toRun=robocopy "%JobMgr_02-BinClient_DP%" "%JobMgr_02-BinClientL_DP%" /mir /r:3 /w:1 /XD _svn .svn Resources Archiv
 Call %toRun%
 rem /ServerSettingsXML "%ClientSettingsXML_DPNE%"
 rem #LUp:10.03.2023/J.Fes use %JobMgrStartP2toPn%
 rem set toRun="%JobClient_EXE_DPNE%" %2 %3 %4 %5 %6 %7 %8 %9
 set toRun="%JobClient_EXE_DPNE%" %JobMgrStartP2toPn%

 rem 29.03.2017/J.Fes %JobMgr_02-BinClientL_DP% removed from path
 set path=%JobMgr_03-BinPublic_DP%;%path_org%
 cd /D "%JobMgr_02-BinClientL_DP%"
 rem 17.02.2021 S.Gueth added startMinimized to start JobClient with minimized window if needed
 set startMinimized=
 if defined JobClient_StartMinimized set startMinimized=/min
 rem 28.09.2012 J.Fes /I eingefuegt um zu erreichen das nur das default Environment beim Start vom JobClient gesetzt ist
 rem 08.10.2012 J.Fes /I wieder entnommen da es zu Fehlern bei den Prompts kommen kann wenn C:\Dokumente und Einstellungen\UserName\..
 rem 05.03.2019/S.Gueth add for compatiblity
 if defined StartAsService set JobMgr_StartAsService=%StartAsService%
 if defined JobMgr_StartAsService (
     call %toRun%
  ) else (
     start "JC V%JobMgr_VerFull%" %startMinimized% /D%JobMgr_02-BinClientL_DP% %toRun%
 )
 set path=%Path_org%
 goto :eof

rem ============================================================================
:JobPlaner
 rem Funktion:
 rem  Starte das Server Programm
 rem
 rem  Kopiert die Programme mit allen erf. Komponenten auf den den localen Rechner (JobServer.Exe).
 rem  Anschliessend wird diese lokal kopierter Stand gestartet.
 rem  Die einstellungen ServerSettingsXML_DPNE werden vom Server verwendet
 rem  Hinweis: die Parameter P2..Pn werden an das Programm bergeben
 rem           die Umgebungsvariabale JobMgr_ServerSetting_DP wird fr die bestimmung des pfades fr den Ablageort der Serversettings festgelegt

 rem das locale JobServer_PRG
 set JobPlaner_EXE_DPNE=%JobMgr_01-BinServerL_DP%\JobManager.OnDemand.exe

 rem kopiert das Programm auf den localen Rechner
 rem dies ist erforderliche da .NET.exe Programme nur mit besonderen einstellungen
 rem vom Netz aus gestartet werden drfen
 if not exist "%JobPlaner_EXE_DPNE%" goto :StartProg

 :StartProg
  set toRun=robocopy "%JobMgr_01-BinServer_DP%" "%JobMgr_01-BinServerL_DP%" /mir /r:0 /w:0 /XD _svn .svn Resources
  %toRun%
  rem #LUp:10.03.2023/J.Fes use %JobMgrStartP2toPn%
  set toRun="%JobPlaner_EXE_DPNE%" %JobPlanerCmdOptions% %JobMgrStartP2toPn%
  rem path setzen
  set path=%JobMgr_01-BinServerL_DP%;%JobMgr_03-BinPublic_DP%;%path_org%
  cd /D "%JobMgr_01-BinServerL_DP%"
  start "%JobMgrBase_TP%" /D%JobMgr_01-BinServerL_DP% %toRun%
  set path=%Path_org%
goto :eof
rem ============================================================================
:JobMgrCmdTools_CBSettingsMgr
 rem Funktion: Starte den CB.Manager
 rem #New:22.03.2013 J.Feuerstein / S.Gueth

 rem locale CBSettingsMgr
 set JobMgrCmdTools_CBSettingsMgrS_DP=%JobMgr_03-BinPublicClientServer_DP%\JobManagerCmdTools_SettingsManager
 set JobMgrCmdTools_CBSettingsMgrL_DP=%JobMgr_03-BinPublicClientServerL_DP%\JobManagerCmdTools_SettingsManager
 set JobMgrCmdTools_CBSettingsMgr_EXE_DPNE=%JobMgrCmdTools_CBSettingsMgrL_DP%\JobMgrCmdTools_CBSettingsMgr.exe

:StartProg
 rem set toRun=robocopy "%JobMgr_03-BinPublicClientServer_DP%" "%JobMgr_03-BinPublicClientServerL_DP%" /mir /r:3 /w:1 /XD _svn .svn Resources Archiv
 set toRun=robocopy "%JobMgrCmdTools_CBSettingsMgrS_DP%" "%JobMgrCmdTools_CBSettingsMgrL_DP%" /mir /r:3 /w:1 /XD _svn .svn Resources Archiv
 Call %toRun%

 rem #LUp:10.03.2023/J.Fes use %JobMgrStartP2toPn%
 set toRun=start "CB.Mgr V%JobMgr_VerFull%" /D"%JobMgr_03-BinPublicClientServerL_DP%" "%JobMgrCmdTools_CBSettingsMgr_EXE_DPNE%" -JobMgr_Root_DP "%JobMgr_Root_DP%" %JobMgrStartP2toPn%

 set path=%JobMgr_03-BinPublicClientServerL_DP%;%JobMgr_03-BinPublic_DP%;%path_org%
 cd /D "%JobMgr_03-BinPublicClientServerL_DP%"
 %toRun%
 set path=%Path_org%
 goto :eof

rem ============================================================================
:JobMgrCmdTools_DQSettingsMgr
 rem Funktion: Starte den DataQuality Settings manager

 rem das locale JobClient_PRG
 rem --- 03-BinPublic.ClientServer ---------------------------------------------
 set JobMgrCmdTools_CBSettingsMgr_EXE_DPNE=%JobMgr_03-BinPublicClientServerL_DP%\JobManagerCmdTools_DataQuality\JobMgrCmdTools_DQSettingsMgr.exe

:StartProg
 set toRun=robocopy "%JobMgr_03-BinPublicClientServer_DP%\JobManagerCmdTools_DataQuality" "%JobMgr_03-BinPublicClientServerL_DP%\JobManagerCmdTools_DataQuality" /mir /r:3 /w:1 /XD _svn .svn Resources Archiv
 Call %toRun%
 rem #LUp:10.03.2023/J.Fes use %JobMgrStartP2toPn%
 set toRun="%JobMgrCmdTools_CBSettingsMgr_EXE_DPNE%" -JobMgr_Root_DP "%JobMgr_Root_DP%" %JobMgrStartP2toPn%
 set path=%JobMgr_03-BinPublicClientServerL_DP%;%JobMgr_03-BinPublic_DP%;%path_org%
 cd /D "%JobMgr_03-BinPublicClientServerL_DP%"
 start "JobMgrCmdTools_DQSettingsMgr V%JobMgr_VerFull%" /D%JobMgr_03-BinPublicClientServerL_DP% %toRun%
 set path=%Path_org%
 goto :eof

rem ============================================================================
:JobMgr_Updater
 rem Funktion: Starte JobManagerUpdate.exe

 rem das locale JobClient_PRG
 rem --- 92-Update ------------------------------------------------------------
 set JobManagerUpdateL_DPNE=%JobMgr_92-UpdateL_DP%\JobManagerUpdate.exe

:StartProg
 REM -- #LUp: 20.04.2021/J.Fes only level 1 to be copy local
 set toRun=robocopy "%JobMgr_92-Update_DP%" "%JobMgr_92-UpdateL_DP%" /LEV:1 /mir /r:3 /w:1 /XF JobManagerStart.cmd JobManagerUpdate-Settings.xml *.ZIP *.zip *.bak
 Call %toRun%

 set toRun="%JobManagerUpdateL_DPNE%"
 set path=%JobMgr_92-UpdateL_DP%;%JobMgr_92-Update_DP%;%path_org%
 cd /D "%JobMgr_92-UpdateL_DP%"
 start "JobManagerUpdate V%JobMgr_VerFull%" /D%JobMgr_92-UpdateL_DP% %toRun%
 set path=%Path_org%
 goto :eof


rem ============================================================================
:PLMPerf
 rem ------------------------------------------------------------------------
 rem Funktion:
 rem  Starte das PLMPerformance Analyse Program
 rem  erstellt 26.11.2012 14:10 S.Gueth J.Feuerstein
 rem @echo on
 rem das locale PDMPerf_PRG
 set PLMPerformanceAnalyse_exe_DPNE=%PLMPerf_01-PLMPerfL_DP%\PLMPerformanceAnalyse.exe
REM  Echo #Debug '%0' LI:432 PLMPerformanceAnalyse_exe_DPNE:'%PLMPerformanceAnalyse_exe_DPNE%'
REM  Echo #Debug '%0' LI:433 PLMPerf_01-PLMPerfS_DP:'%PLMPerf_01-PLMPerfS_DP%'
REM  Echo #Debug '%0' LI:434 PLMPerf_01-PLMPerfL_DP:'%PLMPerf_01-PLMPerfL_DP%'
REM  Pause
REM  Exit /B 5
 rem die PDMPerf Settings immer vom Server
REM  if not exist "%PLMPerf_Setting_DP%" md "%PLMPerf_Setting_DP%"
REM  set SettingsGlobal_DPNE=%PLMPerf_Setting_DP%\PDMPerf_SettingsGlobal.xml
REM  if not exist "%SettingsGlobal_DPNE%" copy "%PLMPerf_01-PLMPerfS_DP%\SettingsGlobal.xml" "%SettingsGlobal_DPNE%"

:StartProg
 rem 27.07.2023/Sasch+Jopp add /mir switch
 set toRun=robocopy "%PLMPerf_01-PLMPerfS_DP%" "%PLMPerf_01-PLMPerfL_DP%" /mir /XD _svn .svn Resources Archiv /r:3 /w:1
REM  Echo #Debug LI:447 %~nx0&Pause
REM  Echo Call %toRun%
REM  Pause
 Call %toRun%
REM  pause

 rem #LUp:10.03.2023/J.Fes use %JobMgrStartP2toPn%
 set toRun="%PLMPerformanceAnalyse_exe_DPNE%" %JobMgrStartP2toPn%

 set path=%PLMPerf_01-PLMPerfL_DP%;%JobMgr_03-BinPublic_DP%;%path_org%
 cd /D "%PLMPerf_01-PLMPerfL_DP%"

 Echo start "PLMPerf V%JobMgr_VerFull%" /D%PLMPerf_01-PLMPerfL_DP% %toRun%
 rem 05.03.2019/S.Gueth add for compatiblity
 if defined StartAsService set JobMgr_StartAsService=%StartAsService%
 if defined JobMgr_StartAsService (
    call %toRun%
  ) else (
    start "PLMPerf V%JobMgr_VerFull%" /D%PLMPerf_01-PLMPerfL_DP% %toRun%
  )
 
 set path=%Path_org%
 goto :eof

rem ============================================================================
:Screenshot
 rem ------------------------------------------------------------------------
 rem Funktion:
 rem  Starte das Screenshot Program
 rem  erstellt 05.09.2013 10:35 J.Feuerstein
 setlocal

   rem #Doc: Settings are defined in  %ScreenShotS_DP%\Greenshot.ini
   rem 05.09.2013 GreenShot Start Params
   REM /help   This help.
   REM /exit   Tries to close all running instances.
   REM /reload Reload the configuration of Greenshot.
   REM /language [language code] Set the language of Greenshot, e.g. greenshot /language en-US. de-DE
   REM [filename] Open the bitmap files in the running Greenshot instance or start a new instance
   @echo off

   rem aktive Sparache herausfinden
   set language_use=de-DE
   FOR /F "tokens=3 delims= " %%G in ('reg query "hklm\system\controlset001\control\nls\language" /v Installlanguage') DO (IF "%%G" NEQ "0407" set language_use=en-US)

   set ScreenShotS_DP=%JobMgr_03-BinPublic_DP%\Greenshot
   set ScreenShotData_DP=%JobMgr_Root_DP%\11-Documentation.Custom\zzScreenShots
   if not exist "%ScreenShotData_DP%" Echo I: Create ScreenShotData_DP:"%ScreenShotData_DP%"& md "%ScreenShotData_DP%"

   rem Locale Dirs festlegen
   set ScreenshotL_DP=%JobMgr_AppL_DP%\03-BinPublic\Greenshot
   set ScreenshotL_DPNE=%JobMgr_AppL_DP%\03-BinPublic\Greenshot\Greenshot.exe

   set toRun=robocopy "%ScreenShotS_DP%" "%ScreenshotL_DP%" /mir /r:3 /w:1 /XD _svn .svn Resources Archiv /xf unins000*.*
   Call %toRun%
   start "" /D%ScreenShotData_DP% %ScreenshotL_DPNE% /language %language_use%

 endlocal
 goto :eof

rem ##### ------------ ERROR Subroutines --------------------- ######
rem -------------------------------------------------------------------------------------------
:JobMgrERR_Params
 call :JobMgrERR_GetMeVisible "!!- %JobMgrBase_TP% StartUp:ISSUE-1 Missing or wrong Parameter (%Date% %time%) -!!"
 echo --------------------------------------------------------------------------
 Echo Error in start script for starting PLMJobManager programms
 Echo.
 Echo Start Parameters:
 Echo P1=%1 P2=%2 P3=%3 P4=%4 P5=%5 P6=%6 P7=%7 P8=%8 P9=%9
 Echo.
 Echo Error: missing valid parameter:!!
 Echo.
 Echo the first paramters must be one of the listed values:
 Echo  /JobServer                    Starts %JobMgrBase_TP% JobServer
 Echo  /JobClinet                    Starts %JobMgrBase_TP% JobClient
 Echo  /JobPlaner                    Starts %JobMgrBase_TP% JobPlaner
 Echo  /JobMgrCmdTools_CBSettingsMgr Starts %JobMgrBase_TP% CheckBox Manager
 Echo  /JobMgrCmdTools_DQSettingsMgr Starts %JobMgrBase_TP% Data Quality Manager
 Echo  /JobMgr_Updater               Starts %JobMgrBase_TP% JobMgr Update Utility
 Echo  /PLMPerf                      Starts %JobMgrBase_TP% PLMPerf Application
 Echo  /Screenshot                   Starts Screeshot Application
 Echo  /JobMgrLocalRoot_Open         Open the locad JobMgr_RootL_DP dir
 Echo.
 Echo Please Check ISSUE
 Pause
goto :eof

 rem -------------------------------------------------------------------------------------------
:JobMgrERR_JobMgr_Root_DP_NotExist

 call :JobMgrERR_GetMeVisible "!!- %JobMgrBase_TP% StartUp:ISSUE-2 Missing: 'JobMgr_Root_DP' (%Date% %time%) -!!"
 echo --------------------------------------------------------------------------
 Echo Error in start script for starting PLMJobManager programms
 Echo Script: %~0
 Echo.
 Echo Start Parameters:
 Echo P1=%1 P2=%2 P3=%3 P4=%4 P5=%5 P6=%6 P7=%7 P8=%8 P9=%9
 Echo.
 Echo Error.: Cannot find required directory JobMgr_Root_DP
 Echo #Debug: EnvVar: JobMgr_Root_DP='%JobMgr_Root_DP%'
 Echo.
 Echo Please Check ISSUE
 Pause
goto :eof

 rem -------------------------------------------------------------------------------------------
:JobMgrERR_Root_DP_BaseNotFound

 call :JobMgrERR_GetMeVisible "!!- %JobMgrBase_TP% StartUp:ISSUE-3 Cannot Identify Application Base Root: (%Date% %time%) -!!"

 set JobMgrBase_TP=JobManagerV3
 set PLMPerfBase_TP=PLMPerfV3

 set robocopy_opt=/R:5 /W:1
 set JobMgr_StartScr_DP=%~dp0
 set JobMgr_StartScr_DP=%JobMgr_StartScr_DP:~0,-1%

 echo --------------------------------------------------------------------------
 Echo Error in start script for starting PLMJobManager programms
 Echo Script: %~0
 Echo.
 Echo Start Parameters:
 Echo P1=%1 P2=%2 P3=%3 P4=%4 P5=%5 P6=%6 P7=%7 P8=%8 P9=%9
 Echo.
 Echo Error.: Cannot find one required subdir
 Echo #Debug: JobMgrBase_TP..: %JobMgrBase_TP%
 Echo #Debug: PLMPerfBase_TP.: %PLMPerfBase_TP%
 Echo #Debug: in Path........: %JobMgr_StartScr_DP%
 Echo.
 Echo Please Check ISSUE
 Pause
goto :eof


:JobMgrERR_GetMeVisible
 set TitleTxt=%~1
 TITLE %TitleTxt%
 call :ColorSet "ERR"
 Echo.
 echo --------------------------------------------------------------------------
 Echo %TitleTxt%

 if exist "%JobMgr_StartScr_DP%\nircmd.exe" (
  Call "%JobMgr_StartScr_DP%\nircmd.exe" win normal stitle "%TitleTxt%"
  Call "%JobMgr_StartScr_DP%\nircmd.exe" win activate stitle "%TitleTxt%"
 )

 goto :eof

rem ##### ------------ Standard Subroutines --------------------- ######
:Parse_PLast
 rem parst den LetzenPath
 set %2=%~n1
 set %3=%~nx1
 goto :eof

:Parse_PathCutLastDir
 rem schneidet das letzte Verzeichniss Uebergeben path ab
 rem P1 = Name der Variablen
 rem P2 = der bergebene Path
 rem Example : call :Parse_PathCutLastDir %~dp0 EntwRoot_DP
 rem Example : call :Parse_PathCutLastDir %~dp0 MyVar_DP

 set PathCutLastDir$temp=%1
 set PathCutLastDir$temp=%PathCutLastDir$temp:"=%

 set PathCutLastDir$tempLastChar=%PathCutLastDir$temp:~-1%
 set PathCutLastDir$tempNoBacks=%PathCutLastDir$temp:~0,-1%

 if "%PathCutLastDir$tempLastChar%"=="\" (
   rem "\" abschneiden wenn vorhanden
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$tempNoBacks%
 ) else (
   rem
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$temp%
 )
 set PathCutLastDir$tempRes=%PathCutLastDir$tempRes:~0,-1%
 set %2=%PathCutLastDir$tempRes%
 set PathCutLastDir$temp=
 set PathCutLastDirDo$temp1=
 set PathCutLastDir$tempNoBacks=
 set PathCutLastDir$tempNoLastChar=
 set PathCutLastDir$tempLastChar=
 set PathCutLastDir$tempRes=
 goto :eof

:PathCutLastDirDo
 rem hiermit schneiden wir den Path ab
 rem echo.
 rem Echo P1=%1 P2=%2
 set PathCutLastDirDo$temp=%~dp2
 rem "\" abschneiden
 set PathCutLastDirDo$temp1=%PathCutLastDir$temp:~0,-1%
 set %1=%PathCutLastDirDo$temp%
 set PathCutLastDirDo$temp=
 set PathCutLastDirDo$temp1=
 goto :eof

:End
 goto :eof

:ColorSet
 rem call :ColorSet "#Key#"
 if /I "%~1" equ "Init"        set JobColorLast=E0
 if /I "%~1" equ "Standard"    set JobColorLast=E0
 if /I "%~1" equ "IsExecuting" set JobColorLast=E0
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 if /I "%~1" equ "ExtractLi"   set JobColorLast=B0
 if /I "%~1" equ "EvalResult"  set JobColorLast=B1
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 if /I "%~1" equ "ERR"         set JobColorLast=C0
 if /I "%~1" equ "Dialog"      set JobColorLast=3F
 if "%JobColorLast%" neq "" color %JobColorLast%
goto :eof

