@Echo off
 REM ===========================================================================
 REM Basisscript JobManager V2 fuer den Refile mit NX in der TC Umgebung
 REM (c) J.Feuerstein 24.11.2006
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   24.11.2006 J.Fes   Ersterstellung 05.09.2013
 REM J.Fes   14.07.2013 J.Fes   Skript umgestellt auf JS Cmd Tools
 REM J.Fes   19.11.2013 J.Fes   integrate UGII_LOAD_OPTIONS + UGII_LOCAL_USER_DEFAULTS
 REM J.Fes   25.12.2013 J.Fes   result is now returning via: %PrgExitCode%
 REM J.FES   21.01.2014 J.Fes   add Process Monitoring
 REM J.FES   12.02.2014 J.Fes   add ResultClassification_DPNE
 REM J.FES   29.04.2014 J.Fes   add JobMgr_RfExtEvalROpt
 REM J.FES   29.04.2014 J.Fes   setlocal endlocal partial removed
 REM J.FES   02.06.2014 J.Fes   error reporting enhanced
 REM ===========================================================================

 Echo **************************************************************************
 Echo * Excuting Refile Script for  PLMJobManager Environ                      *
 Echo * Version: 02.06.2014 addPLM GmbH (c)                                    *
 Echo **************************************************************************

setlocal
 REM -- #Step: Farbe setzen IsIdel
 call :ColorSet IsIdel

 call Echo "--- #Step: Set Up Base ---------------------------------------------------------"

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3
 if not defined JobMgr_TcGroup set JobMgr_TcGroup=dba


 REM -- Rootpfade setzen -------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 rem -- #Step: JobMgr CmdTools local kopieren ----------------------------------
 rem -- #Doc: Steuert aus welchem Bereich die Tools genommen werden J.Fes 14.02.2013
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer

 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"

 Call Echo "TcUser/Group............: [%JobMgr_TcUser%/%JobMgr_TcGroup%]"
 Call Echo "Upd. JobMgrCmd BinL.....: [%BinL_DP%]"
 Call Echo "from....................: [%JobManagerCmdTools_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:5
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.exe">nul 2>nul

 rem new 21.01.2014
 set JFProcessMonitorL_exe=%BinL_DP%\JFProcessMonitor.exe
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%BinPublic_DP%" "%BinL_DP%" "JFProcessMonitor.exe"


 REM -- temp dir Organiesieren -------------------------------------------------
 rem #New: 11.07.2013 13:43 S.Gue
 set JobTemp1_SO_DP=%CmdCurRoot_DP%\JobTempSO
 set JobTemp2_RO_DP=%CmdCurRoot_DP%\JobTempRO
 set RfLogFile_NE=_Rf20_RefileJob.log
 set RfFailedLog_NE=_Rf21_RefileFailed.log
 set RfCmdJobLog_NE=_Rf23_RefileCmdJob.log

 rem #New 30.11.2013 /J.Fes
 set ExtractJobList_MsgLog_DPNE="%CmdCurRoot_DP%\JobData1_ExtractList.log"
 set EvaluateJobResult_MsgLog_DPNE="%CmdCurRoot_DP%\JobData2_ResultEvaluate.log"

 REM -- define cmd files to set variables --------------------------------------
 set JobCustomSetEnv_cmd=%CmdCurRoot_DP%\JobCustomSetEnv.cmd

 rem -- Execute first time RfCustomSetEnv.cmd
 if exist "%JobCustomSetEnv_cmd%" call "%JobCustomSetEnv_cmd%"

 REM -- Option: Control software starten ---------------------------------------
 rem #New: 30.11.2013/J.Fes
 if /I "%JobMgr_use_PLMJobManagerWatchDog%" equ "ON" (
  REM Echo Check Start: PLMJobManagerWatchDog.exe
  Echo --------------------------------------------------------------------------
  call "ProgStart_If_NotRuning.cmd" "PLMJobManagerWatchDog" "%BinPublic_DP%\PLMJobManagerWatchDog_Start.cmd"
 )

 rem #New: 19.06.2014/J.Fes
 if /I "%JobMgr_start_TaskMgr%" equ "ON" (
  REM Echo Check Start: TaskMgr.exe
  Echo --------------------------------------------------------------------------
  call "ProgStart_If_NotRuning.cmd" "TaskMgr" "taskmgr.exe"
 )

 REM new 31.05.2010 21:53
 if /i "%JobMgr_use_TcServerKill%" equ  "ON" (
   call ProgIs_Running.cmd  teamcenter teamcenter_Is_running
   if "%teamcenter_Is_running%" equ "0" (
     REM TcServer Process beenden aber nur wenn TeamCenter nicht aktive ist
     call ProgKill.cmd TcServer "#12-Data#\Refile_TcServerStop_log.txt"
    )
 )


 call Echo "--- #Step: ExecuteMacro ---------------------------------------"
 call :ExecuteMacro "%CmdCurRoot_DP%\JobTemp"


 endlocal& set PrgExitCode=%PrgExitCode%
goto :end


rem ============================================================================
:ExecuteMacro
 rem #Doc: Main Script to run Refile
 rem #Doc get File Params
 set temp=%~1
 if not exist "%temp%" md "%temp%"

 rem #New 15.04.2014 13:48
 set tmp=%temp%
 set HOME=%temp%


 set JobErrLog_DPNE=%temp%\_RfErfrLog.txt

 REM -- cut '\' on end
 if "%UGII_BASE_DIR:~-1%" equ "\" set UGII_BASE_DIR=%UGII_BASE_DIR:~0,-1%
 if "%UGII_ROOT_DIR:~-1%" equ "\" set UGII_ROOT_DIR=%UGII_ROOT_DIR:~0,-1%

 REM -- extend search path
 set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%

 set UGII_TMP_DIR=%temp%
 SET UGII_KEEP_SYSTEM_LOG=TRUE
 set UGII_UGSOLIDS_TMP=%UGII_TMP_DIR%

 REM disable eingefuegt 17.08.12 J.Fes/K.S
 set UGII_UGMGR_USE_CACHE=

 REM -- Symetric Multi-Processing (SMP) disable
 REM diabled 07.02.2011
 set UGII_SMP_ENABLE=

 REM -- CGM erstellung deaktiveren eingefuegt 09.02.10 J.fes
 set UGII_IMAGE_CREATE_CGM=
 set UGII_IMAGE_CREATE_CGM_DRAW=
 set UGII_IMAGE_CREATE_CGM_OPTIONS=
 set UGII_IMAGE_CREATE_NAME=
 set UGII_IMAGE_CREATE_ORIGINAL_BACKGROUND=

 REM -- PFM vermeidet fehler beim refile von PFM Parts eingefuegt 29.11.2010 Info erhalten ber IR1814812
 set UGII_UGMGR_ALLOW_PFM_IMPORT_EXPORT=1

 REM -- IMAN-Variablen umbiegen -------------------------------------------
 SET IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 SET IMAN_KEEP_SYSTEM_LOG=TRUE
 SET IMAN_Journalling=OFF
 SET IMAN_journaling=OFF
 SET IMAN_TRACEBACK=OFF
 SET IMAN_Journal_Modules=NONE
 SET API_JOURNAL=NONE
 set APB_SCHEMA=

 REM -- TC-Variablen umbiegen -------------------------------------------
 REM 11.08.10 SQL Debug on for Test's
 SET TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 SET TC_KEEP_SYSTEM_LOG=TRUE
 SET TC_Journalling=OFF
 SET TC_Journaling=OFF
 SET TC_TRACEBACK=OFF

 REM -- define Load_options -----------------------------------------------
 set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\startup\load_options.def

 REM -- define nx_refile.dpv -----------------------------------------------
 SET UGII_LOCAL_USER_DEFAULTS=%CmdCurRoot_DP%\startup\NxMacroExecute.dpv
 set UGII_USER_DIR=%CmdCurRoot_DP%
 set UGII_GROUP_DIR=


 rem 21.01.2014
 rem Monitors NxCB_program_exe_NE
 rem  - mit max 2 Std Laufzeit
 rem  - mit max 6gb Memory usage fr 5 min
 rem  - mit max 5 min ohne das neue files im JobTemp entstehen oder editiert werden
 set toMon=%JFProcessMonitorL_exe%
 set toMon=%toMon% --waitForProcess 10000
 set toMon=%toMon% --processName ugraf
 set toMon=%toMon% --parentProcessId 0
 REM  set toMon=%toMon% --runtimeLimitSeconds 7200
 set toMon=%toMon% --killChildProcesses
 set toMon=%toMon% --fileLastWriteTime "%temp%\*.*;600"
 REM  set toMon=%toMon% --memoryUsageHigh 6000;300
 set toMon=%toMon% --saveResultsTo "%temp%\zzJFProcessMonitor_log.xml"
 set toMon=%toMon% --tailTextFile "%temp%\%username%*.syslog"
 set toMon=%toMon% --titlePrefix "Job:[%JobName%][%TcSiteId%]"

 REM -- set Rf Parameter ----------------
 set PrgExitCode=
 set JobPara=#JobParameter#

 REM -- set Rf.Contol defaults ----------
 set TC_SHARED_MEMORY_DIR_Disable=false
 set JobMgr_JobPMon_USE=true
 set JobMgr_fccCheck_USE=true

 REM -- set Rf.Environ
 if exist "%RfSetEnv_cmd%" call "%RfSetEnv_cmd%"
 REM -- set Custom.Environ
 if exist "%JobCustomSetEnv_cmd%" call "%JobCustomSetEnv_cmd%"

 REM -- Refile Programm --------------------------------------------------------
 set ugraf_exe_DPNE=%UGII_ROOT_DIR%\ugraf.exe

 REM -- Check's
 REM #Doc: 28.10.10 J.Fes if FMS_HOME is not defined it get erros during Rf.AP's
REM  if not exist "%FMS_HOME%"                 call :ExecuteRf_ERR_Write "Dir.not.f:FMS_HOME"                      "Dir  not found: FMS_HOME"                       "FMS_Home value..........: [%FMS_HOME%]"
REM  if not exist "%JobCustomSetEnv_cmd%"      call :ExecuteRf_ERR_Write "File.not.f:JobCustomSetEnv.cmd"           "File not found: RfCustomSetEnv.cmd"             "JobCustomSetEnv_cmd......: [%JobCustomSetEnv_cmd%]"
REM  if not exist "%UGII_LOCAL_USER_DEFAULTS%" call :ExecuteRf_ERR_Write "File.not.f:UGII_LOCAL_USER_DEFAULTS"     "File not found: UGII_LOCAL_USER_DEFAULTS"       "UGII_LOCAL_USER_DEFAULTS: [%UGII_LOCAL_USER_DEFAULTS%]"
REM  if not exist "%UGII_LOAD_OPTIONS%"        call :ExecuteRf_ERR_Write "File.not.f:UGII_LOAD_OPTIONS"            "File not found: UGII_LOAD_OPTIONS"              "UGII_LOAD_OPTIONS.......: [%UGII_LOAD_OPTIONS%]"
REM  if not exist "%ugraf_exe_DPNE%"  call :ExecuteRf_ERR_Write "File.not.f:ugmanager_refile_program.exe" "File not found: ugmanager_refile_program.exe"   "refile_program_exe......: [%ugraf_exe_DPNE%]"
 REM -- Run fccCheck
REM  if /I "%JobMgr_fccCheck_USE%" equ "true" call :fccCheck
 REM -- Exit if Error happend
 if exist "%JobErrLog_DPNE%" call :ExecuteRf_ERR_Show& goto :ProcessEnd

 rem #New: 30.05.2014 TC_SHARED_MEMORY_DIR
 if /i "%TC_SHARED_MEMORY_DIR_Disable%" neq "true" goto :TC_SHARED_MEMORY_DIR_Enable

:TC_SHARED_MEMORY_DIR_Disable
 rem disable TC_SHARED_MEMORY_DIR, via:
 set TC_NO_TEXTSRV_SHARED_MEMORY=TRUE
 set TC_USE_METADATA_SHARED_MEMORY=FALSE
 set TC_USE_PREFS_SHARED_MEMORY=FALSE
 goto :TC_SHARED_MEMORY_DIR_Next

:TC_SHARED_MEMORY_DIR_Enable
 set TC_SHARED_MEMORY_DIR=%CmdCurRoot_DP%\..\TC_SHARED_MEMORY_%TcSiteId%
 if not exist "%TC_SHARED_MEMORY_DIR%" md "%TC_SHARED_MEMORY_DIR%"
 goto :TC_SHARED_MEMORY_DIR_Next

:TC_SHARED_MEMORY_DIR_Next

 call :Parse_NE %UGII_LOAD_OPTIONS%        UGII_LOAD_OPTIONS
 call :Parse_NE %UGII_LOCAL_USER_DEFAULTS% UGII_LOCAL_USER_DEFAULTS

 set titleRf_str=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleRf_str%

 Echo.                                                                               .
 call :ColorSet IsExecuting
 Echo %titleRf_str%
 call Echo "----------------------------------------------------------------------------"
 Call Echo "Macro Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.................: %JobName%"
 Call Echo "Computer................: %ComputerName%"
 Call Echo "JobDir..................: %temp:~-50%"
 Call Echo "TcSide..................: #TcSite.SiteInfoWith_SiteId_and_pName#"
 Call Echo "TcUser..................: %JobMgr_TcUser%"
 Call Echo "FMS_HOME................: %FMS_HOME%"
 Call Echo "TC_ROOT.................: %TC_ROOT%"
 Call Echo "TC_DATA.................: %TC_DATA%"
 Call Echo "JobProc.Monitor.........: %JobMgr_JobPMon_USE%"
 Call Echo "UGII_LOAD_OPTIONS.......: ..\%UGII_LOAD_OPTIONS_NE%"
 Call Echo "UGII_SITE_DIR...........: %UGII_SITE_DIR%"
 Call Echo "UGII_LOCAL_USER_DEF.....: ..\%UGII_LOCAL_USER_DEFAULTS_NE%"

 cd /d "%temp%"
 set >>"%temp%\zzEnvironBevorRefile.txt"
 if /i "%JobMgr_JobPMon_USE%" neq "false" start "PMon Job:[%JobName%][%TcSiteId%]" %toMon%
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Job Protocol:"

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "NxDataProcessing_2013_09"
 set toRun=%toRun% -SubAction "NXMacroExecute"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"

 set toRun=%toRun% -NXFindCondition10_TitlesNoPart "%NXFindCondition10_TitlesNoPart%"
 set toRun=%toRun% -NXFindCondition10_TitlesNoPart_MaxSEC "%NXFindCondition10_TitlesNoPart_MaxSEC%"
 set toRun=%toRun% -NXFindCondition20_TitleLike "%NXFindCondition20_TitleLike%"
 set toRun=%toRun% -NXFindCondition20_TitleLike_MaxSEC "%NXFindCondition20_TitleLike_MaxSEC%"
 set toRun=%toRun% -NXMacroTemplate_DPNE "%NXMacroTemplate_DPNE%"
 set toRun=%toRun% -NXMacroRuns_MaxSEC "%NXMacroRuns_MaxSEC%"
 set toRun=%toRun% -NXAfterAction_WaitTime_Msec "%NXAfterAction_WaitTime_Msec%"

REM
REM  set toRun=%toRun% -NXFindCondition10_TitlesNoPart "NX 8.5 -;NX 8.5 - [No Part]"
REM  set toRun=%toRun% -NXFindCondition10_TitlesNoPart_MaxSEC "120"
REM  set toRun=%toRun% -NXFindCondition20_TitleLike "NX 8.5 -*"
REM  set toRun=%toRun% -NXFindCondition20_TitleLike_MaxSEC "180"
REM  set toRun=%toRun% -NXMacroTemplate_DPNE "%CmdCurRoot_DP%\%NXMacroTemplate_PPNE%"
REM  set toRun=%toRun% -NXMacroRuns_MaxSEC "300"
REM  set toRun=%toRun% -NXAfterAction_WaitTime_Msec "500"

 if "%TC_ROOT%" equ "" goto :NextStep
   set toRun=%toRun% -u "%JobMgr_TcUser%" -p "%JobMgr_TcPw%"
   if defined JobMgr_TcGroup set toRun=%toRun% -g "%JobMgr_TcGroup%"
 :NextStep
 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -JobData2ResultsDoPrint


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_01NXMacroExecute.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo #Debug.: BEVOR: [%~0]
   Echo %toRun% >>"%Debug_DPNE%"
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
   pause
:JumbOverDebug

 call %toRun%
 set PrgExitCode=%errorlevel%

 call Echo "--- #Res.: PrgExitCode.: [%PrgExitCode%] ---------------------------------------------"

REM  Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 Call Echo "End" "" "NOECHO"
 Banner "End"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo #Debug: Job Results Info:
   Echo #Debug: PrgExitCode: %PrgExitCode%
   pause
:JumbOver

 if defined title_str title %title_str%

 Echo CleanUp......: %temp%\%userName%2TierTransientVolume\..
 rd /S /Q  "%temp%\%userName%2TierTransientVolume" >nul 1>nul 2>nul

 if "%PrgExitCode%" equ "0" goto :RfPrgExit_OK
  set title_str=ERR:%PrgExitCode% !! error ugraf.exe [%Date%/%time:~0,8%] !!
  call :ExecuteRf_ERR_Write "RfPrg.End NOT with '0'" ""  "ugraf: Ends with [ErrorLevel:%PrgExitCode%]"
  call :ExecuteRf_ERR_Show
 goto :ProcessEnd

:RfPrgExit_OK
 Call :ColorSet OK
 REM -- delete alle files not to send to JobServer
 if /I "%JobMgr_TcNxDebug%" neq "ON" (
       if /I "%JobMgr_Debug%" neq "ON" (
          Echo CleanUp......: %temp%\..
          del /S /Q "%temp%\apiserver.exe*.*","%temp%\*.bak","%temp%\*.tmp","%temp%\*.prt","%temp%\tcserver.*","%temp%\tcserver.*.*">nul 1>nul 2>nul
       )
 )
 goto :ProcessEnd

:ProcessEnd
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo.
  Echo #Debug:%~0 [Rf:End]
  pause
:JumbOverDebug

goto :eof

REM ####### ------------ Standard Subroutines ---------------------- ###########
REM ============================================================================
:JobParam_List
 setlocal
  set ParmListTitle=%~1
  set JobParams=%~2
  if "%JobParams%" equ "" goto :JobParam_ListEnd
  rem " ersetzen durch '
  set JobParams=%JobParams:"='%
  set NCur=0
:JobParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%JobParams%") do Call :JobParam_Print "%%i"
  if %NCur% LEQ 10 goto :JobParam_List_PrintNext
:JobParam_ListEnd
 endlocal
 goto :eof

:JobParam_Print
 setlocal
  set JobParaCur=%~1
  if "%NCur%" equ "1" (
                            Call Echo "%ParmListTitle% -%JobParaCur%"
  ) else (
   if "%JobParaCur%" neq "" Call Echo "                        : -%JobParaCur%"
  )
 endlocal
 goto :eof

REM ============================================================================
:fccCheck
 rem #New 28.06.2013 J.Fes
REM  call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 rem Update 19.06.2014  uses now "%fms_home%\bin\fccstat.exe"
 call "%fms_home%\bin\fccstat.exe" -status>>"%temp%\zzfcc1Status.log"
 set tc_fccstatus=%errorlevel%

 if "%tc_fccstatus%" equ "0" goto :fccStartOk

  rem jetzt fcc starten
  call "%fms_home%\bin\fccstat.exe" -start>>"%temp%\zzfcc2Start.log"

  rem fcc preufung nach start
  call "%fms_home%\bin\fccstat.exe" -status>>"%temp%\zzfcc3Status.log"
  set tc_fccstatus=%errorlevel%

  if "%tc_fccstatus%" equ "0" goto :fccStartOk

  Call :ColorSet ERR
  call :ExecuteRf_ERR_Write "fcc.ERR" "fcc cannot be started"
  call :ExecuteRf_ERR_Write "" "" "fcc Status/Start........: Returns [errorlevel:%tc_fccstatus%]"
  call :ExecuteRf_ERR_Write "" "" "please look at 1 Status.: [%temp%\zzfcc1Status.log]"
  call :ExecuteRf_ERR_Write "" "" "please look at 2 Start..: [%temp%\zzfcc2Start.log]"
  call :ExecuteRf_ERR_Write "" "" "please look at 3 Status.: [%temp%\zzfcc3Status.log]"
  call :ExecuteRf_ERR_Write "" "" "#ToDo...................: Please check installation and configuration"
  goto :fccCheckEnd

:fccStartOk
 del "%temp%\zzfcc1Status.log"
 Call Echo "fcc check:..............: OK"
 goto :fccCheckEnd
:fccCheckEnd
goto :eof

REM ============================================================================
:ExecuteRf_ERR_Write
 Call :ColorSet ERR
 Set RfErr_MSG_Key=%~1
 Set RfErr_MSG_Sort=%~2
 Set RfErr_MSG_L1=%~3
 Set RfErr_MSG_L2=%~4
 Set RfErr_MSG_L3=%~5
 Set RfErr_MSG_L4=%~6

 if "%RfErr_MSG_Key%" equ "" goto :Next
 rem add Error Key
 if     defined RfErr_MSG_Keys set RfErr_MSG_Keys=%RfErr_MSG_Keys% %RfErr_MSG_Key%
 if not defined RfErr_MSG_Keys set RfErr_MSG_Keys=%RfErr_MSG_Key%


 set title_str=ERR:%RfErr_MSG_Key% %RfErr_MSG_Sort%
 if "%RfErr_MSG_Sort%" neq "" set title_str=ERR:%RfErr_MSG_Key%

 if not exist "%JobErrLog_DPNE%" Call :ErrLogHeaderWrite

 REM Error in die Datei schreiben!
 call Echo "%title_str%" "%JobErrLog_DPNE%"
:Next
 if "%RfErr_MSG_L1%" neq "" call Echo "%RfErr_MSG_L1%" "%JobErrLog_DPNE%"
 if "%RfErr_MSG_L2%" neq "" call Echo "%RfErr_MSG_L2%" "%JobErrLog_DPNE%"
 if "%RfErr_MSG_L3%" neq "" call Echo "%RfErr_MSG_L3%" "%JobErrLog_DPNE%"
 if "%RfErr_MSG_L4%" neq "" call Echo "%RfErr_MSG_L4%" "%JobErrLog_DPNE%"
REM  Call Echo "." "%JobErrLog_DPNE%"
REM  pause

goto :eof

REM -- -- -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- -- -
:ErrLogHeaderWrite
 call Echo "DateTime: %date% %time%"  "%JobErrLog_DPNE%"
 call Echo "Computer: %ComputerName%" "%JobErrLog_DPNE%"
 call Echo "User....: %UserName%"     "%JobErrLog_DPNE%"
 call Echo "--------------------------------------------------------------------------" "%JobErrLog_DPNE%"
 goto :eof

REM -- -- -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- -- -
:ErrLogFooterWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable JobErrLog_DPNE muss gesetzt sein!!
 Echo."%JobErrLog_DPNE%"
 call Echo "--------------------------------------------------------------------------" "%JobErrLog_DPNE%" "NOECHO"
 call Echo "Environ Info of:\\%ComputerName%" "%JobErrLog_DPNE%" "NOECHO"
 call Echo "." "%JobErrLog_DPNE%" "NOECHO"
 call Echo "-- Path Environ ----------------------------------------------------------" "%JobErrLog_DPNE%" "NOECHO"
 set PATH >>"%JobErrLog_DPNE%"

 call Echo "-- UG* Environ -----------------------------------------------------------" "%JobErrLog_DPNE%" "NOECHO"
 set UG >>"%JobErrLog_DPNE%" 2>nul
 call Echo "-- NX* Environ -----------------------------------------------------------" "%JobErrLog_DPNE%" "NOECHO"
 set NX >>"%JobErrLog_DPNE%" 2>nul
 call Echo "-- IMAN* Environ ---------------------------------------------------------" "%JobErrLog_DPNE%" "NOECHO"
 set IMAN >>"%JobErrLog_DPNE%" 2>nul
 call Echo "-- TC* Environ -----------------------------------------------------------" "%JobErrLog_DPNE%" "NOECHO"
 set TC >>"%JobErrLog_DPNE%" 2>nul
 call Echo "-- All Environ -----------------------------------------------------------" "%JobErrLog_DPNE%" "NOECHO"
 set >>"%JobErrLog_DPNE%" 2>nul
 goto :eof

REM -- -- -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- -- -
:ExecuteRf_ERR_Show
 set title_str=ERR:Refile on:[\\%ComputerName%][%Date%/%time:~0,8%]!!
 call :ErrLogFooterWrite
 title %title_str%
 Echo --------------------------------------------------------------------------
 Type "%JobErrLog_DPNE%"
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_Debug%" neq "ON" goto :ExecuteRf_ERR_Show_end
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%JobErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo #Hint: Type exit and script continues
 cmd
 :ExecuteRf_ERR_Show_end
goto :eof

REM ============================================================================
:ColorSet
Rem Stand 25.06.2011
 REM call :ColorSet Standard
 REM call :ColorSet IsExecuting
 REM call :ColorSet IsIdel
 REM call :ColorSet End
 REM call :ColorSet Ende
 REM call :ColorSet Ok
 REM call :ColorSet Err

 if /I "%~1" equ "Standard"    set JobColorLast=70
 if /I "%~1" equ "IsExecuting" set JobColorLast=E0
 if /I "%~1" equ "ExtractLi"   set JobColorLast=B0
 if /I "%~1" equ "EvalResult"  set JobColorLast=B1
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 if /I "%~1" equ "Err"         set JobColorLast=C0

 REM set color
 if "%JobColorLast%" neq "" color %JobColorLast%
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
  Echo Description    : %FileDescription%
  Echo Contens of File: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo Info...........: File.notf.:[%FileToType_DPNE%]
 endlocal
 goto :eof

REM ============================================================================
:Parse_NE
 set %2_NE=%~nx1
 goto :eof

REM ============================================================================
:end
