@Echo off
 REM ===========================================================================
 REM Basisscript JobManager V2 fuer den Refile mit NX8 in der TC Umgebung
 REM (c) J.Feuerstein 24.11.2006
 rem
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   24.11.2006 00:05   Ersterstellung 24.11.2006
 REM J.Fes   14.07.2013 15:54   Skript umgestellt auf JCT Tools
 REM ===========================================================================
 
 Echo **************************************************************************
 Echo * Excuting Refile Script for NX7.5 in PLMJobManager Environ              *
 Echo * Version: 27.12.2013 addPLM GmbH (c)                                    *
 Echo **************************************************************************

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 REM -- Basiseinstellungen fuer das Verhalten es Scriptes ----------------------
 REM Hier knnen Verschiedene Einstellungen getroffen werden die steuern wie das Script ablaufen soll
 REM      Die mit "#" Gitter eingeschlossenen Variablen werden vom JobServer ersetzt
 
 REM Alle wichtigen Stellen sind mit # gekennzeichnset
 REM #Doc.: steht an allen Dokumentations Stellen
 REM #ToDo: steht an allen Stellen die angepasst werden sollen

 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsList.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsList_txt=false
 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsListAllDetails.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsListAllDetails_txt=false

 REM use WatchDog [default=ON]
 set JobMgr_use_PLMJobManagerWatchDog=ON

 REM use JobMgr_use_TcServerKill [default=OFF]
 set JobMgr_use_TcServerKill=OFF

 REM Debug: [bei Einzel Test's auf=ON] [sonst auf OFF stellen]
 set JobMgr_Debug=OFF
 REM -- JobScriptParametersExtended:
 REM    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen leer
 REM             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt auch leer ist
 #JobScriptParametersExtended#

 REM Steuert Verhalten wenn ein Error aufgetreten ist [ON=Anhalten] [OFF=automatisch weiter arbeiten!]
 REM allgemein einstellen wie JobMgr_Debug [default=%JobMgr_Debug%]
 set JobMgr_OnErrorShowResultOnClient=%JobMgr_Debug%

 REM Disk Connect [default=OFF]
 set JobMgr_use_DiskConnect=OFF

 REM -- #Step: Farbe setzen IsIdel
 call :ColorSet IsIdel

 REM -- Rootpfade setzen -------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 REM -- JobServer Variablen ----------------------------------------------------
 set JobManagerRoot_DP=#00-ApplRoot_DP#
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#

 REM -- JobData ----------------------------------------------------------------
 set JobScripts_DP=#10-JobScripts_DP#
 set JobName=#JobName#
 set JobPacket_NE=#JobPacket_NE#
 set JobParameter=#JobParameter#

 set DataRoot_CustomWorkInst_DP=#DataRoot_CustomWorkInst_DP#
 set JobScriptMinus1_DP=#JobScriptMinus1_DP#

 REM -- uebergabe SiteDef ------------------------------------------------------
 set TcSiteId=#TcSiteId#

 set title_str=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %title_str%

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
  Banner Test:%JobMgr_Test%
 :JumbOver

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Debug:%JobMgr_Debug%
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
   Echo #Debug....: Start Explorer
   Echo at JobDir.: [%CmdCurRoot_DP%]
   start "" Explorer "%CmdCurRoot_DP%"
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
:JumbOver

 if "%JobMgr_use_DiskConnect%" neq "ON" goto :jumbOverDiskConnect
  REM -- Optional # Laufwerk verbinden !! -------------------------------------
  REM Netzwerklaufwerke richtig verbinden
  set ConnectNetUnc_to_Info=S: \\MyServer\ugsshare
  call ConnectNetUnc.cmd "Ugsshare" S: \\MySerrver\ugsshare . . Ugsshare_DiskConnectOk
  Echo Connect Laufwerk:%ConnectNetUnc_to_Info% Status:"%Ugsshare_DiskConnectOk%"
  if /I not "%Ugsshare_DiskConnectOk%" equ "OK" goto :PLMShare_NetConnectERR
:jumbOverDiskConnect


 REM -- temp dir Organiesieren -------------------------------------------------
 set tempOrig_DP=%temp%

 Echo --------------------------------------------------------------------------
 Echo Info: Executing TcPrompt to get "Tc-Environment"

 REM #Doc: der nachfolgende Block kann als alternative verwendet werden
 REM #Doc: wenn mehrere Sites mit unterschiedliche TC Prompts verwendet werden muessen
 if /i "#TcSiteId#" neq "TCY020" goto :JumbOver_TCY020
   set AppRoot_DP=D:\apps
   if not exist "%AppRoot_DP%" set AppRoot_DP=D:\apps\Teamcenter\TCY020\TCROOT
   if not exist "%AppRoot_DP%" set AppRoot_DP=C:\apps\Teamcenter\TCY020\TCROOT
   if not defined TC_DATA set TC_DATA=%AppRoot_DP%\Teamcenter\TCY020\TCDATA
   if not defined TC_ROOT set TC_ROOT=%AppRoot_DP%\Teamcenter\TCY020\TCROOT
   set TcPromtCmd=%TC_DATA%\tc_profilevars.bat
   set TcPromtCmdOpt=
   rem 12.03.2014/J.Fes hier FMS_Home setzen da in den profile vars der path %FMS_HOME%\bin eingarabeitet wird
   rem                  damit wird sicher gestellt das fccstat richtig geht
   set FMS_HOME=%TC_ROOT%\tccs
   rem D:\apps\CAD\NX85\ugii\
   rem 13/12/2013 11:03 defined
:JumbOver_TCY020

 if /i "#TcSiteId#" neq "TCQ05R30" goto :JumbOver_TCQ05R30
   rem #New 23.04.2014 19:13 / J.Fes
   set AppRoot_DP=D:\apps
   if not exist "%AppRoot_DP%" set AppRoot_DP=D:\apps\Teamcenter\TCQ05R30\TCROOT
   if not exist "%AppRoot_DP%" set AppRoot_DP=C:\apps\Teamcenter\TCQ05R30\TCROOT
   if not defined TC_DATA set TC_DATA=%AppRoot_DP%\Teamcenter\TCQ05R30\TCDATA
   if not defined TC_ROOT set TC_ROOT=%AppRoot_DP%\Teamcenter\TCQ05R30\TCROOT
   set TcPromtCmd=%TC_DATA%\tc_profilevars.bat
   set TcPromtCmdOpt=
   rem 12.03.2014/J.Fes hier FMS_Home setzen da in den profile vars der path %FMS_HOME%\bin erstellt wird
   rem                  damit wird sicher gestellt das fccstat richtig geht
   set FMS_HOME=%TC_ROOT%\tccs
:JumbOver_TCQ05R30


 if /i "#TcSiteId#" neq "TCQ04R30" goto :JumbOver_TCQ04R30
   rem #New 23.04.2014 19:13 / J.Fes
   set AppRoot_DP=D:\apps
   if not exist "%AppRoot_DP%" set AppRoot_DP=D:\apps\Teamcenter\TCQ04R30\TCROOT
   if not exist "%AppRoot_DP%" set AppRoot_DP=C:\apps\Teamcenter\TCQ04R30\TCROOT
   if not defined TC_DATA set TC_DATA=%AppRoot_DP%\Teamcenter\TCQ04R30\TCDATA
   if not defined TC_ROOT set TC_ROOT=%AppRoot_DP%\Teamcenter\TCQ04R30\TCROOT
   set TcPromtCmd=%TC_DATA%\tc_profilevars.bat
   set TcPromtCmdOpt=
   rem 12.03.2014/J.Fes hier FMS_Home setzen da in den profile vars der path %FMS_HOME%\bin erstellt wird
   rem                  damit wird sicher gestellt das fccstat richtig geht
   set FMS_HOME=%TC_ROOT%\tccs
:JumbOver_TCQ04R30

 if /i "#TcSiteId#" neq "TCM11R30" goto :JumbOver_TCM11R30
   rem #New 29.09.2014 11:30 / S.Gueth
   set AppRoot_DP=D:\apps
   if not exist "%AppRoot_DP%" set AppRoot_DP=D:\apps\Teamcenter\TCM11R30\TCROOT
   if not exist "%AppRoot_DP%" set AppRoot_DP=C:\apps\Teamcenter\TCM11R30\TCROOT
   if not defined TC_DATA set TC_DATA=%AppRoot_DP%\Teamcenter\TCM11R30\TCDATA
   if not defined TC_ROOT set TC_ROOT=%AppRoot_DP%\Teamcenter\TCM11R30\TCROOT
   set TcPromtCmd=%TC_DATA%\tc_profilevars.bat
   set TcPromtCmdOpt=
   rem 12.03.2014/J.Fes hier FMS_Home setzen da in den profile vars der path %FMS_HOME%\bin erstellt wird
   rem                  damit wird sicher gestellt das fccstat richtig geht
   set FMS_HOME=%TC_ROOT%\tccs
:JumbOver_TCM11R30

 if /i "#TcSiteId#" neq "TCT05R30" goto :JumbOver_TCT05R30
   rem #New 30.04.2015 11:47 / J.Fes
   set AppRoot_DP=D:\apps
   if not exist "%AppRoot_DP%" set AppRoot_DP=D:\apps\Teamcenter\TCT05R30\TCROOT
   if not exist "%AppRoot_DP%" set AppRoot_DP=C:\apps\Teamcenter\TCT05R30\TCROOT
   if not defined TC_DATA set TC_DATA=%AppRoot_DP%\Teamcenter\TCT05R30\TCDATA
   if not defined TC_ROOT set TC_ROOT=%AppRoot_DP%\Teamcenter\TCT05R30\TCROOT
   set TcPromtCmd=%TC_DATA%\tc_profilevars.bat
   set TcPromtCmdOpt=
   rem 12.03.2014/J.Fes hier FMS_Home setzen da in den profile vars der path %FMS_HOME%\bin erstellt wird
   rem                  damit wird sicher gestellt das fccstat richtig geht
   set FMS_HOME=%TC_ROOT%\tccs
:JumbOver_TCT05R30

  if /i "#TcSiteId#" neq "TCP010" goto :JumbOver_TCP010
    set AppRoot_DP=D:\apps
   if not exist "%AppRoot_DP%" set AppRoot_DP=D:\apps\Teamcenter\TCP010\TCROOT
   if not exist "%AppRoot_DP%" set AppRoot_DP=C:\apps\Teamcenter\TCP010\TCROOT
   if not defined TC_DATA set TC_DATA=%AppRoot_DP%\Teamcenter\TCP010\TCDATA
   if not defined TC_ROOT set TC_ROOT=%AppRoot_DP%\Teamcenter\TCP010\TCROOT
   set TcPromtCmd=%TC_DATA%\tc_profilevars.bat
   set TcPromtCmdOpt=
   rem 12.03.2014/J.Fes hier FMS_Home setzen da in den profile vars der path %FMS_HOME%\bin erstellt wird
   rem                  damit wird sicher gestellt das fccstat richtig geht
   set FMS_HOME=%TC_ROOT%\tccs
:JumbOver_TCP010


 if not exist "%TcPromtCmd%" goto :TcPromtCmdError
 if     exist "%TcPromtCmd%" call "%TcPromtCmd%" %TcPromtCmdOpt%

 rem 12.03.2014 08:35
REM  set UGII_SITE_DIR=\\demchtcvd01.ww500.siemens.net\gplmshare\NX\tcp01\nx85\ugii
REM  set UGII_SITE_DIR=\\DEMCHTCvP01.ww500.siemens.net\TcJobManP\JobManagerV2_T\90-DATA\SiIEC_SettingsGlobal\10-JobScripts\RefileNX85\Custom\UGII_SITE_DIR
 set UGII_SITE_DIR=%JobScriptMinus1_DP%\Custom\UGII_SITE_DIR

 set FSC_HOME=
 REM set FCC_PROXYPIPENAME=\\.\pipe\FMSClientPipe_TCA020
 rem Wichtig 10/05/2012 15:15 entnehmen da sonst der fcc nicht richtig funktoniert
 rem #toDo: 3/12/2013 10:09 Stand pruefen
 set FCC_PROXYPIPENAME=

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
  Echo #Debug:
  Echo after excuting:
  Echo path..........: [%path%]
  Echo TcPromtCmd....: [%TcPromtCmd%]
  Echo TcPromtCmdOpt.: [%TcPromtCmdOpt%]
  Echo TC_ROOT.......: [%TC_ROOT%]
  Echo TC_DATA.......: [%TC_DATA%]
  Echo FMS_HOME......: [%FMS_HOME%]
  set >>"%CmdCurRoot_DP%\zz_01EnvironMent_Env.txt"
  pause
:JumbOver

 REM -- PathVariable erweitern
 set path=%CmdCurRoot_DP%;%BinPublic_Custom_DP%;%BinPublic_ClientServer_DP%;%BinPublic_DP%;%Path%

 Call "%CmdCurRoot_DP%\NXDP10_Main.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
  Banner Test:End
  Echo -------------------------------------------------------------------------
  Echo #TestMode.........: End of Refile Test
  Echo JobName...........: [%JobName%]
  Echo RfPrgExitCode.....: [%RfPrgExitCode%]
  Echo -------------------------------------------------------------------------
  pause
:JumbOver

goto :end


REM ###### ------------ Standard Subroutines ---------------------- ##########
REM ============================================================================
:TcPromtCmdError
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_MissingTcPromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start refile on:\\%ComputerName% missing TcPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TcPromtCmd:=%TcPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
 goto :end


REM ============================================================================
:ErrLogHeaderWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ErrLogFooterWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo.>>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
 Echo.>>"%ErrLog_DPNE%"
 Echo -- Path Environ ---------------------------------------------------------->>"%ErrLog_DPNE%"
 set PATH>>"%ErrLog_DPNE%"

 Echo -- UG* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set UG>>"%ErrLog_DPNE%"
 Echo -- IMAN* Environ --------------------------------------------------------->>"%ErrLog_DPNE%"
 set IMAN>>"%ErrLog_DPNE%"
 Echo -- All Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set>>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ColorSet
Rem Stand 25.06.2011
Rem Examples:
 REM call :ColorSet Standard
 REM call :ColorSet IsExecuting
 REM call :ColorSet IsIdel
 REM call :ColorSet End
 REM call :ColorSet Ende
 REM call :ColorSet Ok
 REM call :ColorSet Err

 REM -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei
 REM -- Farben nach Status setzen
 REM Gelb Schwarz
 if /I "%~1" equ "Standard"    set JobColorLast=E0
 REM 25.06.2011 07:00 Standard eingef. IsExecuting Neu
 if /I "%~1" equ "IsExecuting" set JobColorLast=D0
 REM Blaugrn Schwarz 15.11.2010 07:45 Hellgrau Schwarz
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 REM Hellgrau Schwarz
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 REM Gruen Schwarz
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 REM Rot Schwarz
 if /I "%~1" equ "Err"         set JobColorLast=C0

 REM jetzt die Farbe setzen
 if "%JobColorLast%" neq "" color %JobColorLast%
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
  Echo Description    : %FileDescription%
  Echo Contens of File: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo Info...........: File not exist
 endlocal
 goto :eof

REM ============================================================================
:Wait
 set waitTime=2
 if "%1" neq "" set waitTime=%1
 CHOICE.exe /C:w /N /T:w,%waitTime% "warte %waitTime%[sec] oder [w] druecken fuer weiter: "
 goto :eof

REM ============================================================================
:PLMShare_NetConnectERR
 set ErrLog_DPNE=%temp%\_PLMShare_NetConnect_ERR.txt
 REM schreibt die erweiterten Infos an einen ErrLogFile
 Echo Err: erf. Netzwerkverb. fuer: %TcSiteId% [%ConnectNetUnc_to_Info%] konnte nicht richtig verbunden werden!!>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 type "%ErrLog_DPNE%"
 Echo !!Einstellungen oder Netzwerkverbindungen pruefen!!
 cmd 
 Pause
 goto :eof

REM ============================================================================
:end
 cd /d "%tempOrig_DP%"
 Echo --------------------------------------------------------------------------
 Echo Info: all files in: [%temp%]
 Echo       will be zipt by JobClient and send to JobServer
 REM -- farbe wieder auf standard zurueck setzen
 Call :ColorSet End
