@Echo off
 REM ==========================================================================================
 REM Migrationsscript JobManager V2 for migrate Ideas to NX in TC Environment
 REM (c) J.Feuerstein 08.10.2013
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   24.11.2006 00:05   Ersterstellung 05.09.2013
 REM J.Fes   14.07.2013 15:54   Skript umgestellt auf JS Cmd Tools
 REM ==========================================================================================
 rem Echo JobName...........:              25
 rem Call Echo "from...............: [xx]" 35
 rem Echo ------------------               95
 rem call Echo "--- #Step: ... ---"       113

 Echo *****************************************************************************************
 Echo * Excuting Process Script for  PLMJobManager Environ                                    *
 Echo * Version: 0.9 addPLM GmbH  08.10.2013 (c)                                              *
 Echo *****************************************************************************************
setlocal

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3
 if not defined JobMgr_TcGroup set JobMgr_TcGroup=dba
 REM  #Doc Variable CMMType wird von den Scripts und Parametern gesteuert (06.02.2014/JF+SG)
 if not defined CMMType set CMMType=I-deas

 REM -- #Step: Farbe setzen IsIdel
 Call ColorSet.cmd IsIdel

 REM -- Rootpfade setzen ----------------------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%
 set JobScriptTemplateMinus1_DP=#JobScriptTemplateMinus1_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinServer_Custom_DP=#01-BinServer_DP#.Custom
 rem Parameter
 set ProcPara=#JobParameter#


 rem -- #Step: JobMgr CmdTools local kopieren -------------------------------------------------
 rem -- #Doc: Steuert aus welchem Bereich die Tools genommen werden J.Fes 14.02.2013
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer

 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"
 Call Echo "JobMgr_TcUser/Group...: [%JobMgr_TcUser%/%JobMgr_TcGroup%]"
 Call Echo "Upd. JobMgrCmd BinL...: [%BinL_DP%]"
 Call Echo "from..................: [%JobManagerCmdTools_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:1
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.*">nul 2>nul

 rem  -- siemens_assign_cmm_status.exe  to:[%BinL_DP%\MigIdeas2NxTools\SetStatus]
 set siemens_assign_cmm_status_L=%BinL_DP%\MigIdeas2NxTools\SetStatus\siemens_assign_cmm_status.exe
 set toRun=robocopy %robocopy_opt% /S /NP /NJS /NJH /NDL /NFL "%JobScriptTemplateMinus1_DP%\MigIdeas2NxTools" "%BinL_DP%\MigIdeas2NxTools"
 %toRun%

 rem  -- OraClient  to:[%BinL_DP%\OraClient]
 set toRun=robocopy %robocopy_opt% /S /NP /NJS /NJH /NDL /NFL "%BinPublic_Custom_DP%\OraClient" "%BinL_DP%\OraClient"
 %toRun%

 set JFProcessMonitorL_exe=%BinL_DP%\JFProcessMonitor.exe
 robocopy /NP /NJS /NJH /NDL /NFL /R:2 /W:2 "%BinPublic_DP%" "%BinL_DP%" "JFProcessMonitor.exe"

 rem -- #Step: Print JobDetails
 set ProcessTime_Start=%Date% %time:~0,5%
 call :PrintJobInfo

 if "%RunProcess%" equ "" set RunProcess=unknown

 rem -- #Step: resets all JobData to Reset Data
 call "ProcessDataResetToStartValue.cmd" "%RunProcess%"
 rem i-deas
 if /I "%RunProcess%" equ "initial"   Call :Execute01_initial
 if /I "%RunProcess%" equ "CMM"       Call :Execute02_CMM
 if /I "%RunProcess%" equ "final"     Call :Execute03_final
 if /I "%RunProcess%" equ "remigrate" Call :Execute04_remigrate
 if /I "%RunProcess%" equ "finalChk"  Call :Execute05_finalChk

 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  -----
 Banner "P:End"
 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  -----

 REM -- alle Files loeschen die nicht zum JobServer gesendet werden sollen
 if /I "%JobMgr_Debug%" neq "ON" (
       rem if /I "%JobMgr_Test%" neq "ON" (
          Echo CleanUp:%temp%\..
          del /S /Q "%temp%\apiserver.exe*.*","%temp%\*.bak","%temp%\*.tmp","%temp%\*.prt","%temp%\tcserver.*","%temp%\tcserver.*.*">nul 1>nul 2>nul
          Echo CleanUp:%temp%\%userName%2TierTransientVolume\..
          rd /S /Q  "%temp%\%userName%2TierTransientVolume" >nul 1>nul 2>nul
      rem )
 )

 set ProcessTime_End=%Date% %time:~0,5%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
    Echo.
    Echo #Debug:%~0 [End:P]
    pause
:JumbOverDebug

endlocal
goto :end

rem ===========================================================================================
:Execute01_initial
 rem #Doc: run's CMM Processsteps to convert I-DEAS data to NXData
 rem #New: 12.09.2013 / J.Fes
 setlocal

 set JobData_DP=%temp%\JobData_10_initial
 set temp=%JobData_DP%

 if not exist "%temp%" md "%temp%"
 cd /d "%temp%"
 set TC_TMP_DIR=%temp%
 set TC_KEEP_SYSTEM_LOG=TRUE

 set Status_initial_InpList_DPNE=%JobData_DP%\10-Status_initial_InpList.txt
 set Status_initial_OutList_DPNE=%JobData_DP%\11-Status_initial_OutList.txt
 set Status_initial_OutListERR_DPNE=%JobData_DP%\12-Status_initial_OutListErr.txt
 set Status_initial_TcDataSetExtract_DPNE=%JobData_DP%\13-Status_initial_TcDataSetExtract_PostInitial.xml

 set StepN=0
 set StepM=4

 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] initial: Extract List ---------------------------------------------------"
 call ProcessDataExtract.cmd ":Status_initial_InpListGen" "%Status_initial_InpList_DPNE%"

 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] initial: Execute SetStatus ----------------------------------------------"
 call SetStatus.cmd "initial" "%Status_initial_InpList_DPNE%" "%Status_initial_OutList_DPNE%" "%Status_initial_OutListErr_DPNE%" "%CMMType%"

 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] initial: TcExtractData for Result Eval ----------------------------------"
 call TcExtractData.cmd "%JobData_DP%" "%Status_initial_TcDataSetExtract_DPNE%"

 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] initial: Result Eval ----------------------------------------------------"
 call "ProcessDataEvaluate.cmd" ":Status_initial_ResultEval" "%JobData_DP%" "%Status_initial_TcDataSetExtract_DPNE%"
 endlocal
goto :end

rem ===========================================================================================
:Execute02_CMM
 rem #Doc: run's CMM Process
 rem #New: 12.09.2013 / J.Fes
 setlocal

 set JobTemp_20_CMM_DP=%temp%\JobData_20_CMM
 set CMM21_TcDataSetExtract_PreCMM_DPNE=%JobTemp_20_CMM_DP%\21-CMM_TcExtract_DS_of_IR_PreCMM.xml
 set CMM22_TcExtract_Bom_Datasets_PreCMM=%JobTemp_20_CMM_DP%\22-CMM_TcExtract_BOM_Datasets_PreCMM.xml
 set CMM23_InpList_DPNE=%JobTemp_20_CMM_DP%\23-CMM_%CMMType%_InpList.xml
 rem #Doc: siehe Logfile Namen in CMM_JM_IdeasMoveToNX.cmd
 set CMM27_TcDataSetExtract_PostCMM_DPNE=%JobTemp_20_CMM_DP%\27-CMM_TcDataSetExtract_PostCMM.xml
 set CMM28_TcExtract_Bom_Datasets_PostCMM=%JobTemp_20_CMM_DP%\28-CMM_TcExtract_BOM_Datasets_PostCMM.xml

 Call ColorSet.cmd IsExecuting

 cd /d "%temp%"
 set StepN=0
 set StepM=5

 Banner Remi:%CMMRemig%

 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] CMM: TcExtractBOMData Pre -----------------------------------------------"
 call TcExtractData.cmd "%JobTemp_20_CMM_DP%" "%CMM21_TcDataSetExtract_PreCMM_DPNE%" "%CMM22_TcExtract_Bom_Datasets_PreCMM%" "pre"

 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] CMM: Extract list -------------------------------------------------------"
 call ProcessDataExtract.cmd ":CMM_InpListGen" "%CMM23_InpList_DPNE%" "%CMM21_TcDataSetExtract_PreCMM_DPNE%" "%CMM22_TcExtract_Bom_Datasets_PreCMM%" "%CMMBomAnalyseSkip%"

 set /a StepN=%StepN% + 1
 if exist "%CMM23_InpList_DPNE%" (
 call Echo "--- #Step:[%StepN%/%StepM%] CMM: Run ----------------------------------------------------------------"
  if /I "%CMMType%" equ "I-deas"  Call "CMM_JM_IdeasMoveToNX.cmd" "%JobTemp_20_CMM_DP%" "%CMM23_InpList_DPNE%"
  if /I "%CMMType%" equ "ProE"    Call "CMM_JM_ProEMoveToNX.cmd"  "%JobTemp_20_CMM_DP%" "%CMM23_InpList_DPNE%"
 ) else (
 call Echo "--- #Step:[%StepN%/%StepM%] CMM: NOT Processed ------------------------------------------------------"
 call Echo " because: No Data found in this Job to process via CMM Tools"
 )

 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] CMM: TcExtractBOMData Post ----------------------------------------------"
 call TcExtractData.cmd "%JobTemp_20_CMM_DP%" "%CMM27_TcDataSetExtract_PostCMM_DPNE%" "%CMM28_TcExtract_Bom_Datasets_PostCMM%" "post"

 rem #Doc: 4711/001 .PResMsg=[Initial:OK][CMM:OK]
 rem #Doc: 4711/001 OK  .PResMsg=[CMM:OK]
 rem #Doc: 4713/001 ERR .PResMsg=[CMM:ERR]
 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] CMM: Evaluate Result ----------------------------------------------------"
 call ProcessDataEvaluate.cmd ":CMM_ResultEval" "%JobTemp_20_CMM_DP%" "%CMM27_TcDataSetExtract_PostCMM_DPNE%"

 endlocal
goto :eof




rem ===========================================================================================
:Execute03_final
 rem #Doc: run's final process
 rem #New: 12.09.2013 / J.Fes
 setlocal

 set JobData_DP=%temp%\JobData_30_final
 set temp=%JobData_DP%
 if not exist "%temp%" md "%temp%"
 cd /d "%temp%"
 set TC_TMP_DIR=%temp%
 set TC_KEEP_SYSTEM_LOG=TRUE

 rem #Doc: in diesem file sind die aus der TC.DB extraierten IR Post infromationen enthalten
 set Status_final_TcDataSetExtract_Prefinal_DPNE=%JobData_DP%\31-Status_final_TcDataSetExtract_Pre.xml
 rem #Doc: in diesem File wird die set status inputliste geschrieben
 set Status_final_InpList_DPNE=%JobData_DP%\32-Status_final_InpList.txt
 rem #Doc: in diesen LogFiles ist der Outpunt des Status programmes
 set Status_final_OutList_DPNE=%JobData_DP%\33-Status_final_OutList.txt
 rem #Doc: in diesen LogFiles ist der Error Outpunt des Status programmes
 set Status_final_OutListERR_DPNE=%JobData_DP%\34-Status_final_OutListErr.txt
 rem #Doc: in diesem file sind die aus der TC.DB extrahierten IR Post infromationen enthalten
 set Status_final_TcDataSetExtract_Postfinal_DPNE=%JobData_DP%\35-Status_final_TcDataSetExtract_Post.xml

 set StepN=0
 set StepM=5

REM  set JobMgr_Debug=ON
REM  start "" Explorer "%JobData_DP%"
REM  pause

 set /a StepN=%StepN% + 1
 Echo.
 call Echo "--- #Step:[%StepN%/%StepM%] final: TcExtractData Pre ------------------------------------------------"
 call TcExtractData.cmd "%JobData_DP%" "%Status_final_TcDataSetExtract_Prefinal_DPNE%"

 Echo.
 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] final: Extract Status_final_InpList_DPNE --------------------------------"
 call ProcessDataExtract.cmd ":Status_final_InpListGen" "%Status_final_InpList_DPNE%"  "%Status_final_TcDataSetExtract_Prefinal_DPNE%"

 Echo.
 set /a StepN=%StepN% + 1
 if exist "%Status_final_InpList_DPNE%" (
  call Echo "--- #Step:[%StepN%/%StepM%] final: Execute SetStatus ------------------------------------------------"
  call SetStatus.cmd "final" "%Status_final_InpList_DPNE%" "%Status_final_OutList_DPNE%" "%Status_final_OutListErr_DPNE%" "%CMMType%"
 ) else (
  call Echo "--- #Step:[%StepN%/%StepM%] final: Execute SetStatus NOT Processed ----------------------------------"
 )

 Echo.
 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] final: TcExtractData for Result Eval ------------------------------------"
 call TcExtractData.cmd "%JobData_DP%" "%Status_final_TcDataSetExtract_Postfinal_DPNE%"

 Echo.
 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] final: Result Eval ------------------------------------------------------"
 call "ProcessDataEvaluate.cmd" ":Status_final_ResultEval" "%JobData_DP%" "%Status_final_TcDataSetExtract_Postfinal_DPNE%"

 endlocal
goto :end

rem ===========================================================================================
:Execute04_remigrate
 rem #Doc: run's to process status remigrate
 rem #New: 13.01.2014 / J.Fes
 setlocal

 set JobData_DP=%temp%\JobData_40_Remigrate
 set temp=%JobData_DP%
 if not exist "%temp%" md "%temp%"
 cd /d "%temp%"
 set TC_TMP_DIR=%temp%
 set TC_KEEP_SYSTEM_LOG=TRUE

 rem #Doc: in diesem file sind die aus der TC.DB extraierten IR Post infromationen enthalten
 set Status_remigrate_TcDataSetExtract_Pre_DPNE=%JobData_DP%\41-Status_remigrate_TcDataSetExtract_Pre.xml
 rem #Doc: in diesem File wird die set status inputliste geschrieben
 set Status_remigrate_InpList_DPNE=%JobData_DP%\42-Status_remigrate_InpList.txt
 rem #Doc: in diesen LogFiles ist der Outpunt des Status programmes
 set Status_remigrate_OutList_DPNE=%JobData_DP%\43-Status_remigrate_OutList.txt
 rem #Doc: in diesen LogFiles ist der Error Outpunt des Status programmes
 set Status_remigrate_OutListERR_DPNE=%JobData_DP%\44-Status_remigrate_OutListErr.txt
 rem #Doc: in diesem file sind die aus der TC.DB extrahierten IR Post infromationen enthalten
 set Status_remigrate_TcDataSetExtract_Post_DPNE=%JobData_DP%\45-Status_remigrate_TcDataSetExtract_Post.xml

 set StepN=0
 set StepM=5

REM  set JobMgr_Debug=ON
REM  start "" Explorer "%JobData_DP%"
REM  pause

 set /a StepN=%StepN% + 1
 Echo.
 call Echo "--- #Step:[%StepN%/%StepM%] remigrate: TcExtractData Pre --------------------------------------------"
 call TcExtractData.cmd "%JobData_DP%" "%Status_remigrate_TcDataSetExtract_Pre_DPNE%"

 Echo.
 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] remigrate: Extract Status_remigrate_InpList_DPNE ------------------------"
 call ProcessDataExtract.cmd ":Status_remigrate_InpListGen" "%Status_remigrate_InpList_DPNE%"  "%Status_remigrate_TcDataSetExtract_Pre_DPNE%"

 Echo.
 set /a StepN=%StepN% + 1
 if exist "%Status_remigrate_InpList_DPNE%" (
  call Echo "--- #Step:[%StepN%/%StepM%] remigrate: Execute SetStatus -ls=%CMMType% ---------------------------------"
  call SetStatus.cmd "remigrate" "%Status_remigrate_InpList_DPNE%" "%Status_remigrate_OutList_DPNE%" "%Status_remigrate_OutListErr_DPNE%" "%CMMType%"
 ) else (
  call Echo "--- #Step:[%StepN%/%StepM%] remigrate: Execute SetStatus NOT Processed ------------------------------"
 )

 Echo.
 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] remigrate: TcExtractData for Result Eval --------------------------------"
 call TcExtractData.cmd "%JobData_DP%" "%Status_remigrate_TcDataSetExtract_Post_DPNE%"

 Echo.
 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] remigrate: Result Eval --------------------------------------------------"
 call "ProcessDataEvaluate.cmd" ":Status_remigrate_ResultEval" "%JobData_DP%" "%Status_remigrate_TcDataSetExtract_Post_DPNE%"

 endlocal
goto :end


rem ===========================================================================================
:Execute05_finalChk
 rem #Doc: run's finalCheck
 rem #New: 12.09.2013 / J.Fes
 setlocal

 set JobData_DP=%temp%\JobData_40_finalChk
 set temp=%JobData_DP%
 if not exist "%temp%" md "%temp%"
 cd /d "%temp%"
 set TC_TMP_DIR=%temp%
 set TC_KEEP_SYSTEM_LOG=TRUE

 rem #Doc: in diesem file sind die aus der TC.DB extraierten IR Post infromationen enthalten
 set Status_final_TcDataSetExtract_Prefinal_DPNE=%JobData_DP%\41-Status_finalChk_TcDataSetExtract_Pre.xml
 rem #Doc: in diesem File wird die set status inputliste geschrieben
 set Status_final_InpList_DPNE=%JobData_DP%\42-Status_finalChk_InpList.txt
 rem #Doc: in diesen LogFiles ist der Outpunt des Status programmes
 set Status_final_OutList_DPNE=%JobData_DP%\43-Status_finalChk_OutList.txt
 rem #Doc: in diesen LogFiles ist der Error Outpunt des Status programmes
 set Status_final_OutListERR_DPNE=%JobData_DP%\44-Status_finalChk_OutListErr.txt
 rem #Doc: in diesem file sind die aus der TC.DB extrahierten IR Post infromationen enthalten
 set Status_final_TcDataSetExtract_Postfinal_DPNE=%JobData_DP%\45-Status_finalChk_TcDataSetExtract_Post.xml
 rem #New: 18/12/2014/J.Fes
 rem #Doc: in diesem file sind die aus der TC.DB extrahierten BOM infromationen enthalten
 set Status_final_TcExtract_BOM_Datasets_PostCMM=%JobData_DP%\28-CMM_TcExtract_BOM_Datasets_PostCMM.xml

 set StepN=0
 set StepM=3

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo #Debug:%~0 20.03.2014
  Echo JobData_DP:[%JobData_DP%]
  start "" Explorer "%JobData_DP%"
  pause
 :JumbOverDebug
 
 Echo.
 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] finalChk: TcExtractData for Result Eval ---------------------------------"
 rem #Change 18/12/2014 / J.Fes
 rem #Doc: with P3 = "" no Datasets Data OF BOM will be exported
 rem #Doc: with P4 = "post" Post BOM Data (*.XML) of Process will be exported to JobData_DP
 call TcExtractData.cmd "%JobData_DP%" "%Status_final_TcDataSetExtract_Postfinal_DPNE%" "" "post"

 Echo.
 set /a StepN=%StepN% + 1
 call Echo "--- #Step:[%StepN%/%StepM%] finalChk: Result Eval ---------------------------------------------------"
 call ProcessDataEvaluate.cmd ":finalChk_ResultEval" "%JobData_DP%" "%Status_final_TcDataSetExtract_Postfinal_DPNE%"

 endlocal
goto :end

rem ===========================================================================================
:PrintJobInfo

 set titleProcess_str=Job:[%JobName%][%CMMType%][%Date% %time:~0,5%][%TcSiteId%][\\%ComputerName%]
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  set titleProcess_str=%titleProcess_str%[Degug:ON]
 :JumbOverDebug
 if /i "%JobMgr_TEST%" neq "ON" goto :JumbOverTest
  set titleProcess_str=%titleProcess_str%[Test:ON]
 :JumbOverTest
 title %titleProcess_str%

 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  -----
 banner %RunProcess%
 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  -----
 Echo.                                                                               .
 Echo %titleProcess_str%
 Echo -----------------------------------------------------------------------------------------
 Echo ProcessJob Info:
 Echo JobName...........: %JobName%
 Echo RunProcess........: %RunProcess%
 Echo Computer..........: %ComputerName%
 Echo Process Environ...:
 Echo ProcessDir........: %temp:~-50%
 Echo TcSide............: #TcSite.SiteInfoWith_SiteId_and_pName#
 Echo TcUser............: %JobMgr_TcUser%
 Echo FMS_HOME..........: %FMS_HOME%
 Echo TC_ROOT...........: %TC_ROOT%
 Echo TC_DATA...........: %TC_DATA%
 Echo Start.............: %ProcessTime_Start%
 Echo RunProcess........: %RunProcess%
 Echo CMMType...........: %CMMType%
 Echo -----------------------------------------------------------------------------------------

goto :eof
rem ============================================================================



REM ####### ------------ Standard Subroutines ---------------------- ###########
REM ============================================================================
:JobParam_List
 setlocal
  set ParmListTitle=%~1
  set JobParams=%~2
  rem " ersetzen durch '
  set JobParams=%JobParams:"='%
  set NCur=0
:JobParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%JobParams%") do Call :JobParam_Print "%%i"
  if %NCur% LEQ 10 goto :JobParam_List_PrintNext
 endlocal
 goto :eof

:JobParam_Print
 setlocal
  set JobParaCur=%~1
  if "%NCur%" equ "1" (
                            Echo %ParmListTitle% -%JobParaCur%
  ) else (
   if "%JobParaCur%" neq "" Echo                     : -%JobParaCur%
  )
 endlocal
 goto :eof

REM ============================================================================
:ErrLogHeaderWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ErrLogFooterWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo.>>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
 Echo.>>"%ErrLog_DPNE%"
 Echo -- Path Environ ---------------------------------------------------------->>"%ErrLog_DPNE%"
 set PATH>>"%ErrLog_DPNE%"

 Echo -- UG* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set UG>>"%ErrLog_DPNE%"
 Echo -- IMAN* Environ --------------------------------------------------------->>"%ErrLog_DPNE%"
 set IMAN>>"%ErrLog_DPNE%"
 Echo -- All Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set>>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
  Echo Description.......: %FileDescription%
  Echo Contens of File...: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo Info...........: File not exist
 endlocal
 goto :eof

REM ============================================================================
:Wait
 set waitTime=2
 if "%1" neq "" set waitTime=%1
 CHOICE.exe /C:w /N /T:w,%waitTime% "warte %waitTime%[sec] oder [w] druecken fuer weiter: "
 goto :eof

REM ============================================================================
:Parse_ALL
 REM parst alle File Bezeichner aus
 REM "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 REM "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof



REM ============================================================================
:end
