@Echo off

 Echo **************************************************************************
 Echo * Excuting CMM Script in PLMJobManager Environ                           *
 Echo * Version: 0.9  addPLM GmbH  25.09.2013 (c)                              *
 Echo **************************************************************************

 REM ===========================================================================
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   24.11.2006 00:05   Ersterstellung 25.09.2013 19:01
 REM ===========================================================================

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 set JobMgr_TcDBSID=%~3
 set JobMgr_TCDBUsr=%~4
 set JobMgr_TCDBPw=%~5

 REM -- Basiseinstellungen fuer das Verhalten es Scriptes ----------------------
 rem File:[#JobName#_ObjectsList.txt]
 set JobAddFile_ObjectsList_txt=false
 rem No File:[#JobName#_ObjectsListAllDetails.txt]
 set JobAddFile_ObjectsListAllDetails_txt=false

 REM use WatchDog [default=ON]
 set JobMgr_use_PlmJobManagerWatchDog=ON

 REM use JobMgr_use_TcServerKill [default=OFF]
 set JobMgr_use_TcServerKill=OFF

 REM Debug: [bei Einzel Test's auf=ON] [sonst auf OFF stellen]
 set JobMgr_Debug=OFF
 REM -- JobScriptParametersExtended:
 REM    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen leer
 REM             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt auch leer ist
 #JobScriptParametersExtended#

 REM Steuert Verhalten wenn ein Error aufgetreten ist [ON=Anhalten] [OFF=automatisch weiter arbeiten!]
 REM allgemein einstellen wie JobMgr_Debug [default=%JobMgr_Debug%]
 set JobMgr_OnErrorShowResultOnClient=%JobMgr_Debug%
 REM set JobMgr_OnErrorShowResultOnClient=ON
 
 REM Disk Connect [default=OFF]
 rem 24.01.2014 16:00 / Laufwerk Verb. deaktiviert
 set JobMgr_use_DiskConnect=OFF

 REM -- #Step: Farbe setzen IsIdel
 Call ColorSet.cmd IsIdel

 REM -- Rootpfade setzen -------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%
 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"

 REM -- JobServer Variablen ----------------------------------------------------
 set JobManagerRoot_DP=#00-ApplRoot_DP#
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#

 REM -- JobData ----------------------------------------------------------------
 set JobScripts_DP=#10-JobScripts_DP#
 set JobName=#JobName#
 set JobPacket_NE=#JobPacket_NE#
 set JobParameter=#JobParameter#

 set DataRoot_CustomWorkInst_DP=#DataRoot_CustomWorkInst_DP#

 REM -- uebergabe SiteDef ------------------------------------------------------
 set TcSiteId=#TcSiteId#

 set title_str=[%JobName%][%CMMType%][%Date% %time:~0,5%][%TcSiteId%][\\%ComputerName%]
 title %title_str%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Debug:%JobMgr_Debug%
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
 :JumbOver
 if /i "%JobMgr_Debug%" neq "xON" goto :JumbOver
   pause
   Echo #Debug....: Start Explorer
   Echo at JobDir.: [%CmdCurRoot_DP%]
   start "" Explorer "%CmdCurRoot_DP%"
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
:JumbOver

 if "%JobMgr_use_DiskConnect%" neq "ON" goto :jumbOverDiskConnect
  REM -- Optional # Laufwerk verbinden !! -------------------------------------
  REM Netzwerklaufwerke richtig verbinden
  set ConnectNetUnc_to_Info=L: \\ww004.siemens.net\bu05$\proj\MOVE2NX
  call ConnectNetUnc.cmd "Ugsshare" L: \\ww004.siemens.net\bu05$\proj\MOVE2NX . . PLMshare_LWL_DiskConStat
  Echo Connect Laufwerk:%ConnectNetUnc_to_Info% Status:"%PLMshare_LWL_DiskConStat%"
  if /I not "%PLMshare_LWL_DiskConStat%" equ "OK" goto :PLMshare_DiskConnectErr

  set ConnectNetUnc_to_Info=S: \\demchtcvq01.ww500.siemens.net\tcshare\TC_INSTALL_WIN
  call ConnectNetUnc.cmd "Ugsshare" S: \\demchtcvq01.ww500.siemens.net\tcshare\TC_INSTALL_WIN . . PLMshare_LWS_DiskConStat
  Echo Connect Laufwerk:%ConnectNetUnc_to_Info% Status:"%PLMshare_LWS_DiskConStat%"
  if /I not "%PLMshare_LWS_DiskConStat%" equ "OK" goto :PLMshare_DiskConnectErr

  set ConnectNetUnc_to_Info=Y: \\demchtcvq01.ww500.siemens.net\tcshare
  call ConnectNetUnc.cmd "Ugsshare" Y: \\demchtcvq01.ww500.siemens.net\tcshare . . PLMshare_LWY_DiskConStat
  Echo Connect Laufwerk:%ConnectNetUnc_to_Info% Status:"%PLMshare_LWY_DiskConStat%"
  if /I not "%PLMshare_LWY_DiskConStat%" equ "OK" goto :PLMshare_DiskConnectErr

:jumbOverDiskConnect


 REM -- temp dir Organiesieren -------------------------------------------------
 set tempOrig_DP=%temp%
 set temp=%CmdCurRoot_DP%

 Echo --------------------------------------------------------------------------
 Echo Info: Executing TcPrompt to get "Tc-Environment"

 REM #Doc: SetUp TcPrompt
 if /i "#TcSiteId#" neq "TCP010" goto :JumbOver_TCP010
   rem Tc - Prompt for GERMANY
   set AppRoot_D=E:
   if not exist "%AppRoot_D%\Tc_DATA\tc9_data" set AppRoot_D=D:
   if not exist "%AppRoot_D%\Tc_DATA\tc9_data" set AppRoot_D=C:
   rem 13.01.2014 13:14/J.Fes angepasst von tc8.3 auf tc9
   if not defined TC_DATA set TC_DATA=%AppRoot_D%\Tc_DATA\tc9_data
   if not defined TC_ROOT set TC_ROOT=%AppRoot_D%\TC_App\tc9
   set TcPromtCmd=%TC_DATA%\tc_profilevars.bat
   set TcPromtCmdOpt=
:JumbOver_TCP010

REM #Doc: SetUp TcPrompt
 if /i "#TcSiteId#" neq "TCY020" goto :JumbOver_TCY020
   rem Tc - Prompt for GERMANY
   set AppRoot_D=E:
   if not exist "%AppRoot_D%\Tc_DATA\tc9_data" set AppRoot_D=D:
   if not exist "%AppRoot_D%\Tc_DATA\tc9_data" set AppRoot_D=C:
   rem 10.03.2014 S.Gueth angepasst
   if not defined TC_DATA set TC_DATA=%AppRoot_D%\Tc_DATA\tc9_data
   if not defined TC_ROOT set TC_ROOT=%AppRoot_D%\TC_Appl\tc9
   set TcPromtCmd=%TC_DATA%\tc_profilevars.bat
   set TcPromtCmdOpt=
:JumbOver_TCY020

 if /i "%JobMgr_Debug%" neq "xON" goto :JumbOver
  Echo #Debug:
  Echo befor excuting:
  Echo JobMgr_TcUser.: [%JobMgr_TcUser%/%JobMgr_TcPW%]
  Echo TcPromtCmd....: [%TcPromtCmd%]
  Echo TcPromtCmdOpt.: [%TcPromtCmdOpt%]
  pause
:JumbOver

 if     exist "%TcPromtCmd%" call "%TcPromtCmd%" %TcPromtCmdOpt%
 if not exist "%TcPromtCmd%" goto :TcPromtCmdError

 if /i "%JobMgr_Debug%" neq "xON" goto :JumbOver
  Echo #Debug:
  Echo after excuting:
  Echo TcPromtCmd....: [%TcPromtCmd%]
  Echo TcPromtCmdOpt.: [%TcPromtCmdOpt%]
  Echo FMS_HOME......: [%FMS_HOME%]
  pause
:JumbOver

 REM -- PathVariable erweitern
 set path=%CmdCurRoot_DP%;%BinPublic_Custom_DP%;%BinPublic_ClientServer_DP%;%BinPublic_DP%;%Path%

 REM -- Option: Control software starten ---------------------------------------
 if /I "%JobMgr_use_PlmJobManagerWatchDog%" neq "ON"  goto :JumbOver
   Echo --------------------------------------------------------------------------
   pushd "%tempOrig_DP%"
   robocopy /NP /NJS /NJH /NDL /NFL /R:2 /W:2 "%BinPublic_DP%" "%BinL_DP%" "PlmJobManagerWatchDog.exe"
   call "ProgStart_If_NotRuning.cmd" "PlmJobManagerWatchDog" "%BinL_DP%\PlmJobManagerWatchDog.exe"
   popd
:JumbOver

 Call "%CmdCurRoot_DP%\MigIdeas2NxExecute.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"
 if /i "%JobMgr_Debug%" equ "ON" goto :JumbIn
 if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
  :JumbIn
  Echo -------------------------------------------------------------------------
  Echo after excuting Job
  Echo MigIdeas2NxExecute.cmd: [%CmdCurRoot_DP%\MigIdeas2NxExecute.cmd]
  Echo -------------------------------------------------------------------------
  pause
:JumbOver

goto :end


REM ###### ------------ Standard Subroutines ---------------------- ##########
REM ============================================================================
:TcPromtCmdError
 Call ColorSet.cmd ERR
 set ErrLog_DPNE=%temp%\__Err_MissingTcPromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start refile on:\\%ComputerName% missing TcPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TcPromtCmd:=%TcPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
 goto :end


REM ============================================================================
:ErrLogHeaderWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ErrLogFooterWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo.>>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
 Echo.>>"%ErrLog_DPNE%"
 Echo -- Path Environ ---------------------------------------------------------->>"%ErrLog_DPNE%"
 set PATH>>"%ErrLog_DPNE%"

 Echo -- UG* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set UG>>"%ErrLog_DPNE%"
 Echo -- IMAN* Environ --------------------------------------------------------->>"%ErrLog_DPNE%"
 set IMAN>>"%ErrLog_DPNE%"
 Echo -- All Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set>>"%ErrLog_DPNE%"
 goto :eof



REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
  Echo Description    : %FileDescription%
  Echo Contens of File: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo Info...........: File not exist
 endlocal
 goto :eof

REM ============================================================================
:Wait
 set waitTime=2
 if "%1" neq "" set waitTime=%1
 CHOICE.exe /C:w /N /T:w,%waitTime% "warte %waitTime%[sec] oder [w] druecken fuer weiter: "
 goto :eof

REM ============================================================================ 
:Parse_ALL
 REM parst alle File Bezeichner aus
 REM "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 REM "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof 

REM ============================================================================
:PLMshare_DiskConnectErr
 set ErrLog_DPNE=%temp%\__Err_Ugsshare_DiskConnect.txt
 REM schreibt die erweiterten Infos an einen ErrLogFile
 Echo Err: erf. Netzwerkverb. fuer: %TcSiteId% [%ConnectNetUnc_to_Info%] konnte nicht richtig verbunden werden!!>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 type "%ErrLog_DPNE%"
 Echo !!Einstellungen oder Netzwerkverbindungen pruefen!!
 cmd 
 Pause
 goto :eof

REM ============================================================================
:end
 cd /d "%tempOrig_DP%"
 Echo --------------------------------------------------------------------------
 Echo Info: all files in: [%temp%]
 Echo       will be zipt by JobClient and send to JobServer
 REM -- farbe wieder auf standard zurueck setzen
 Call ColorSet.cmd End
