:CMM_Execute

setlocal
rem ----------------------------------------------------------------------------
rem Script to control CMM Process
REM  #Doc: 21/01/2014 / J.Fes toMon angepasst
rem ----------------------------------------------------------------------------

 set CMMJobRoot_DP=%~1
 set selection_xml_DPNE_p=%~2
 set RUN_IN_DIR=%CMMJobRoot_DP%\CMMTmp
 set configuration_DP=%RUN_IN_DIR%\configuration
 set CMM_BATCH_XML_LOGIN_FILE=%configuration_DP%\cmm_login.xml

 set CMMEnv_DPNE=%CMMJobRoot_DP%\23-CMM_RunEnv.txt
 set CMMDefLog_DPNE=%CMMJobRoot_DP%\24-CMM_RunDefLog.txt
 set CMMErrLog_DPNE=%CMMJobRoot_DP%\25-CMM_RunErrLog.txt
 set CMMLogSearch_DPNE=%RUN_IN_DIR%\*_cmm.log

 REM -- define ProcPara ----------------------------------------------------------
 rem Process Parameter
 set ProcPara=#JobParameter#

 set CMM_SERVER_NAME=%COMPUTERNAME%
 rem 13.01.2014/J.Fes change from CMM755 to:CMM852
 set CMM_BASE_DIR=E:\Tc_APPL\CMM852

 REM -- #Doc define BASE_DIR
 set BASE_DIR=%CMM_BASE_DIR%

 if not exist "%RUN_IN_DIR%" md "%RUN_IN_DIR%"
 if not exist "%configuration_DP%" md "%configuration_DP%"

 call "%BASE_DIR%\Config\cmmConfig.cmd"
 if exist "%CMM_BASE_DIR%\Config\cmmConfig.xml" (
    goto :cmmBaseDirValidated
 ) else (
  echo Error............: CMM Config file not found
  echo Error............: %CMM_BASE_DIR%\Config\cmmConfig.xml
    pause
    goto :END_SCRIPT
 )

:cmmBaseDirValidated
 set IPR=E:\Tc_APPL\tc9\portal
 set TPR=E:\Tc_APPL\tc9\portal
 rem set TPR=%IPR%
 if not defined FMS_HOME set FMS_HOME=%TC_ROOT%\fcc
 set PATH=%FMS_HOME%\bin;%FMS_HOME%\lib;%TPR%;%PATH%
 set JAVA_HOME=%IPR%\jre

 REM -- #Step: copy configuration directory to temp directory von _7. auf _8. angepasst
 set config_ini_S_DPNE=%TPR%\plugins\com.teamcenter.rac.addcmmbatch_8.0.0\configuration\config.ini
 set config_ini_D_DPNE=%configuration_DP%\config.ini
 set toRun=copy /Y "%config_ini_S_DPNE%" "%config_ini_D_DPNE%"
 Echo Info..............: copy config.ini
 Echo from..............: [%config_ini_S_DPNE%]
 Echo to................: [%config_ini_D_DPNE%]
  %toRun% >nul 2>nul

 if exist "%config_ini_D_DPNE%" (
  Echo Copy Done.........: [config.ini:OK]
 ) else (
  echo Error copying config.ini
  Echo to................: [%config_ini_D_DPNE%]
  Echo Action will be....: - aborting.
  pause
  goto :END_SCRIPT
 )

 REM -- #Step: start_imr.bat
 cd /d "%IPR%\temp"
 set IMAN_ROOT=E:\Tc_APPL\tc9
 call ProgIs_Running.cmd ImplRepo_Service ImplRepo_Service_Is_running
 if "%ImplRepo_Service_Is_running%" neq "0" goto :JumbOver_StartImplRepo_Service
  rem E:\Tc_APPL\tc9\iiopservers\start_imr.bat
  set toRun=start "ImplRepo Service:[%Date% %time:~0,8%]" cmd /c "%IMAN_ROOT%\iiopservers\start_imr.bat"
  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   Echo #Debug:%~0 [bevor Start toRun]
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
   pause
  :JumbOverDebug
  Echo ImplRepo_Service..: Sleep [10 sec] after Start ImplRepo_Service
  %toRun%
 ping localhost -n 10 >>nul
:JumbOver_StartImplRepo_Service


 REM -- #Step: start_portal
:start_portal
 set JRE_HOME=%IMAN_ROOT%\portal\jre
 set JAVA_HOME=%IMAN_ROOT%\portal\jre
 set TPR=%IMAN_ROOT%\portal

 cd /d "%RUN_IN_DIR%"
 echo CMM RUN_IN_DIR....: [%RUN_IN_DIR%]

 rem -- #Doc: 09.10.2013 / J.Fes Org CmmOption Files -------------------------------------
 rem cmmOptions Dir of Job
 set cmmOptionsXML_DP=%CmdCurRoot_DP%\settingsCMM
 rem #Doc: default CMM Option file 24.01.2014
 set CMM_BATCH_OPTIONS_FILE=%cmmOptionsXML_DP%\cmmOptions_02_timeout_No.xml
 rem #Doc: look if other option file is to be used example: cmmOptions_02_timeout_0.xml
 rem #Doc: see config JS/ set cmmOptionsXML_NE=cmmOptions_02_timeout_0.xml
 if defined cmmOptionsXML_NE if exist "%cmmOptionsXML_DP%\%cmmOptionsXML_NE%" set CMM_BATCH_OPTIONS_FILE=%cmmOptionsXML_DP%\%cmmOptionsXML_NE%

 rem -- Step gen CMM_BATCH_XML_LOGIN_FILE
 call CMMLoginGen "%CMM_BATCH_XML_LOGIN_FILE%" "%JobMgr_TcUser%" "%JobMgr_TcPw%" "dba" "DBA" "TcServer1"

 set CMM_VMARGS=-Djava.io.tmpdir=%RUN_IN_DIR%
 set ECLIPSE_VMARGS=-Dosgi.configuration.area=%RUN_IN_DIR%\configuration -Djava.awt.headless=true

 set toRun=%JAVA_HOME%\bin\java
 set toRun=%toRun% -Xms256m
REM  set toRun=%toRun% -Xmx1300m
rem 20.01.2014/angepasst wegen Java HeapSpace ERR
rem set toRun=%toRun% -Xmx2048m
rem 21.01.2014 11:29/angepasst naechst hoeherer Wert
 set toRun=%toRun% -Xmx4096m
 set toRun=%toRun% -DCMMBaseDir=%CMM_BASE_DIR%
 set toRun=%toRun% -DTC_PORTAL_ROOT=%TPR%
 set toRun=%toRun% %ECLIPSE_VMARGS%
 set toRun=%toRun% %CMM_VMARGS%
 set toRun=%toRun% -jar %TPR%\plugins\org.eclipse.equinox.launcher_1.1.0.v20100507.jar.

 set toRun=%toRun% -mode migrate
 set toRun=%toRun% -datatype i
 set toRun=%toRun% -selection %selection_xml_DPNE_p%
 set toRun=%toRun% -login %CMM_BATCH_XML_LOGIN_FILE%
 set toRun=%toRun% -options %CMM_BATCH_OPTIONS_FILE%
 set toRun=%toRun% -runindir %RUN_IN_DIR%
 set toRun=%toRun% "%RUN_IN_DIR%"


 rem -- #Doc: 11.10.2013 / J.Fes Org ProcessMonitor --------------------------------------
 rem Monitors java for cmm
 set toMon="%JFProcessMonitorL_exe%"
 set toMon=%toMon% -w 50000
 set toMon=%toMon% --n java
 set toMon=%toMon% --parentProcessId 0
 if defined CMMOpt_PMon set toMon=%toMon% %CMMOpt_PMon%
 set toMon=%toMon% --killChildProcesses
 rem  - mit max 10 Std ohne das neue files im JobTemp entstehen oder editiert werden
 set toMon=%toMon% --fileLastWriteTime "%RUN_IN_DIR%\*.*;6000"
 set toMon=%toMon% --saveResultsTo "%temp%\zzProcessMonitor_log.xml"
REM  set toMon=%toMon% --tailTextFile "%CMMDefLog_DPNE%"
 set toMon=%toMon% --tailTextFile "%CMMLogSearch_DPNE%"
 rem new 29.01.2014
 set toMon=%toMon% --titlePrefix  "Job:[%JobName%][%date% %time:~0,5%]"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo #Debug............: %~0
  Echo bevor Run.........: %toRun%
  set toRunForPrint=%toRun:"=%
  call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
  Echo bevor toMon.......: %toMon%
  set toMonForPrint=%toMon:"=%
  call Echo " %~0 toMon:%toMonForPrint% " "" "NOECHO"
  pause
:JumbOverDebug

 set >>"%CMMEnv_DPNE%"
 Call ColorSet.cmd IsExecuting
 Echo.
 Echo .........................................................................................
 Echo CMM Start.........: %date% %time:~0,8%
 Echo CMM_OPTIONS_FILE..: %CMM_BATCH_OPTIONS_FILE%
 Echo see OutP.File.....:
 Echo CMMDefLog_DPNE....: %CMMDefLog_DPNE%
 Echo CMMErrLog_DPNE....: %CMMErrLog_DPNE%
 Echo ----------------------------------------------------------------------------------------->>"%CMMDefLog_DPNE%"
 start "JFPMon" /min %toMon%
 Echo CMMDefLog_DPNE....: CMM_Execute %~0 >>"%CMMDefLog_DPNE%"
 Echo CMM Start.........: %date% %time:~0,8% >>"%CMMDefLog_DPNE%"
 call %toRun% >>"%CMMDefLog_DPNE%" 2>>"%CMMErrLog_DPNE%"
 set CMM_JM_IdeasMoveToNx_errorlevel=%errorlevel%
 Echo ----------------------------------------------------------------------------------------->>"%CMMDefLog_DPNE%"
 Echo Ende..............: %date% %time:~0,8% >>"%CMMDefLog_DPNE%"

 call ColorSet.cmd IsIdel

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo #Debug:%~0 [after torun]
  pause
:JumbOverDebug

:END_SCRIPT
 rem cleanUP conf. DIR
 if exist "%configuration_DP%" rd /s /q "%configuration_DP%"
 rem cleanUp *.xml new 22/01/2014 J.Fes
 if exist "%RUN_IN_DIR%\*opt.xml" del "%RUN_IN_DIR%\*.xml","%RUN_IN_DIR%\*.xsl","%RUN_IN_DIR%\batLog.txt"

endlocal& set CMM_JM_IdeasMoveToNx_errorlevel=%CMM_JM_IdeasMoveToNx_errorlevel%
goto :end

REM ============================================================================
:fccCheck
 rem #New 28.06.2013 J.Fes
 call fccstat -status>"%temp%\zzfcc1Status.log"
 set tc_fccstatus=%errorlevel%

 if "%tc_fccstatus%" equ "0" goto :fccStartOk

  rem jetzt fcc starten
  call fccstat -start>"%temp%\zzfcc2Start.log"

  rem fcc preufung nach start
  call fccstat -status>"%temp%\zzfcc3Status.log"
  set tc_fccstatus=%errorlevel%

  if "%tc_fccstatus%" equ "0" goto :fccStartOk

  Call ColorSet.cmd ERR
  rem der fcc kann nicht gestartet werden dann Prozess anhalten
  Echo - - - - - - - - - - - - - - - - - - - - - -
  Echo Error fcc cannot be started
  Echo.
  Echo --- Content of fcc zzfcc1Status.log ---
  type "%temp%\zzfcc1Status.log"
  Echo --- Content of fcc zzfcc2Start.log ----
  type "%temp%\zzfcc2Start.log"
  Echo --- Content of fcc zzfcc3Status.log ---
  type "%temp%\zzfcc3Status.log"
  Echo.
  Echo Please check installation and configuration
  Echo !! -- Job not done -- !!
  Echo - - - - - - - - - - - - - - - - - - - - - -
  pause
  Exit

 :fccStartOk
  del "%temp%\zzfcc1Status.log"
  Echo fcc check:OK on \\%ComputerName%

goto :eof

REM ===========================================================================================
:FMS_HOME_ERR
 Call ColorSet.cmd ERR
 set ErrLog_DPNE=%temp%\__Err_FMS_HOME_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start Process on:\\%ComputerName%  FMS_HOME:[%FMS_HOME%] Dir Not found [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo -----------------------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo FMS_HOME Dir not foundFMS_HOME:[%FMS_HOME%] Dir Not found >>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 REM if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
 goto :end

REM ============================================================================
:Process_program_exe_DPNE_Error
 Call ColorSet.cmd ERR
 set ErrLog_DPNE=%temp%\__Err_Missing_Process_Program.Exe_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start Process on: [\\%ComputerName%] missing Process_program.exe [%Date%/%time:~0,8%] !!
 call :ErrLogHeaderWrite
 title %title_str%
 Echo -----------------------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 REM Error in die Datei schreiben!
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo Process_program_exe_DPNE:=%Process_program_exe_DPNE%>>%temp%\__ErrorUp-ReadMeFirst-DeaktivateComputer.txt>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite

 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
 goto :end

 REM ==========================================================================================
:ProcessProgramResultErr
 Call ColorSet.cmd ERR
 set ErrLog_DPNE=%temp%\__Err_ProcessProgramResultErr.txt
 set title_str=ERR:%ProcessProgramResultLevel% !! error running ugmanager_Process_program.exe [%Date%/%time:~0,8%] !!
 title %title_str%
 call :ErrLogHeaderWrite
 Echo -----------------------------------------------------------------------------------------
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo Process Prog        : %Process_program_exe_DPNE%>>"%ErrLog_DPNE%"
 Echo ends with Err Level : %ProcessProgramResultLevel% >>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite

 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /I "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 pause
 goto :end

rem - - - - - -
 rem cmd ends
:end
