<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:rxl="http://www.plmxml.org/Schemas/ReportXMLSchema"
  xmlns:oxl="http://www.plmxml.org/Schemas/MigrationOptionsXML"
  xmlns:java="com.ugsolutions.ideasnxmigration.migrationmanager.util.helper.XSLServices">
  
  <xsl:import href="cmmstyle.xsl" />

  <xsl:output encoding="UTF-8" indent="yes" method="html"/>

  <!-- ******************************************************** -->
  <!-- Some GLOBAL variables -->

  <xsl:variable name="indentFactor">5</xsl:variable>

  <!-- ******************************************************** -->
  <!-- Start generating the FIDELITY Report -->

  <xsl:template match="/">
    <xsl:apply-templates />
  </xsl:template>

  <!-- ******************************************************** -->
  <!-- Template to match top level element in report file. -->

  <xsl:template match="oxl:MigrationOptions">
    
    <html>      
      <body>
        <xsl:attribute name="style"><xsl:value-of select="$bodystyle"/></xsl:attribute>
        <xsl:call-template name="rxl:Body"/>
      </body>
    </html>
  </xsl:template>

  <!-- ******************************************************** -->
  <!-- Generate the body report html -->

  <xsl:template name="rxl:Body" >
    
    <xsl:call-template name="oxl:ListMigrationOptions" />
    
    
  </xsl:template>


  <!-- ********************************************************-->
  <!-- Generate the options sections withing the seesion section -->

  <xsl:template name="oxl:ListMigrationOptions">
    <xsl:param name="pNestLevel" select="1" />
    <!-- Get the options file -->
    <h2>
      <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
      <xsl:choose>
        <xsl:when test="function-available('java:getUiString')">
          <xsl:value-of select="java:getUiString( 'Options.TopLevelGroup')"/>
        </xsl:when>
        <xsl:otherwise>
          Options
        </xsl:otherwise>
      </xsl:choose>
      <hr/>
    </h2>
    <xsl:for-each select="//oxl:MigrationOptions">
      <xsl:call-template name="oxl:Group">
        <xsl:with-param name="pNestLevel" select="$pNestLevel"/>
      </xsl:call-template>
    </xsl:for-each>
    <br/>
  </xsl:template>
  

  <!-- ******************************************************** -->
  <!-- Generate the migration import report html                -->
  <xsl:template name="oxl:Group">
    <xsl:param name='pNestLevel'/>
    
    <xsl:for-each select="./oxl:Group">
      <xsl:element name="div">
        <xsl:attribute name="style">margin-left:<xsl:value-of select="$pNestLevel*$indentFactor" />
        </xsl:attribute>
        <b>
          <xsl:attribute name="style"><xsl:value-of select="$h3style"/></xsl:attribute>
          <xsl:choose>
            <xsl:when test="@unique and function-available('java:getGroupName')">       
              <xsl:value-of select="java:getGroupName(@unique)" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="@name" />
            </xsl:otherwise>
          </xsl:choose>  
        </b>
        <xsl:call-template name="oxl:Option">
          <xsl:with-param name="pNestLevel" select="$pNestLevel + 1"/>
        </xsl:call-template>
        <xsl:call-template name="oxl:Group">
          <xsl:with-param name="pNestLevel" select="$pNestLevel + 1"/>
        </xsl:call-template>
      </xsl:element>
    </xsl:for-each>
    
    
  </xsl:template>

  <!-- ******************************************************** -->
  <!-- Generate the migration import report html                -->
  <xsl:template name="oxl:Option">
    <xsl:param name='pNestLevel'/>

    <xsl:if test="./oxl:Option">
      <table>
        <xsl:attribute name="width">95%</xsl:attribute>
        <xsl:attribute name="cellpadding">2</xsl:attribute>
        <tr>
          <td align="center" style="font-weight:bold">
            <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
            <xsl:choose>
              <xsl:when test="function-available('java:getUiString')">
                <xsl:value-of select="java:getUiString( 'Options.NameColumn')"/>
              </xsl:when>
              <xsl:otherwise>
                Name
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td align="center" style="font-weight:bold">
            <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
            <xsl:choose>
              <xsl:when test="function-available('java:getUiString')">
                <xsl:value-of select="java:getUiString( 'Options.ValueColumn')"/>
              </xsl:when>
              <xsl:otherwise>
                Value
              </xsl:otherwise>
            </xsl:choose>
          </td>          
        </tr>
        
        <xsl:for-each select="./oxl:Option">
          <xsl:choose>
            <xsl:when test="@application='Native'">
            </xsl:when>
            <xsl:when test="@isVisible='false'">
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="oxl:PrintValue" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
        
      </table>
      
    </xsl:if>
    
  </xsl:template>
  
  <!-- ******************************************************** -->
  <!-- Generate the migration import report html                -->
  <xsl:template name="oxl:PrintValue">
    <tr>
      <td align="center">
        <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
        <xsl:choose>
          <xsl:when test="function-available('java:getOptionName')">
            <xsl:value-of select="java:getOptionName(@unique)"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:value-of select="@name" />
          </xsl:otherwise>
        </xsl:choose>        
      </td>
      <td align="center">
        <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
        <xsl:choose>
          <xsl:when test="@type='enum' and function-available('java:getOptionValueName')">
            <xsl:value-of select="java:getOptionValueName(@unique, @value )" />
          </xsl:when>
          <xsl:when test="@type='boolean' and @value='true' and function-available('java:getUiString')">
            <xsl:value-of select="java:getUiString('Options.Value.True' )" />
          </xsl:when>
          <xsl:when test="@type='boolean' and @value='false' and function-available('java:getUiString')">
            <xsl:value-of select="java:getUiString('Options.Value.False' )" />
          </xsl:when>
          <xsl:otherwise>                     
             <xsl:value-of select="@value" />
          </xsl:otherwise> 
        </xsl:choose> 
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>

 
