<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:rxl="http://www.plmxml.org/Schemas/ReportXMLSchema"
  xmlns:oxl="http://www.plmxml.org/Schemas/MigrationOptionsXML">

  <xsl:output
    encoding="UTF-8"
    indent="yes"
    method="html" />

  <xsl:template match="/">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="MigratedItems">

    <html>
      <body>
        <xsl:call-template name="ItemTable" />
      </body>
    </html>
  </xsl:template>

  <xsl:template name="ItemTable">
    <table>
      <xsl:attribute name="width">95%</xsl:attribute>
      <xsl:attribute name="cellpadding">1</xsl:attribute>

      <thead>
        <tr  style="font-weight:bold">
          <td>
            <xsl:value-of select="'Item'" />
          </td>
          <td>
            <xsl:value-of select="'Rev'" />
          </td>
          <td>
            <xsl:value-of select="'Name'" />
          </td>
          <td>
            <xsl:value-of select="'Type'" />
          </td>
          <td>
            <xsl:value-of select="'Status'" />
          </td>
          <td>
            <xsl:value-of select="'Report'" />
          </td>
          <td>
            <xsl:value-of select="'Options'" />
          </td>
          <td>
            <xsl:value-of select="'NX Part'" />
          </td>
        </tr>
      </thead>
      <xsl:for-each select="//Item">
        <tr>
          <td>
            <xsl:value-of select="@ItemId" />
          </td>
          <td>
            <xsl:value-of select="@Revision" />
          </td>
          <td>
            <xsl:value-of select="@Name" />
          </td>
          <td>
            <xsl:value-of select="@Type" />
          </td>
          <td>
            <xsl:value-of select="@Status" />
          </td>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="@CMMReportFile" />
              </xsl:attribute>
              <xsl:value-of select="'Report'" />
            </a>
          </td>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="@CMMOptionsFile" />
              </xsl:attribute>
              <xsl:value-of select="'Options'" />
            </a>
          </td>
          <td>
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="@NXPartFile" />
              </xsl:attribute>
              <xsl:value-of select="'NX Part'" />
            </a>
          </td>
        </tr>
      </xsl:for-each>
    </table>
  </xsl:template>
</xsl:stylesheet>