<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:rxl="http://www.plmxml.org/Schemas/ReportXMLSchema">
  
  <xsl:output encoding="UTF-8" indent="yes" method="html"/>

  <!-- ******************************************************** -->
  <!-- Style settings -->

  <xsl:variable name="failure_color">red</xsl:variable>
  <xsl:variable name="warning_color">yellow</xsl:variable>
  <xsl:variable name="quarantined_color">orange</xsl:variable>
  
  <xsl:variable name="bodystyle">
    font-size:100%;
    margin-left:3%;
    margin-right:3%;
    color:black;
    background:#F8F8FF;
  </xsl:variable>
  
  <xsl:variable name="h1style">
    font-size: 125%;
    align: center;
    font-weight: bold;
    margin-left: 1%; 
    color: #00008B;
  </xsl:variable>
  
  <xsl:variable name="h2style">
    font-size: 110%;
    align: left;
    margin-left: 1%; 
    font-weight: bold;
    color: #00008B;
  </xsl:variable>

  <xsl:variable name="h3style"> 
    font-size: 100%;
    align: left;
    font-weight: bold;
    color: #000066;
  </xsl:variable>
  
  <xsl:variable name="tableitemstyle">
    frame: border;
    font-weight: bold;
    font-size: 100%;
    background: #D1D8F0;
    border-width:1;
    cellpadding:2;
  </xsl:variable>

  <xsl:variable name="tbodyitemstyle">
    font-size: 100%;
    background:#EAE9FE;
    border-width:1;
    cellpadding:2;
  </xsl:variable>

  <!-- ******************************************************** -->
  <!-- Some GLOBAL variables -->

  <xsl:variable name="indentFactor">20</xsl:variable>
  <xsl:variable name="severityMark">0</xsl:variable>

  <!-- ******************************************************** -->
  <!-- Start generating the Default Report -->

  <xsl:template match="/">
    <xsl:apply-templates />
  </xsl:template>

  <!-- ******************************************************** -->
  <!-- Template to match top level element in report file. -->

  <xsl:template match="rxl:MigrationReport">
    
    <html>      
      <body>
        <xsl:attribute name="style"><xsl:value-of select="$bodystyle"/></xsl:attribute>
        <h1>
          <xsl:attribute name="style">
            <xsl:value-of select="$h1style"/>
          </xsl:attribute>
          Migration Report
        </h1>

        <table>
          <xsl:attribute name="style">
            margin-left:<xsl:value-of select="$indentFactor" />
          </xsl:attribute>
          <xsl:attribute name="width">80%</xsl:attribute>
          <xsl:attribute name="cellpadding">2</xsl:attribute>
          
          <thead>
            <tr>
              <td align="center" style="font-weight:bold">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
                <a href="#ItemSummary">Item Summary</a>
              </td>
              <td align="center" style="font-weight:bold">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
                <a href="#ItemDetails">Item Details</a>
              </td>
              <td align="center" style="font-weight:bold">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
                <a href="#ItemFidelity">Item Fidelity</a>
              </td>
              <td align="center" style="font-weight:bold">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
                <a href="#SystemAudit">System Audit</a>
              </td>
            </tr>
          </thead>
        </table>
        
        <xsl:call-template name="rxl:Body"/>
      </body>
    </html>
  </xsl:template>
  
  <!-- ******************************************************** -->
  <!-- Generate the body report html -->

  <xsl:template name="rxl:Body" >
    
    <xsl:call-template name="rxl:ItemDescription" />

    <xsl:call-template name="rxl:SummaryHighLevelTotal" />

    <xsl:call-template name="rxl:OperationStatus" />

    <xsl:call-template name="rxl:Stats" />

    <xsl:call-template name="rxl:MigrationDetails" />

    <xsl:call-template name="rxl:FidelityStats" />

    <xsl:call-template name="rxl:SystemAudit" />

    <xsl:call-template name="rxl:UserData" />

    <xsl:call-template name="rxl:LogFiles" />
  
  </xsl:template>


  <!-- *********************************************************** -->
  <!-- Shows the Item name, number, revision and type              -->

  <xsl:template name="rxl:ItemDescription">

    <xsl:if test="//rxl:Session/rxl:Input">

      <h2>
        <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
        <hr/>
        Item Description
      </h2>
      
      <xsl:for-each select="//rxl:Session/rxl:Input">
        
        <table>
          <xsl:attribute name="style">
            margin-left:<xsl:value-of select="$indentFactor" />
          </xsl:attribute>
          <xsl:attribute name="width">60%</xsl:attribute>
          <xsl:attribute name="cellpadding">1</xsl:attribute>

          <tr>
            <td align="left">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Item Number
            </td>
            <td align="left">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:value-of select="./@itemNumber" />
            </td>
          </tr>
          <tr>
            <td align="left">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Item Revision
            </td>
            <td align="left">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:value-of select="./@itemRevision" />
            </td>
          </tr>
          <tr>
            <td align="left">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Name
            </td>
            <td align="left">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:value-of select="./@itemName" />
            </td>
          </tr>
          <tr>
            <td align="left">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Type
            </td>
            <td align="left">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:value-of select="./@description" />
            </td>
          </tr>
        </table>
        
      </xsl:for-each>
    </xsl:if>
  </xsl:template>


  <!-- ******************************************************************** -->
  <!-- Presents the Migration and Operation Status of individual categories -->

  <xsl:template name="rxl:OperationStatus">
    <xsl:param name="nestLevel" select="1" />

    <a name="ItemSummary"></a>

    <h2>
      <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
      <hr/>
      Item Summary
    </h2>


    <table>
      <xsl:attribute name="style">
        margin-left:<xsl:value-of select="$indentFactor" />
      </xsl:attribute>
      <xsl:attribute name="width">80%</xsl:attribute>
      <xsl:attribute name="cellpadding">2</xsl:attribute>
      
      <thead>
        <tr>
          <td align="center" style="font-weight:bold">
            <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
            Type
          </td>
          <td align="center" style="font-weight:bold">
            <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
            Status
          </td>
        </tr>
      </thead>
      
      <tbody> 
        <xsl:for-each select="//rxl:Export/rxl:Report[@application='Inspection']/rxl:Datatype">
          <xsl:variable name="datatypeVal"><xsl:value-of select="./@type"/></xsl:variable>
          <xsl:call-template name="rxl:SummaryTable">
            <xsl:with-param name="detailType" select="./@type"/>
          </xsl:call-template>
        </xsl:for-each>
        <xsl:for-each select="//rxl:Import/rxl:Report/rxl:Datatype">
          <xsl:variable name="datatypeVal"><xsl:value-of select="./@type"/></xsl:variable>
          <xsl:call-template name="rxl:SummaryTable">
            <xsl:with-param name="detailType" select="./@type"/>
          </xsl:call-template>
        </xsl:for-each>

        <xsl:for-each select="//rxl:Session">
          <xsl:variable name="datatypeVal"><xsl:value-of select="./@type"/></xsl:variable>
          <xsl:call-template name="rxl:SummaryTable">
            <xsl:with-param name="detailType" select="'CMM Session'"/>
          </xsl:call-template>
        </xsl:for-each>
      </tbody> 
    </table>


  </xsl:template>


  <!-- ************************************************************ -->
  <!-- Outputs the number of succeeded/failed Parts, Assembly etc   -->

  <xsl:template name="rxl:SummaryHighLevelTotal">
    <xsl:param name="nestLevel" select="1" />

    <h2>
      <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
      Status
    </h2>

    <table>
      <xsl:attribute name="style">
        margin-left:<xsl:value-of select="$indentFactor" />
      </xsl:attribute>
          <xsl:attribute name="width">60%</xsl:attribute>
      <xsl:attribute name="cellpadding">1</xsl:attribute>

      <tr>
        <td align="center" style="font-weight:bold">
          <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
          Report
        </td>
        <td align="center" style="font-weight:bold">
          <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
          NX Part
        </td>
      </tr>
      <tr>

        <td align="center">
          <xsl:attribute name="style">
            <xsl:value-of select="$tbodyitemstyle"/>
          </xsl:attribute>
          <xsl:choose>
            <xsl:when test="//rxl:Session/rxl:Report/rxl:Status/@operationStatus = 'warnings'">
              <xsl:attribute name="style">background:
                <xsl:value-of select="$warning_color"/>
              </xsl:attribute>
            </xsl:when>
            <xsl:when test="//rxl:Session/rxl:Report/rxl:Status/@operationStatus = 'failure'">
              <xsl:attribute name="style">background:
                <xsl:value-of select="$failure_color"/>
              </xsl:attribute>
            </xsl:when>
            <xsl:when test="//rxl:Session/rxl:Report/rxl:Status/@operationStatus = 'quarantined'">
              <xsl:attribute name="style">background:
                <xsl:value-of select="$quarantined_color"/>
              </xsl:attribute>
            </xsl:when>
          </xsl:choose>
          <xsl:value-of select="//rxl:Session/rxl:Report/rxl:Status/@operationStatus" />
        </td>
        <td align="center">
          <xsl:attribute name="style">
            <xsl:value-of select="$tbodyitemstyle"/>
          </xsl:attribute>
          <xsl:value-of select="//rxl:Session/rxl:Report/rxl:Datatype[@type='ItemSummary']/rxl:Statistics/rxl:Row/rxl:Cell[2]" />
        </td>
       
      </tr>
      
    </table>

  </xsl:template>


  <!-- ******************************************************************** -->
  <!-- Presents the statistics table -->

  <xsl:template name="rxl:SummaryTable">
    <xsl:param name='detailType'/>
    <tr>
      <td align="center" style="font-weight:bold">
        <xsl:attribute name="style">
          <xsl:value-of select="$tbodyitemstyle"/>
        </xsl:attribute>
        <xsl:choose>
          <xsl:when test="./rxl:Statistics">
            <a>
              <xsl:attribute name="href">#<xsl:value-of select="./@type" />
              </xsl:attribute>
              <xsl:value-of select="$detailType" />
            </a>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$detailType" />
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td align="center" style="font-weight:bold">
        <xsl:attribute name="style">
          <xsl:value-of select="$tbodyitemstyle"/>
        </xsl:attribute>
        <xsl:choose>
          <xsl:when test="./rxl:Status/@operationStatus = 'warnings'">
            <xsl:attribute name="style">background:
              <xsl:value-of select="$warning_color"/>
            </xsl:attribute>
          </xsl:when>
          <xsl:when test="./rxl:Status/@operationStatus = 'failure'">
            <xsl:attribute name="style">background:
              <xsl:value-of select="$failure_color"/>
            </xsl:attribute>
          </xsl:when>
        </xsl:choose>
        
        <xsl:value-of select="./rxl:Status/@operationStatus" />
      </td>
    </tr>
  </xsl:template>

  <!-- ******************************************************************** -->
  <!-- Presents the statistics table -->

  <xsl:template name="rxl:Stats">
    <xsl:param name="nestLevel" select="1" />

    <xsl:choose>
      <xsl:when test="//rxl:Import/rxl:Report/rxl:Datatype/rxl:Statistics">
        <h2>
          <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
          <hr/>
          Summary
        </h2>
        <br/>

        <xsl:call-template name="rxl:InspectionStats" />
        
        <xsl:for-each select="//rxl:Import/rxl:Report/rxl:Datatype/rxl:Statistics">
          <xsl:variable name="pImportType">
            <xsl:value-of select="../@type"/>
          </xsl:variable>
          <xsl:variable name="pShowExport">
            <xsl:choose>
              <xsl:when test="$pImportType = 'Constraints'">1</xsl:when>
              <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:if test="$pShowExport='1'">
            <xsl:variable name="pComment">exported</xsl:variable>
            <xsl:for-each select="//rxl:Export/rxl:Report/rxl:Datatype[@type=$pImportType]/rxl:Statistics">
              <xsl:call-template name="rxl:Table">
                <xsl:with-param name="pType" select="../@type"/>
                <xsl:with-param name="pComment" select="$pComment"/>
                <xsl:with-param name="pOperationStatus" select="../rxl:Status/@operationStatus"/>
                <xsl:with-param name="pNestLevel" select="'1'"/>
              </xsl:call-template>
            </xsl:for-each> <!-- Statistics -->
          </xsl:if>
          <xsl:variable name="pComment">
            <xsl:choose>
              <xsl:when test="$pShowExport='1'">imported</xsl:when>
              <xsl:otherwise></xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:call-template name="rxl:Table">
            <xsl:with-param name="pType" select="../@type"/>
            <xsl:with-param name="pComment" select="$pComment"/>
            <xsl:with-param name="pOperationStatus" select="../rxl:Status/@operationStatus"/>
            <xsl:with-param name="pNestLevel" select="'1'"/>
          </xsl:call-template>
          <xsl:for-each select="../rxl:Datatype/rxl:Statistics">
            <xsl:call-template name="rxl:Table">
              <xsl:with-param name="pType" select="../@type"/>
              <xsl:with-param name="pComment" select="$pComment"/>
              <xsl:with-param name="pOperationStatus" select="../rxl:Status/@operationStatus"/>
              <xsl:with-param name="pNestLevel" select="'2'"/>
            </xsl:call-template>
          </xsl:for-each> <!-- sub datatypes -->
        </xsl:for-each> <!-- Statistics -->
        
        <br/>

        <xsl:for-each select="//rxl:Report[@application ='Drafting']/rxl:Datatype">
          <xsl:if test="starts-with(./@type, 'Evaluation')">
            <xsl:for-each select="./rxl:Statistics">
              <xsl:variable name="pImportType">
                <xsl:value-of select="../@type"/>
              </xsl:variable>
              <xsl:call-template name="rxl:Table">
                <xsl:with-param name="pType" select="../@type"/>
                <xsl:with-param name="pComment" select="''"/>
                <xsl:with-param name="pOperationStatus" select="../rxl:Status/@operationStatus"/>
                <xsl:with-param name="pNestLevel" select="'1'"/>
              </xsl:call-template>
            </xsl:for-each>
            <xsl:for-each select="./rxl:Datatype/rxl:Statistics">
              <xsl:call-template name="rxl:Table">
                <xsl:with-param name="pType" select="../@type"/>
                <xsl:with-param name="pComment" select="''"/>
                <xsl:with-param name="pOperationStatus" select="../rxl:Status/@operationStatus"/>
                <xsl:with-param name="pNestLevel" select="'2'"/>
              </xsl:call-template>
            </xsl:for-each> <!-- sub datatypes -->
          </xsl:if>
        </xsl:for-each>

        <br/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="//rxl:Export/rxl:Report/rxl:Datatype/rxl:Statistics">
          
          <h2>
            <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
            <hr/>
            Export Summary
          </h2>
          <br/>
          
          <xsl:for-each select="//rxl:Export/rxl:Report/rxl:Datatype/rxl:Statistics">
            <xsl:variable name="pImportType">
              <xsl:value-of select="../@type"/>
            </xsl:variable>
            <xsl:call-template name="rxl:Table">
              <xsl:with-param name="pType" select="../@type"/>
              <xsl:with-param name="pComment" select="''"/>
               <xsl:with-param name="pOperationStatus" select="../rxl:Status/@operationStatus"/>
              <xsl:with-param name="pNestLevel" select="'1'"/>
            </xsl:call-template>
            <xsl:for-each select="../rxl:Datatype/rxl:Statistics">
              <xsl:call-template name="rxl:Table">
                <xsl:with-param name="pType" select="../@type"/>
                <xsl:with-param name="pComment" select="''"/>
                 <xsl:with-param name="pOperationStatus" select="../rxl:Status/@operationStatus"/>
                <xsl:with-param name="pNestLevel" select="'2'"/>
              </xsl:call-template>
            </xsl:for-each> <!-- sub datatypes -->
          </xsl:for-each> <!-- Statistics -->
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
    
   
  </xsl:template>

  <!-- ******************************************************************** -->
  <!-- Presents the row column table -->

  <xsl:template name="rxl:Table">
    <xsl:param name='pType'/>
    <xsl:param name='pComment'/>
    <xsl:param name='pNestLevel'/>
    <xsl:param name='pOperationStatus'/>
    <xsl:variable name="heading">header</xsl:variable>

    <xsl:variable name="pLabel">
      <xsl:value-of select="concat($pType, ' ', $pComment)"/>
    </xsl:variable>

    <a>
      <xsl:attribute name="name"><xsl:value-of select="$pType" />
      </xsl:attribute>
    </a>

    <table>
      <xsl:attribute name="style">margin-left:<xsl:value-of select="$pNestLevel*$indentFactor" />
      </xsl:attribute>
      <xsl:attribute name="width">90%</xsl:attribute>
      <xsl:attribute name="cellpadding">2</xsl:attribute>
      <thead>
        <tr>
          <td align="left" style="font-weight:bold">
            <xsl:attribute name="style">
              <xsl:value-of select="$tableitemstyle"/>
            </xsl:attribute>
            <xsl:choose>
              <xsl:when test="$pOperationStatus = 'warnings'">
                <xsl:attribute name="style">background:
                  <xsl:value-of select="$warning_color"/>
                </xsl:attribute>
              </xsl:when>
              <xsl:when test="$pOperationStatus = 'warning'">
                <xsl:attribute name="style">background:
                  <xsl:value-of select="$warning_color"/>
                </xsl:attribute>
              </xsl:when>
              <xsl:when test="$pOperationStatus = 'failure'">
                <xsl:attribute name="style">background:
                  <xsl:value-of select="$failure_color"/>
                </xsl:attribute>
              </xsl:when>
            </xsl:choose>
            <b>
              <xsl:value-of select="$pLabel" />
              ( <xsl:value-of select="$pOperationStatus"/> )
            </b>
          </td>
        </tr>
      </thead>
    </table>

    <table>
      <xsl:attribute name="width">90%</xsl:attribute>
      <xsl:attribute name="cellpadding">2</xsl:attribute>
      <xsl:attribute name="style">margin-left:<xsl:value-of select="$pNestLevel*$indentFactor" />
      </xsl:attribute>
      
      <xsl:for-each select="./rxl:Row">
        <xsl:variable name="headingtype" select="./@type" />
        <xsl:if test="contains($headingtype,$heading)">
          <thead>
            <tr>
              <xsl:for-each select="./rxl:Cell">
                <td align="center" style="font-weight:bold">
                  <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
                  <xsl:value-of select="." />
                </td>
              </xsl:for-each> <!-- Cell -->
            </tr>
          </thead>
        </xsl:if>
        <xsl:if test="not(contains($headingtype,$heading))">
          <!-- tbody -->
          <tr>
            <xsl:if test="(position()= 1)">
              <xsl:attribute name="style">font-weight:bold</xsl:attribute>
            </xsl:if>
            <xsl:if test="(position() != 1)">
              <xsl:attribute name="style">font-weight:medium</xsl:attribute>
            </xsl:if>
            <xsl:for-each select="./rxl:Cell">
              <td align="center">
                <xsl:if test="@locationRef">
                  <a>
                    <xsl:attribute name="href">
                      <xsl:value-of select="@locationRef" />
                    </xsl:attribute>
                    <xsl:value-of select="." />
                  </a>
                </xsl:if>
                <xsl:if test="not(@locationRef)">
                  <xsl:attribute name="style">
                    <xsl:value-of select="$tbodyitemstyle"/>
                  </xsl:attribute>
                  <xsl:value-of select="." />
                </xsl:if>

              </td>
              
              
            </xsl:for-each> <!-- Cell -->
          </tr>
          <!-- /tbody -->
        </xsl:if>
      </xsl:for-each> <!-- Row -->
    </table>


    <br/>
  </xsl:template>

  <!-- *********************************************************** -->
  <!-- Outputs Migration Date, Time and Duration                   -->

  <xsl:template name="rxl:SystemAudit">
    <xsl:for-each select="//rxl:Session">

      <a name="SystemAudit"></a>
      <h2>
        <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
        <hr/>
        System Audit
      </h2>


      <xsl:for-each select="./rxl:Audit">
        <table class="info">
          <xsl:attribute name="style">
            margin-left:<xsl:value-of select="$indentFactor" />
          </xsl:attribute>
          <xsl:attribute name="width">60%</xsl:attribute>
          <xsl:attribute name="cellpadding">1</xsl:attribute>

          <tbody class="info">
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Migration date
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./@date" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                End time
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./@time" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Migration duration (sec)
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./@duration" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Machine
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Host/@machine" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Platform
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Host/@platform" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                User
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Host/@user" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                NX version
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="parent::*/parent::*/rxl:Import/rxl:Audit/rxl:Application/@version" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Source CAD version
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="parent::*/parent::*/rxl:Export/rxl:Audit/rxl:Application/@version" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Last saved version
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="parent::*/parent::*/rxl:Export/rxl:Input/@itemAppVersion" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Last saved platform
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="parent::*/parent::*/rxl:Export/rxl:Input/@itemPlatform" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Application
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Application/@name" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Version
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Application/@version" />
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Session ID
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Application/@description" />
              </td>
            </tr>
          </tbody>
        </table>
      </xsl:for-each>

    </xsl:for-each>

  </xsl:template>

  <!-- ******************************************************************** -->
  <!-- Presents the User Data table -->

  <xsl:template name="rxl:UserData">
    <br/>
    <xsl:for-each select="//rxl:Session/rxl:Report/rxl:Datatype[@type='UserData']/rxl:Statistics">
      <xsl:call-template name="rxl:Table">
        <xsl:with-param name="pType" select="./@heading"/>
        <xsl:with-param name="pComment" select="''"/>
        <xsl:with-param name="pNestLevel" select="'1'"/>
      </xsl:call-template>
    </xsl:for-each> <!-- Statistics -->
  </xsl:template>

  <!-- ******************************************************************** -->
  <!-- Presents the Log File table -->

  <xsl:template name="rxl:LogFiles">
    <br/>
    <xsl:for-each select="//rxl:Session/rxl:Report/rxl:Datatype[@type='LogFiles']/rxl:Statistics">
      <xsl:call-template name="rxl:Table">
        <xsl:with-param name="pType" select="./@heading"/>
        <xsl:with-param name="pComment" select="''"/>
        <xsl:with-param name="pNestLevel" select="'1'"/>
      </xsl:call-template>
    </xsl:for-each> <!-- Statistics -->
  </xsl:template>

  <!-- ************************************************************** -->
  <!-- FIRST LEVEL template called from the TOP Level. This template
  organizes the display of other templates                       -->

  <xsl:template name="rxl:MigrationDetails">

    <a name="ItemDetails"></a>

    <h2>
      <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
      <hr/>
      Item Details
    </h2>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'Quarantine Check'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'Product Structure'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>
    
    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'Catmap'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>
    
    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'BVR'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>
    
    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'Arrangements'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'Constraints'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'Sequences'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'Mechanism'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'WireFrame'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'Geometry'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'Features'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'3D Annotation'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:for-each select="//rxl:Report[@application ='Drafting']/rxl:Datatype">
      <xsl:if test="starts-with(./@type, 'Sheet')">
        <xsl:call-template name="rxl:InformationDetailTable">
          <xsl:with-param name="detailType" select="./@type" />
          <xsl:with-param name="nestLevel" select="1" />
        </xsl:call-template>
        
        <xsl:for-each select="./rxl:Datatype">
          <xsl:if test="starts-with(./@type, 'View')">
            <xsl:call-template name="rxl:InformationDetailTable">
              <xsl:with-param name="detailType" select="./@type" />
              <xsl:with-param name="nestLevel" select="2" />
            </xsl:call-template>
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
    </xsl:for-each>

    <xsl:call-template name="rxl:InformationDetailTable">
      <xsl:with-param name="detailType" select="'System and User Attributes'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <xsl:call-template name="rxl:SessionInformation">
      <xsl:with-param name="detailType" select="'Session'" />
      <xsl:with-param name="nestLevel" select="1" />
    </xsl:call-template>

    <br/>

  </xsl:template>

  <!-- ******************************************************** -->
  <!-- InformationDetailTable                                   -->

  <xsl:template name="rxl:InformationDetailTable">
    <xsl:param name='detailType'/>
    <xsl:param name='nestLevel'/>


    <xsl:if test="//rxl:Datatype[@type=$detailType]">

      <xsl:element name="div">
        <xsl:attribute name="style">margin-left:<xsl:value-of select="$nestLevel*$indentFactor" />
        </xsl:attribute>
        
        <h3>
          <xsl:attribute name="style"><xsl:value-of select="$h3style"/></xsl:attribute>
          <xsl:value-of select="$detailType"/>
        </h3>
        
        <table>
          <xsl:attribute name="width">95%</xsl:attribute>
          <!-- thead -->
          <tr>
            <td align="center" style="font-weight:bold" width="10%">
              <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
              Phase
            </td>
            <td align="center" style="font-weight:bold">
              <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
              Information
            </td>
          </tr>

          <!-- thead -->
          <xsl:for-each select="//rxl:Datatype[@type=$detailType]">
            <xsl:variable name="phase">
              <xsl:choose>
                <xsl:when test="$nestLevel='1'">
                  <xsl:value-of select="local-name(*/parent::*/parent::*/parent::*)"/>
                </xsl:when>
                <xsl:when test="$nestLevel='2'">
                  <xsl:value-of select="local-name(*/parent::*/parent::*/parent::*/parent::*)"/>
                </xsl:when>
              </xsl:choose>
            </xsl:variable>

            <xsl:call-template name="rxl:StatusTable">
              <xsl:with-param name="pPhase" select="$phase"/>
            </xsl:call-template>
          </xsl:for-each>
        </table>
      </xsl:element>
    </xsl:if>

    <xsl:if test="//rxl:Datatype[@type=$detailType]/rxl:Detail">
      <xsl:element name="div">
        <xsl:attribute name="style">margin-left:<xsl:value-of select="$nestLevel*$indentFactor" />
        </xsl:attribute>
        
        <table>
          <xsl:attribute name="width">95%</xsl:attribute>
          
          <!-- tbody --> 
          <xsl:for-each select="//rxl:Datatype[@type=$detailType]">
            <xsl:variable name="phase">
              <xsl:choose>
                <xsl:when test="$nestLevel='1'">
                  <xsl:value-of select="local-name(*/parent::*/parent::*/parent::*)"/>
                </xsl:when>
                <xsl:when test="$nestLevel='2'">
                  <xsl:value-of select="local-name(*/parent::*/parent::*/parent::*/parent::*)"/>
                </xsl:when>
              </xsl:choose>
            </xsl:variable>

            <xsl:call-template name="rxl:DetailTable">
              <xsl:with-param name="pPhase" select="$phase"/>
            </xsl:call-template>
          </xsl:for-each>
          <!-- tbody --> 
        </table>
      </xsl:element>
    </xsl:if>

  </xsl:template>

  <!-- ******************************************************** -->
  <!-- SessionInformation                                   -->

  <xsl:template name="rxl:SessionInformation">
    <xsl:param name='detailType'/>
    <xsl:param name='nestLevel'/>


    <xsl:if test="//rxl:Session/rxl:Status">

      <xsl:element name="div">
        <xsl:attribute name="style">margin-left:<xsl:value-of select="$nestLevel*$indentFactor" />
        </xsl:attribute>
        
        <h2>
          <xsl:attribute name="style"><xsl:value-of select="$h3style"/></xsl:attribute>
          <xsl:value-of select="'Session'"/>
        </h2>
        
        <table>
          <xsl:attribute name="width">95%</xsl:attribute>
          <!-- thead -->
          <tr>
            <td align="center" style="font-weight:bold" width="10%">
              <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
              Phase
            </td>
            <td align="center" style="font-weight:bold">
              <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
              Information
            </td>
          </tr>

          <!-- thead -->
          <xsl:for-each select="//rxl:Session">
            <xsl:variable name="phase">
              <xsl:value-of select="'Session'"/>
            </xsl:variable>

            <xsl:call-template name="rxl:StatusTable">
              <xsl:with-param name="pPhase" select="$phase"/>
            </xsl:call-template>
          </xsl:for-each>
        </table>
      </xsl:element>
    </xsl:if>

  </xsl:template>

  <!-- ********************************************* -->
  <!-- StatusTable                                   -->

  <xsl:template name="rxl:StatusTable">
    <xsl:param name='pPhase'/>
    <xsl:for-each select="./rxl:Status">
      <xsl:for-each select="./rxl:Information">
        <xsl:variable name="severityLevel">
          <xsl:choose>
            <xsl:when test="./@severity = 'warning'">1</xsl:when>
            <xsl:when test="./@severity = 'severe'">2</xsl:when>
            <xsl:when test="./@severity = 'quarantined'">3</xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="$severityLevel >= $severityMark">
          <tr>
            <td align="center" style="font-weight:bold">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:if test="$severityLevel = '1'">
                <xsl:attribute name="style">background:
                  <xsl:value-of select="$warning_color"/>
                </xsl:attribute>
              </xsl:if>
              <xsl:if test="$severityLevel = '2'">
                <xsl:attribute name="style">background:
                  <xsl:value-of select="$failure_color"/>
                </xsl:attribute>
              </xsl:if>
              <xsl:if test="$severityLevel = '3'">
                <xsl:attribute name="style">background:
                  <xsl:value-of select="$quarantined_color"/>
                </xsl:attribute>
              </xsl:if>
              <xsl:value-of select="$pPhase" />
            </td>
            <td align="left" style="font-weight:bold">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:call-template name="rxl:Message"/>
            </td>
          </tr>
        </xsl:if>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>

  <!-- *************************************************** -->
  <!-- InformataionTable                                   -->

  <xsl:template name="rxl:DetailTable">
    <xsl:param name='pPhase'/>
    <xsl:for-each select="./rxl:Detail">
      <xsl:variable name="severityLevel">
        <xsl:choose>
          <xsl:when test="./@status = 'warning'">1</xsl:when>
          <xsl:when test="./@status = 'Warning'">1</xsl:when>
          <xsl:when test="./@status = 'severe'">2</xsl:when>
          <xsl:when test="./@status = 'Severe'">2</xsl:when>
          <xsl:when test="./@status = 'unknown'">2</xsl:when>
          <xsl:when test="./@status = 'incomplete'">1</xsl:when>
          <xsl:when test="./@status = 'Incomplete'">1</xsl:when>
          <xsl:when test="./@status = 'failure'">2</xsl:when>
          <xsl:when test="./@status = 'Failure'">2</xsl:when>
          <xsl:when test="./@status = 'unsupported'">1</xsl:when>
          <xsl:when test="./@status = 'Unsupported'">1</xsl:when>
          <xsl:when test="./@status = 'unattempted'">1</xsl:when>
          <xsl:when test="./@status = 'Unattempted'">1</xsl:when>
          <xsl:when test="./@status = 'suppressed'">1</xsl:when>
          <xsl:when test="./@status = 'locked'">1</xsl:when>
          <xsl:when test="./@status = 'quarantined'">3</xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

     <xsl:variable name="showStatus">
        <xsl:choose>
          <xsl:when test="./@show = 'true'">Show</xsl:when>
          <xsl:when test="./@show = 'false'">No Show</xsl:when>
        </xsl:choose>
      </xsl:variable>

     <xsl:variable name="instancename">
        <xsl:choose>
          <xsl:when test="./@InstanceName = 'null'"></xsl:when>
          <xsl:when test="./@InstanceName != 'null'">
             <xsl:value-of select="./@InstanceName"/>
          </xsl:when>
        </xsl:choose>
      </xsl:variable>

      <xsl:if test="$severityLevel >= $severityMark">
        <tr>
          <td align="center" style="font-weight:bold" width="10%">
            <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
            <xsl:if test="$severityLevel = '1'">
              <xsl:attribute name="style">background:
                <xsl:value-of select="$warning_color"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:if test="$severityLevel = '2'">
              <xsl:attribute name="style">background:
                <xsl:value-of select="$failure_color"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:if test="$severityLevel = '3'">
              <xsl:attribute name="style">background:
                <xsl:value-of select="$quarantined_color"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$pPhase" />
          </td>
          <td align="center" style="font-weight:bold" >
            <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
            <xsl:value-of select="./@name" />
          </td>
          <td align="center" style="font-weight:bold" >
            <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
            <xsl:value-of select="./@uuid" />
          </td>
          <td align="center" style="font-weight:bold" >
            <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
          <xsl:value-of select="./@type" />
          </td>
          <td align="center" style="font-weight:bold" >
            <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
          <xsl:value-of select="./@status" />
          </td>
          <td align="center" style="font-weight:bold" >
            <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
            <xsl:value-of select="$instancename" />
          </td>
          <td align="center" style="font-weight:bold" >
            <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
            <xsl:value-of select="$showStatus" />
          </td>
          <td align="left" style="font-weight:bold">
            <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
            <xsl:call-template name="rxl:Message"/>
          </td>
        </tr>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <!-- *************************************************** -->
  <!-- Message                                            -->

  <xsl:template name="rxl:Message">
    <ul>
      <xsl:for-each select="./rxl:Message">
        <li>
          <xsl:value-of select="." />
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>


  <!-- ******************************************************************** -->
  <!-- Presents the statistics table -->

  <xsl:template name="rxl:FidelityStats">
    <xsl:param name="nestLevel" select="1" />


    <xsl:if test="//rxl:Import/rxl:Report/rxl:Datatype/rxl:Fidelity">

      <a name="ItemFidelity"></a>

      <h2>
        <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
        <hr/>
        Item Fidelity
      </h2>
      
      <xsl:for-each select="//rxl:Import/rxl:Report/rxl:Datatype">
        <xsl:for-each select="./rxl:Fidelity">       
          <xsl:for-each select="./rxl:Statistics">
            <xsl:call-template name="rxl:FidelityTable">
              <xsl:with-param name="pType" select="../../@type"/>
              <xsl:with-param name="pOperationStatus" select="../@status"/>
              <xsl:with-param name="pNestLevel" select="'1'"/>
            </xsl:call-template>
          </xsl:for-each>
          
          <xsl:call-template name="rxl:FidelityCheck">
            <xsl:with-param name="pNestLevel" select="'2'"/>
            <xsl:with-param name="pType" select="../@type"/>
          </xsl:call-template>
          <xsl:call-template name="rxl:FidelityIssue">
            <xsl:with-param name="pNestLevel" select="'2'"/>
            <xsl:with-param name="pType" select="../@type"/>
          </xsl:call-template>
        </xsl:for-each>

        <br/>

        <xsl:for-each select="./rxl:Datatype/rxl:Fidelity">
          <xsl:for-each select="./rxl:Statistics">
            <xsl:call-template name="rxl:FidelityTable">
              <xsl:with-param name="pType" select="../../@type"/>
               <xsl:with-param name="pOperationStatus" select="../@status"/>
              <xsl:with-param name="pNestLevel" select="'3'"/>
            </xsl:call-template>
          </xsl:for-each>
          
          <xsl:call-template name="rxl:FidelityCheck">
            <xsl:with-param name="pNestLevel" select="'4'"/>
            <xsl:with-param name="pType" select="../@type"/>
          </xsl:call-template>
          <xsl:call-template name="rxl:FidelityIssue">
            <xsl:with-param name="pNestLevel" select="'4'"/>
            <xsl:with-param name="pType" select="../@type"/>
          </xsl:call-template>
          <br/>
          <br/>
        </xsl:for-each>


      </xsl:for-each>
    </xsl:if>
    
  </xsl:template>

  <xsl:template name="rxl:JTFidelityStats">
    <xsl:param name="nestLevel" select="1" />


    <xsl:if test="//rxl:Export/rxl:Report/rxl:Datatype/rxl:Fidelity">

      <a name="ItemFidelity"></a>

      <h2>
        <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
        <hr/>
        Item Fidelity
      </h2>
      
      <xsl:for-each select="//rxl:Export/rxl:Report/rxl:Datatype">
        <xsl:for-each select="./rxl:Fidelity">       
          <xsl:for-each select="./rxl:Statistics">
            <xsl:call-template name="rxl:FidelityTable">
              <xsl:with-param name="pType" select="../../@type"/>
              <xsl:with-param name="pOperationStatus" select="../@status"/>
              <xsl:with-param name="pNestLevel" select="'1'"/>
            </xsl:call-template>
          </xsl:for-each>
          
          <xsl:call-template name="rxl:FidelityCheck">
            <xsl:with-param name="pNestLevel" select="'2'"/>
            <xsl:with-param name="pType" select="../@type"/>
          </xsl:call-template>
          <xsl:call-template name="rxl:FidelityIssue">
            <xsl:with-param name="pNestLevel" select="'2'"/>
            <xsl:with-param name="pType" select="../@type"/>
          </xsl:call-template>
        </xsl:for-each>

        <br/>

        <xsl:for-each select="./rxl:Datatype/rxl:Fidelity">
          <xsl:for-each select="./rxl:Statistics">
            <xsl:call-template name="rxl:FidelityTable">
              <xsl:with-param name="pType" select="../../@type"/>
               <xsl:with-param name="pOperationStatus" select="../@status"/>
              <xsl:with-param name="pNestLevel" select="'3'"/>
            </xsl:call-template>
          </xsl:for-each>
          
          <xsl:call-template name="rxl:FidelityCheck">
            <xsl:with-param name="pNestLevel" select="'4'"/>
            <xsl:with-param name="pType" select="../@type"/>
          </xsl:call-template>
          <xsl:call-template name="rxl:FidelityIssue">
            <xsl:with-param name="pNestLevel" select="'4'"/>
            <xsl:with-param name="pType" select="../@type"/>
          </xsl:call-template>
          <br/>
          <br/>
        </xsl:for-each>


      </xsl:for-each>
    </xsl:if>
    
  </xsl:template>

  <!-- ******************************************************************** -->
  <!-- Presents the Inspection statistics table -->

  <xsl:template name="rxl:InspectionStats">
    <xsl:param name="nestLevel" select="1" />


    <xsl:if test="//rxl:Export/rxl:Report[@application='Inspection']/rxl:Datatype/rxl:Statistics">

      <a name="Quarantine Check"></a>

    
      <xsl:for-each select="//rxl:Export/rxl:Report[@application='Inspection']/rxl:Datatype">
        <xsl:for-each select="./rxl:Statistics">
          <xsl:call-template name="rxl:Table">
            <xsl:with-param name="pType" select="../../@type"/>
            <xsl:with-param name="pNestLevel" select="'1'"/>
            <xsl:with-param name="pOperationStatus" select="../rxl:Status/@operationStatus"/>
            <xsl:with-param name="pComment" select="../@type"/>
          </xsl:call-template>
        </xsl:for-each>

        
      </xsl:for-each>
    </xsl:if>
    
  </xsl:template>

  <!-- ******************************************************************** -->
  <!-- Presents the row column table -->

  <xsl:template name="rxl:FidelityTable">
    <xsl:param name='pType'/>
    <xsl:param name='pOperationStatus'/>
     <xsl:param name='pNestLevel'/>
    <xsl:variable name="heading">header</xsl:variable>
    <a>
      <xsl:attribute name="name"><xsl:value-of select="$pType" />
      </xsl:attribute>
    </a>

    <table>
      <xsl:attribute name="style">margin-left:<xsl:value-of select="$pNestLevel*$indentFactor" />
      </xsl:attribute>
      <xsl:attribute name="width">90%</xsl:attribute>
      <xsl:attribute name="cellpadding">2</xsl:attribute>
      <thead>
        <tr>
          <td align="left" style="font-weight:bold">
            <xsl:attribute name="style">
              <xsl:value-of select="$tableitemstyle"/>
            </xsl:attribute>
            <xsl:choose>
              <xsl:when test="$pOperationStatus = 'warnings'">
                <xsl:attribute name="style">background:
                  <xsl:value-of select="$warning_color"/>
                </xsl:attribute>
              </xsl:when>
              <xsl:when test="$pOperationStatus = 'warning'">
                <xsl:attribute name="style">background:
                  <xsl:value-of select="$warning_color"/>
                </xsl:attribute>
              </xsl:when>
              <xsl:when test="$pOperationStatus = 'failure'">
                <xsl:attribute name="style">background:
                  <xsl:value-of select="$failure_color"/>
                </xsl:attribute>
              </xsl:when>
            </xsl:choose>
            <b>
              <xsl:value-of select="$pType"/>
              ( <xsl:value-of select="$pOperationStatus"/> )
            </b>
          </td>
        </tr>
      </thead>
    </table>

    <table>
      <xsl:attribute name="style">margin-left:<xsl:value-of select="$pNestLevel*$indentFactor" />
      </xsl:attribute>
      <xsl:attribute name="width">90%</xsl:attribute>
      <xsl:attribute name="cellpadding">2</xsl:attribute>
      
      <xsl:for-each select="./rxl:Row">
        <xsl:variable name="headingtype" select="./@type" />
        <xsl:if test="contains($headingtype,$heading)">
          <thead>
            <tr>
              <xsl:for-each select="./rxl:Cell">
                <td align="center">
                  <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
                  <xsl:value-of select="." />
                </td>
              </xsl:for-each>
            </tr>
          </thead>
        </xsl:if>
        <xsl:if test="not(contains($headingtype,$heading))">
          <!-- tbody -->
          <tr>
            <xsl:if test="(position()= 1)">
              <xsl:attribute name="style">font-weight:bold</xsl:attribute>
            </xsl:if>
            <xsl:if test="(position() != 1)">
              <xsl:attribute name="style">font-weight:medium</xsl:attribute>
            </xsl:if>
            <xsl:for-each select="./rxl:Cell">
              <td align="center">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="." />
              </td>
              
              
            </xsl:for-each>
          </tr>
        </xsl:if>
      </xsl:for-each>
    </table>
    <br/>
  </xsl:template>

  <!-- ******************************************************************** -->
  <!-- Presents the fidelity check                                          -->
  
  <xsl:template name="rxl:FidelityCheck">
    <xsl:param name='pNestLevel'/>
    <xsl:param name='pType'/>
    <xsl:if test="./rxl:Check">
      <table>
        <xsl:attribute name="style">
          margin-left:<xsl:value-of select="$pNestLevel*$indentFactor" />
        </xsl:attribute>
        <xsl:attribute name="width">90%</xsl:attribute>
        <xsl:attribute name="cellpadding">2</xsl:attribute>
        <thead>
          <tr>
            <td align="center">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Check
            </td>
            <td align="center">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Entity
            </td>
            <td align="center">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Info
            </td>
            <td align="center">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Source
            </td>
            <td align="center">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Target
            </td>
          </tr>        
          <xsl:for-each select="./rxl:Check">
            <tr>
              <td align="center">
                <xsl:attribute name="style">
                  <xsl:value-of select="$tbodyitemstyle"/>
                </xsl:attribute>
                <xsl:value-of select="./@checkType" />
              </td>
              <td align="center">
                <xsl:attribute name="style">
                  <xsl:value-of select="$tbodyitemstyle"/>
                </xsl:attribute>
                <xsl:value-of select="./@entityType" />
              </td>
              <td align="center">
                <xsl:attribute name="style">
                  <xsl:value-of select="$tbodyitemstyle"/>
                </xsl:attribute>
                <xsl:value-of select="./@entityInfo" />
              </td>
              <td align="center">
                <xsl:attribute name="style">
                  <xsl:value-of select="$tbodyitemstyle"/>
                </xsl:attribute>
                <xsl:value-of select="./@srcValue" />
              </td>
              <td align="center">
                <xsl:attribute name="style">
                  <xsl:value-of select="$tbodyitemstyle"/>
                </xsl:attribute>
                <xsl:value-of select="./@tgtValue" />
              </td>
            </tr>
          </xsl:for-each> <!-- Statistics -->
        </thead>
      </table>
      <br/>
    </xsl:if>
  </xsl:template>


  <!-- ******************************************************************** -->
  <!-- Presents the fidelity issue                                          -->
  
  <xsl:template name="rxl:FidelityIssue">
    <xsl:param name='pNestLevel'/>
    <xsl:param name='pType'/>
    <xsl:if test="./rxl:Issue">
      <table>
        <xsl:attribute name="style">
          margin-left:<xsl:value-of select="$pNestLevel*$indentFactor" />
        </xsl:attribute>
        <xsl:attribute name="width">90%</xsl:attribute>
        <xsl:attribute name="cellpadding">2</xsl:attribute>
        <thead>
          <tr>
            <td align="center">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Type
            </td>
            <td align="center">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Entity Info
            </td>
            <td align="center">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Failure Info
            </td>
            <td align="center">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Message
            </td>
          </tr>        
          <xsl:for-each select="./rxl:Issue">
            <tr>
              <td align="center">
                <xsl:attribute name="style">
                  <xsl:value-of select="$tbodyitemstyle"/>
                </xsl:attribute>
                <xsl:value-of select="./@issueType" />
              </td>
              <td align="center">
                <xsl:attribute name="style">
                  <xsl:value-of select="$tbodyitemstyle"/>
                </xsl:attribute>
                <xsl:value-of select="./@entityInfo" />
              </td>
              <td align="center">
                <xsl:attribute name="style">
                  <xsl:value-of select="$tbodyitemstyle"/>
                </xsl:attribute>
                <xsl:value-of select="./@failureInfo" />
              </td>
              <td align="left">
                <xsl:attribute name="style">
                  <xsl:value-of select="$tbodyitemstyle"/>
                </xsl:attribute>
                <ul>
                  <xsl:for-each select="./rxl:Message">
                    <li>
                      <xsl:value-of select="." />
                    </li>
                  </xsl:for-each>
                </ul>
              </td>
            </tr>
          </xsl:for-each> <!-- Statistics -->
        </thead>
      </table>
      <br/>
    </xsl:if>
  </xsl:template>


  <!-- ******************************************************** -->
  <!-- Template to match top level element in report file. -->

  <xsl:template match="rxl:JT_XTReport">
    
    <html>      
      <body>
        <xsl:attribute name="style"><xsl:value-of select="$bodystyle"/></xsl:attribute>
        <h1>
          <xsl:attribute name="style">
            <xsl:value-of select="$h1style"/>
          </xsl:attribute>
          JT Report
        </h1>

        <table>
          <xsl:attribute name="style">
            margin-left:<xsl:value-of select="$indentFactor"/>
          </xsl:attribute>
          <xsl:attribute name="width">80%</xsl:attribute>
          <xsl:attribute name="cellpadding">2</xsl:attribute>
          
          <thead>
            <tr>
              <td align="center" style="font-weight:bold">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
                <a href="#JTItemSummary">Item Summary</a>
              </td>
              <td align="center" style="font-weight:bold">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
                <a href="#ItemDetails">Item Details</a>
              </td>
	      <!--
              &lt;td align=&quot;center&quot; style=&quot;font-weight:bold&quot;&gt;
                &lt;xsl:attribute name=&quot;style&quot;&gt;&lt;xsl:value-of select=&quot;$tableitemstyle&quot;/&gt;&lt;/xsl:attribute&gt;
                &lt;a href=&quot;#Stats&quot;&gt;Export Summary&lt;/a&gt;
              &lt;/td&gt;
	      -->
              <td align="center" style="font-weight:bold">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
                <a href="#JTSystemAudit">System Audit</a>
              </td>
            </tr>
          </thead>
        </table>
        
        <xsl:call-template name="rxl:JTBody"/>
      </body>
    </html>
  </xsl:template>
  
  <!-- ******************************************************** -->
  <!-- Generate the body report html -->

  <xsl:template name="rxl:JTBody">
    
    <xsl:call-template name="rxl:JTItemDescription"/>

    <xsl:call-template name="rxl:JTSummaryHighLevelTotal"/>

    <xsl:call-template name="rxl:JTOperationStatus"/>

    <xsl:call-template name="rxl:Stats"/>

    <xsl:call-template name="rxl:MigrationDetails"/>

    <xsl:call-template name="rxl:JTFidelityStats" />

    <xsl:call-template name="rxl:JTSystemAudit"/>

    <!--xsl:call-template name=&quot;rxl:UserData&quot; /-->

    <!--xsl:call-template name=&quot;rxl:LogFiles&quot; /-->
  
  </xsl:template>


  <!-- ************************************************************ -->
  <!-- Outputs the number of succeeded/failed Parts, Assembly etc   -->

  <xsl:template name="rxl:JTSummaryHighLevelTotal">
    <xsl:param name="nestLevel" select="1"/>

    <h2>
      <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
      Status
    </h2>

    <table>
      <xsl:attribute name="style">
        margin-left:<xsl:value-of select="$indentFactor"/>
      </xsl:attribute>
          <xsl:attribute name="width">60%</xsl:attribute>
      <xsl:attribute name="cellpadding">1</xsl:attribute>

      <tr>
        <td align="center" style="font-weight:bold">
          <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
          Report
        </td>
        <td align="center" style="font-weight:bold">
          <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
          JT Part
        </td>
      </tr>
      <tr>

        <td align="center">
          <xsl:attribute name="style">
            <xsl:value-of select="$tbodyitemstyle"/>
          </xsl:attribute>
          <xsl:choose>
            <xsl:when test="//rxl:Export/rxl:Status/@operationStatus = &apos;warnings&apos;">
              <xsl:attribute name="style">background:
                <xsl:value-of select="$warning_color"/>
              </xsl:attribute>
            </xsl:when>
            <xsl:when test="//rxl:Export/rxl:Status/@operationStatus = &apos;failure&apos;">
              <xsl:attribute name="style">background:
                <xsl:value-of select="$failure_color"/>
              </xsl:attribute>
            </xsl:when>
            <xsl:when test="//rxl:Export/rxl:Status/@operationStatus = &apos;quarantined&apos;">
              <xsl:attribute name="style">background:
                <xsl:value-of select="$quarantined_color"/>
              </xsl:attribute>
            </xsl:when>
          </xsl:choose>
          <xsl:value-of select="//rxl:Export/rxl:Status/@operationStatus"/>
        </td>
        <td align="center">
          <xsl:attribute name="style">
            <xsl:value-of select="$tbodyitemstyle"/>
          </xsl:attribute>
          <xsl:value-of select="//rxl:Export/rxl:Report/rxl:Datatype/rxl:Detail/@status"/>
        </td>
       
      </tr>
      
    </table>

  </xsl:template>


  <!-- *********************************************************** -->
  <!-- Shows the Item name, number, revision and type              -->

  <xsl:template name="rxl:JTItemDescription">

    <xsl:if test="//rxl:Export/rxl:Input">

      <h2>
        <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
        <hr/>
        Item Description
      </h2>
      
      <xsl:for-each select="//rxl:Export/rxl:Input">
        
        <table>
          <xsl:attribute name="style">
            margin-left:<xsl:value-of select="$indentFactor"/>
          </xsl:attribute>
          <xsl:attribute name="width">60%</xsl:attribute>
          <xsl:attribute name="cellpadding">1</xsl:attribute>

          <tr>
            <td align="left">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Item Number
            </td>
            <td align="left">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:value-of select="./@itemNumber"/>
            </td>
          </tr>
          <tr>
            <td align="left">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Item Revision
            </td>
            <td align="left">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:value-of select="./@itemRevision"/>
            </td>
          </tr>
          <tr>
            <td align="left">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Name
            </td>
            <td align="left">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:value-of select="./@itemName"/>
            </td>
          </tr>
          <tr>
            <td align="left">
              <xsl:attribute name="style">
                <xsl:value-of select="$tableitemstyle"/>
              </xsl:attribute>
              Type
            </td>
            <td align="left">
              <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
              <xsl:value-of select="./@description"/>
            </td>
          </tr>
        </table>
        
      </xsl:for-each>
    </xsl:if>
  </xsl:template>

  <!-- *********************************************************** -->
  <!-- Outputs Migration Date, Time and Duration                   -->

  <xsl:template name="rxl:JTSystemAudit">
    <xsl:if test="//rxl:Export/rxl:Audit">

      <a name="JTSystemAudit"/>
      <h2>
        <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
        <hr/>
        System Audit
      </h2>

      <xsl:for-each select="//rxl:Export/rxl:Audit">
        <table class="info">
          <xsl:attribute name="style">
            margin-left:<xsl:value-of select="$indentFactor"/>
          </xsl:attribute>
          <xsl:attribute name="width">60%</xsl:attribute>
          <xsl:attribute name="cellpadding">1</xsl:attribute>

          <tbody class="info">
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Generated on
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./@date"/>
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                End time
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./@time"/>
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Time to generate
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:if test="@duration">
                <xsl:value-of select="substring(@duration, 3)"/>
                </xsl:if>
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Machine
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Host/@machine"/>
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Platform
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Host/@platform"/>
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                User
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Host/@user"/>
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Source CAD version
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Application/@version"/>
              </td>
            </tr>
            <tr>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/>
                </xsl:attribute>
                Application
              </td>
              <td align="left">
                <xsl:attribute name="style"><xsl:value-of select="$tbodyitemstyle"/></xsl:attribute>
                <xsl:value-of select="./rxl:Application/@name"/>
              </td>
            </tr>
          </tbody>
        </table>
        </xsl:for-each>
    </xsl:if>

  </xsl:template>

  <!-- ******************************************************************** -->
  <!-- Presents the Migration and Operation Status of individual categories -->

  <xsl:template name="rxl:JTOperationStatus">
    <xsl:param name="nestLevel" select="1"/>

    <a name="JTItemSummary"/>

    <h2>
      <xsl:attribute name="style"><xsl:value-of select="$h2style"/></xsl:attribute>
      <hr/>
      Item Summary
    </h2>


    <table>
      <xsl:attribute name="style">
        margin-left:<xsl:value-of select="$indentFactor"/>
      </xsl:attribute>
      <xsl:attribute name="width">80%</xsl:attribute>
      <xsl:attribute name="cellpadding">2</xsl:attribute>
      
      <thead>
        <tr>
          <td align="center" style="font-weight:bold">
            <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
            Type
          </td>
          <td align="center" style="font-weight:bold">
            <xsl:attribute name="style"><xsl:value-of select="$tableitemstyle"/></xsl:attribute>
            Status
          </td>
        </tr>
      </thead>
      
      <tbody> 
        <xsl:for-each select="//rxl:Export/rxl:Report[@application=&apos;Inspection&apos;]/rxl:Datatype">
          <xsl:variable name="datatypeVal"><xsl:value-of select="./@type"/></xsl:variable>
          <xsl:call-template name="rxl:SummaryTable">
            <xsl:with-param name="detailType" select="./@type"/>
          </xsl:call-template>
        </xsl:for-each>
        <xsl:for-each select="//rxl:Export/rxl:Report/rxl:Datatype">
          <xsl:variable name="datatypeVal"><xsl:value-of select="./@type"/></xsl:variable>
          <xsl:call-template name="rxl:SummaryTable">
            <xsl:with-param name="detailType" select="./@type"/>
          </xsl:call-template>
        </xsl:for-each>

        <xsl:for-each select="//rxl:Session">
          <xsl:variable name="datatypeVal"><xsl:value-of select="./@type"/></xsl:variable>
          <xsl:call-template name="rxl:SummaryTable">
            <xsl:with-param name="detailType" select="&apos;CMM Session&apos;"/>
          </xsl:call-template>
        </xsl:for-each>
      </tbody> 
    </table>


  </xsl:template>

</xsl:stylesheet>

 
