@Echo off
 REM ===========================================================================
 REM Basisscript JobManager V2 fuer den Refile mit NX8 in der TC Umgebung
 REM (c) J.Feuerstein 24.11.2006
 rem
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   24.11.2006 00:05   Ersterstellung 24.11.2006
 REM J.Fes   01.03.2008 14:00    -SpOpt_RefileReplicaParts
 REM J.Fes   20.07.2009 08:00    -Script angepasst SetColor
 REM J.Fes   01.11.2009 19:00   Scriptinterne Optionsschalter eingefuegt:
 REM                             - JobMgr_Debug
 REM                             - JobMgr_use_PlmJobManagerWatchDog
 REM                             - JobMgr_use_RemoteSoftwareVNC
 REM                             - JobMgr_OnErrorShowResultOnClient
 REM J.Fes   12.12.2009 23:00   Scriptinterne Optionsschalter eingefuegt:
 REM                             -JobMgr_use_DiskConnect
 REM J.Fes   12.12.2009 23:00   Rf Replica mit TC2007.1/NX7.5 neu Optionsschalter beruecksichtigt
 REM                             -replica_bypass=yes und Environ SET UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS=true
 REM J.Fes   21.12.2009 13:00   Call :JobParam_List "%RfPara%" ergaenzt
 REM J.Fes   31.05.2010 21:51   Scriptinterne Optionsschalter eingefuegt:
 REM                             - JobMgr_use_TcServerKill
 REM J.Fes   28.08.2010 17:11   JobUser und JobUserPw per cmd P1 und P2 uebernehmen eingefuegt:
 REM                             - set JobMgr_TcUser=
 REM                             - set JobMgr_TcPw=
 REM J.Fes   29.10.2010 20:22   FMS_HOME Check eingebaut + Formatierungen
 REM J.Fes   31.08.2011 18:21   Eingefuegt: Docu 31.08.2011 K.Scholz/J.Feuerstein + Formatierungen
 REM J.Fes   04.04.2012 22:35   Script fuer NX75 Refile angepasst
 REM J.Fes   14.06.2012 18:17   -u=dba als default fuer den Rf User gesetzt
 REM J.Fes   14.06.2012 18:17   entfernt: setlocal EnableDelayedExpansion EnableExtensions
 REM J.Fes   17.08.2012 10:20   umgestellt set UGII_DISABLE_PREVIEW= und  set UGII_DISABLE_QAF_NAMED_REFS=ON
 REM J.Fes   14.07.2013 15:54   Skript umgestellt auf JS Cmd Tools
 REM ===========================================================================
 
 Echo **************************************************************************
 Echo * Excuting Refile Script for NX8.0 in PLMJobManager Environ              *
 Echo * Version: 7.5  addPLM GmbH  15.07.2013 (c)                              *
 Echo **************************************************************************

 set JobMgr_TcUser=%1
 set JobMgr_TcPw=%2
 REM -- Basiseinstellungen fuer das Verhalten es Scriptes ----------------------
 REM Hier knnen Verschiedene Einstellungen getroffen werden die steuern wie das Script ablaufen soll
 REM      Die mit "#" Gitter eingeschlossenen Variablen werden vom JobServer ersetzt
 
 REM Alle wichtigen Stellen sind mit # gekennzeichnset
 REM #Doc:  steht an allen Dokumentations Stellen
 REM #ToDo: steht an allen Stellen die angepasst werden sollen

  rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsList.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsList_txt=false
 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsListAllDetails.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsListAllDetails_txt=false

 REM Debug: [bei Einzel Test's auf=ON] [sonst auf OFF stellen]
 set JobMgr_Debug=OFF
 REM -- JobScriptParametersExtended:
 REM    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen leer
 REM             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt auch leer ist
 #JobScriptParametersExtended#

 REM use WatchDog [default=ON]
 set JobMgr_use_PlmJobManagerWatchDog=ON

 REM use RemoteSoftwareVNC [default=OFF]
 set JobMgr_use_RemoteSoftwareVNC=OFF

 REM use JobMgr_use_TcServerKill [default=OFF]
 set JobMgr_use_TcServerKill=OFF

 REM Steuert Verhalten wenn ein Error aufgetreten ist [ON=Anhalten] [OFF=automatisch weiter arbeiten!]
 REM allgemein einstellen wie JobMgr_Debug [default=%JobMgr_Debug%]
 set JobMgr_OnErrorShowResultOnClient=%JobMgr_Debug%
 REM set JobMgr_OnErrorShowResultOnClient=ON
 
 REM Disk Connect [default=OFF]
 set JobMgr_use_DiskConnect=OFF

 REM ===========================================================================
 REM -- Farbe setzen IsIdel
 call :ColorSet IsIdel



 REM -- Rootpfade setzen -------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 REM -- JobServer Variablen ----------------------------------------------------
 set JobManagerRoot_DP=#00-ApplRoot_DP#
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#

 REM -- JobData ----------------------------------------------------------------
 set JobScripts_DP=#10-JobScripts_DP#
 set JobName=#JobName#
 set JobPacket_NE=#JobPacket_NE#
 set JobObjectsPacketAllDetails_NE=#JobObjectsPacketAllDetails_NE#

 REM !! Wichtig: JobObjectsPacketAllDetails_DPNE darf erst nach dem alle #Variablen gesetz wuerden verwendet werden
 set JobObjectsPacketAllDetails_DPNE=%CmdCurRoot_DP%\%JobObjectsPacketAllDetails_NE%
 set DataRoot_CustomWorkInst_DP=#DataRoot_CustomWorkInst_DP#

 REM -- uebergabe SiteDef ------------------------------------------------------
 set TcSiteId=#TcSiteId#

 set title_str=Rf:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %title_str%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Debug:%JobMgr_Debug%
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
   Echo #Debug....: Start Explorer
   Echo at JobDir.: [%CmdCurRoot_DP%]
   start "" Explorer "%CmdCurRoot_DP%"
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
:JumbOver


 if "%JobMgr_use_DiskConnect%" neq "ON" goto :jumbOverDiskConnect
  REM -- Optional # Laufwerk verbinden !! -------------------------------------
  REM Netzwerklaufwerke richtig verbinden
  set ConnectNetUnc_to_Info=S: \\MyServer\ugsshare
  call ConnectNetUnc.cmd "Ugsshare" S: \\MySerrver\ugsshare . . Ugsshare_DiskConnectOk
  Echo Connect Laufwerk:%ConnectNetUnc_to_Info% Status:"%Ugsshare_DiskConnectOk%"
  if /I not "%Ugsshare_DiskConnectOk%" equ "OK" goto :Ugsshare_DiskConnectErr
:jumbOverDiskConnect


rem -- #Step: JobMgr CmdTools local kopieren ----------------------------------
 rem #Doc: Steuert aus welchem Bereich die Tools genommen werden J.Fes 14.02.2013
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer
 if not exist "%JobManagerCmdTools_DP%"  set JobManagerCmdTools_DP=\\jf-26\JobManagerV2_Root\JobManagerV2\03-BinPublic.ClientServer

 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"

 Echo "Update BinL......: [%BinL_DP%]"
 Echo "Update From......: [%JobManagerCmdTools_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:1
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL /R:2 /W:2 "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.exe">nul 2>nul
 rem ?? J.Fes "%BinPublic_ClientServer_DP%\JobManagerCmdTools_Resources eingearbeitet
 REM  robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL /R:2 /W:2 /MIR "%JobManagerCmdTools_DP%\JobManagerCmdTools_Resources" "%BinL_DP%\JobManagerCmdTools_Resources" "*.*">nul 2>nul
 dir %JobManagerCmdTools_L%>>%~dp0zzTracActionInfo_log.txt


 REM -- temp dir Organiesieren -------------------------------------------------
 set tempOrig_DP=%temp%

 rem #New: 11.07.2013 13:43 S.Gue
 set JobTemp1_SO_DP=%CmdCurRoot_DP%\JobTemp1_SO_DP
 set JobTemp2_RO_DP=%CmdCurRoot_DP%\JobTemp2_RO_DP

 REM -- define cmd files to set the right variables -------------------------------------------------
 set RfSetEnv_SO_cmd=%CmdCurRoot_DP%\RfSetEnv_SO.cmd
 set RfSetEnv_RO_cmd=%CmdCurRoot_DP%\RfSetEnv_RO.cmd

 REM -- Refile Logfiles fr Owning Site festlegen ---------------------------------------------
 set RfLogFile1_SO_DPNE=%JobTemp1_SO_DP%\_Rf20_RefileJob.log
 set RfFailedLog1_SO_DPNE=%JobTemp1_SO_DP%\_Rf21_Failed_Refiles.log
 set RfCmdJobLogOwningSite_DPNE=%JobTemp1_SO_DP%\_Rf23_RefileCmdJob.log

 REM -- Refile Logfiles fr Replika festlegen ---------------------------------------------
 set RfLogFile2_RO_DPNE=%JobTemp2_RO_DP%\_Rf20_RefileJob.log
 set RfFailedLog2_RO_DPNE=%JobTemp2_RO_DP%\_Rf21_Failed_Refiles.log
 set RfCmdJobLogReplika_DPNE=%JobTemp2_RO_DP%\_Rf23_RefileCmdJob.log

 REM -- RefilePaketFile festlegen
 set RfInputList1_SO_DPNE=%JobTemp1_SO_DP%\_Rf01_RefileIrList.txt
 set RfInputList2_RO_DPNE=%JobTemp2_RO_DP%\_Rf01_RefileIrList.txt

 call Echo " -- #Step: extract refile IR list ----------------------------------------------"
 rem #Step: Extract Refile Ir list
 call :ExtractIrList

 if not exist "%RfInputList1_SO_DPNE%" goto :JumbOver_RefileOwingSiteObjects
  call Echo " -- #Step: Refile Site Owning (SO) --------------------------------------------"
  set temp=%JobTemp1_SO_DP%
  set RfJobLog_DPNE=%RfLogFile1_SO_DPNE%
  set RfFailedLog_DPNE=%RfFailedLog1_SO_DPNE%
  set RfCmdJobLog_DPNE=%RfCmdJobLogOwningSite_DPNE%
  set RfPaket_DPNE=%RfInputList1_SO_DPNE%
  set RfSetVariables_cmd=%RfSetEnv_SO_cmd%

  rem execute refile
  call :ExecuteRefile
:JumbOver_RefileOwingSiteObjects

 rem #Step: refile replika objects
 if not exist "%RfInputList2_RO_DPNE%" goto :JumbOver_RefileReplicaObjects
 call Echo " -- #Step: Refile Replica Objects (RO) ------------------------------------------"

 set temp=%JobTemp2_RO_DP%
 set RfJobLog_DPNE=%RfLogFile2_RO_DPNE%
 set RfFailedLog_DPNE=%RfFailedLog2_RO_DPNE%
 set RfCmdJobLog_DPNE=%RfCmdJobLogReplika_DPNE%
 set RfPaket_DPNE=%RfInputList2_RO_DPNE%
 set RfSetVariables_cmd=%RfSetEnv_RO_cmd%

 rem execute refile
 call :ExecuteRefile
:JumbOver_RefileReplicaObjects

 call Echo " -- #Step: Evaluate Refile Results ----------------------------------------------"
 call :EvaluateRefileResult

goto :end


rem ============================================================================
:ExecuteRefile
 Echo --------------------------------------------------------------------------
 Echo Info: Executing TcPrompt to get "Tc-Environment"

 REM #Doc: SetUp TcPrompt
 REM #ToDo: Setup Customer Scripts  Done:#??.??.??#
 REM #Doc: 31.08.2011 K.Scholz/J.Feuerstein
 REM #Doc: Wichtig!! es muss geprueft werden ob beim durchlaufen des
 REM #Doc:           TC.Prompt-Script der FCC neu gestartet wird.
 REM #Doc:           wenn ja dann darf immer nur ein Job je Client laufen

 rem #Doc: Tc.Prompt Generic: fuer TC8.3
 rem SET TC_ROOT=d:\ugs\tc83
 rem SET TC_DATA=D:\ugsshare\tc83data\windows
 rem call "%TC_DATA%\tc_profilevars.bat"

 REM #Doc: Tc.Prompt nach SIDT Standard: fuer TC8.3
 set SIDT_DEBUG=0
 set TcPromtCmd=%UGS_SHR_DIR%\start_apps\windows\start_nx75.bat
 set TcPromtCmdOpt=de tc_prompt #TcSiteId# tc83

 REM #Doc: der nachfolgende Block kann als alternative verwendet werden
 REM #Doc: wenn mehrere Sites mit unterschiedliche TC Prompts verwendet werden muessen
 if /i "#TcSiteId#" neq "tc83" goto :JumbOver1
   set TcPromtCmd=d:\ugs\tc83\tc_menu\tc83_tc83.bat
   set TcPromtCmdOpt=
:JumbOver1

 if     exist "%TcPromtCmd%" call "%TcPromtCmd%" %TcPromtCmdOpt%
 if not exist "%TcPromtCmd%" goto :TcPromtCmdError

 REM #Doc: 28.10.2010 J.Feuerstein
 REM #Doc: Achtung wenn FMS_HOME nicht definiert dann entstehen erhebliche
 REM #Doc: fehler beim refile von Baugruppen FMS_HOME=%Tc_Root%\fcc
 if not exist "%FMS_HOME%" goto :FMS_HOME_ERR

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
  Echo #Debug:
  Echo after excuting:
  Echo TcPromtCmd....: [%TcPromtCmd%]
  Echo TcPromtCmdOpt.: [%TcPromtCmdOpt%]
  Echo FMS_HOME......: [%FMS_HOME%]
  pause
:JumbOver

 REM -- PathVariable erweitern
 set path=%CmdCurRoot_DP%;%BinPublic_Custom_DP%;%BinPublic_ClientServer_DP%;%BinPublic_DP%;%Path%

 REM -- Option: Control software starten --------------------------------------- 
 if /I "%JobMgr_use_PlmJobManagerWatchDog%" equ "ON" (
       REM WatchDog starten !!
       REM Echo Check Start: PlmJobManagerWatchDog.exe
       Echo --------------------------------------------------------------------------
       call "ProgStart_If_NotRuning.cmd" "PlmJobManagerWatchDog" "%BinPublic_DP%\PlmJobManagerWatchDog.exe"
       REM #ToDo: Notwendigenfalls caffeine einschalten
       REM call "ProgStart_If_NotRuning.cmd" "caffeine" "%BinPublic_DP%\caffeine.exe"
 )
 if /I "%JobMgr_use_RemoteSoftwareVNC%" equ "ON" (
       REM -- Optional VNC Viewer starten
       call "ProgStart_If_NotRuning.cmd" "WinVNC" "%BinPublic_DP%\UltraVNC\winvnc.exe"
 )

 REM new 31.05.2010 21:53
 if /i "%JobMgr_use_TcServerKill%" equ  "ON" (
   call ProgIs_Running.cmd  teamcenter teamcenter_Is_running
   if "%teamcenter_Is_running%" equ "0" (
     REM TcServer Process beenden aber nur wenn TeamCenter nicht aktive ist
     call ProgKill.cmd TcServer "#12-Data#\RefileNx75_TcServerStop_log.txt"
    )
 )

 REM  --------------------------------------------------------------------------
 REM # UG Umgebungsvariablen setzen (wenn Erforderlich !!)
 REM if "%UGII_BASE_DIR%" equ "" set UGII_BASE_DIR=C:\UG\UGNX8
 REM if "%UGII_ROOT_DIR%" equ "" set UGII_ROOT_DIR=%UGII_BASE_DIR%\UGII

 REM -- am Ende "\"  abschneiden
 if "%UGII_BASE_DIR:~-1%" equ "\" set UGII_BASE_DIR=%UGII_BASE_DIR:~0,-1%
 if "%UGII_ROOT_DIR:~-1%" equ "\" set UGII_ROOT_DIR=%UGII_ROOT_DIR:~0,-1%

 REM -- Suchpath angepasst erforderlich da sonst der refile nicht startet
 set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%
 REM -- UG-Variablen umbiegen --------------------------------------------------
 REM #Doc: Anwenderstandards *.dpv umbiegen
 SET UGII_LOCAL_USER_DEFAULTS=%CmdCurRoot_DP%\startup\NX75_Refile.dpv
 set UGII_USER_DIR=%CmdCurRoot_DP%
 set UGII_GROUP_DIR=

 REM #Doc: steuerung Load_options
 REM 21.12.2009 J.Fes angepasst dass wenn %UGII_LOAD_OPTIONS_NE% via JobScriptParametersExtended uebergeben wurde
 set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\load_options_refile.def
 if defined UGII_LOAD_OPTIONS_NE if exist "%CmdCurRoot_DP%\%UGII_LOAD_OPTIONS_NE%" set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\%UGII_LOAD_OPTIONS_NE%

 set UGII_TMP_DIR=%temp%
 set UGII_UGSOLIDS_TMP=%UGII_TMP_DIR%

 REM For NX75 disable eingefuegt 17.08.2012 J.Fes / K.S
 set UGII_UGMGR_USE_CACHE=

 REM -- Sysmmetric Multi-Processing (SMP) --------------------------------------
 REM diabled 07.02.2011
 set UGII_SMP_ENABLE=

 REM -- CGM erstellung deaktiveren eingefuegt 09.02.2010 J.fes
 set UGII_IMAGE_CREATE_CGM=
 set UGII_IMAGE_CREATE_CGM_DRAW=
 set UGII_IMAGE_CREATE_CGM_OPTIONS=
 set UGII_IMAGE_CREATE_NAME=
 set UGII_IMAGE_CREATE_ORIGINAL_BACKGROUND=

 REM -- PFM vermeidet fehler beim refile von PFM Parts eingefuegt 29.11.2010 Info erhalten ber IR1814812
 set UGII_UGMGR_ALLOW_PFM_IMPORT_EXPORT=1

 REM -- IMAN-Variablen umbiegen -------------------------------------------
 SET IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 SET IMAN_KEEP_SYSTEM_LOG=TRUE
 SET UGII_KEEP_SYSTEM_LOG=TRUE
 SET IMAN_Journalling=OFF
 SET IMAN_journaling=OFF
 SET IMAN_TRACEBACK=OFF
 SET IMAN_Journal_Modules=NONE
 SET API_JOURNAL=NONE
 set APB_SCHEMA=

 REM -- TC-Variablen umbiegen -------------------------------------------
 REM 11.08.2010 16:44SQL Debug on for Test's
 SET TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 SET TC_KEEP_SYSTEM_LOG=TRUE
 SET TC_Journalling=OFF
 SET TC_Journaling=OFF
 SET TC_TRACEBACK=OFF

 rem new 12.07.2013 16:29
 set TC_SHARED_MEMORY_DIR=%CmdCurRoot_DP%\..\TC_SHARED_MEMORY_%TcSiteId%
 if not exist "%TC_SHARED_MEMORY_DIR%" md "%TC_SHARED_MEMORY_DIR%"

 REM -- Use TcNx Debug Variables ----------------------------------------------------
 if /I "%JobMgr_TcNxDebug%" neq "ON" goto :JumbOver
   Banner TcNxDeb:ON
   set TC_Journalling=ON
   set TC_Journal_Modules=ALL
   set TC_TRACEBACK=ON

   REM -- (Note the small j and single l)
   set TC_journaling=ON
   REM  (Make sure it is N and not ON)
   set TC_POM_JOURNALLING=N
   set TC_Journal_Modules=ALL
   set TC_SQL_DEBUG=BJTP

   REM -- (SUMMARY for shorter list)
   set TC_JOURNAL=FULL
   set TC_JOURNAL_LINE_LIMIT=0
   set TC_DATASET_DEBUG=on
   set JOURNAL_dpat_report=on

   REM -- this variable prints the SOA based server calls timing information into the syslog
   set UGII_UGMGR_MONITOR_NETWORK_CALLS=1
   set UGII_DEBUG=OCC_update_structure
   set TC_SLOW_SQL=-1
   set TC_KEEP_SYSTEM_LOG=true
   set WhereReferencePOMPref=1
   REM Vorsicht !!
   REM set UGII_CHECKING_LEVEL=1
:JumbOver

 rem #Doc: JobParameter is to set on this line
 set JobParameter=#JobParameter#

 REM #Doc: -- Multisite Variablen setzen new 11.12.2009 J.Fes -----------
 REM #Doc: verfuegbar ab Tc 2007.1, und jeder NX6 Version You have to set (Dave Howe:)
 REM #Doc: Environ Variable: UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS=true
 REM #Doc: Refile Parameter: -replica_bypass=yes switch.
 if /I "%JobParameter%" NEQ "%JobParameter: -replica_bypass=yes=%" (
    SET SpOpt_RefileReplicaParts=true
    SET UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS=true
    REM ergnzt 18.05.2010 J.Fes siehe E-Mail Geisler, David  15. Mai 2010 00:19
    SET IMAN_UG_REFILE_REPLACE_FILE=true
    rem umgestellt von set UGII_DISABLE_PREVIEW=on auf set UGII_DISABLE_PREVIEW=
    set UGII_DISABLE_PREVIEW=ON
    rem umgestellt von set UGII_DISABLE_QAF_NAMED_REFS=ON auf set UGII_DISABLE_QAF_NAMED_REFS
    set UGII_DISABLE_QAF_NAMED_REFS=ON
 ) else (
    SET SpOpt_RefileReplicaParts=false
    SET UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS=
    SET IMAN_UG_REFILE_REPLACE_FILE=
    rem UGII_DISABLE_PREVIEW nicht bei OwingSite Object's
    set UGII_DISABLE_PREVIEW=
    rem umgestellt von set UGII_DISABLE_QAF_NAMED_REFS=ON auf set UGII_DISABLE_QAF_NAMED_REFS
    set UGII_DISABLE_QAF_NAMED_REFS=
 )

 if /i "%JobMgr_Debug%" neq "xON" goto :JumbOver
  Echo #Debug: Check if RfPara contains:'-replica_bypass=yes'
  Echo JobParameter..........................: [%JobParameter%]
  Echo SpOpt_RefileReplicaParts..............: [%SpOpt_RefileReplicaParts%]
  Echo UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS: [%UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS%]
  pause
:JumbOver

 if /I "%JobParameter%" equ "%JobParameter: -update_mod_props=no=%" goto :JumbOver
    REM #Doc: 01.06.2011 23:12 Info from Phil.K
    SET TC_UPDATE_MOD_PROPS=NO
:JumbOver

 REM -- #Customer Settings ---------------------------------------------------------
 REM #ToDo: place all extendet Cutomer Settings at the next lines
 
 REM -- Refile Programm --------------------------------------------------------
 set refile_program_exe_DPNE=%UGII_BASE_DIR%\UGMANAGER\ugmanager_refile_program.exe
 if not exist "%refile_program_exe_DPNE%" goto :refile_program_exe_DPNE_Error

 REM -- define RfPara ----------------------------------------------------------
 set RfPara=%JobParameter%
 call :Parse_ALL %UGII_LOAD_OPTIONS% UGII_LOAD_OPTIONS
 call :Parse_ALL %UGII_LOCAL_USER_DEFAULTS% UGII_LOCAL_USER_DEFAULTS
 
 call :ColorSet Standard

 Echo.                                                                               .
 Echo %title_str%
 Echo --------------------------------------------------------------------------
 Echo RefileJob Info:
 Echo JobName.............: %JobName%
 Echo Computer............: %ComputerName%
 Echo Refile Environ......:
 Echo RfDir...............: %temp:~-50%
 Echo TcSide..............: #TcSite.SiteInfoWith_SiteId_and_pName#
 Echo TcUser..............: %JobMgr_TcUser%
 Echo FMS_HOME............: %FMS_HOME%
 Echo TC_ROOT.............: %TC_ROOT%
 Echo TC_DATA.............: %TC_DATA%
 Call :JobParam_List "Refile Parameter....:" "%RfPara%"
 Echo Special Options.....:
 Echo RfReplicaParts......: %SpOpt_RefileReplicaParts%
 Echo UGII_LOAD_OPTIONS...: ..\%UGII_LOAD_OPTIONS_NE%
 Echo UGII_SITE_DIR.......: %UGII_SITE_DIR%
 Echo UGII_LOCAL_USER_DEF.: ..\%UGII_LOCAL_USER_DEFAULTS_NE%
 REM Echo UGII_GROUP_DIR..: %UGII_GROUP_DIR%
 REM Echo UGII_USER_DIR...: %UGII_USER_DIR%
 REM Echo.

 rem Inc. JobMgr_VolMap wenn erforderlich (siehe: ..\OptionFiles\Refile_VolumeMapper_Einbinden_in_Refile_Script.TXT)

 REM -- set special variables from cmd file --
 call "%RfSetVariables_cmd%"

 cd /d "%temp%"
 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 Echo Refile Protocol: 
 REM -- hier wird das Refileprogram gestartet --
 call "%refile_program_exe_DPNE%" %RfPara% -i="%RfPaket_DPNE%" -log="%RfJobLog_DPNE%" -out="%RfFailedLog_DPNE%" -u=%JobMgr_TcUser% -p=%JobMgr_TcPw%
 set RefileProgramResultLevel=%errorlevel%

 :RfEnd
 REM set Color OK da refile_program_exe_DPNE beendet werden konnte
 Call :ColorSet OK
 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 Banner "Rf:End"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo #Debug Refile Results Info:
   Call :TypeFile "%RfCmdJobLog_DPNE%"  "Rf Cmd Log:"
   Call :TypeFile "%RfJobLog_DPNE%"     "Rf Job Log:"
   Call :TypeFile "%RfFailedLog_DPNE%"  "Rf Failed Log:"
   pause
:JumbOver

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
  Echo -------------------------------------------------------------------------
  Echo #TestMode: after excuting Refile:
  Echo TcPromtCmd........: [%TcPromtCmd%]
  Echo TcPromtCmdOpt.....: [%TcPromtCmdOpt%]
  Echo refile_program.exe: [%refile_program_exe_DPNE%]
  Echo RfPara............: [%RfPara%]
  Echo RfPaket...........: [%RfPaket_DPNE%]
  Echo -------------------------------------------------------------------------
  pause
:JumbOver

 if not "%RefileProgramResultLevel%"=="0" goto :RefileProgramResultErr

 REM -- alle Files loeschen die nicht zum JobServer gesendet werden sollen
 REM    aber nicht wenn eines der bedingungen:JobMgr_Debug :JobMgr_TcNxDebug JobMgr_Test 'ON' ist
 if /I "%JobMgr_TcNxDebug%" neq "ON" (
    if /I "%JobMgr_Debug%" neq "ON" (
       if /I "%JobMgr_Test%" neq "ON" (
          del /S /Q "%temp%\apiserver.exe*.*","%temp%\*.bak","%temp%\*.tmp","%temp%\*.prt","%temp%\tcserver.*","%temp%\tcserver.*.*">nul 1>nul 2>nul
       )
    )
 )
 if /I "%JobMgr_Debug%" equ "ON" Pause
 goto :eof

REM ============================================================================
:ExtractIrList
 rem #Doc: Extracts the IR lists for Refile input
 rem #New: 15.07.2013

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "RefileTC_2012_01"
 set toRun=%toRun% -SubAction extract
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobTemp1_SO_DP "%JobTemp1_SO_DP%"
 set toRun=%toRun% -JobTemp2_RO_DP "%JobTemp2_RO_DP%"
 set toRun=%toRun% -RfInputList1_SO_DPNE "%RfInputList1_SO_DPNE%"
 set toRun=%toRun% -RfInputList2_RO_DPNE "%RfInputList2_RO_DPNE%"
 set toRun=%toRun% -JobData1ToProcessDoPrint

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_01_ExtractIrList.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo #Debug.: BEVOR: [%~0]
   Echo %toRun% >>"%Debug_DPNE%"
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
   pause
:JumbOverDebug

 call %toRun%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   Echo #Debug.: After: [%~0]
   pause
:JumbOverDebug

goto :eof


rem ============================================================================
:EvaluateRefileResult
 rem #Doc: Evaluate the refile results
 rem #New: 15.07.2013

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "RefileTC_2012_01"
 set toRun=%toRun% -SubAction evaluate
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobTemp1_SO_DP "%JobTemp1_SO_DP%"
 set toRun=%toRun% -JobTemp2_RO_DP "%JobTemp2_RO_DP%"
 set toRun=%toRun% -RfInputList1_SO_DPNE "%RfInputList1_SO_DPNE%"
 set toRun=%toRun% -RfInputList2_RO_DPNE "%RfInputList2_RO_DPNE%"
 set toRun=%toRun% -RfLogFile1_SO_DPNE "%RfLogFile1_SO_DPNE%"
 set toRun=%toRun% -RfLogFile2_RO_DPNE "%RfLogFile2_RO_DPNE%"
 set toRun=%toRun% -RfFailedLog1_SO_DPNE "%RfFailedLog1_SO_DPNE%"
 set toRun=%toRun% -RfFailedLog2_RO_DPNE "%RfFailedLog2_RO_DPNE%"
 set toRun=%toRun% -JobData2ResultsDoPrint

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_03_EvaluateRefileResult.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo #Debug.: BEVOR: [%~0]
   Echo %toRun% >>"%Debug_DPNE%"
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
   pause
:JumbOverDebug

 call %toRun%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   Echo #Debug.: After: [%~0]
   pause
:JumbOverDebug

goto :eof


REM ###### ------------ Standard Subroutines ---------------------- ##########
REM ============================================================================
:JobParam_List
 setlocal
  set ParmListTitle=%~1
  set JobParams=%~2
  rem " ersetzen durch '
  set JobParams=%JobParams:"='%
  set NCur=0
:JobParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%JobParams%") do Call :JobParam_Print "%%i"
  if %NCur% LEQ 10 goto :JobParam_List_PrintNext
 endlocal
 goto :eof

:JobParam_Print
 setlocal
  set JobParaCur=%~1
  if "%NCur%" equ "1" (
                            Echo %ParmListTitle% -%JobParaCur%
  ) else (
   if "%JobParaCur%" neq "" Echo                     : -%JobParaCur%
  )
 endlocal
 goto :eof

REM ============================================================================
:RefileProgramResultErr
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_RefileProgramResultErr.txt
 set title_str=ERR:%RefileProgramResultLevel% !! error running ugmanager_refile_program.exe [%Date%/%time:~0,8%] !!
 title %title_str%
 call :ErrLogHeaderWrite
 Echo --------------------------------------------------------------------------
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo Refile Prog         : %refile_program_exe_DPNE%>>"%ErrLog_DPNE%"
 Echo ends with Err Level : %RefileProgramResultLevel% >>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite

 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /I "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 pause
 goto :end


REM ============================================================================
:TcPromtCmdError
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_MissingTcPromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start refile on:\\%ComputerName% missing TCEPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TcPromtCmd:=%TcPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
 goto :end

REM ============================================================================
:FMS_HOME_ERR
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_FMS_HOME_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start refile on:\\%ComputerName%  FMS_HOME:[%FMS_HOME%] Dir Not found [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo FMS_HOME Dir not foundFMS_HOME:[%FMS_HOME%] Dir Not found >>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 REM if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
 goto :end


REM ============================================================================
:refile_program_exe_DPNE_Error
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_Missing_Refile_Program.Exe_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start refile on: [\\%ComputerName%] missing refile_program.exe [%Date%/%time:~0,8%] !!
 call :ErrLogHeaderWrite
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 REM Error in die Datei schreiben!
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo refile_program_exe_DPNE:=%refile_program_exe_DPNE%>>%temp%\__ErrorUp-ReadMeFirst-DeaktivateComputer.txt>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite

 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
 goto :end

REM ============================================================================
:ErrLogHeaderWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ErrLogFooterWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo.>>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
 Echo.>>"%ErrLog_DPNE%"
 Echo -- Path Environ ---------------------------------------------------------->>"%ErrLog_DPNE%"
 set PATH>>"%ErrLog_DPNE%"

 Echo -- UG* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set UG>>"%ErrLog_DPNE%"
 Echo -- IMAN* Environ --------------------------------------------------------->>"%ErrLog_DPNE%"
 set IMAN>>"%ErrLog_DPNE%"
 Echo -- All Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set>>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ColorSet
Rem Stand 25.06.2011
Rem Examples:
 REM call :ColorSet Standard
 REM call :ColorSet IsExecuting
 REM call :ColorSet IsIdel
 REM call :ColorSet End
 REM call :ColorSet Ende
 REM call :ColorSet Ok
 REM call :ColorSet Err

 REM -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei
 REM -- Farben nach Status setzen
 REM Gelb Schwarz
 if /I "%~1" equ "Standard"    set JobColorLast=E0
 REM 25.06.2011 07:00 Standard eingef. IsExecuting Neu
 if /I "%~1" equ "IsExecuting" set JobColorLast=D0
 REM Blaugrn Schwarz 15.11.2010 07:45 Hellgrau Schwarz
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 REM Hellgrau Schwarz
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 REM Gruen Schwarz
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 REM Rot Schwarz
 if /I "%~1" equ "Err"         set JobColorLast=C0

 REM jetzt die Farbe setzen
 if "%JobColorLast%" neq "" color %JobColorLast%
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
  Echo Description    : %FileDescription%
  Echo Contens of File: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo Info...........: File not exist
 endlocal
 goto :eof

REM ============================================================================
:Wait
 set waitTime=2
 if "%1" neq "" set waitTime=%1
 CHOICE.exe /C:w /N /T:w,%waitTime% "warte %waitTime%[sec] oder [w] druecken fuer weiter: "
 goto :eof

REM ============================================================================ 
:Parse_ALL
 REM parst alle File Bezeichner aus
 REM "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 REM "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof 

REM ============================================================================
:Ugsshare_DiskConnectErr
 set ErrLog_DPNE=%temp%\__Err_Ugsshare_DiskConnect.txt
 REM schreibt die erweiterten Infos an einen ErrLogFile
 Echo Err: erf. Netzwerkverb. fuer: %TcSiteId% [%ConnectNetUnc_to_Info%] konnte nicht richtig verbunden werden!!>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 type "%ErrLog_DPNE%"
 Echo !!Einstellungen oder Netzwerkverbindungen pruefen!!
 cmd 
 Pause
 goto :eof

REM ============================================================================
:end
 cd /d "%tempOrig_DP%"
 Echo --------------------------------------------------------------------------
 Echo Info: all files in: [%temp%]
 Echo       will be zipt by JobClient and send to JobServer
 REM -- farbe wieder auf standard zurueck setzen
 Call :ColorSet End
