@Echo off
 rem setlocal EnableDelayedExpansion EnableExtensions

 call :ColorSet IsIdel
 Echo --------------------------------------------------------------------------
 Echo Script Refile Tests mit NX75
 Echo (c) J.Feuerstein 24.11.2006
 Echo.
 Echo Aenderungs Info:
 Echo User    Date/Time (Shift+strg+T)  Infotext:
 Echo J.Fes   24.11.2006 00:05       Ersterstellung 24.11.2006
 Echo J.Fes   25.10.2010 18:03       anpassungen NX7.5

 call :DateTimeNowGet

 rem ---------------------------------------------------------------------------
 rem Rootpfade setzen
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%
 set path=%CmdCurRoot_DP%;%Path%
 set TceSiteId=%ORACLE_SID%
 rem RfTestSetting File organiesieren
 set RfTestSetting_DPNE=%CmdCurRoot_DP%\RfTestSetting_Custom_Site_%TceSiteId%.cmd
 if exist "%RfTestSetting_DPNE%" call "%RfTestSetting_DPNE%"
 Echo rem Custom SetupFile create %Date% %time% by %UserName% \\%ComputerName%>"%RfTestSetting_DPNE%"

 rem ---------------------------------------------------------------------------
 rem temp dir Organiesieren
 set temp=%CmdCurRoot_DP%\RfTemp-%DateTimeNowFileExt%
 if not exist "%temp%" md "%temp%"
 cd /d "%temp%"


 rem --------------------------------
 rem ## UG Umgebungsvariablen setzen (wenn Erforderlich !!)
 rem if "%UGII_BASE_DIR%"=="" set UGII_BASE_DIR=C:\UG\UGNX4
 rem if "%UGII_ROOT_DIR%"=="" set UGII_ROOT_DIR=C:\UG\UGNX4\UGII

 rem Suchpath angepasst erforderlich da sonst der refile nicht startet
 set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%

 rem ------ Anwenderstandards *.dpv umbiegen --- wichtig muss mit ..\StartUp\.. Enden
 rem Hinweis die beim Refile verwendeten Anwenderstandarts sind in das Verzeichniss:
 SET UGII_LOCAL_USER_DEFAULTS=%CmdCurRoot_DP%\startup\nx_refile.dpv
 set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\load_options_refile.def

 rem -- UG-Variablen umbiegen --
 set UGII_TMP_DIR=%temp%
 set UGII_UGMGR_USE_CACHE=
 set UGII_DISABLE_PREVIEW=on
 set UGII_DISABLE_QAF_NAMED_REFS=on

 rem -- IMAN-Variablen umbiegen --
 SET IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 SET IMAN_KEEP_SYSTEM_LOG=TRUE
 SET UGII_KEEP_SYSTEM_LOG=TRUE
 SET IMAN_Journalling=OFF
 SET IMAN_journaling=OFF
 SET IMAN_TRACEBACK=OFF
 SET IMAN_Journal_Modules=NONE
 SET API_JOURNAL=NONE
 set APB_SCHEMA=

 rem -- TC-Variablen umbiegen -------------------------------------------
 rem 11.08.2010 16:44SQL Debug on for Test's
 SET TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 SET TC_KEEP_SYSTEM_LOG=TRUE
 SET TC_Journalling=OFF
 SET TC_Journaling=OFF
 SET TC_TRACEBACK=OFF


 rem -- Refile Logfiles festlegen --
 set RfJobLog_DPNE=%temp%\_RefileJob.LOG
 set RfFailedLog_DPNE=%temp%\_RefileJobFaild.LOG
 rem -- RefilePaketFile festlegen
 set RefilePaket_DPNE=%CmdCurRoot_DP%\RfTest_Tc_InputList.txt

 Echo --------------------------------------------------------------------------
 Echo Input Tc User an Password
 if not defined TcUser         set TcUser=infodba
 if not defined TcUserPw set TcUserPw=infodba
 set /P TcUser="TcUser (Return=%TcUser%):"
 set /P TcUserPw="Password  (Return=%TcUserPw%):"
REM  Echo ##Debug: TcUser=[%TcUser%]
REM  Echo ##Debug: TcUserPw=[%TcUserPw%]

 Echo set TcUser=%TcUser%>>"%RfTestSetting_DPNE%"
 Echo set TcUserPw=%TcUserPw%>>"%RfTestSetting_DPNE%"
 Echo --------------------------------------------------------------------------


 rem ## die verwendeten Refile Parameter:
 rem set JobParameter=
 set JobParameter=-keep_volume=yes
 set JobParameter=%JobParameter% -non_master=yes
 set JobParameter=%JobParameter% -bypass=yes
 set JobParameter=%JobParameter% -update_mod_props=no
 set JobParameter=%JobParameter% -refile_released=yes
REM  set JobParameter=%JobParameter% -structure_sync=no
REM  set JobParameter=%JobParameter% -force_structure_sync=no
REM  set JobParameter=%JobParameter% -y
REM  set JobParameter=%JobParameter% -force_refile
REM  set JobParameter=%JobParameter% -replica_bypass=yes


 if /I "%JobParameter%" NEQ "%JobParameter: -replica_bypass=yes=%" (
    SET SpOpt_RefileReplicaParts=true
    SET UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS=true
    rem ergnzt 18.05.2010 23:23 J.Fes siehe E-Mail Geisler, David  15. Mai 2010 00:19
    SET IMAN_UG_REFILE_REPLACE_FILE=true
 ) else (
    SET SpOpt_RefileReplicaParts=false
    SET UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS=
    SET IMAN_UG_REFILE_REPLACE_FILE=
 )
 set RfPara=%JobParameter%

 rem ## -i oder -folder
 set JobParameter=%JobParameter% -i=%RefilePaket_DPNE%
 rem set JobParameter=%JobParameter% -folder=RefileTest20071109
 set JobParameter=%JobParameter%

 rem -- Multisite refiling of remote parts
 rem SET IMAN_UG_REFILE_REPLACE_FILE=TRUE

 rem -- start Refile Programme ----------------------------------
 set refile_program_exe_DPNE=%UGII_BASE_DIR%\UGMANAGER\ugmanager_refile_program.exe
 set run_refile=%refile_program_exe_DPNE% %JobParameter% -log=%RfJobLog_DPNE% -out=%RfFailedLog_DPNE%

 if exist "%refile_program_exe_DPNE%" Echo RefileProg Ok: "%refile_program_exe_DPNE%"

:StartRefileOk
 set title_str=Refile Test [%TceSiteId%] [Start:%Date%/%time:~0,8%] [\\%ComputerName%] [%TcUser%]
 title %title_str%
 Echo %title_str%
 Echo --------------------------------------------------------------------------
 Echo RefileJob Info:
 Echo Computer............: %ComputerName%
 Echo TcUser..............: %TceSiteId%
 Echo RfDir...............: %temp%
 Echo TcUser..............: %TcUser%
 Echo FMS_HOME............: %FMS_HOME%
 Echo Refile Parameter....:
 Call :RfParam_List "%RfPara%"
 Echo RfReplicaParts......: %SpOpt_RefileReplicaParts%
 Echo UGII_LOAD_OPTIONS...: %UGII_LOAD_OPTIONS%
 Echo UGII_SITE_DIR.......: %UGII_SITE_DIR%
 Echo UGII_LOCAL_USER_DEF.: %UGII_LOCAL_USER_DEFAULTS%

 Echo --------------------------------------------------------------------------
 Echo Refile this items:
 type "%RefilePaket_DPNE%"
 Echo --------------------------------------------------------------------------
 :doNextMenu
 Echo --------------------------------------------------------------------------
 set doNext=
 set /P doNext="type S=Start Q=Quit do not start Refile:"
 if /I "%doNext%" equ "S" goto :RfStart
 if /I "%doNext%" equ "Q" Echo nothing done Quit&pause& goto :RfStartNo
 goto :doNextMenu

:RfStart
 call :ColorSet IsExecuting
 Echo --------------------------------------------------------------------------
 Echo Explorer starts now in RfLogDir:
 Echo %temp%
 start ""  Explorer "%temp%"
 Echo --------------------------------------------------------------------------
 Echo Refile Start:[%Date%/%time:~0,8%]
 set >"%temp%\_EnvironInfo.txt"
 rem Check FMS_HOME
 if not exist "%FMS_HOME%" goto :FMS_HOME_ERR

 rem -- hier wird das Refileprogram gestartet --
 call %run_refile% -u=%TcUser% -p=%TcUserPw% -g=dba
 set RefileProgramResultLevel=%errorlevel%
 Echo Refile Ends :[%Date%/%time:~0,8%]
 Echo Refile Ends with Result:"%RefileProgramResultLevel%"
 if "%RefileProgramResultLevel%" equ "0" (
  goto :RfOk
 ) else (
  goto :RfErr
 )

:RfOk
 call :ColorSet OK
 goto :RfEnd
:RfErr
 call :ColorSet Err
 goto :RfEnd


:RfEnd
 Echo --------------------------------------------------------------------------
 Echo Refile LogFiles:
 Echo RfLog :[%RfJobLog_DPNE%]
 Echo RfFail:[%RfFailedLog_DPNE%]
 pause
 Echo --------------------------------------------------------------------------
 goto :end

:RfStartNo
 cd /d "%CmdCurRoot_DP%"
 rd /s /q "%temp%"
 goto :end

rem ============================================================================
:StartRefileError
 set title_str=ERR: !! cannot start refile on: [\\%ComputerName%] missing refile installation [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 Echo %title_str%
 rem Error in die Datei schreiben!
 Echo %title_str%>>%temp%\__ErrorUp-ReadMeFirst-DeaktivateComputer.txt
 goto :end
 
 
rem ============================================================================
:DateTimeNowGet
 rem call :DateTimeNowGet
 rem Set File_LPNE=%DatRoot_LP%\MyName-%DateTimeNowFileExt%.txt


 if     "%time:~0,1%"==" " set time-h=0%time:~1,1%
 if not "%time:~0,1%"==" " set time-h=%time:~0,2%

 if     "%time:~3,1%"==" " set time-m=0%time:~4,1%
 if not "%time:~3,1%"==" " set time-m=%time:~3,2%

 set Date-Y=%Date:~6,4%
 set Date-M=%Date:~3,2%
 set Date-D=%Date:~0,2%
 set DateTimeNowFileExt=%Date-Y%-%Date-M%-%Date-D%-%time-h%-%time-m%
 goto :eof

rem ============================================================================
:ColorSet
 rem -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei

 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 rem Blaugrn Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=30
 if /I "%1"=="IsIdel"      set JobColorLast=B0
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof
rem ============================================================================
:RfParam_List
 setlocal
  rem entfernen von " durch '' = nichts
  rem set RfPara=%RfPara:"=%
  set RfPara=%~1
  set NCur=0
 :RfParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%RfPara%") do Call :RfParam_Echo "%%i"
  if %NCur% LEQ 10 goto :RfParam_List_PrintNext
 endlocal
 goto :eof

:RfParam_Echo
 setlocal
  set RfParaCur=%~1
  if not "%RfParaCur%"=="" Echo                     : -%RfParaCur%
 endlocal
 goto :eof
rem ============================================================================
:FMS_HOME_ERR
 Call :ColorSet ERR
 set title_str=ERR: !! cannot start refile on:\\%ComputerName%  FMS_HOME:[%FMS_HOME%] Dir Not found [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 goto :end

rem ============================================================================
:end
 cd /d "%CmdCurRoot_DP%"
 endlocal

