/* UG-Datasets einer IR 28.10.09 J.Fes/T.Nestler */
Select
  pd.puid               As DataSetPuid,
  wso.pobject_name      As DataSetName,
  wso.pobject_desc      As DataSetDescription, -- description
  pdt.pdatasettype_name As DataSetType,        -- UGMASTER.. UGPART.. UGALTREP..
  ptype.ptype_name      As DataSetPTYPE_NAME,  -- neu 8.2.09 PType_Name: IMAN_specification. IMAN_UG_altrep IMAN_UG_scenario IMAN_specification IMAN_manifestation
  pu_owni_ds.puser_id   As DataSetOwningUser,
  pg_owni_ds.pname      As DataSetOwningGroup,
  pao.pcreation_date    As DataSetCreateDate,
  pu_lmod_ds.puser_id   As DataSetLastModUser,
  pao.plast_mod_date    As DataSetLastModDate,
  imv.pvolume_name      As imv_pvolume_name,    -- volume name
  imv.pmachine_type     As imv_pmachine_type,   -- Maschinen Type 0=winnt 1=
  imv.punix_path_name   As imv_punix_path_name, -- vol_DP unix pathname
  imv.pwnt_path_name    As imv_pwnt_path_name,  -- vol_DP windows
  imf.psd_path_name     As imf_psd_path_name,
  imf.pfile_name        As imf_pfile_name
From
  infodba.PDATASET pd,
  infodba.PIMANRELATION pr,
  infodba.PIMANTYPE ptype,
  infodba.PWORKSPACEOBJECT wso,
  infodba.PPOM_APPLICATION_OBJECT pao,
  infodba.PDATASETTYPE pdt,
  infodba.PPOM_USER pu_owni_ds,  -- DS OwningUser
  infodba.PPOM_USER pu_lmod_ds,  -- DS LastModUser
  infodba.PPOM_GROUP pg_owni_ds, -- DS OwningGroup
  infodba.PREVISIONS rev,
  infodba.PREF_NAMES rn,
  infodba.PREF_LIST rl,
  infodba.PIMANFILE imf,
  infodba.PIMANVOLUME imv
Where
  pr.rsecondary_objectu   = pd.puid
and ptype.puid            = pr.rrelation_typeu
and pd.rdataset_typeu     = pdt.puid
and wso.puid              = pd.puid
and pu_owni_ds.puid       = pao.rowning_useru
and pu_lmod_ds.puid       = pao.rlast_mod_useru
and pg_owni_ds.puid       = pao.rowning_groupu
and rl.puid               = pd.puid
and imf.puid              = rl.pvalu_0
and imv.puid              = imf.rvolume_tagu
and pao.puid              = rev.pvalu_0
and rn.pseq               = rl.pseq
and pd.rrev_chain_anchoru = rev.puid
and rev.pvalu_0           = rn.puid
and
  (
    pr.rprimary_objectu = :para_puid
  and rn.pval_0         = 'UGPART'  -- nur UGPART
  and rev.pseq          = 0         -- n.last Doc
  )
