Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Procedures    : [ObjectsUpdate_ProcessStatus]'
Print ' Creation Date : 08.04.2013'
Print ' Autor         : J.Feuerstein'
Print '' Print ''
Print '-------------------------------------------------------------------------'
GO

use [#DB_N#]
GO

------------------------------------------------------------------
-- Abschnitt: ProsessDaten verarbeiten
------------------------------------------------------------------
Print '' Print ''
Print '-- [ObjectsUpdate_ProcessStatus] ----------------------------------------'
If Exists (select Name
           from sysobjects
           where Name = "ObjectsUpdate_ProcessStatus" and type = "P")
Drop Procedure ObjectsUpdate_ProcessStatus
GO

CREATE Procedure ObjectsUpdate_ProcessStatus
                    (
                    @ObjectDataTableProcStateCol     nvarchar (32) ,     -- Name der Spalte ProcStateCol01..10 ProcStateColRf in dem der Processtatus der Quelltabelle steht

                    @Objects_tbl_ID                  uniqueidentifier = null ,  -- ID des zu bearbeitenden Datensatzes in Objects_tbl

                    @ObjectName                      nvarchar (32) , -- Name
                    @ObjectFromSiteID                nvarchar (32) , -- von welcher site
                    @ObjectCliName                   nvarchar (255) , -- Cli Name des Objectes Ir Example: @DB/ItemName/Rev  Ds Example: @DB/ItemName/Rev/specification/ObjectName
                    @IRCliName                       nvarchar (255) , -- IR Cli Objectes Ir Example: @DB/ItemName/Rev (new:15.02.2012 J.Fes)
                    @ObjectClass                     nvarchar (10) , -- DS IR

                    @ObjectSpecialEditRule           nvarchar (64) , -- new 30.1.09  Rule1='UgMaster_Of_Ir' Rule2='SetPStateTo_IR_And_DS'

                    @JobControlRuleName              nvarchar (32) ,

                    @JobControl_ObjectsProcessData_tbl_ID uniqueidentifier = null , -- Ref auf Datensatz in JobControl_ObjectsProcessData_tbl

                    @ProcessPacketName               nvarchar (64)  ,
                    @ProcessOnSiteID                 nvarchar (32)  ,
                    @ProcessState                    nvarchar (34)  ,   -- beinhaltet den Process Status eines Objektes Size geandert auf 34 23.11.2011 J.Fes
                    @ProcessStateExtendetEdit_SQL    nvarchar (max) ,   -- new 19.07.2012 J.Fes setzt erw. P.Satus via ProcStateCol01='M', ProcStateCol02='M'
                    @ProcessTimeStart                datetime ,
                    @ProcessTimeEnd                  datetime ,
                    @ProcessCMDLine                  nvarchar (255) ,
                    @ProcessResultCode               nvarchar (32)  ,
                    @ProcessResultMsg                nvarchar (255) ,
                    @ProcessResultHasWarning         bit ,
                    @ProcessResultLink               nvarchar (255) ,
                    @ProcessOnComputer               nvarchar (64)  ,
                    @TaskScheduler_tbl_ID            uniqueidentifier = null , -- ID des referenzierten TaskSheduler Datensatzes in TaskScheduler_tbl
                    @ProcessPrgUsedVer               nvarchar (255) , -- #New: 05.04.2013 / J.Fes
                    @ProcessObjectSaveVersion        nvarchar (64) = null ,  -- #New: 05.04.2013 / J.Fes

                    @ProcessProcStateCol             nvarchar (32) ,    -- Info: @ObjectDataTableProcStateCol beinhaltet den gleichen Wert wird jedoch aus bersichtsgrnden mit verwendet

                    @ObjectCliName_SQL_r             nvarchar (255) = null Output  ,   -- Cli Return neu 15.02.2012 J.Fes
                    @Objects_tbl_ID_SQL_r            uniqueidentifier = null Output   -- ID  Return neu 15.02.2012 J.Fes
                    )
   /*
   Lastet die Daten der Process verarbeitungen in die Datenbank ein
   wichtig bei Struktur anpassungen ist immer die dazugehrigen View zu prfen !!
   */
As
BEGIN

 Declare @DebugPrintOn bit
 set @DebugPrintOn = 0

 DECLARE @ObjectId uniqueidentifier
 DECLARE @ExecuteSQLstr nvarchar(max)
 DECLARE @MyValue nvarchar(max)

 if @DebugPrintOn = 1
     begin
      EXECUTE zzzzzDebugTbl_Empty
     end

 -- wenn @Objects_tbl_ID gegeben ist dann diese suchen lassen
 if @Objects_tbl_ID IS NOT NULL
    BEGIN
     -- pruefen ob Object Datensatz in Objects_tbl vorhanden ist
     select @ObjectId=Id from Objects_tbl where ID = @Objects_tbl_ID
    END

 -- Abschnitt Objects_tbl bearbeiten --------------------------------------------------------------------------------
 if @DebugPrintOn = 1
  begin
   set @MyValue = CONVERT(varchar(64), @Objects_tbl_ID)
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '01-@Objects_tbl_ID:' ,         @MyValue
   set @MyValue = CONVERT(varchar(64), @ObjectId)
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '02-@ObjectId:' ,               @MyValue
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '03-@ObjectSpecialEditRule:' ,  @ObjectSpecialEditRule
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '04-@ObjectName:' ,             @ObjectName
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '05-@ObjectCliName:' ,          @ObjectCliName
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '06-@ObjectFromSiteID:' ,       @ObjectFromSiteID
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '07-@ObjectClass:' ,            @ObjectClass
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '08-@ProcessProcStateCol' ,     @ProcessProcStateCol
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '09-@ProcessPrgUsedVer:' ,      @ProcessPrgUsedVer
   EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '10-@ProcessObjectSaveVersion:',@ProcessObjectSaveVersion
  end


 if @ObjectSpecialEditRule = 'UgMaster_Of_Ir'
     BEGIN

     if @DebugPrintOn = 1
       begin
         EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , 'zz-ControlInfo:' ,  'in:if @ObjectSpecialEditRule = UgMaster_Of_Ir'
       end
       -- Sondersuchregel anwenden es wird nach dem UGMaster DS der IR gesucht
       set @ObjectId = NULL
       EXECUTE Objects_tbl_Object_GetId_UgMasterDS_of_IR  @ObjectCliName, @ObjectFromSiteID, @ObjectClass,
                                                          @ObjectId Output, @ObjectName Output, @ObjectCliName Output , @ObjectClass Output
     END

 -- neu 15.02.2012
 if @ObjectSpecialEditRule = 'DS_of_IR_viaObjectID'
     BEGIN
     if @DebugPrintOn = 1
       begin
         EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , 'zz-ControlInfo:' ,  'in:if @ObjectSpecialEditRule = DS_of_IR_viaObjectID'
       end
       -- Sondersuchregel anwenden es wird nach dem UGMaster DS der IR gesucht
       set @ObjectId = NULL
       EXECUTE Objects_tbl_Object_GetId_DS_of_IR_viaObjectID
                       @IRCliName, @ObjectFromSiteID, @ObjectName,
                       @ObjectId Output, @ObjectCliName Output
     if @DebugPrintOn = 1
       begin
         set @MyValue = CONVERT(varchar(64), @ObjectId)
         EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '14-@ObjectId:' ,  @MyValue
       end
     END

 -- neu 15.02.2012
 if @ObjectSpecialEditRule = 'DS_of_IR_viaObjectType_UGMASTER'
     BEGIN
     if @DebugPrintOn = 1
       begin
         EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus', '20-zz-ControlInfo:',
                          'in:if @ObjectSpecialEditRule = DS_of_IR_viaObjectType_UGMASTER'
       end
       -- Sondersuchregel anwenden es wird nach dem UGMaster DS der IR gesucht
       set @ObjectId = NULL
       EXECUTE Objects_tbl_Object_GetId_DS_of_IR_viaObjectType_UGMASTER
                       @IRCliName, @ObjectFromSiteID, @ObjectName,
                       @ObjectId Output, @ObjectCliName Output
     if @DebugPrintOn = 1
       begin
         set @MyValue = CONVERT(varchar(64), @ObjectId)
         EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '14-@ObjectId:' ,  @MyValue
       end
     END


 if @ObjectId IS NULL
    BEGIN
     -- Print ('in -2- if @ObjectId IS NULL')
     -- Nach der ID logisch suchen wenn nicht schon gefunden !!
     EXECUTE Objects_tbl_Object_GetId  @ObjectCliName, @ObjectFromSiteID, @ObjectClass, @ObjectId Output
    END

 -- Print ('ermittelte @ObjectId=' + CONVERT(nvarchar(64), @ObjectId) + '')
 if @ObjectId IS NOT NULL
    BEGIN
     -- Object Processstatus updaten Hinweis es muss die passende Colume genommen werden / CodeExample: GUID via Parameter in T-SQL Procedure verwenden !
     set @ExecuteSQLstr = N'UPDATE Objects_tbl SET ' + @ObjectDataTableProcStateCol + '=''' + @ProcessState + ''''
     -- new 19.07.2012 19:23 J.Fes
     if @ProcessStateExtendetEdit_SQL <> '' set @ExecuteSQLstr = @ExecuteSQLstr + ', ' + @ProcessStateExtendetEdit_SQL
     set @ExecuteSQLstr = @ExecuteSQLstr + ' Where Objects_tbl.Id=''' + CONVERT(nvarchar(64), @ObjectId) + ''''
     execute sp_executesql @ExecuteSQLstr

     if @ObjectSpecialEditRule = 'SetPStateTo_IR_And_DS' and @ObjectClass = 'IR'
        BEGIN
          -- EXECUTE zzzzzDebugTbl_Empty
          -- EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '10-@ObjectDataTableProcStateCol:' ,  @ObjectDataTableProcStateCol
          -- declare  @ObjectId_tmp nvarchar(64)
          -- set @ObjectId_tmp=CONVERT(nvarchar(64), @ObjectId)
          -- EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '20-@ObjectId:' ,  @ObjectId_tmp
          set @ExecuteSQLstr = N'UPDATE Objects_tbl SET ' + @ObjectDataTableProcStateCol + '=''' + @ProcessState + '''' +
                                ' Where Objects_tbl.Id IN ' +
                                '(SELECT' +
                                '   DS.Id' +
                                ' FROM  dbo.Objects_tbl IR' +
                                '  INNER JOIN dbo.Objects_Ir_Rel_tbl with (nolock) ON (IR.Id = dbo.Objects_Ir_Rel_tbl.IrId)' +
                                '  INNER JOIN dbo.Objects_tbl DS with (nolock) ON (dbo.Objects_Ir_Rel_tbl.ObjectId = DS.Id)' +
                                '  WHERE IR.Id = ''' + CONVERT(nvarchar(64), @ObjectId) + '''' + ')'
         -- EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '30-@ExecuteSQLstr:' , @ExecuteSQLstr
         execute sp_executesql @ExecuteSQLstr
        END

     if @ObjectSpecialEditRule = 'SetPStateTo_All_DS_Off_UGMASTER' and @ObjectClass = 'DS'
        BEGIN
          -- neu 20.06.2010 14:47 J.fes
          -- EXECUTE zzzzzDebugTbl_Empty
          -- EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '10-@ObjectDataTableProcStateCol:' ,  @ObjectDataTableProcStateCol
          -- declare  @ObjectId_tmp nvarchar(64)
          -- set @ObjectId_tmp=CONVERT(nvarchar(64), @ObjectId)
          -- EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '20-@ObjectId:' ,  @ObjectId_tmp
          -- 23.09.2010 13:20  with (nolock) eingefuegt J.Fes
          set @ExecuteSQLstr = N'UPDATE Objects_tbl SET ' + @ObjectDataTableProcStateCol + '=''' + @ProcessState + '''' +
                                ' Where Objects_tbl.Id IN' +
                                ' (' +
                                '   SELECT' +
                                '    dbo.Objects_tbl.Id' +
                                '   FROM' +
                                '     dbo.Objects_Ir_Rel_tbl' +
                                '    INNER JOIN dbo.Objects_tbl with (nolock) ON (dbo.Objects_Ir_Rel_tbl.ObjectId = dbo.Objects_tbl.Id)' +
                                '   WHERE' +
                                '     dbo.Objects_Ir_Rel_tbl.IrId =' +
                                '     (' +
                                '       SELECT dbo.Objects_Ir_Rel_tbl.IrId' +
                                '       FROM dbo.Objects_tbl INNER JOIN dbo.Objects_Ir_Rel_tbl with (nolock) ON (dbo.Objects_tbl.Id = dbo.Objects_Ir_Rel_tbl.ObjectId)' +
                                '       WHERE dbo.Objects_tbl.Id = ''' + CONVERT(nvarchar(64), @ObjectId) + '''' +
                                '      )' +
                                ' )'
          -- EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '30-@ExecuteSQLstr:' , @ExecuteSQLstr
         execute sp_executesql @ExecuteSQLstr
        END
    END

 -- Abschnitt JobControl_ObjectsProcessData_tbl  bearbeiten --------------------------------------------------------
 if @ObjectId IS NOT NULL
    BEGIN
     -- Datensatz in JobControl_ObjectsProcessData_tbl anlegen .. updaten

     -- suchen nach dem Referenzdatensatz via  @Objects_tbl_ID und ProcessPacketName
     if @ProcessPacketName <> ''
        BEGIN
          -- nur nach der @JobControl_ObjectsProcessData_tbl_ID via SQL suchen wenn @ProcessPacketName <> '' gegeben ist
          --     wenn @ProcessPacketName='' dann muss immer ein neuer datensatz in der JobControl_ObjectsProcessData_tbl Tabelle angelegt werden
          --     dieses ist im zusammenhang mit dem JobPlaner erforderlich da dieser vorgeplante JobInfos anlegt!
          if @JobControl_ObjectsProcessData_tbl_ID IS NULL
             BEGIN
                -- suchen in JobControl_ObjectsProcessData_tbl ueber ObejctId und ProcessPaketName
                select @JobControl_ObjectsProcessData_tbl_ID=Id from JobControl_ObjectsProcessData_tbl with (nolock)
                       where     [Objects_tbl_ID] = @ObjectId
                             and [ProcessPacketName] = @ProcessPacketName
             END

          -- wenn Referenzdatensatz nicht gefunden dann suchen via  ProcessPacketName und ObjectCliName
          if @JobControl_ObjectsProcessData_tbl_ID IS NULL
            BEGIN
             select @JobControl_ObjectsProcessData_tbl_ID=Id from JobControl_ObjectsProcessData_tbl with (nolock)
                    where     [ProcessPacketName] = @ProcessPacketName
                          and [ObjectCliName]     = @ObjectCliName
            END
        END
      -- 04.04.2012 21:29 angepasst damit bei Taskscheduler Objekten der Richtige referenz Datensatz gefunden wird
      if @TaskScheduler_tbl_ID IS NOT NULL
         BEGIN
            -- suchen in JobControl_ObjectsProcessData_tbl ueber ObejctId und TaskScheduler_tbl_ID erforderlich fuer ReDo
            select @JobControl_ObjectsProcessData_tbl_ID=Id from JobControl_ObjectsProcessData_tbl with (nolock)
                   where     [Objects_tbl_ID] = @ObjectId
                         and [TaskScheduler_tbl_ID] = @TaskScheduler_tbl_ID
         END


     if @DebugPrintOn = 1
     begin
          set @MyValue = CONVERT(varchar(64), @JobControl_ObjectsProcessData_tbl_ID)
          EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '20-Insert @JobControl_ObjectsProcessData_tbl_ID:' ,  @MyValue
          set @MyValue = CONVERT(varchar(64), @ObjectId)
          EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '21-Insert @ObjectId:' ,  @MyValue
     end

     -----------------------------------------  Daten anlegen Updaten ------------------------------------------------
     -- Process Dataset anlegen
     if @JobControl_ObjectsProcessData_tbl_ID IS NULL
       BEGIN
        --  neuen ProcessDatensatz zum Object anlegen
        SET @JobControl_ObjectsProcessData_tbl_ID = NEWID()


        if @DebugPrintOn = 1
        begin
          set @MyValue = CONVERT(varchar(64), @JobControl_ObjectsProcessData_tbl_ID)
          EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '30-Insert @JobControl_ObjectsProcessData_tbl_ID:' ,  @MyValue
          set @MyValue = CONVERT(varchar(64), @ObjectId)
          EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '31-Insert @ObjectId:' ,  @MyValue
        end


        INSERT INTO JobControl_ObjectsProcessData_tbl
                             (ID ,
                              Objects_tbl_ID,
                              ObjectFromSiteID,
                              ObjectCliName,
                              ObjectClass,
                              ObjectName,
                              JobControlRuleName ,
                              ProcessPacketName,
                              ProcessOnSiteID ,
                              ProcessState ,
                              ProcessTimeStart,
                              ProcessTimeEnd,
                              ProcessCMDLine,
                              ProcessResultCode,
                              ProcessResultMsg,
                              ProcessResultHasWarning,
                              ProcessResultLink,
                              ProcessOnComputer,
                              TaskScheduler_tbl_ID,
                              ProcessPrgUsedVer,
                              ProcessObjectSaveVersion,
                              ProcessProcStateCol)
                    VALUES   (@JobControl_ObjectsProcessData_tbl_ID,
                              @ObjectId,
                              @ObjectFromSiteID,
                              @ObjectCliName,
                              @ObjectClass,
                              @ObjectName,
                              @JobControlRuleName ,
                              @ProcessPacketName,
                              @ProcessOnSiteID ,
                              @ProcessState ,
                              @ProcessTimeStart,
                              @ProcessTimeEnd,
                              @ProcessCMDLine,
                              @ProcessResultCode,
                              @ProcessResultMsg,
                              @ProcessResultHasWarning,
                              @ProcessResultLink,
                              @ProcessOnComputer,
                              @TaskScheduler_tbl_ID,
                              @ProcessPrgUsedVer,
                              @ProcessObjectSaveVersion,
                              @ProcessProcStateCol)
       END
     ELSE
       BEGIN
        --  vorhanden ProcessDatensatz zum Object updaten = Ergebniss einbuchen
        UPDATE JobControl_ObjectsProcessData_tbl
               SET
                   Objects_tbl_ID          = @ObjectId ,            -- einfuegen zur evtl. selbstreperatur
                   ObjectFromSiteID        = @ObjectFromSiteID ,
                   ObjectCliName           = @ObjectCliName ,
                   ObjectClass             = @ObjectClass ,

                   ObjectName              = @ObjectName ,
                   JobControlRuleName      = @JobControlRuleName ,
                   ProcessPacketName       = @ProcessPacketName ,
                   ProcessOnSiteID         = @ProcessOnSiteID ,
                   ProcessState            = @ProcessState ,
                   ProcessTimeStart        = @ProcessTimeStart ,
                   ProcessTimeEnd          = @ProcessTimeEnd ,
                   ProcessCMDLine          = @ProcessCMDLine ,
                   ProcessResultCode       = @ProcessResultCode,
                   ProcessResultMsg        = @ProcessResultMsg ,
                   ProcessResultHasWarning = @ProcessResultHasWarning ,
                   ProcessResultLink       = @ProcessResultLink ,
                   ProcessOnComputer       = @ProcessOnComputer ,
                   -- TaskScheduler_tbl_ID = @TaskScheduler_tbl_ID ,
                   -- ProcessProcStateCol = @ProcessProcStateCol  -- Daten nicht updaten da diese eigentlich nur beim anlegen gesetzt werden!
                   ProcessPrgUsedVer       = @ProcessPrgUsedVer ,
                   ProcessObjectSaveVersion= @ProcessObjectSaveVersion ,
                   ProcessProcStateCol     = @ProcessProcStateCol
               Where ID = @JobControl_ObjectsProcessData_tbl_ID
       END

       -- 15.02.2012 in die
       Declare @Objects_tbl_ID_as_nvarchar nvarchar(36)
           set @Objects_tbl_ID_as_nvarchar=CONVERT(nvarchar(36), @ObjectId)
       -- und jetzt Mark as LastRes hier her verlegt
       Execute ObjectsUpdate_ProcessStatus_Mark_LastRes @Objects_tbl_ID_as_nvarchar
    END


    if @ObjectId is not Null and @ProcessObjectSaveVersion <> ''
      begin

        if @DebugPrintOn = 1
        begin
          EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '40-Insert @ProcessObjectSaveVersion:' ,  @ProcessObjectSaveVersion
          set @MyValue = CONVERT(varchar(64), @ObjectId)
          EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '41-Insert @ObjectId:' ,  @MyValue
        end

        UPDATE Objects_tbl
          SET ObjectSaveVersion = @ProcessObjectSaveVersion
          where Objects_tbl.ID = @ObjectId
      end

 set @ObjectCliName_SQL_r = @ObjectCliName
 set @Objects_tbl_ID_SQL_r = @ObjectId

 if @DebugPrintOn = 1
     begin
      set @MyValue = CONVERT(varchar(64), @ObjectId)
      EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '50-@ObjectId:' ,  @MyValue
      EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '52-@ObjectCliName_SQL_r:' , @ObjectCliName_SQL_r
      set @MyValue = CONVERT(varchar(64), @Objects_tbl_ID_SQL_r)
      EXECUTE zzzzzDebugTbl_AddDataSet 'ObjectsUpdate_ProcessStatus' , '53-@Objects_tbl_ID_SQL_r:' , @MyValue
     end
END
GO

ende:

Print ''
Print '-------------------------------------------------------------------------'
Print ' Procedures imported to #DB_N#'
Print '-------------------------------------------------------------------------'
GO

