setlocal
 rem Tool zum Extrahiert und vergleichen von Assembly Listen in der Tce/NX umgebung
 rem Stand 20.12.2007 12:32:47 J.Fes
 set myAppl_Title=AsListControl

 rem -- Parameter uebergabe
 set doAktion=%1

 set ASListPrePostRoot_DP=%2
 set ASListOnServerRoot_DP=%3
 set JobObjectsPacket_DPNE=%4
 set FileExtend=%5

 rem -- strip '"'
 set ASListPrePostRoot_DP=%ASListPrePostRoot_DP:"=%
 set ASListOnServerRoot_DP=%ASListOnServerRoot_DP:"=%
 set JobObjectsPacket_DPNE=%JobObjectsPacket_DPNE:"=%
 set FileExtend=%FileExtend:"=%

 Echo ---------------------------------------------------------------------------------------
 Call :PrintCurrAction "ExpoASList: [%FileExtend%] ....start"
 Echo List of objects to get list from:
 type "%JobObjectsPacket_DPNE%"
 Echo.

 rem jedes Element der Inputliste verarbeiten
 if "%doAktion%"=="ExportAssemblyListRun" FOR /F "tokens=1 delims=;" %%i in (%JobObjectsPacket_DPNE%) do call :ExportAssemblyListRun %%i %FileExtend%

 rem jedes Element der Liste PrePost vergleichen
 if "%doAktion%"=="ExportAssemblyListCompare" FOR /F "tokens=1 delims=;" %%i in (%JobObjectsPacket_DPNE%) do call :ExportAssemblyListCompare %%i %FileExtend%
 Call :PrintCurrAction "ExpoASList: [%FileExtend%] ....end"

endlocal

goto :eof

rem -----------------------------------------------------------------------------
:ExportAssemblyListCompare
  rem Exportiert die Infoliste eine einzelne Baugruppe
  setlocal
       rem uebergabe Parameter
   set CliNamedId=%1

   rem aus %ObjectNamedId% %CliNamedId% parsen
   call :ObjectNamedId_Parse

   call :asInfoFile_DPNE_get asInfoFile1Pre_DPNE %ObjectNamedId% 1Pre
   call :asInfoFile_DPNE_get asInfoFile2Post_DPNE %ObjectNamedId% 2Post

   rem vergleichen der 1Pre und 2Post Listen
   fc /L "%asInfoFile1Pre_DPNE%" "%asInfoFile2Post_DPNE%">nul
   set DifErrorlevel=%errorlevel%

   if     "%DifErrorlevel%"=="0" goto :exitOk
   if not "%DifErrorlevel%"=="0" goto :exitErr

   REM ---- oK
   :exitOk
    Banner "Pre-Post:[OK]"
    Call :PrintCurrAction "ExpoASList:[%ObjectNamedId%] Diff 1Pre - 2Post Check [OK]"
    set ASListOnServer_DP=%ASListOnServerRoot_DP%\01-OKLists\%ObjectNamedId%
    if not exist "%ASListOnServer_DP%" md "%ASListOnServer_DP%"
    goto :exitEnde

   REM ---- error
   :exitErr
    rem es ist beim vergleich ein Error aufgetreten
    set ASListOnServer_DP=%ASListOnServerRoot_DP%\02-ErrorLists\%ObjectNamedId%
    if not exist "%ASListOnServer_DP%" md "%ASListOnServer_DP%"

    call :DateTimeNowGet
    set ASListErrLog_DPNE=%ASListOnServer_DP%\_%ObjectNamedId%_Diff-%DateTimeNowFileExt%.txt
    Echo ------------------------------------------------>>"%ASListErrLog_DPNE%"
    Echo Assembly Partlist Diff REPORT>>"%ASListErrLog_DPNE%"
    Echo createt on \\%Computername% %Date% %time%>>"%ASListErrLog_DPNE%"
    Echo.>>"%ASListErrLog_DPNE%"
    Echo Diff between:>>"%ASListErrLog_DPNE%"
    Echo 1Pre =%asInfoFile1Pre_DPNE%>>"%ASListErrLog_DPNE%"
    Echo 2Post=%asInfoFile2Post_DPNE%>>"%ASListErrLog_DPNE%"
    Echo.>>"%ASListErrLog_DPNE%"
    Echo Reports Diff Details:>>"%ASListErrLog_DPNE%"

    rem Diff erstellen lassen
    fc /L "%asInfoFile1Pre_DPNE%" "%asInfoFile2Post_DPNE%">>"%ASListErrLog_DPNE%"
    rem und 1Pre 2Post Listen in das Verzeichniss kopieren lassen

    rem ausgabe auf der console
    Call :PrintCurrAction "!!! ExpoASList:[%ObjectNamedId%] Dif 1Pre-2Post [Err:%DifErrorlevel%] !!!"

    goto :exitEnde

   :exitEnde
    rem und 1Pre 2Post Listen in das Verzeichniss kopieren lassen
    copy "%asInfoFile1Pre_DPNE%" "%ASListOnServer_DP%\*.*">nul
    copy "%asInfoFile2Post_DPNE%" "%ASListOnServer_DP%\*.*">nul
    copy "%fixPreV16Log_DPNE%" "%ASListOnServer_DP%\*.*">nul
    copy "%temp%\*%ObjectNamedId%_*_AsListGen_cmd.log" "%ASListOnServer_DP%\*.*">nul

  endlocal
goto :eof

:asInfoFile_DPNE_get
 rem erstellt den Dateinamen fr den asInfoFileNamen
 rem uebergabe Parameter P1 = bergabe war
 set ObjectNamedId_l=%2
 set FileExtend_l=%3
 set %1=%ASListPrePostRoot_DP%\%ObjectNamedId_l%_%FileExtend_l%_AsList.txt
 set CliNamedId_l=
 set FileExtend_l=
 goto :eof

rem -----------------------------------------------------------------------------
:ExportAssemblyListRun
  rem Exportiert die Infoliste eine einzelne Baugruppe
  setlocal

   rem Retry Counter
   set ExportAssemblyListRunCurrTry=0
 :ExportAssemblyListRunRetry
   set /A ExportAssemblyListRunCurrTry=%ExportAssemblyListRunCurrTry% +1

   rem uebergabe Parameter
   set CliNamedId=%1
   set FileExtend=%2

   rem aus %ObjectNamedId% %CliNamedId% parsen
   call :ObjectNamedId_Parse

   rem Doku
   rem CliNamedId=@DB/000001/A
   rem ObjectNamedId=000001_A - verwenden fuer den Dateinamen


   rem -- Verzeichniss erzeugen
   if not exist "%ASListPrePostRoot_DP%" md "%ASListPrePostRoot_DP%"
   rem -- Filenamen fuer den asInfoFile erzeugen
   call :asInfoFile_DPNE_get asInfoFile_DPNE %ObjectNamedId% %FileExtend%
   set asInfoFileUnSort_DPNE=%asInfoFile_DPNE%.us.txt
   set asInfoFileCutEntity_DPNE=%asInfoFile_DPNE%.cutEntyty.txt
   set ParasExpo_exe_Runlog_DPNE=%temp%\%ObjectNamedId%_%FileExtend%_AsListGen_cmd.log

   rem ## loadoptions anpassen
   rem set UGII_LOAD_OPTIONS=%ApplRoot_DP%\load_options_LoadNoComponents.def
   set UGII_LOAD_OPTIONS=%JobScripts_DP%\NXTools\load_options_LoadAllComponents.def

   rem ## Path to ParasExpo.exe anpassen
   set toRun=
   set toRun=%toRun% "%JobScripts_DP%\NXTools\ParasExpo.exe"
   if     "%tcelogin%"=="" set toRun=%toRun% -u=refile_user01 -p=refile_user
   if not "%tcelogin%"=="" set toRun=%toRun% %tcelogin%
   set toRun=%toRun% -part=%CliNamedId%
   set toRun=%toRun% -Layer=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,101
   set toRun=%toRun% -ExpoType=AS
   set toRun=%toRun% -asInfoFile="%asInfoFileUnSort_DPNE%"
   %toRun%>>"%ParasExpo_exe_Runlog_DPNE%"
   set ParasExpo_exeRun_errorlevel=%errorlevel%


   rem fehlerbehandlung
   if     "%ParasExpo_exeRun_errorlevel%"=="-1" goto :ExportAssemblyListRunRetryJumbIn
   if not "%ParasExpo_exeRun_errorlevel%"=="0" goto :ExportAssemblyListRunRetryJumbInMaxNTimes
   if not exist "%asInfoFileUnSort_DPNE%"   goto :exitErr

   goto :exitOk

   rem ------------
   :ExportAssemblyListRunRetryJumbIn
    rem Echo.
    rem Echo [!!!!!!!!!!! ***** ASRetry ********* !!!!!!!!!!!!!]
    Call :PrintCurrAction "ExpoASList:[%FileExtend%/%ObjectNamedId%] retry:[%ExportAssemblyListRunCurrTry%] !licens failed! [Error:%ParasExpo_exeRun_errorlevel%]"
    if "%ExportAssemblyListRunCurrTry%" gtr "400" goto :exitErr
    call :Wait 1

    goto :ExportAssemblyListRunRetry

   :ExportAssemblyListRunRetryJumbInMaxNTimes
    rem Echo.
    Echo [!!!!!!!!!!! ***** ASRetry ********* !!!!!!!!!!!!!]
    Call :PrintCurrAction "ExpoASList:[%FileExtend%/%ObjectNamedId%] retry:[%ExportAssemblyListRunCurrTry%] Error:%ParasExpo_exeRun_errorlevel%"
    Echo see report of logfile:
    Type "%ParasExpo_exe_Runlog_DPNE%"
    echo.
    call :Wait 1
    if "%ExportAssemblyListRunCurrTry%" gtr "4" goto :exitErr
    goto :ExportAssemblyListRunRetry


   :exitOk
    rem prima die Liste konnte erzeugt werden dann diese verarbeiten
    rem -Entity Handle abschneiden
    FOR /F "tokens=1,* delims=;" %%a in (%asInfoFileUnSort_DPNE%) do Echo %%b>>"%asInfoFileCutEntity_DPNE%"

    rem das ganze dann sortieren
    SORT "%asInfoFileCutEntity_DPNE%">"%asInfoFile_DPNE%"
    if     exist "%asInfoFile_DPNE%" del "%asInfoFileCutEntity_DPNE%"
    if     exist "%asInfoFile_DPNE%" del "%asInfoFileUnSort_DPNE%"
    if not exist "%asInfoFile_DPNE%" goto :exitErr
    Banner "%FileExtend%:[OK]"
    Call :PrintCurrAction "ExpoASList:[%FileExtend%/%ObjectNamedId%] end with [OK]"
    goto :exitEnde

   :exitErr
    Banner "%FileExtend%:[ERR]!"
    Call :PrintCurrAction "ExpoASList:[%FileExtend%/%ObjectNamedId%] end with [ERR]"
    goto :exitEnde


   :exitEnde
  endlocal
 goto :eof

rem -------------


rem ---------------------------------------------------------------------------------
:ObjectNamedId_Parse
 rem ObjectNamedId aus CliNamedId parsen
 rem Replace @DB/ durch Leerzeichen
 set ObjectNamedId=%CliNamedId:@DB/=%
 rem Replace @DB durch nichts
 set ObjectNamedId=%ObjectNamedId:@DB=%

 rem Replace - durch _
 set ObjectNamedId=%ObjectNamedId:-=_%

 rem Replace \ durch _
 set ObjectNamedId=%ObjectNamedId:\=_%
 rem Replace / durch _
 set ObjectNamedId=%ObjectNamedId:/=_%
 rem Replace # durch _
 set ObjectNamedId=%ObjectNamedId:#=_%
 rem Replace Leerzeichen durch _
 set ObjectNamedId=%ObjectNamedId: =_%
 rem Replace , durch _
 set ObjectNamedId=%ObjectNamedId:,=_%
 rem Replace ; durch _
 set ObjectNamedId=%ObjectNamedId:;=_%

 rem Replace [ durch _
 set ObjectNamedId=%ObjectNamedId:[=_%
 rem Replace ] durch _
 set ObjectNamedId=%ObjectNamedId:]=_%

 rem Replace ( durch _
 set ObjectNamedId=%ObjectNamedId:(=_%
 rem Replace ) durch _
 set ObjectNamedId=%ObjectNamedId:)=_%

 rem Replace { durch _
 set ObjectNamedId=%ObjectNamedId:{=_%
 rem Replace } durch _
 set ObjectNamedId=%ObjectNamedId:}=_%

 rem Replace . durch _
 set ObjectNamedId=%ObjectNamedId:.=_%

 rem Replace = durch _
 call :ReplaceSign "%ObjectNamedId%" _ ObjectNamedId

 goto :eof


rem -------------
 rem entfernt ein = aus einem string
:ReplaceSign
 if "%3"=="" echo Syntax: Call :ReplaceSign StringIn CharNew  Newstring& goto :EOF
 setlocal
 set string=%1
 set CharNew=%2
 :again
  set work=%string%
  for /f "Tokens=1* Delims==" %%a in ('@echo %string%') do if "%%b" NEQ "" set string=%%a%CharNew%%%b
  if {%string%} NEQ {%work%} goto again
  rem strip "
  set string=%string:"=%

 endlocal& set %3=%string%
goto :eof


:PrintCurrAction
 rem Ausgabe ber aktuelle Aktion
 rem P1 = AktionInfo
 Set CurrInfo=%myAppl_Title% %1 [%Date:~0,6%%Date:~8,2% %Time:~0,5% %JobName%]
 Title %CurrInfo%
 rem Echo ----------------------------------------------------------------------------------
 Echo Aktion:%1 [%Date:~0,6%%Date:~8,2% %Time:~0,5% %JobName%]
 rem Echo JobName : %JobName%
 rem Echo ----------------------------------------------------------------------------------
 goto :eof

:DateTimeNowGet
 rem call :DateTimeNowGet
 rem Set File_LPNE=%DatRoot_LP%\MyName-%DateTimeNowFileExt%.txt
 if     "%time:~0,1%"==" " set time-h=0%time:~1,1%
 if not "%time:~0,1%"==" " set time-h=%time:~0,2%

 if     "%time:~3,1%"==" " set time-m=0%time:~4,1%
 if not "%time:~3,1%"==" " set time-m=%time:~3,2%

 set Date-Y=%Date:~6,4%
 set Date-M=%Date:~3,2%
 set Date-D=%Date:~0,2%
 set DateTimeNowFileExt=%Date-Y%-%Date-M%-%Date-D%-%time-h%-%time-m%
 goto :eof 

:Wait
 set waitTime=2
 if not "%1"=="" set waitTime=%1
 CHOICE /C:w /N /T:w,%waitTime% warte %waitTime% sec oder "w" druecken.
 goto :eof
