@Echo off

 setlocal EnableDelayedExpansion EnableExtensions
 rem ---------------------------------------------------------
 rem JobManager Nx - Tc Migration
 rem (c) J.Feuerstein 24.11.2006
 rem
 rem Aenderungs Info:
 rem User    Date/Time (Shift+strg+T)  Infotext:
 rem J.Fes   21.06.2011 18:46          Ersterstellung
 rem J.Fes   14.02.2012 21:57          JC.Cmd.Tools eingefuegt
 rem ---------------------------------------------------------

 set JobMgr_TcUser=%1
 set JobMgr_TcPw=%2

 rem Debug: [bei Einzel Test's auf=ON] [sonst auf OFF stellen]
 set JobMgr_Debug=OFF
 set JobMgr_Test=OFF

 set JobAddFile_ObjectsList_txt=false
 set JobAddFile_ObjectsListAllDetails_txt=false

 rem -- JobScriptParametersExtended:
 #JobScriptParametersExtended#
 set Action=AppUID

 set TitleTxt=Nx75TcMig:Action:[%Action%]
 title %TitleTxt%
 Echo.
 Echo --------------------------------------------------------------------------
 Echo %TitleTxt%
 Echo --------------------------------------------------------------------------
 rem -- am Anfang Farbe auf IsIdel setzen
 call :ColorSet IsIdel

 rem -- JobServer Variablen ----------------------------------------------------
 set JobManagerRoot_DP=#00-ApplRoot_DP#
 set JobScripts_DP=#10-JobScripts_DP#
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#

 rem -- JobParameter:
 set JobName=#JobName#
 set JobParameter=#JobParameter#
 set JobPacket_NE=#JobPacket_NE#
 set JobObjectsPacket_NE=#JobObjectsPacket_NE#
 set JobObjectsPacketAllDetails_NE=#JobObjectsPacketAllDetails_NE#

 rem -- Root Verzeichniss der Scriptvorlage:
 set JobScriptTemplateMinus1_DP=#JobScriptTemplateMinus1_DP#
 set JobScriptTemplate_DP=#JobScriptTemplate_DP#

 rem -- TC Daten:
 set TcSiteId=#TcSiteId#

 rem -- Extendet Settings
 set CmdCur_Title=#JobName#


REM
 rem ---------------------------------------------------------------------------
 if /i "%JobMgr_Test%" equ "ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
   Banner AU.Test
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 )
 if "%JobMgr_Debug%"=="ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
   Banner AU.Debug
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 )
 if /i "%JobMgr_Debug%" neq "ON" if /i "%JobMgr_Test%" neq "ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
   Banner %Action%
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 )


 rem ---------------------------------------------------------------------------
 rem Rootpfade setzen
 set CmdCur_DPNE=%~0
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 rem -- PathVariable erweitern
 set path=%CmdCurRoot_DP%;%BinPublic_Custom_DP%;%BinPublic_ClientServer_DP%;%BinPublic_DP%;%Path%

 Echo --------------------------------------------------------------------------
 Echo Start: Executing TcPrompt to get Tc Environ
 rem -- ## anpassen TcePrompt durchlaufen
 set SIDT_DEBUG=0
 set TCPromtCmd=NotSet please check JobMainScript:[%0]

 rem -- 18.08.2010 17:41 Mapping Sites and Prompt
 if /i "#TcSiteId#" equ "tc8Site1" (
   set TCPromtCmd=!UGS_SHR_DIR!\start_apps\windows\start_nx75.bat
   rem Prompt angepasst
   set TCPromtCmdOpt=de tc_prompt #TcSiteId# tc83
 )
 if /i "#TcSiteId#" equ "tc8Site2" (
   set TCPromtCmd=!UGS_SHR_DIR!\start_apps\windows\start_nx75.bat
   rem Prompt angepasst
   set TCPromtCmdOpt=de tc_prompt #TcSiteId# tc83
 )

 if "%JobMgr_Debug%" equ "ON" (
  Echo ##Debug:
  Echo befor excuting:
  Echo TCPromtCmd=%TCPromtCmd% %TCPromtCmdOpt%
  pause
 )

 rem Exit wenn TCPromt nicht gefunden werden kann
 if not exist "%TCPromtCmd%" goto :TCPromtCmdError

 rem -- TC Prompt durchlaufen --------------------------------------------------
 call "%TCPromtCmd%" %TCPromtCmdOpt%
 Echo End: Executing TcPrompt to get Tc Environ
 Echo --------------------------------------------------------------------------

 rem temp dir Organiesieren
 set temp_DP_org=%temp%
 set temp=%CmdCurRoot_DP%\JobTemp
 if not exist "%temp%" md "%temp%"
 cd /d "%temp%"

 rem -- TC-Variablen umbiegen --------------------------------------------------
 rem 09.08.2011 09:14 eingebaut
 Echo ##Debug: 23.08.2011 15:09 Test on
 SET TC_SQL_DEBUG=JBT
 set TC_TMP_DIR=%temp%
 SET TC_KEEP_SYSTEM_LOG=TRUE
 SET TC_Journalling=ON
 SET TC_Journaling=ON
 SET TC_TRACEBACK=OFF

 rem ---------------------------------------------------------------------------
 rem -- PaketFile festlegen
 set JobObjectsPacket_DPNE=%CmdCurRoot_DP%\%JobObjectsPacket_NE%
 set JobObjectsPacketAllDetails_DPNE=%CmdCurRoot_DP%\%JobObjectsPacketAllDetails_NE%

:StartJobProcessing
 call :ColorSet IsExecuting
 set JobTimeStart=%Date% %time:~0,8%
 set title_str=Job:[%JobName%][%Action%][%TcSiteId%][Start:%JobTimeStart%][\\%ComputerName%][%JobMgr_TcUser%]
 title %title_str%
 Echo %title_str%
 Echo --------------------------------------------------------------------------
 Echo Job Info:
 Echo Job Action..........: %Action%
 Echo JobName.............: %JobName%
 Echo Computer............: %ComputerName%
 Echo TempDir.............: %temp%
 Echo TcSide..............: %TcSiteId%
 Echo TcUser..............: %JobMgr_TcUser%
 Echo Start...............: %JobTimeStart%

 if /I "%JobMgr_Debug%"=="ON" (
  Echo ##Debug: Start Explorer at JobDir:[%CmdCurRoot_DP%]
  start "" Explorer "%CmdCurRoot_DP%"
  pause
 )

 rem Start AppUid
 call :AppUidObj_Run

 Echo --------------------------------------------------------------------------
 Echo #Step: alle Files loeschen die nicht zum JobServer gesendet werden sollen
 if /I "%JobMgr_Debug%" neq "ON" (
    del /S /Q "%temp%\nxmgr_upgrade_appuid.exe*.*","%temp%\tcserver*.jnl","%temp%\*.bak","%temp%\*.tmp","%temp%\*.prt">nul 1>nul 2>nul
 )

 set JobTimeEnd=%Date% %time:~0,8%
 Echo.
 Echo --------------------------------------------------------------------------
 Echo End.................: %JobTimeEnd%

 if "%JobMgr_Debug%"=="ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Echo ##Debug Info: Ende
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
 )
 if /i "%JobMgr_Test%" equ "ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner AU.T.End
   Echo #Test: Ende
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
 )

 rem -- Farbe auf JobEnds setzen
 call :ColorSet End

 goto :end


rem ----------------------------------------------------------------------------
:AppUidObj_Run
 Echo --------------------------------------------------------------------------
 Echo These Teamcenter utility programs can be used to repair NX Non-Master
 Echo (UGPART, UGALTREP, UGSCENARIO) type datasets that are missing
 Echo the APPUID-OBJ named reference object in the database.
 Echo ##Doc: Select JobMgr: DS Master(Latest)
 Echo --------------------------------------------------------------------------

 rem 17.11.2011 16:52 / J.Fes Nach absprache mit G-TAG wird die Version aus %TC_ROOT%\bin genommen Version ist 8000.3.0.42 vom 1.9.2011
 set NxMgr_Upgrade_AppUid_exe_DPNE=%TC_ROOT%\bin\nxmgr_upgrade_appuid.exe
 if not exist "%NxMgr_Upgrade_AppUid_exe_DPNE%" goto :NxMgr_Upgrade_AppUid_exe_DPNE_Err

REM  set DataR_DP=#12-Data#\MlgD_AppUid_LOGS
REM  if not exist "%DataR_DP%" md "%DataR_DP%"

 set JobPaket_DPNE=%CmdCurRoot_DP%\%JobPacket_NE%
 set Inputfile01_DPNE=%temp%\01_Inputfile.xml
 set Report02_DPNE=%temp%\02_report.txt
 set Report02_CopyTo_NE=%JobPacket_NE%_02_report.txt
 set Report02_CopyTo_DPNE=%DataR_DP%\%Report02_CopyTo_NE%
 set conflict_report03_DPNE=%temp%\03_conflict_report.txt
 set conflict_report03_CopyTo_DPNE=%DataR_DP%\%JobPacket_NE%_03_conflict_report.txt
 set errlog04_DPNE=%temp%\04_errlog.txt
 set errlog04_CopyTo_DPNE=%DataR_DP%\%JobPacket_NE%_04_errlog.txt

  Echo #Step: GenerateAppUidImportFile - - - - - - - - - - - - - - - - - - - - -
  call JobManagerCmdTools.exe -Action "AppUid_2012_02" -GenerateAppUidImportFile -JobRoot_dp "%CmdCurRoot_DP%" -JobDataInputXml "JobData1ToProcess.xml" -AppUidImportXml "%Inputfile01_DPNE%"

  if "%JobMgr_Debug%"=="ON" (
    Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
    start "" Explorer.exe "%temp%"
    Echo ##Debug: Type: [%Inputfile01_DPNE%]
    Type "%Inputfile01_DPNE%"
    Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
    pause
  )

  Echo #Step: AppUid ausfuehren  - - - - - - - - - - - - - - - - - - - - - - - -
  set toRun="%NxMgr_Upgrade_AppUid_exe_DPNE%"
  set toRun=%toRun% -xml_file="%Inputfile01_DPNE%"
  set toRun=%toRun% -report="%report02_DPNE%"
  set toRun=%toRun% -conflict_report="%conflict_report03_DPNE%"
  set toRun=%toRun% -errlog="%errlog04_DPNE%"
  set toRun=%toRun% -remove=no
  set toRun=%toRun% -bypass=yes
  set toRun=%toRun% -update_mod_props=no
  REM   set toRun=%toRun% -dryrun=yes
  set toRun=%toRun% -debug=yes
  set toRun=%toRun% -u=%JobMgr_TcUser% -g=dba

  if "%JobMgr_Test%"=="ON" (
    Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
    Echo ##Debug: befor run:
    Echo %toRun%
    Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
REM     pause
  )
  Rem -- start AppUid process
  Call %toRun% -p=%JobMgr_TcPw%

  Echo #Step: Auswerten des Ergebnisses -ParseAppUidResultsFile  - - - - - - - -
  set toRun=call JobManagerCmdTools.exe
  set toRun=%toRun% -Action "AppUid_2012_02" -ParseAppUidResultsFile
  set toRun=%toRun% -JobRoot_dp "%CmdCurRoot_DP%"
  set toRun=%toRun% -AppUidResultsLog "%Report02_DPNE%"
  %toRun%

  if "%JobMgr_Debug%"=="ON" (
    Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
    Echo ##Debug: after run:
    Echo %toRun%
    Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
    pause
   )
goto :eof

rem ============================================================================
:ColorSet
 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 rem Blaugrn Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=30
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof

rem ============================================================================
:NxMgr_Upgrade_AppUid_exe_DPNE_Err
 Call :ColorSet Err
 set ErrLog_DPNE=%temp%\__Err_NxMgr_Upgrade_AppUid_exe_DPNE_Err_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start JobProcess on:\\%ComputerName% missing NxMgr_Upgrade_AppUid.exe [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 Echo %title_str%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 pause
 start " " Notepad.exe "%ErrLog_DPNE%"
 pause
 goto :end

rem ============================================================================
:TcPromtCmdError
 Call :ColorSet Err
 set ErrLog_DPNE=%temp%\__Err_MissingTcePromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start JobProcess on:\\%ComputerName% missing TCEPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 rem call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TCEPromtCmd:=%TCEPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 rem call :ErrLogFooterWrite
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 pause
 start " " Notepad.exe "%ErrLog_DPNE%"
 pause
 goto :end

rem ============================================================================
:Wait
 set waitTime=2
 if not "%1"=="" set waitTime=%~1
 Wait.exe %waitTime% ESC "wait:[%waitTime%] or push 'ESC'-key to continue"
 goto :eof

rem ============================================================================
:end
 cd /d "%temp_DP_org%"
 Echo --------------------------------------------------------------------------
 Echo Info: all files in: [%temp%]
 Echo       will be zipt by JobClient and send to JobServer
 rem -- farbe wieder auf standard zurueck setzen
 Call :ColorSet End
