@Echo off
 rem ---------------------------------------------------------------------------
 rem JobManager V2 Generic Script
 rem (c) J.Feuerstein 24.11.2006
 rem
 rem Aenderungs Info:
 rem User    Date/Time (Shift+strg+T)  Infotext:
 rem J.Fes   24.11.2006 00:05:59       Ersterstellung 24.11.2006
 rem ---------------------------------------------------------------------------
 rem Variablen ersetzungs Abschnitt
 rem Info die mit "#" Gitter eingeschlossenen Vaiablen werden vom JobServer
 rem vor dem senden an den JobClient ersetzt
 rem cls
 rem                   User  Date/Time   Infotext:
 set MyApplCurVerInfo=J.Fes  02.06.2009  erst Erstellung
 set MyApplCurVerInfo=J.Fes  26.06.2009  Aktualiesierung TCE
 set MyApplCurVerInfo=J.Fes  07.01.2010  JobServerExtendCommandsTrigger eingefuegt
 set MyApplCurVerInfo=J.Fes  15.04.2010  CheckBox_CustomStart eingefuegt
 set MyApplCurVerInfo=J.Fes  14.02.2011  JobMgr_Test eingefuegt
 set MyApplCurVerInfo=J.Fes  06.06.2011  aktuelle anpassungen uebernommen
 set MyApplCurVerInfo=J.Fes  08.06.2012  aktuelle anpassungen uebernommen
 set MyApplCurVerInfo=J.Fes  08.08.2012  Akt. Anpassungen + JobManagerCmdTools.exe eingearbeitet.


 rem #Doc: Get TcUser data via Parameter P1 P2
 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_Debug=OFF


 rem -- am Anfang Farbe auf IsIdel setzen
 call :ColorSet IsExecuting

 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsList.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsList_txt=false

 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsListAllDetails.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsListAllDetails_txt=false

 rem wird im JobScript angegben so wird der File:[JobData1ToProcess_XML] nicht dem JobFile hinzugefuegt.
 set JobAddFile_JobData1ToProcess_xml=true


 rem initaliesiert die Umgebung
 set myAppl_Title=NxCB
 title %myAppl_Title%

 set MyApplName_TP=#MyApplName_TP#
 set MyApplMainInfo=%MyApplName_TP% %MyApplCurVerInfo%

 Echo.
 Echo **************************************************************************
 Echo * %MyApplMainInfo%                   *
 Echo * executing PLMJobManager script for:                                    *
 Echo *  -  extract CheckBox Data                                              *
 Echo **************************************************************************

 rem Standard Path Variablen
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#
 set BinPublic_ClientServer_DP=\\w3\ugsshare\kba_custom_v4\applications_prod\JobManagerV2\03-BinPublic.ClientServer.ENTW
 rem -- Root Verzeichniss der Scriptvorlage ------------------------------------
 set JobScriptTemplateMinus1_DP=#JobScriptTemplateMinus1_DP#
 set JobScriptTemplate_DP=#JobScriptTemplate_DP#
 set JobScriptTemplateMinus1_DP=\\w3\ugsshare\kba_custom_v4\applications_prod\JobManagerV2\90-DATA\KBA_SettingsGlobal\10-JobScripts\CheckBox\Bin
 rem ---------------------------------------------------------------------------

 set JobScripts_DP=#10-JobScripts_DP#
 set MyApplName_TP=#MyApplName_TP#

 rem -- in diesem Verzeichniss liegt das ClientSTart Script
 set JobScriptTemplate_DP=#JobScriptTemplate_DP#

 rem -- JobParameter
 set JobName=#JobName#
 set JobParameter=#JobParameter#
 set JobParameter=#JobParameter#
 set JobObjectsPacket_NE=#JobObjectsPacket_NE#
 set JobObjectsPacketAllDetails_NE=#JobObjectsPacketAllDetails_NE#

 rem -- TCE Daten
 set TcSiteId=#TcSiteId#
 set CmdCur_Title=#JobName#
 
 rem use WatchDog [default=ON]
 set JobMgr_use_PlmJobManagerWatchDog=OFF

 rem use JobMgr_use_TcServerKill [default=OFF]
 set JobMgr_use_TcServerKill=ON

 rem -- JobScriptParametersExtended:
 rem    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen dann leer
 rem             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt leer
 #JobScriptParametersExtended#

 rem ---------------------------------------------------------------------------
 rem Rootpfade setzen
 set CmdCur_DPNE=%~0
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%
 set path=%CmdCurRoot_DP%;%BinPublic_ClientServer_DP%;%Path%

 rem ---------------------------------------------------------------------------

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOverTest
   Banner TEST:ON
:JumbOverTest

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   Echo -- #Debug Start Job
   Banner.exe Deb:ON
   Echo "%CmdCurRoot_DP%"
   start "" Explorer /e,"%CmdCurRoot_DP%"
   pause
:JumbOverDebug


 rem ---------------------------------------------------------------------------
 rem temp dir Organiesieren
 set temp_DP_org=%temp%
 set temp=%CmdCurRoot_DP%\JobTemp
 set tmp=%temp%
 if not exist "%temp%" md "%temp%"
 cd /d "%temp%"

 rem -- Option: Control software starten ---------------------------------------
 if /I "%JobMgr_use_PlmJobManagerWatchDog%" neq "ON" goto :endif
   rem WatchDog starten !!
   rem Echo Check Start: PlmJobManagerWatchDog.exe
   Echo --------------------------------------------------------------------------
   call "ProgStart_If_NotRuning.cmd" "PlmJobManagerWatchDog" "%BinPublic_DP%\PlmJobManagerWatchDog.exe"
 :endif

 rem -- Option Anpassen der Ornerstruktur der CBDaten via Option: -DataOrg_BaseNameSchema "RootPP_LL=n.Chars" --
 rem #Doc: Ablageort fr Daten einer 'ItemRev' setzt sich allgemein zusammen aus: "..\CbData\#SiteId#\#ItemId:5#\#Item#\#Rev#"
 rem #Doc:   Standard laenge fr RootPP_LL=5 ..\CbData\#SiteId#\#ItemId:5#  = 5 Chars
 REM #Doc: via set CBCompairExtra_Opt= kann die laenge des CB RootOrdner angepasst werden.
 Rem #Doc  Bspl: CBCompairExtra_Opt=-DataOrg_BaseNameSchema "RootPP_LL=10"
 rem #Doc        AblageOrt wird dann zu: "..\CbData\#SiteId#\#ItemId:10#\#Item#\#Rev#"

:JobProcessing
 set title_str=Job:[%JobName%][%CB_Action%:%NxCB_UseNxVer%][%TcSiteId%][Start:%Date%/%time:~0,8%][\\%ComputerName%][%TceUser%]
REM  Echo --------------------------------------------------------------------------
REM  Banner.exe %CB_Action%
 Echo --------------------------------------------------------------------------
 title %title_str%
 Echo %title_str%
 Echo --------------------------------------------------------------------------
 call :Echo "Job Info:"
 call :Echo "JobName...........: %JobName%"
 call :Echo "Computer..........: %ComputerName%"
 call :Echo "TempDir...........: %temp%"
 call :Echo "TcSide............: %TcSiteId%"
 call :Echo "TcUser............: %JobMgr_TcUser%"
 call :Echo "."
 call :Echo "JobPara...........: %JobParameter%"
 call :Echo "CB_Action.........: %CB_Action%"
 call :Echo "CB_Ver1...........: %CB_Ver1%"
 call :Echo "CB_Ver2...........: %CB_Ver2%"
 call :Echo "NxCB_UseNxVer.....: %NxCB_UseNxVer%"
 call :Echo "Start.............: %Date%/%Time:~0,8%"
 call :Echo "."

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   SET CB_
   SET NxCB_
   pause
:JumbOver

 rem #new.: 10.10.2012/J.Fes
 rem #ToDo: Setup RootPP_LL defines length off partical path of
 rem        CheckBox Path .\12-Data\JobMgrData\#SiteID#\#ItemId#:#RootPP_LL#\#ItemId#\#RevId#\
 REM set JobMgrDataOrg_BaseNameSchema_Custom=RootPP_LL=10
 set JobMgrDataOrg_BaseNameSchema_Custom="RootPP1_N=CBComp"
 rem #ToDo: Define  JobMgrDataOrg_Root_DP_Custom  or use default
 rem \\w3\ugsshare\kba_custom_v4\applications_prod\JobManagerV2\90-DATA\KBA_WorkInst_TC8_Testystem\12-Data
 set JobMgrDataOrg_Root_DP_Custom=#12-Data#\JobMgrData

 rem -- #Step: verzweigen in die jeweilige version des CB Vorgangs
 if /I "%CB_Action%" equ "NxCB_Extract" (
   if /i "%CB_VerUse%" equ "VER1"  goto :CB_VerUse_Ver1
   if /i "%CB_VerUse%" equ "VER2"  goto :CB_VerUse_Ver2
 )

 if /I "%CB_Action%" equ "ResultGen" (
   goto :CB_ResultGen
 )

 call :Echo "---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---"
 call :Echo "Err: invalid CB_Action:[%CB_Action%] committed"
 call :Echo "     valid CB_Actions are: NxCB_Extract / ResultGen"
 call :Echo "     Please check settings in JobServer Scripts/Param"
 pause
 goto :MyEnd

rem ============================================================================
:CB_VerUse_Ver1
 setlocal
  REM #Doc: Get CbData for Nx Version cur in use Example: Nx2..NX80
  set TcPromtCmd=Unkown please Check settings in:[%0]

  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo #Debug:
   Echo Start excuting: [CB_VerUse_Ver1]
   pause
:JumbOver

    set TcPromtCmd=%UGS_SHR_DIR%\start_apps\windows\start_nx75.bat
    set TcPromtCmdOpt=de tc_prompt tc8t tc83

  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver_Debug
   Echo #Debug........: befor excuting:
   Echo  TcPromtCmd...: [%TcPromtCmd%]
   Echo  TcPromtCmdOpt: [%TcPromtCmdOpt%]
   pause
:JumbOver_Debug

  if not exist "%TcPromtCmd%" goto :TcPromtCmdError
  call :Echo "excuting TcPrompt:[%TcPromtCmd% %TcPromtCmdOpt%]"
  call "%TcPromtCmd%" %TcPromtCmdOpt%

  rem -- #Step: start CheckBox Main to extract Data
  call "%CmdCurRoot_DP%\CheckBox_Main.cmd"
 endlocal
 goto :MyEnd


rem ============================================================================
:CB_VerUse_Ver2
 setlocal
 REM #Doc: Get CbData for Nx Version New Example: Nx75 ...
 REM #ToDo: anpassen NX75 TcePrompt durchlaufen

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo #Debug:
   Echo Start excuting: [CB_VerUse_Ver2]
   pause
:JumbOver

   set TcPromtCmd=%UGS_SHR_DIR%\start_apps\windows\start_nx85.bat
   set TcPromtCmdOpt=de tc_prompt tc8x tc83


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
  Echo #Debug:
  Echo befor excuting:
  Echo TcPromtCmd:[%TcPromtCmd% %TcPromtCmdOpt%]
  pause
:JumbOver

 if     exist "%TcPromtCmd%" call "%TcPromtCmd%" %TcPromtCmdOpt%
 if not exist "%TcPromtCmd%" goto :TcPromtCmdError

 rem 23.12.2010 16:19 J.Fes
 REM   set UGII_CHARACTER_FONT_DEFAULT=iso_font
 call "%CmdCurRoot_DP%\CheckBox_Main.cmd"
 endlocal
 goto :MyEnd

rem ============================================================================
:CB_ResultGen
 setlocal
  rem #Doc: Nx environ festlegen um Tool cgm2tiff.exe verwenden zu knnen
  rem #Doc: works only with version later then 'NX4'
  if not defined UGII_BASE_DIR set UGII_BASE_DIR=D:\ugs\nx75
  set UGII_ROOT_DIR=%UGII_BASE_DIR%\ugii
  REM   set UGS_LICENSE_SERVER=28000@JF-26
  REM   set UGS_LICENSE_BUNDLE=NX13100N;P1
  REM   REM Call "%UGS_SHR_DIR%\start_apps\windows\start_nx75.bat" de nx_prompt
  set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%
  rem #ToDo prfen ob richtiger
  set CB_Setting_DPNE=#01-BinServer_DP#.Custom\CheckBoxSettings-TC8_TestSystem.xml

  rem Optional:
  set CgmToTif_Opt=ON
  REM   set CgmToTif_cmdProg_Opt=%ProgramW6432%\Siemens\Teamcenter8.3\Visualization\VVCP\prepare.exe
  REM   set CgmToTif_cmdArgs_Opt=" -tif -monocolor ''#cgm_dpne#'' -out ''#tif_dpne#'' -density 150"
  set CgmToTif_cmdProg_Opt=default
  set CgmToTif_cmdArgs_Opt=default
  set CBcompDifMergTifgen_Opt=default


  rem #ToDo: Setup Details for Report description #new 26.02.2013 S.Gueth/J.Fes
  rem #Doc: for not using it use in next line goto: :JumbOverCBDescripton

  set CB1DescShort_Custom=TCE9.x/(NX6.0)
  set CB2DescShort_Custom=TC8.3./(NX8.5)

  set CB1DescFull_Custom=CustomInfo 1 Detail %CB1DescShort_Custom%
  set CB2DescFull_Custom=CustomInfo 2 Detail %CB2DescShort_Custom%

  set CBCompairExtra_Opt=%CBCompairExtra_Opt% -CB1DescShort "%CB1DescShort_Custom%"
  set CBCompairExtra_Opt=%CBCompairExtra_Opt% -CB2DescShort "%CB2DescShort_Custom%"
  set CBCompairExtra_Opt=%CBCompairExtra_Opt% -CB1DescFull  "%CB1DescFull_Custom%"
  set CBCompairExtra_Opt=%CBCompairExtra_Opt% -CB2DescFull  "%CB2DescFull_Custom%"
  set CBCompairExtra_Opt=%CBCompairExtra_Opt% -CBReportDesc "Compair between %CB1DescShort_Custom% and %CB2DescShort_Custom%"
:JumbOverCBDescripton

  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo #Debug:
   Echo befor excuting: 'CB_ResultGen'
   set ugII
   set ugs
   set CB_Setting_DPNE
   dir "%CB_Setting_DPNE%"
   pause
:JumbOver
  rem dann CheckBox Main aufrufen
  call "%CmdCurRoot_DP%\CheckBox_Main.cmd"

 endlocal
 goto :MyEnd

rem ==========================================================================
:MyEnd
  call :ColorSet End
  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
    Echo ========================================================================
    Echo [%0]
    Banner Deb.End
    Echo Debug:Ende
    pause
:JumbOver

  if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
    Echo ========================================================================
    Echo [%0]
    Banner Test.End
    Echo Test:Ende
    pause
:JumbOver

  rem -- #Step: alle Files loeschen die nicht zum JobServer gesendet werden sollen
  rem          #Doc: Nich loeschen wenn JobMgr_Debug=ON oder JobMgr_Test=ON
  if /i "%JobMgr_Debug%" equ "ON" goto :JumbOver
  if /i "%JobMgr_Test%"  equ "ON" goto :JumbOver
   del /S /Q "%temp%\*.exe","%temp%\apiserver.exe*.*","%temp%\*.bak","%temp%\*.tmp","%temp%\*.prt","%temp%\*.cgm","%temp%\tcserver*.*">nul 1>nul 2>nul
:JumbOver


 goto :end


rem ============================================================================
:ColorSet
 rem -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei

 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 rem Gelb Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=70
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof



rem ============================================================================
:TcPromtCmdError
 Call :ColorSet Err
 set ErrLog_DPNE=%temp%\__Err_MissingTcPromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start JobProcess on:\\%ComputerName% missing TCEPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo ---------------------------------------------------------------------
 rem call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TcPromtCmd:=%TcPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 rem call :ErrLogFooterWrite
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 pause
 start " " Notepad.exe "%ErrLog_DPNE%"
 Echo type "exit" to continue
 cmd
 goto :end

:end
 Echo -----------------------------------------------------------
 Echo Info:
 Echo all files in: %temp%
 Echo will be zipt by JobClinet and send to JobServer
 goto :eof


rem ============================================================================
:Wait
 set waitTime=2
 if not "%1"=="" set waitTime=%1
 CHOICE /C:w /N /T:w,%waitTime% warte %waitTime% [sec] oder "w" fuer weiter druecken.
 goto :eof

rem ============================================================================
:Echo
 rem Echos Text auf die Console und in eine Datei (wenn angegeben)
 rem Call :Echo "Result Message.........: %JobResMsg%"   "%CmdLog_DPNE%" "MailCmd_Protokoll_DPNE%"
 setlocal

   rem - TextToEcho erstellen
   set TextToEcho=%~1
   set TextToEcho=%TextToEcho:"=%
   if "%TextToEcho%" equ ""  set TextToEcho=.
   if "%TextToEcho%" neq "." set TextToEcho= %TextToEcho%

   rem - Ausgabe in File
   set EchoToFile_DPNE=
   if "%2" neq "" (
    set EchoToFile_DPNE=%2
    set EchoToFile_DPNE=!EchoToFile_DPNE:"=!
    Echo!TextToEcho! >>"!EchoToFile_DPNE!"
   )

   set EchoToFile_DPNE=
   if "%3" neq "" (
    set EchoToFile_DPNE=%3
    set EchoToFile_DPNE=!EchoToFile_DPNE:"=!
    Echo!TextToEcho! >>"!EchoToFile_DPNE!"
   )

   rem - Ausgabe Console
   Echo%TextToEcho%

   rem - Ausgabe in :TracAc
   if "%TextToEcho%" neq "." call :TracAc "%TextToEcho%"

 :EchoEnd
 endlocal
 goto :eof
rem ============================================================================
:TracAc
 rem example: Call :TracAc "%0 [MyInfo XYZ]"
 setlocal
 set TracAc_DPNE=%CmdCurRoot_DP%\zzTracActionInfo_log.txt
 set P1=%~1
 set P2=%~2
 set P3=%~3
 set P4=%~4
 set P5=%~5
 set P6=%~6
 set P7=%~7
 set P8=%~8
 set P9=%~9
 if DEFINED P1 Echo %date% %time:~0,8% %P1%>>"%TracAc_DPNE%"
 if DEFINED P2 Echo %date% %time:~0,8% %P2%>>"%TracAc_DPNE%"
 if DEFINED P3 Echo %date% %time:~0,8% %P3%>>"%TracAc_DPNE%"
 if DEFINED P4 Echo %date% %time:~0,8% %P4%>>"%TracAc_DPNE%"
 if DEFINED P5 Echo %date% %time:~0,8% %P5%>>"%TracAc_DPNE%"
 if DEFINED P6 Echo %date% %time:~0,8% %P6%>>"%TracAc_DPNE%"
 if DEFINED P7 Echo %date% %time:~0,8% %P7%>>"%TracAc_DPNE%"
 if DEFINED P8 Echo %date% %time:~0,8% %P8%>>"%TracAc_DPNE%"
 if DEFINED P9 Echo %date% %time:~0,8% %P9%>>"%TracAc_DPNE%"
 endlocal
 goto :eof
rem ============================================================================
:Parse_ALL
 rem parst alle File Bezeichner aus
 rem "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 rem "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof
