Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections.Generic
Imports JF.PlmJobManager
Imports JF.Tools

'' Script For Importing Ir+Datasets via TaskSheduler: 
''  Date         Person        ChangeInfo
''  12.04.2007   J.Feuerstein  createt
''  29.08.2007   J.Feuerstein  Doc -> Parameter addet

'' Documentation:
'' Parameter usage: /SiteList=MySiteId1;MySiteId2
''                   |-> use Liste  

Namespace JS_ScriptingDataImport
	
    Public Class ScriptingEngineClass
        Public Function ScriptMain(ByVal JS_ScriptingInterface As JobServer.ScriptingInterface.Methodes) As JF_Return_cls

            ' Required class for returning script results
            Dim MyScriptReturn As New JF_Return_cls
            Dim MyCallReturn As New JF_Return_cls
			Dim WaitTimeIn_MSec As Integer

            ' Example: using "standard form" for printing script informations 
            Dim MyScriptOutput_frm As New JobServer.JobServer_ScriptRun_frm(JS_ScriptingInterface.ScriptDef)
            MyScriptOutput_frm.Show()

            ' Example: for printing Informations to the header textbox 
            MyScriptOutput_frm.InfoSysHeader.PrintInfoLine("SiteImport")
            Dim SiteLi1 As String()

            Dim MyCmdPara As String
            MyCmdPara = JS_ScriptingInterface.ScriptDef.cmdPara
            MyScriptOutput_frm.InfoSysProtocol.Print(MyCmdPara)

            Try
                SiteLi1 = JS_ScriptingInterface.ParameterValueGet("SiteList").Split(New Char() {","c, ";"c})
                For Each SiteId As String In SiteLi1
                    MyCallReturn.ResetToDefaultValues()
                    MyScriptOutput_frm.InfoSysHeader.Print("Import IRs and Datasets of Site:" & SiteId)
                    MyCallReturn = JS_ScriptingInterface.Irs_and_Datasets_ImportFromTceDB(MyScriptOutput_frm.InfoSysProtocol, SiteId)
                    MyScriptOutput_frm.InfoSysHeader.Print(MyCallReturn.ResultMsgEvaluate)
                    MyScriptReturn.ResultMsg &= "Result importing data off site:" & SiteId & vbCrLf & _
                                                 MyCallReturn.ResultMsgEvaluate '& "" & vbCrLf
                Next
                MyScriptReturn.ResultMsg = MyScriptReturn.ResultMsg.TrimEnd(CChar(vbLf)).TrimEnd(CChar(vbCr))

            Catch ex As Exception
                MyScriptReturn.Ex = ex
                MyScriptReturn.ExMsg = "Exeption in script:" & JS_ScriptingInterface.ScriptDef.NameDescription
                MyScriptOutput_frm.InfoSysProtocol.PrintEx(ex, "in ex")
            End Try

EndOfScript:
            Call MyScriptOutput_frm.InfoSysProtocol.PrintInfoListClear()
            Call MyScriptOutput_frm.InfoSysProtocol.Print(MyScriptReturn.ResultMsg)
            'MsgBox("Next",MsgBoxStyle.OkCancel ,"Next")
			WaitTimeIn_MSec = 5000
			MyScriptOutput_frm.InfoSysProtocol.Print_and_StatusBarSetCurrActionStatusInfo_Panel3("wait:" & (WaitTimeIn_MSec / 1000).ToString("#.#") & " sec")
			System.Threading.Thread.Sleep(WaitTimeIn_MSec)

            ' Example: closing the ScriptRun form 
			MyScriptOutput_frm.Close()
			MyScriptOutput_frm.Dispose()

            Return MyScriptReturn
        End Function
    End Class
End Namespace
