Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Table         : [Objects_Ir_Rel_tbl]'
Print ' Creation Date : 22.03.2006'
Print ' Autor         : J.Feuerstein'
Print ' '
Print '-------------------------------------------------------------------------'

use [#DB_N#]


Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
set @MyTableName='Objects_Ir_Rel_tbl'
--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Objects_Ir_Rel_tbl]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   goto TableUpdate
  END
ELSE
  BEGIN
   goto TableCreate
  END

--------------------------------------------------------------------------------
TableCreate:
  set @MyActionMsg1=
      '-- Table: [' + @MyTableName + '] dose not exist and will be created new'
  Print (@MyActionMsg1)

  CREATE TABLE [dbo].[Objects_Ir_Rel_tbl] (
         /* mappt IRS zu den Objects */
         [Id]                        uniqueidentifier NOT NULL,
         [ObjectId]                  uniqueidentifier NOT NULL,
         [IrId]                      uniqueidentifier NOT NULL
  )
  ON [PRIMARY]



goto CheckCreateIndex

--------------------------------------------------------------------------------
TableUpdate:
  set @MyActionMsg1=
       '-- Table: [' + @MyTableName + '] exist and will be updated'
  Print (@MyActionMsg1)
  goto CheckCreateIndex


--------------------------------------------------------------------------------
CheckCreateIndex:

  Declare @ColumeName nvarchar (256)
  Declare @ColumeNameOld nvarchar (256)
  Declare @ColumeNameNew nvarchar (256)
  Declare @ExecuteStr nvarchar (max)

  -- 08.03.2011 16:00 angepasst
  EXECUTE JF_PrimKeyCheckCreateDef 'Objects_Ir_Rel_tbl_pk',           @MyTableName, 'Id'
  EXECUTE JF_IndexCheckCreateDef   'Objects_Ir_Rel_tbl_IDX_ObjectId', @MyTableName, 'ObjectId'
  EXECUTE JF_IndexCheckCreateDef   'Objects_Ir_Rel_tbl_IDX_IrId',     @MyTableName, 'IrId'

  /*
  If NOT Exists (select Name from sysindexes where Name = 'Objects_Ir_Rel_tbl_Id_pk')
  begin
     Print(' --> create index: Objects_Ir_Rel_tbl_Id_pk')
     ALTER TABLE [dbo].[Objects_Ir_Rel_tbl]
       ADD CONSTRAINT [Objects_Ir_Rel_tbl_Id_pk]
       PRIMARY KEY NONCLUSTERED ([Id])
       WITH (
         FILLFACTOR = 80,
         PAD_INDEX = OFF,
         STATISTICS_NORECOMPUTE = OFF,
         ALLOW_ROW_LOCKS = ON,
         ALLOW_PAGE_LOCKS = ON)
  end
  */

  /*
  If NOT Exists (select Name from sysindexes where Name = 'Objects_Ir_Rel_tbl_Id_uq')
  begin
     Print(' --> create index: Objects_Ir_Rel_tbl_Id_uq')
     ALTER TABLE [dbo].[Objects_Ir_Rel_tbl]
        ADD CONSTRAINT [Objects_Ir_Rel_tbl_Id_uq]
        UNIQUE NONCLUSTERED ([ObjectId], [IrId])
        WITH (
          FILLFACTOR = 80,
          PAD_INDEX = OFF,
          IGNORE_DUP_KEY = OFF,
          STATISTICS_NORECOMPUTE = OFF,
          ALLOW_ROW_LOCKS = ON,
          ALLOW_PAGE_LOCKS = ON)
  end
  */

  /*
  If NOT Exists (select Name from sysindexes where Name = 'Objects_Ir_Rel_tbl_IDX01')
  begin
     CREATE NONCLUSTERED INDEX [Objects_Ir_Rel_tbl_IDX01] ON [dbo].[Objects_Ir_Rel_tbl]
       (
       	[IrId] ASC,
       	[ObjectId] ASC
       )
         WITH (
         FILLFACTOR = 80,
         SORT_IN_TEMPDB = OFF,
         IGNORE_DUP_KEY = OFF,
         DROP_EXISTING = OFF,
         ONLINE = OFF) ON [PRIMARY]
  end
  */
  -- new 12.08.2009 14:57


--------------------------------------------------------------------------------
EndeExit:
 Print ('   |-> Done on Database: #DB_N#')
 Print '------------------------------------------------------------------------'

GO
