Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Table         : [JobControlRules_tbl]'
Print ' Creation Date : 22.03.2006'
Print ' Autor         : J.Feuerstein'
Print ' '
Print '-------------------------------------------------------------------------'

use [#DB_N#]


Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
DECLARE @ExecuteSQLstr nvarchar(max)
set @MyTableName='JobControlRules_tbl'

--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[JobControlRules_tbl]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   goto TableUpdate
  END
ELSE
  BEGIN
   goto TableCreate
  END

--------------------------------------------------------------------------------
TableCreate:
  set @MyActionMsg1=
      '-- Table: [JobControlRules_tbl] dose not exist and will be created new'
  Print (@MyActionMsg1)
  CREATE TABLE [dbo].[JobControlRules_tbl] (

          [Id] [uniqueidentifier] NOT NULL ,
          [JobOrder] [nvarchar] (10) ,
          [JobName]  [nvarchar] (32) ,                            -- JobName ##Doc: "der JobName ist eindeutig"
          [JobDescription]  [nvarchar] (255) ,                    -- Beschreibung des Job's
          [JobAktive] [bit] NULL ,                                -- ist diese Regel aktive Ja/Nein
          [JobComputers] [nvarchar] (128) ,                       -- hlt fest welche Computer mit Computernamen diesen Job bearbeiten drfen
          [JobOnTceSite_id_IsRefTo_Sites_tbl_id] [nvarchar] (64), -- [uniqueidentifier] null ,
          [JobScriptName] [nvarchar] (50) ,                       -- JobScriptName = Referenziert den Eintrag in JobScript_tbl (JobScripts)
          [JobPacket_ObjectCount] int ,                           -- Anzahl der zu extrahierenden ItemRef's

          [JobResourcePoints] int ,                               -- JobResourcePoints legt die Anzahl der JobResource Points fest
                                                                  --  |-> die dieser Job verbraucht. Wird 0 vergeben so wird kein ResourePoint gezaehlt. New:[31.10.2011]

          [JobNumberLast] int ,                                   -- letzte JobNumer
          [ObjectsSendCount] int ,                                -- Anzahl der durch diese Regel gesendeten Objekte

          [TimeSchedule]              [nvarchar](255) ,
          [ProcStateCol]              [varchar] (32) ,            -- hlt fest in welchem Colume der Dataset Ir Tabelle der Processstatus verwaltet wird !
          [JobResult_ProcStateValueRule] [nvarchar](max) ,        -- definiert die ProcStatValueRule new:[31.10.2011]
                                                                  -- Hierber knnen Regeln festgelegt werden den P.Status eines JobErgebnisses festzulegen.

          [SelObjectsBy_ProcStateVal] [nvarchar](34) ,            -- legt den Wert fest ber den die Objekte selektiert werden z.b. 'N' 'M' ...
                                                                  -- Size angepasst auf 32+2 = 34

          [SelObjectsBy_ObjectClass]  [nvarchar](10) ,            -- selection der Daten ber DS=Datasets oder IR=Irs IRforRefile
          [SelObjectsBy_UgMasterType] [nvarchar](10) ,            -- selection ber SP oder AP
          [SelObjectsBy_ObjectType]   [nvarchar](32) ,            -- selection der Daten ber UGMASTER, UGPART , UGALTREP ..
                                                                  -- .Net siehe JC --> DatsetObjectTypes.UGMASTER
          [SelObjectsBy_ObjectIrType] [nvarchar](32) ,            -- selection der Daten ber ItemRevsision Type new 20.12.2011 06:35


          [SelObjectsBy_MinComponents] int ,                      -- = select min Compontens
          [SelObjectsBy_MaxComponents] int ,                      -- = select max Compontens

          [SelObjectsBy_MinApLevels] int ,                        -- = select min AP Levesl
          [SelObjectsBy_MaxApLevels] int ,                        -- = select min AP Levesl
          
          [SelObjectsBy_Volume]           [nvarchar] (255) ,      -- = select nach Volume
          [SelObjectsBy_Name]             [nvarchar] (128) ,      -- = select nach Names
          [SelObjectsBy_Group]            [nvarchar] (32) ,       -- = select nach Group
          [SelObjectsBy_Owner]            [nvarchar] (32) ,       -- = select nach User
          [SelObjectsBy_MultiSiteObjects] [nvarchar] (10) ,       -- = MultiSite Object selection 10 = OwningSiteObjektes_Only 20 = RemoteSiteObjektes_Only 30 = RemoteAndOwningSiteObjektes_Only
          
          [SelObjectsBy_PFM] [nvarchar] (10) ,                    -- = PartFamily Object selection [1=PFM_Ignor] [2=PFM_No]  [4=PFM_Only] (new 21.10.2009 J.Fes)
          [SelObjectsBy_FsHitCount_YN] [bit] NULL ,               -- Objekte via FsHitCount selectieren Yes/No (new 26.03.2010)

          [SelObjectsBy_SQLScript_YN]            [bit] NULL ,                -- ist diese Regel aktive Ja/Nein (neu in 18.10.2007)
          [SelObjectsBy_SQLScript_PPNE]          [nvarchar] (255) ,      -- = Teilverzeichniss zum SQL Script (neu in 18.10.2007)

          [SelObjectsBy_ObjectLastModDateBefor]  [datetime] ,     -- selection der Daten ber Last Mod Befor Datetime
          [SelObjectsBy_ObjectLastModDateAfter]  [datetime] ,     -- selection der Daten ber Last Mod After Datetime
          [Note]                                 [nvarchar] (MAX)    -- Notice Feld (new 17.11.2011 20:39)
  ) ON [PRIMARY]


  goto CheckCreateIndex

--------------------------------------------------------------------------------
TableUpdate:

  set @MyActionMsg1=
       '-- Table: [JobControlRules_tbl] exist and will be updated'
  Print (@MyActionMsg1)

  Declare @ColumeName nvarchar (256)
  Declare @ColumeNameOld nvarchar (256)
  Declare @ColumeNameNew nvarchar (256)
  Declare @ExecuteStr nvarchar (max)


  -- ergaenzt 05.08.2008
  set @ColumeName='SelObjectsBy_ProcStateVal'
  if (Select Coalesce(Col_length('JobControlRules_tbl',@ColumeName),0)) = 0
    begin
      print ('Create Column:' + @ColumeName + ' for table:  [JobControlRules_tbl] (new 05.08.2008)]')
      set @ExecuteStr='ALTER TABLE [dbo].[JobControlRules_tbl] ADD [' + @ColumeName +'] [nvarchar] (10) NULL'
      execute (@ExecuteStr)
    end

  -- ergaenzt 03.07.2009 13:00
  set @ColumeName='SelObjectsBy_MaxApLevels'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
    begin
      print ('Create Column:' + @ColumeName + ' in Table:' + @MyTableName + ' select AP Objects by Max AP Levels (new 03.07.2009)]')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] Int'
      execute (@ExecuteStr)
    end

  -- ergaenzt 03.07.2009 13:00
  set @ColumeName='SelObjectsBy_MinApLevels'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
    begin
      print ('Create Column:' + @ColumeName + ' in Table:' + @MyTableName + ' select AP Objects by Min AP Levels (new 03.07.2009)]')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] Int'
      execute (@ExecuteStr)
    end
    
  -- ergaenzt 21.10.2009 J.Fes
  set @ColumeName='SelObjectsBy_PFM'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
    begin
      print ('Create Column:' + @ColumeName + ' in Table:' + @MyTableName + ' select Objects by PartFamily [1=PFM_Ignor] [2=PFM_No]  [4=PFM_Only] (new 21.10.2009 J.Fes)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] Int'
      execute (@ExecuteStr)
      -- siehe auch ..\01-BinServer\Resources\T-SQL\JobMgr_90_MaintainDatabase.sql Abschnitt JobControlRules_tbl_Update_SelObjectsBy_PFM
    end

  -- ergaenzt 31.10.2011 J.Fes
  set @ColumeName='SelObjectsBy_FsHitCount_YN'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
    begin
      print ('Create Column:' + @ColumeName + ' in Table:' + @MyTableName + ' Objekte via FsHitCount selectieren Yes/No (new 31.10.2011 J.Fes)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] Bit'
      execute (@ExecuteStr)
    end

  -- ergaenzt 31.10.2011 J.Fes
  set @ColumeName='JobResourcePoints'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
   begin
     print ('Create Column:' + @ColumeName + ' in Table:' + @MyTableName + ' JobResourcePoints legt die Anzahl der JobResource Points fest die dieser Job verbraucht. Wird 0 vergeben so wird kein ResourePoint gezaehlt. New:[31.10.2011 J.Fes]')
     set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] Int'
     execute (@ExecuteStr)
     -- siehe auch ..\02-VB.NET\JobServer\JobServer_JobControl_ClientServer.vb
   end

  -- ergaenzt 31.10.2011 J.Fes
  set @ColumeName='JobResult_ProcStateValueRule'
  if (Select Coalesce(Col_length('JobControlRules_tbl',@ColumeName),0)) = 0
   begin
     print ('Create Column:' + @ColumeName + ' for table:  [JobControlRules_tbl] efiniert die ProcStatValueRule (new:31.10.2011 J.Fes)]')
     set @ExecuteStr='ALTER TABLE [dbo].[JobControlRules_tbl] ADD [' + @ColumeName +'] [nvarchar] (max) NULL'
     execute (@ExecuteStr)
   end


  set @ColumeName='JobComputers'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) <> -1
   BEGIN
      print ('Column: JobControlRules_tbl.JobComputers upsize to max char [Change:31.10.2011 J.Fes]')
      ALTER TABLE [dbo].[JobControlRules_tbl]
        ALTER COLUMN [JobComputers] nvarchar(max) COLLATE Latin1_General_CI_AS
   END

  set @ColumeName='Note'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
   BEGIN
     print ('Create Column:' + @ColumeName + ' in Table:' + @MyTableName + ' Note Colume New:[17.11.2011 J.Fes]')
     set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] [nvarchar] (max) NULL'
     execute (@ExecuteStr)
     -- siehe auch ..\02-VB.NET\JobServer\JobServer_JobControl_ClientServer.vb
   END

   -- angepasst 23.11.2011 / J.Fes
   set @ColumeName='SelObjectsBy_ProcStateVal'
   if (Select Col_length(@MyTableName,@ColumeName)) <> 34*2
     BEGIN
      -- Anpassen auf Sice = 34
      set @ExecuteSQLstr='ALTER TABLE [dbo].[' + @MyTableName + ']' + ' ALTER COLUMN [' + @ColumeName + '] nvarchar(34) COLLATE Latin1_General_CI_AS'
      print (@ExecuteSQLstr)
      execute sp_executesql @ExecuteSQLstr
     END

  -- new 20.12.2011 / J.Fes  / verbleibt 10.01.2012
  set @ColumeName='SelObjectsBy_ObjectIrType'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
   BEGIN
     print ('Create Column:' + @ColumeName + ' in Table:' + @MyTableName + ' selection der Daten ber ItemRevsision Type [new 20.12.2011 J.Fes]')
     set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] [nvarchar] (32) NULL'
     execute (@ExecuteStr)
     -- siehe auch ..\02-VB.NET\JobServer\JobServer_JobControl_ClientServer.vb
   END



goto CheckCreateIndex

CheckCreateIndex:

  If NOT Exists (select Name from sysindexes where Name = 'JobControlRules_tbl_pk')
  begin
     Print(' --> create index: JobControlRules_tbl_pk')
     ALTER TABLE [dbo].[JobControlRules_tbl]
       ADD CONSTRAINT [JobControlRules_tbl_pk]
       PRIMARY KEY NONCLUSTERED ([Id])
       WITH (
         FILLFACTOR = 80,
         PAD_INDEX = OFF,
         STATISTICS_NORECOMPUTE = OFF,
         ALLOW_ROW_LOCKS = ON,
         ALLOW_PAGE_LOCKS = ON)
  end

  If NOT Exists (select Name from sysindexes where Name = 'JobControlRules_tbl_JobName_uq')
  begin
     Print(' --> create index: JobControlRules_tbl_JobName_uq')
     ALTER TABLE [dbo].[JobControlRules_tbl]
        ADD CONSTRAINT [JobControlRules_tbl_JobName_uq]
        UNIQUE NONCLUSTERED ([JobName])
        WITH (
          FILLFACTOR = 80,
          PAD_INDEX = OFF,
          IGNORE_DUP_KEY = OFF,
          STATISTICS_NORECOMPUTE = OFF,
          ALLOW_ROW_LOCKS = ON,
          ALLOW_PAGE_LOCKS = ON)
  end

--------------------------------------------------------------------------------
EndeExit:
 Print '------------------------------------------------------------------------'
 Print (@MyActionMsg1)
 Print ('   |-> Done on Database: #DB_N#')
 Print '------------------------------------------------------------------------'

GO
