/* ir.puid of ItemRev ren IrName -> ItemId + ItemPuid */
select
      ItemRev.ItemId       AS ItemId,
      ItemRev.ItemPuid     AS ItemPuid,
      ItemRev.IrRev        AS IrRev,
      ItemRev.IrPuid       AS IrPuid
      -- ,ItemRev.Source
from
(Select
      i.pitem_id           AS ItemId,
      i.puid               AS ItemPuid,
      ir.pitem_revision_id AS IrRev,
      ir.puid              AS IrPuid
     -- ,'SequYes' As Source
    From
      infodba.PITEMREVISION ir
    Inner Join
      (Select ir.ritems_tagu || ir.rsequence_anchoru Id, Max(ir.psequence_id) MaxSeq
        From  infodba.PITEMREVISION ir
        Where ir.rsequence_anchoru Is Not Null
        Group By ir.ritems_tagu || ir.rsequence_anchoru
      ) HSeq
    On ir.ritems_tagu || ir.rsequence_anchoru = HSeq.Id
       and ir.psequence_id = HSeq.MaxSeq
    Left Join infodba.PITEM i On (ir.ritems_tagu = i.puid)
    Union All (
     Select
      i.pitem_id           AS ItemId,
      i.puid               AS ItemPuid,
      ir.pitem_revision_id AS IrRev,
      ir.puid              AS IrPuid
      -- ,'SequNo' As Source
    From
      infodba.PITEMREVISION ir
    Left Join infodba.PITEM i On (ir.ritems_tagu = i.puid)
    Where ir.rsequence_anchoru Is Null)
) ItemRev
where ItemRev.ItemId =:i_pitem_id
and ItemRev.IrRev =:ir_pitem_revision_id
