Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Procedures    : JobControl'
Print ' Creation Date : 12.02.2010'
Print ' Autor         : J.Feuerstein'
Print ' '
Print '-------------------------------------------------------------------------'
GO

use [#DB_N#]
GO

Print '' Print ''
Print '-- [JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData] ---------'
If Exists (select Name
           from sysobjects
           where Name = "JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData" and type = "P")
Drop Procedure JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData
GO


/* Neu: 12.02.2010 15:33 / J.Fes
   Description: Sucht in JobControl_ObjectsProcessData_tbl fr: @Object_tbl_ID nach unbearbeiteten JobPlaner eintrag
                 siehe hierzu .Net V.02-VB.NET\JobServer.DataSource\JobServer_DataSource.vb:JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData
   Letze Anpassung: 04.04.2012 20:27  WHERE
    dbo.JobControl_ObjectsProcessData_tbl.Row_isLastRes = 1 -- AND
   order by dbo.JobControl_ObjectsProcessData_tbl.ProcessTimeStart DESC
*/
CREATE PROCEDURE JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData
                           @Object_tbl_ID  nvarchar(64)   -- ID des Datensatzes in dbo.JobControl_ObjectsProcessData_tbl.Objects_tbl_ID

AS
BEGIN

 SELECT TOP 1
  -- new 15.10.2013/J.Fes  use to get IR Data
  Ir.ObjectPuid AS IrPuid,
  Ir.ObjectName AS IrName,
  dbo.JobControl_ObjectsProcessData_tbl.*,
  dbo.Objects_tbl.*

FROM
  dbo.JobControl_ObjectsProcessData_tbl with (nolock)
      INNER JOIN dbo.Objects_tbl WITH (nolock) ON (dbo.JobControl_ObjectsProcessData_tbl.Objects_tbl_ID = dbo.Objects_tbl.Id),
  -- new 15.10.2013/J.Fes use to get IR Data
  dbo.Objects_Ir_Rel_tbl with (nolock)
      LEFT OUTER JOIN dbo.Objects_tbl Ir WITH (nolock) ON (dbo.Objects_Ir_Rel_tbl.IrId = Ir.Id)
WHERE
      dbo.JobControl_ObjectsProcessData_tbl.Objects_tbl_ID = @Object_tbl_ID
  AND dbo.JobControl_ObjectsProcessData_tbl.Row_isLastRes = 1
ORDER BY
  dbo.JobControl_ObjectsProcessData_tbl.ProcessTimeStart DESC

END
GO
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------


-- Print ''
-- Print ''
-- Print ''
-- Print '----------------------------------------------------'
-- Print ' Test Procedures ObjectsUpdate_ProcessStatus_Mark_LastRes'
-- Print '----------------------------------------------------'
-- GO
-- im9t
-- Execute JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData '5d7c3cc4-227d-4333-8615-dd40f70b909e'
-- go
-- goto ende
ende:

Print ''
Print '-------------------------------------------------------------------------'
Print ' Procedures imported to #DB_N#'
Print '-------------------------------------------------------------------------'
GO
