Print ''                
Print '-------------------------------------------------------------------------'
Print ' using Database: PLMPerfAnalyse'
Print ' Table         : [tblEvents]'
Print ' Creation Date : 13.11.2012'
Print ' Autor         : S.G?th'
Print '-------------------------------------------------------------------------'

use [PLMPerfAnalyse]

Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
set @MyTableName='tblEvents'
DECLARE @ExecuteSQLstr nvarchar(max)

declare @indexNrCur  int
declare @indexNrEnd  int
declare @indexNrStr       varchar(32)
declare @IndexName        varchar(max)
declare @ProcStateColName varchar(max)
set @indexNrEnd = 10


--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblEvents]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   goto TableUpdate
  END
ELSE
  BEGIN
   goto TableCreate
  END

--------------------------------------------------------------------------------
TableCreate:
  set @MyActionMsg1=
      '-- Table: [tblEvents] dose not exist and will be created new'

  Print (@MyActionMsg1)

  CREATE TABLE tblEvents
  (
        [EventID]               int NOT NULL,
        [EventDate]             datetime2 NOT NULL,
        [EventTimeBegin]        datetime2 NOT NULL,
        [EventTimeEnd]          datetime2 NOT NULL,
        [MesslinieID]           int,
        [EventTitel]            nvarchar(255),
        [EventText]             nvarchar(max),
        [EintragVon]            nvarchar(50),
        CONSTRAINT tblEvents_PK PRIMARY KEY ([EventID])
  )
  ON [PRIMARY]

  goto CheckCreateIndex

--------------------------------------------------------------------------------
TableUpdate:

  set @MyActionMsg1=
       '-- Table: [' + @MyTableName + '] exist and will be updated'
  Print (@MyActionMsg1)

  Declare @ColumeName nvarchar (256)
  Declare @ColumeNameOld nvarchar (256)
  Declare @ColumeNameNew nvarchar (256)
  Declare @ExecuteStr nvarchar (max)


 --- set @ColumeName='ObjectPuid'
 --- if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
 ---   begin
 ---     print ('Create Column:' + @ColumeName +  ' .. PUID of Object (new 2.1.2009 J.Fes)')
 ---     set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(15) COLLATE Latin1_General_CS_AS NULL'
 ---     execute (@ExecuteStr)
 ---   end




goto CheckCreateIndex

--------------------------------------------------------------------------------
CheckCreateIndex:

  EXECUTE JF_PrimKeyCheckCreateDef 'tblEvents_pk',                      @MyTableName, 'EventID'
  EXECUTE JF_IndexCheckCreateDef   'tblEvents_IDX_EventDate',           @MyTableName, 'EventDate'
  EXECUTE JF_IndexCheckCreateDef   'tblEvents_IDX_EventTimeBegin',      @MyTableName, 'EventTimeBegin' 
  EXECUTE JF_IndexCheckCreateDef   'tblEvents_IDX_EventTimeEnd',        @MyTableName, 'EventTimeEnd' 

--------------------------------------------------------------------------------
EndeExit:
 Print ('   |-> Done on Database: PLMPerfAnalyse')
 Print '------------------------------------------------------------------------'

GO
