
Option Compare Text
Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections.Generic
Imports System.Data

Imports JF.PlmJobManager
Imports JF.PlmJobManager.JobServer

'' # ---------------------------------------------------------------------------------------
'' # Documentation:
'' # Description  : Script fuer das Updaten des Status von den E-Matrix Daten die erneut via Refile/CheckBox geprueft werden sollen
'' # Parameters   : keine
'' # History:
'' # Date         Person        ChangeInfo
'' # 14.03.2014   J.Fes         createt
'' # ---------------------------------------------------------------------------------------
'' # ---------------------------------------------------------------------------------------
'' # Dokumentation:
'' # Vereinbarungen:


Namespace JS_RefileSelectPartBatch


	Public Class ScriptingEngineClass

		' Classen weite deklarationen
		Private Import_Obj As New JF.PlmJobManager.JobServer.Datasets_and_Irs_cls
		Private UgMaster_Obj As New JF.PlmJobManager.JobServer.Datasets_and_Irs_cls
		
		' ##Debug: Variablen
        Private DebugAktive As Boolean = False
        Private DebugTestAktive As Boolean = False
		
		Private MyScriptOutput_frm As JobServer_ScriptRun_frm
        Private MyScriptTitle As String = "Groz Beckert eMatrix RefileSelectPartBatch 14.03.2014..14.03.2014 V0.9 [DebugMode:" + Me.DebugAktive.ToString + "] [TestMode:" + Me.DebugTestAktive.ToString + "] Start:[" + Now().ToString + "]"
		
		Private iText As String = ""
        Private Debug_Nlog As NLog.Logger = NLog.LogManager.GetLogger("RefileSelectPartBatch")
        Dim DataSource_Obj As New MyAppl_DataSource_cls("RefileSelectPartBatch")



        '!!!!!!!!!!!!!!!!!! ---------------- wichtige Konstanten 27.01.2011 J.Feuerstein ------------------ !!!!!!!!!!!!!!!!!!!!!!!!!!
        ''' <summary>
        ''' legt fest von welche SiteDef Daten eingelesen werden siehe auch Sites/Data Import --> SiteDef "mxgb"
        ''' </summary>
        Private Const SiteIDCurr As String = "mxgb"             '
        ''' <summary>
        ''' legt fest mit welcher Db MQL arbeitet siehe auch Sites/Data Import --> SiteDef "mxgb"
        ''' </summary>
        Private Const MatrixSiteId As String = "MATRIX-R.prod"


        Dim Headline_Return As New JF.Tools.JF_Return_cls
        Dim ImportRun_Return As New JF.Tools.JF_Return_cls
        Dim Footline_Return As New JF.Tools.JF_Return_cls
        Dim ResultReturn As New JF.Tools.JF_Return_cls

        Dim JS_ScriptingInterface As ScriptingInterface.Methodes

        Dim LogF_Protocol_DPNE As String
        Dim RefileSelectPartPatch_Data_DPNE As String

        Dim RefileSelectPartPatch As String


        '--------------------------------------------------------------------------------------
        Public Function ScriptMain(ByVal JS_ScriptingInterfaceIn As ScriptingInterface.Methodes) As JF.Tools.JF_Return_cls

            Me.JS_ScriptingInterface = JS_ScriptingInterfaceIn

            '-- using "standard form" for printing script informations
            MyScriptOutput_frm = New JobServer_ScriptRun_frm(Me.JS_ScriptingInterface.ScriptDef)
            MyScriptOutput_frm.Show()
            MyScriptOutput_frm.Text = MyScriptTitle


            '-- Liste der LogFiles ----------------------------------
            LogF_Protocol_DPNE = LogFileGet_DPNE(LogFile_Enums.Protocol)
            RefileSelectPartPatch_Data_DPNE = LogFileGet_DPNE(LogFile_Enums.RefileSelectPartPatch)

            '-- parsing parameters 
            Dim DataImport_DoExec As String = JS_ScriptingInterface.ParameterValueGet("DataImport")
            Dim DataSync_DoExec As String = JS_ScriptingInterface.ParameterValueGet("DataSync")
            Dim DataSyncStart As String = JS_ScriptingInterface.ParameterValueGet("DataSyncStart")

            '-- handling Exeptions ---------------
            Try

                Me.MyScriptOutput_frm.InfoSysHeader.PrintInfoLine(MyScriptTitle)
                Me.MyScriptOutput_frm.InfoSysProtocol.PrintInfoLine(MyScriptTitle)

                '-- Header Info erzeugen
                LogF_AddLine(LogF_Protocol_DPNE, MyScriptTitle, True, True)
                LogF_AddLine(LogF_Protocol_DPNE, "----------------------------------------------------------------------------", True, True)
                LogF_AddLine(LogF_Protocol_DPNE, "Execute.: " + MyScriptTitle, True, True, True)
                LogF_AddLine(LogF_Protocol_DPNE, "Script..: " + jf.Tools.JF_ToolsFile.ParsePath_NE(JS_ScriptingInterface.ScriptDef.Script_DPNE), True, True, True)
                LogF_AddLine(LogF_Protocol_DPNE, "RfSelF..: " + RefileSelectPartPatch_Data_DPNE, True, True, True)
                LogF_AddLine(LogF_Protocol_DPNE, "JobLog..: " + JF.Tools.JF_ToolsFile.ParsePath_DP(LogF_Protocol_DPNE), True, True, True)
                LogF_AddLine(LogF_Protocol_DPNE, "----------------------------------------------------------------------------", True, True, True)


                If JF.Tools.JF_ToolsString.StringEnvironValuesGet("%MXHOME%") = "%MXHOME%" Then
                    'MyScriptOutput_frm.InfoSysProtocol.PrintEx(ex, Footline_Return.ExMsg)
                    iText = "Err: cannot Run Script missing Environ Var:[%MXHOME%]"
                    Footline_Return.ResultMsgAdd(iText)
                    LogF_AddLine(LogF_Protocol_DPNE, iText, True, True)
                    GoTo EndOfScript
                End If

                '-- LogFiles bereitstellen
                LogF_AddLine(LogF_Protocol_DPNE, LogF_Protocol_DPNE, True, True)

                '-- #Step 1: erzeugen der SelectionsListe    
                If Not Me.DebugTestAktive Then
                    ' call exec prog SYS_RefileSelectPartBatch c:/temp/refile_report.txt;
                    ImportRun_Return = MqlExecute(String.Format("SYS_RefileSelectPartBatch:[{0}]", Me.RefileSelectPartPatch_Data_DPNE), _
                                                  String.Format("exec prog SYS_RefileSelectPartBatch {0}", Me.RefileSelectPartPatch_Data_DPNE), _
                                                  True)
                End If

                '-- #Step 2: lesen des OutPutFiles 
                '            Status der aufgelisteten Parts auf Refile setzen Status = ‚M‘
                '            prüfen der Anzahl der Objekte wenn mehr als 10.000 dann not Do ..
                'ug0000001171;ug0000001171;12.01.2014
                'ug0000001338;ug0000001338;12.01.2014
                Me.RefileSelectPartPatch = "M"
                If Me.DebugTestAktive Then
                    Me.RefileSelectPartPatch_Data_DPNE = "C:\temp\RefileSelectPartBatch_test.txt"
                    RefileSelectPartPatch = "Mx"
                End If
                Call RefileSelectPartPatch_set_M(Me.RefileSelectPartPatch_Data_DPNE)


            Catch ex As Exception
                Footline_Return.Ex = ex
                Footline_Return.ExUp = True
                'Footline_Return.ExMsg = "ScriptTemplate"
                MyScriptOutput_frm.InfoSysProtocol.PrintEx(ex, Footline_Return.ExMsg)
                Footline_Return.ResultMsgAdd(Footline_Return.ResultMsgEvaluate)
                GoTo EndOfScript
            End Try

            '-- returning results --------------------------------------------------------------------------
EndOfScript:

            Call MyScriptOutput_frm.InfoSysProtocol.PrintInfoLine("")
            Call LogF_AddLine(LogF_Protocol_DPNE, ResultReturn.ResultMsg)
            If DebugAktive Then
                MyScriptOutput_frm.Pause("#DebugAktive: click me and script will end")
            End If

            If DebugTestAktive Then
                MyScriptOutput_frm.Pause("#DebugTestAktive: click me and script will end")
            End If

            '-- setting the progress bar to idel
            Call MyScriptOutput_frm.InfoSysProtocol.StatusBarProgressBarSetIdle()

            '-- closing the ScriptRun form
            MyScriptOutput_frm.Close()
            MyScriptOutput_frm.Dispose()

            ResultReturn.ResultMsgClear()
            ResultReturn.ResultMsgAdd(Headline_Return.ResultMsg)
            ResultReturn.ResultMsgAdd(ImportRun_Return.ResultMsg)
            ResultReturn.ResultMsgAdd(Footline_Return.ResultMsg)


            Return ResultReturn
        End Function


        '--------------------------------------------------------------------------------------------------------
        ''' <summary>
        ''' setzt den Status auf 'M' fuer alle in RefileSelectPartPatch_Data_DPNE_p 
        ''' aufgelisteten Daten
        ''' </summary>
        Private Sub RefileSelectPartPatch_set_M(ByVal RefileSelectPartPatch_Data_DPNE_p As String)
            Dim RefileSelectPartPatch_fp As New JF.Tools.JF_ToolsFile.JF_FileProcessing_cls(RefileSelectPartPatch_Data_DPNE_p)
            Dim FileLineItems As String()

            Dim GetDSResult_Obj As New JF.Tools.JF_Return_cls
            Dim Datasets_and_Irs_Obj As New JF.PlmJobManager.JobServer.Datasets_and_Irs_cls

            RefileSelectPartPatch_fp.FileReadAllText()

            For Each FileLine As String In RefileSelectPartPatch_fp.ListOfString_LinesWithOutEmpty_TextLines
                iText = "MqL FileLine:[" + FileLine + "]"
                FileLineItems = FileLine.Split(";"c)
                If FileLineItems.Length >= 2 Then
                    '-- werte auf Datasets_and_Irs_Obj uebertragen
                    With Datasets_and_Irs_Obj
                        .ResetToDefaultValue()
                        .ItemName = FileLineItems(0)
                        .IrRev = "0"
                        '-- O.Name
                        .ObjectName = FileLineItems(1)
                        .ObjectClass = JF.PlmJobManager.JobServer.ObjectClass_enum.DS
                        .ObjectFromSiteID = SiteIDCurr
                        '-- Last ModDate wird genommen aus CheckInDate-3
                        '.ObjectLastModDate = ConvertDateTime(FileLineItems(3))
                        GetDSResult_Obj = Me.DataSource_Obj.Objects_tbl_GetDS(Datasets_and_Irs_Obj)
                        iText = String.Format("Set O.Item:[{0}] O.Name:[{1}] for:[{2}] Status=[{3}]", FileLineItems(0), FileLineItems(1), .ObjectCliNameForOutput, RefileSelectPartPatch)
                        LogF_AddLine(LogF_Protocol_DPNE, iText, False, True, False)
                    End With
                    GetDSResult_Obj = DsIr_ProcStateColRf_set_M(Datasets_and_Irs_Obj)
                End If
            Next
        End Sub


        '-----------------------------------------------------------------------------------------------------------------
        Private Function DsIr_ProcStateColRf_set_M(ByVal DsIr_p As JF.PlmJobManager.JobServer.Datasets_and_Irs_cls) As JF.Tools.JF_Return_cls
            Dim GetDSResult_Obj As New JF.Tools.JF_Return_cls
            '-- Step:  setzen Status ProcStateColRf = 'M' 
            GetDSResult_Obj = DataSource_Obj.Objects_tbl_UpdateColumeValue_by_ID(DsIr_p.ID.ToString, "ProcStateCol04", RefileSelectPartPatch)
            Return GetDSResult_Obj
        End Function

        '-----------------------------------------------------------------------------------------------------------------
        ''' <summary>
        ''' Temp Sub fur das ausgeben der debug meldungen
        ''' </summary>
        ''' <param name="MsgText"></param>
        Private Sub ImportRun_DebugPrint(ByVal MsgText As String)
            If DebugAktive Then
                ImportRun_Return.ResultMsgAdd("##debug: " + MsgText)
                Me.MyScriptOutput_frm.InfoSysProtocol.Print(ImportRun_Return.ResultMsgLast)
            End If
        End Sub

        '-----------------------------------------------------------------------------------------------------------------
        ''' <summary>
        ''' Konvertiert  "1.2.2007:18:02:56" --> "1.2.2007 18:02:56"
        ''' </summary>
        ''' <param name="DateReadIn"></param>
        ''' <returns></returns>
        Private Function ConvertDateTime(ByRef DateReadIn As String) As DateTime
            'dim DateRead As string ="1.2.2007:18:02:56"
            Dim DateReadItems As String()
            Dim DateReadReturn As String = DateReadIn
            DateReadItems = DateReadIn.Split(CChar(":"))

            If DateReadItems.Length = 4 Then
                DateReadReturn = DateReadItems(0) + " " + DateReadItems(1) + ":" + DateReadItems(2) + ":" + DateReadItems(3)
            End If

            Return JF.Tools.CTypeTryDefault(Of DateTime)(DateReadReturn, now())
        End Function


        ''' <summary>
        ''' Konvertiert  "1.2.2007 18:02:56" --> "1.2.2007:18:02:56"
        ''' </summary>
        ''' <returns></returns>
        Private Function ConvertDateTimeFor_eMatrix(ByRef DateTimeIn As DateTime) As String
            With DateTimeIn
                Return .Day.ToString("0#") + "." + .Month.ToString("0#") + "." + .Year.ToString("0#") + _
                ":" + .Hour.ToString("0#") + ":" + .Minute.ToString("0#") + ":00"
            End With

        End Function

        '-------------------------------------------------------------------------------------------
        ''' <summary>
        ''' 
        ''' </summary>
        ''' <returns></returns>
        Private Function MqlExecute(ByVal infoTextIn As String, _
            ByVal MqlArguments As String, ShowMqlWindow As Boolean) As JF.Tools.JF_Return_cls

            Dim MyReturn As New JF.Tools.JF_Return_cls

            Dim MqlOiQ_Process As New System.Diagnostics.Process
            MqlOiQ_Process.StartInfo.FileName = JF.Tools.JF_ToolsString.StringEnvironValuesGet("%MXBINPATH%\mql.exe")
            MqlOiQ_Process.StartInfo.Arguments = "-b " + MatrixSiteId + " -t -v -c "
            If ShowMqlWindow Or DebugTestAktive Or DebugAktive Then
                MqlOiQ_Process.StartInfo.Arguments = MqlOiQ_Process.StartInfo.Arguments.Replace("-t", "")
            End If
            MqlOiQ_Process.StartInfo.Arguments += chr(34) + MqlArguments + chr(34)


            If MqlOiQ_Process.StartInfo.FileName.Contains("%MXHOME%") Then
                iText = String.Format("Umgebungsvariable %MXHOME% nicht gesetzt Abbruch DataSync")
                LogF_AddLine(LogF_Protocol_DPNE, iText)
                MyReturn.ErrMsg = iText
                Return MyReturn
            End If

            Try

                ' MyScriptOutput_frm.InfoSysProtocol.StatusBarProgressBarStart()
                ' Call MyScriptOutput_frm.InfoSysProtocol.PrintInfoLine("")
                'iText = string.Format("MQL:{0} / Start Time:[{1}]",infoTextIn,now())
                'LogF_AddLine(LogF_Protocol_DPNE,iText)
                iText = String.Format("MQL:{0}/Start:[{1}] [{2} {3}]", infoTextIn, now(), MqlOiQ_Process.StartInfo.FileName, MqlOiQ_Process.StartInfo.Arguments)
                LogF_AddLine(LogF_Protocol_DPNE, iText)

                Call MyScriptOutput_frm.InfoSysProtocol.StatusBarProgressBarStart("MqL", iText)
                MqlOiQ_Process.Start()
                While Not MqlOiQ_Process.HasExited
                    system.windows.Forms.Application.DoEvents()
                    system.Threading.Thread.Sleep(200)
                End While
                MqlOiQ_Process.Close()
                iText = String.Format("MQL:{0} / Ende Time:[{1}]", infoTextIn, now())
                LogF_AddLine(LogF_Protocol_DPNE, iText)

            Catch ex As Exception
                MyReturn.Ex = ex
            End Try


            Return MyReturn

        End Function


        '-----------------------------------------------------------------------------------------------------------------
        ''' <summary>
        ''' erstellt einen LogFile Namen (New 18.2.2011)
        ''' </summary>
        ''' <returns></returns>
        Private Function LogFileGet_DPNE(ByRef LogFile_EnumIn As LogFile_Enums) As String
            Dim LogFile_DP As String
            Dim LogFile_NE As String
            Dim LogFile_DPNE As String
            LogFile_DP = Archiv_DP_GET(Me.JS_ScriptingInterface.ServerSettings.Dir_DataRoot_DP_30DataBase_22ItemInfoLists)
            LogFile_NE = JF.Tools.JF_ToolsFile.ParsePath_NExtendAtEnd("RfSelectPartPatch", String.Format("_{0}_{1}.txt", CInt(LogFile_EnumIn).ToString, LogFile_EnumIn.ToString))
            LogFile_NE = JF.Tools.JF_ToolsFile.ParsePath_NExtendWithDateAndTime(LogFile_NE, now(), JF.Tools.JF_ToolsFile.DateTimeFormat_enum.Format_YYMMDDHM)
            LogFile_DPNE = path.Combine(LogFile_DP, LogFile_NE)
            Return LogFile_DPNE
        End Function

        ''' <summary>
        ''' definiert die Verschiedenen LogFile Typen
        ''' </summary>
        Enum LogFile_Enums
            Protocol = 1
            RefileSelectPartPatch = 7
        End Enum

        ''' <summary>
        ''' fuegt dem LogFile eine Zeile hinzu
        ''' </summary>
        Private Sub LogF_AddLine(ByRef LogFile_DPNE As String, _
                                 ByRef FileLine As String, _
                                Optional HeaderAdd As Boolean = False, _
                                Optional ProtoColAdd As Boolean = False, _
                                Optional ResMsgForResultColAdd As Boolean = False)

            Try
                Call System.IO.File.AppendAllText(LogFile_DPNE, FileLine + vbCrLf, System.Text.Encoding.GetEncoding(1252))
                If LogFile_DPNE = LogF_Protocol_DPNE Then
                    ProtoColAdd = True
                End If
                If HeaderAdd Then
                    Me.MyScriptOutput_frm.InfoSysHeader.Print(FileLine)
                End If
                If ProtoColAdd Then
                    Me.MyScriptOutput_frm.InfoSysProtocol.Print(FileLine)
                End If

                If ResMsgForResultColAdd Then
                    Me.Headline_Return.ResultMsgAdd(FileLine)
                End If


            Catch ex As Exception
                'ImportRun_DebugPrint(ex.Message)
                Me.MyScriptOutput_frm.InfoSysProtocol.Print(String.Format("Exception happend on writing to LogFile:[{0}]" + vbCrLf + "{1}", LogFile_DPNE, FileLine, ex.Message))
            End Try
        End Sub


        '---------------------------------------------------------------------------------------------------------------------
        ''' <summary>
        ''' Gibt den
        ''' </summary>
        ''' <param name="File_DPNE"></param>
        ''' <returns></returns>
        Function FileItem_DPNE_MoveToArchiv(ByVal File_DPNE As String) As String
            Dim Archiv_DP As String
            Dim Archiv_DPNE As String
            'Archiv_DP = JF.Tools.JF_ToolsFile.ParsePath_DP(File_DPNE)
            Archiv_DPNE = JF.Tools.JF_ToolsFile.ParsePath_PInsertTP(File_DPNE, JF.Tools.JF_ToolsFile.ParsePath_NExtendWithDateAndTime("Archiv", now(), JF.Tools.JF_ToolsFile.DateTimeFormat_enum.Format_YYMMDD))
            Archiv_DPNE = JF.Tools.JF_ToolsFile.ParsePath_NExtendWithDateAndTime(Archiv_DPNE, now(), JF.Tools.JF_ToolsFile.DateTimeFormat_enum.Format_YYMMDDHM)
            Archiv_DP = JF.Tools.JF_ToolsFile.ParsePath_DP(Archiv_DPNE)
            Call Me.MyScriptOutput_frm.InfoSysProtocol.Print("Archiv_DP:[" + Archiv_DP + "]")
            Call Me.MyScriptOutput_frm.InfoSysProtocol.Print("Archiv_DPNE:[" + Archiv_DPNE + "]")
            If JF.Tools.JF_ToolsFile.DirCreate(Archiv_DP).ReturnBol Then
                My.Computer.FileSystem.MoveFile(File_DPNE, Archiv_DPNE, True)
                Me.MyScriptOutput_frm.InfoSysProtocol.Print_and_StatusBarSetCurrActionStatusInfo_Panel3( _
                    "Aktion: schiebe InputFile:" + vbcrlf + _
                    "von   :" + File_DPNE & vbcrlf + _
                    "nach  :" + Archiv_DPNE)
            End If
            Return Archiv_DPNE
        End Function

        ''' <summary>
        ''' stellt Archiv Verzeichniss bereit
        ''' </summary>
        ''' <param name="Root_DP"></param>
        ''' <returns></returns>
        Function Archiv_DP_GET(ByVal Root_DP As String) As String
            Dim Archiv_DP As String
            Archiv_DP = path.Combine(Root_DP, JF.Tools.JF_ToolsFile.ParsePath_NExtendWithDateAndTime("Archiv", now(), JF.Tools.JF_ToolsFile.DateTimeFormat_enum.Format_YYMMDD))
            Call JF.Tools.JF_ToolsFile.DirCreate(Archiv_DP)
            Return Archiv_DP
        End Function

	End Class
End Namespace