SELECT
 Objects_tbl.*,
 Ir.ObjectPuid AS IrPuid,
 Ir.ObjectName AS IrName
FROM
  dbo.Objects_tbl WITH (nolock)
 LEFT OUTER JOIN dbo.Objects_Ir_Rel_tbl WITH (nolock) ON (dbo.Objects_tbl.Id = dbo.Objects_Ir_Rel_tbl.ObjectId)
 LEFT OUTER JOIN dbo.Objects_tbl Ir WITH (nolock) ON (dbo.Objects_Ir_Rel_tbl.IrId = Ir.Id)
WHERE Objects_tbl.Id in
 ( -- Select 2 = get ObjectId
  select Objects_Ir_Rel_tbl.ObjectId
   from Objects_Ir_Rel_tbl WITH (nolock)
   WHERE Objects_Ir_Rel_tbl.IrId in
  ( -- Select 1 = get IrId 
   SELECT TOP 2
    Objects_Ir_Rel_tbl.IrId
   FROM
    Objects_tbl WITH (nolock)
    INNER JOIN Objects_Ir_Rel_tbl WITH (nolock) ON (Objects_tbl.Id = Objects_Ir_Rel_tbl.ObjectId)
   WHERE
     Objects_tbl.ObjectClass='DS'
 AND Objects_tbl.ProcStateCol01 = 'TESTState'
 AND Objects_tbl.ObjectFromSiteID = 'tceng'
 AND Objects_tbl.ObjectOwningSiteID='tceng'
 AND Objects_tbl.ObjectType = 'IDEASPART'
    ORDER BY Objects_tbl.ObjectUgMaster_APLevels ASC, 
 Objects_tbl.ObjectUgMaster_CompCount ASC, Objects_tbl.ObjectLastModDate DESC
    ) 
 )
 ORDER BY Objects_tbl.ObjectUgMaster_APLevels ASC, 
 Objects_tbl.ObjectUgMaster_CompCount ASC, Objects_tbl.ObjectLastModDate DESC