@Echo off

 rem ---------------------------------------------------------
 rem (c) J.Feuerstein 24.11.2006
 rem
 rem Aenderungs Info:
 rem User    Date/Time (Shift+strg+T)  Infotext:
 rem J.Fes   06.02.2013                Ersterstellung
 rem ---------------------------------------------------------
 rem Variablen ersetzungs Abschnitt
 rem Info die mit "#" Gitter eingeschlossenen Vaiablen werden vom JobServer
 rem vor dem senden an den JobClient ersetzt

 rem #Doc: Stand 15.02.2013 J.Fes
 rem #Doc: Die Steuerung des Ablaufes in diesem Script wird gesteuert von
 rem #Doc: den Einstellungen im JobServer  siehe hierzu settings
 rem #Doc:  Tab:['Scripts/Parma'] Def:['TcSc_*'] Spalte:['JC.Script(cmd).ParmExt']
 rem #Doc: Verwendet werden hierfuer die Variablen:
 rem #Doc:     'Action' 'TcSiteSource' 'TcSiteTarget'
 rem #Doc:
 rem #Doc: weitere Details siehe
 rem #Doc: ..\Dokumentation.Custom\TcSiteKon_DokumentationKonzept_JFES.pptx"

REM  cls
 call :ColorSet IsIdel
 rem reset Basis var
 set toRun=
 set JobMgr_Debug=OFF
 set JobMgr_Test=OFF

 set CmdCur_DPNE=%~0
 set JobMgr_JumbTo=%~3
 if "%JobMgr_JumbTo%" neq "" goto %JobMgr_JumbTo%

 rem get JobComputer Passworts
 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 rem def. das keine Text Listen dem Job hinzugefuegt werden sollen
 set JobAddFile_ObjectsList_txt=false
 set JobAddFile_ObjectsListAllDetails_txt=false

 call Echo "**************************************************************************"
 call Echo "* Excuting TcSiteCons Script in PLMJobManager Environ                    *"
 call Echo "* Version: J.Feuerstein 01.03.2013 (c)                                   *"
 call Echo "**************************************************************************"

 rem -- values of JobScriptParametersExtended:
 #JobScriptParametersExtended#

 rem Standard Path Variablen
 set MyApplName_TP=#MyApplName_TP#

 rem -- JobServer Variablen ----------------------------------------------------
 set JobManagerRoot_DP=#00-ApplRoot_DP#
 set JobScripts_DP=#10-JobScripts_DP#
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#
 set DataRoot_DP=#90-Data_DP#


 rem JobParameter
 set JobName=#JobName#
 set JobParameter=#JobParameter#

 rem TC Daten
 set TcSiteId=#TcSiteId#
 set curCmd_Title=#JobName#

 set title_strBase=TcSC:[%JobName%][%Action%]
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   Banner Debug:ON
   set title_strBase=%title_strBase%[Debug:%JobMgr_Debug%]
:JumbOverDebug

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOverTest
   Banner Test:ON
   set title_strBase=%title_strBase%[Test:%JobMgr_Test%]
:JumbOverTest

rem 24-07-2015 18:24 Define Site Mapping PLMEU-PLMCN
set TcSiteTarget=!!unkown!!
if /I "%TcSiteId%" equ "PLMEU" set TcSiteTarget=PLMCN_Productive
if /I "%TcSiteId%" equ "PLMCN" set TcSiteTarget=PLMEU_Productive



 set title_str=%title_strBase%[%Date% %time:~0,5%][\\%ComputerName%]
 title %title_str%

 rem ---------------------------------------------------------
 rem Rootpfade setzen
 set CmdCurRoot_DPNE=%0
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 rem -- #Step: JobMgr CmdTools local kopieren ----------------------------------
 rem #Doc: Steuert aus welchem Bereich die Tools genommen werden J.Fes 14.02.2013
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer

 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"

 call Echo "Update BinL......: [%BinL_DP%]"
 call Echo "Update From......: [%JobManagerCmdTools_DP%, %FlipTheSwitch_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:1
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL /R:2 /W:2 "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.exe">nul 2>nul
 rem ?? J.Fes "%BinPublic_ClientServer_DP%\JobManagerCmdTools_Resources eingearbeitet
 REM  robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL /R:2 /W:2 /MIR "%JobManagerCmdTools_DP%\JobManagerCmdTools_Resources" "%BinL_DP%\JobManagerCmdTools_Resources" "*.*">nul 2>nul
 dir %JobManagerCmdTools_L%>>%~dp0zzTracActionInfo_log.txt

 rem -- #Step: Prepare PMon
 set PMon_exe_DP=%BinPublic_DP%
 set PMon_exe_DPNE=%PMon_exe_DP%\JFProcessMonitor.exe
	set PMon_exeL_DPNE=%BinL_DP%\JFProcessMonitor.exe
	robocopy /NP /NJS /NJH /NDL /NFL /R:2 /W:2 "%PMon_exe_DP%" "%BinL_DP%" "JFProcessMonitor.exe"


 rem -- #Step: copy flip the switch exe to local
REM  set FlipTheSwitch_N=bsh_change_owning_site
REM  set FlipTheSwitch_NE=%FlipTheSwitch_N%.exe
REM  set FlipTheSwitch_DP=#JobScriptTemplateMinus1_DP#\TcSiteCons\Bin
REM  set FlipTheSwitch_DP=\\#PLMServer#\ugsshare\\JobManagerV2\90-DATA\#Custom#_SettingsGlobal\10-JobScripts\TcSiteCons\Bin
REM  set FlipTheSwitch_DPNE=%FlipTheSwitch_DP%\%FlipTheSwitch_NE%
REM  set FlipTheSwitch_L=%BinL_DP%\%FlipTheSwitch_NE%
REM  robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL /R:2 /W:2 "%FlipTheSwitch_DP%" "%BinL_DP%" >nul 2>nul


 rem -- Path Variable erweitern
 set path=%CmdCurRoot_DP%;%BinL_DP%;%BinPublic_Custom_DP%;%BinPublic_ClientServer_DP%;%BinPublic_DP%;%Path%

 rem -- Start WatchDog #New 10.06.2013 J.Fes
 call "ProgStart_If_NotRuning.cmd" "PLMJobManagerWatchDog" "%BinPublic_DP%\PLMJobManagerWatchDog.exe"

 rem ---------------------------------------------------------
 rem temp dir Organiesieren
 set temp_DP_org=%temp%
 set temp=%CmdCurRoot_DP%\%Action%_tmp
 set tmp=%temp%
 if not exist "%temp%" md "%temp%"
 rem -- erf. Verzeichniss 'tc_multi' erzeugen
REM  if not exist "C:\temp\tc_multi" md "C:\temp\tc_multi"
REM  if not exist "%temp%\tc_multi" md "%temp%\tc_multi"
 rem #New 21.08.2014/J.Fes
 set TC_transfer_area=%temp%
 cd /d "%temp%"

REM  if "%JobMgr_DEBUG%" equ "ON" start "" Explorer "%temp%"

 set ErrLog_DPNE=%temp%\_TcSiteConsErrLog.txt

 set OracleClient_DP=%BinPublic_DP%\OraClient
 set HashCodeGen=OFF

:StartJobProcessing

 Call :SetGlobalSettings

 if "%Action%" equ "DataShare"  set title_strBase=%title_strBase%[from:%TcSiteSource% to:%TcSiteTarget%][TcU:%JobMgr_TcUser%]
 if "%Action%" equ "DataSync"   set title_strBase=%title_strBase%[from:%TcSiteSource% to:%TcSiteTarget%][TcU:%JobMgr_TcUser%]
 set title_txt=%title_strBase%[Start:%Date%/%time:~0,8%][\\%ComputerName%]

 title %title_txt%
 call Echo "%title_txt%"
 call Echo "--------------------------------------------------------------------------"
 call Echo "JobInfo:"
 call Echo "JobName..........: %JobName%"
 call Echo "Computer.........: %ComputerName%"
 call Echo "TempDir..........: %temp%"
 call Echo "Start............: %Date%/%time:~0,8%"
 call Echo "JobMgr_Debug.....: %JobMgr_Debug%"
 call Echo "JobMgr_Test......: %JobMgr_Test%"
 call Echo "."
 call Echo "Action...........: %Action%"
 call Echo "TcSiteSource.....: %TcSiteID%"
 call Echo "TcSiteTarget.....: %TcSiteTarget%"
 call Echo "TcUser...........: %JobMgr_TcUser%"
 call Echo "--------------------------------------------------------------------------"

 if /i "%JobMgr_Debug%" equ "ON" pause

 if /I "%Action%" equ "DataShare"         call :DataShare& goto :end
 if /I "%Action%" equ "DSEvalExtractPre"  call :DSEvalExtractPre& goto :end
 if /I "%Action%" equ "DSEvalExtractPost" call :DSEvalExtractPost& goto :end
 if /I "%Action%" equ "DSEvalCompair"     call :DSEvalCompair& goto :end
 if /I "%Action%" equ "DataSync"          call :DataSync& goto :end
 if /I "%Action%" equ "FlipTheSwitch"     call :FlipTheSwitch& goto :end
 if /I "%Action%" equ "DataSetShare"      call :DataSetShare& goto :end
 rem wenn nichts passt dann:
 Call :ErrActionWrong

 goto :end

rem ===== DataShare ============================================================
:DataShare

 call Echo "+++## Start:DataShare: ##########################################+++"

 call Echo " -- Step:DataShare: Extract List of Items---------------------------"
 Call :ItemListGen

 call Echo " -- Step:DataShare: Get TcPrompt -----------------------------------"
 Call :TcPromptGet :DataShare_Next

:DataShare_Next
 rem -- #Step: set TC Job Environs
 call :TcSetJobEnviron


 call Echo " -- Step:DataShare: Run DataShare ----------------------------------"
 if /I  "%TCSiteTarget%" equ "!!unkown!!" (
   call :ColorSet ERR
   call Echo "------------------------------------------------------------------------"
   call Echo "ERR: TCSiteTarget: %TCSiteTarget%"
   call Echo "please check settings in TCSiteCons"
   call Echo "No DataShare Action will be Done!"
   pause
   goto :DataShare_Jumbover
 )
 call :DataShare_Run

:DataShare_Jumbover
 call Echo " -- Step:DataShare: Eval Results Datashare of Processed Items ------"
 Call :TcDataShare_EvalResult

 call Echo "+++## END:DataShare: ############################################+++"
goto :eof


rem ===== DSEvalExtractPre =====================================================
:DSEvalExtractPre

 call :ColorSet IsExecuting4

 set toRun="%JobManagerCmdTools_L%"
 set toRun=%toRun% -Action TcExtractData_2013_10
 set toRun=%toRun% -Subaction I_IR_BOM_DS_extract
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobMgrDataOrg_Root_DP "%JobMgrDataOrg_Root_DP%"
 set toRun=%toRun% -extract_PrePost pre
 set toRun=%toRun% -OraClient_DP "%OracleClient_DP%"
 set toRun=%toRun% -TcSQL_DP #TcSQL_DP#
 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -JobData2ResultsDoPrint
 set toRun=%toRun% -JobParaDoPrint
 if /i "%HashCodeGen%" neq "OFF" goto :JumbOverHashCodeGen
   set toRun=%toRun% -HashCodeGenOFF
:JumbOverHashCodeGen

 set toRunForPrint=%toRun:"=%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver1
  set toRun=%toRun% -verbose -pauseOnEnd
  Echo --------------------------------------------------------------------------
  Echo Bevor DSEvalExtractPre
  call Echo "toRun:%toRunForPrint%"
  pause
  Echo --------------------------------------------------------------------------
:JumbOver1


 call Echo "   ##### START DATASHARE EVALUATE EXTRAKT PRE #####" "" "NOECHO"
 call Echo "   - toRun:%toRunForPrint%" "" "NOECHO"
 call %toRun%
 call Echo "   ##### END DATASHARE EVALUATE EXTRAKT PRE #####" "" "NOECHO"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver2
  Echo --------------------------------------------------------------------------
  echo After DSEvalExtractPre
  Echo --------------------------------------------------------------------------
  pause
:JumbOver2

 call :ColorSet IsIdel

goto :eof


rem ===== DSEvalExtractPost ====================================================
:DSEvalExtractPost

 call :ColorSet IsExecuting4

 set toRun="%JobManagerCmdTools_L%"
 set toRun=%toRun% -Action TcExtractData_2013_10
 set toRun=%toRun% -Subaction I_IR_BOM_DS_extract
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobMgrDataOrg_Root_DP "%JobMgrDataOrg_Root_DP%"
 set toRun=%toRun% -extract_PrePost post
  set toRun=%toRun% -OraClient_DP "%OracleClient_DP%"
 set toRun=%toRun% -TcSQL_DP "#02-BinClient_Custom_DP#\_CustomTcSQL\%TcSiteTarget%"
 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -JobData2ResultsDoPrint
 set toRun=%toRun% -JobParaDoPrint
 set toRun=%toRun% -I_IR_BOM_DS_extract_FromSiteID %TcSiteTarget%
 if /i "%HashCodeGen%" neq "OFF" goto :JumbOverHashCodeGen
   set toRun=%toRun% -HashCodeGenOFF
:JumbOverHashCodeGen

 set toRunForPrint=%toRun:"=%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver1
  set toRun=%toRun% -verbose -pauseOnEnd
  Echo --------------------------------------------------------------------------
  Echo Bevor DSEvalExtractPost
  call Echo "toRun:%toRunForPrint%"
  pause
  Echo --------------------------------------------------------------------------
:JumbOver1


 call Echo "   ##### START DATASHARE EVALUATE EXTRAKT POST #####" "" "NOECHO"
 call Echo "   - toRun:%toRunForPrint%" "" "NOECHO"
 call %toRun%
 call Echo "   ##### END DATASHARE EVALUATE EXTRAKT POST #####" "" "NOECHO"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver2
  Echo --------------------------------------------------------------------------
  echo After DSEvalExtractPost
  Echo --------------------------------------------------------------------------
  pause
:JumbOver2

 call :ColorSet IsIdel

goto :eof


rem ===== DSEvalCompair ========================================================
:DSEvalCompair

 call :ColorSet IsExecuting4

 set toRun="%JobManagerCmdTools_L%"
 set toRun=%toRun% -Action TcMultiSite_2012_02
 set toRun=%toRun% -Subaction I_IR_BOM_DS_eval
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobMgrDataOrg_Root_DP "%JobMgrDataOrg_Root_DP%"
 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -JobData2ResultsDoPrint
 set toRun=%toRun% -JobParaDoPrint

 set toRunForPrint=%toRun:"=%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver1
  set toRun=%toRun% -verbose -pauseOnEnd
  Echo --------------------------------------------------------------------------
  Echo Bevor DSEvalCompair
  call Echo "toRun:%toRunForPrint%"
  pause
  Echo --------------------------------------------------------------------------
:JumbOver1


 call Echo "   ##### START DATASHARE EVALUATE COMPAIR #####" "" "NOECHO"
 call Echo "   - toRun:%toRunForPrint%" "" "NOECHO"
 call %toRun%
 call Echo "   ##### END DATASHARE EVALUATE COMPAIR #####" "" "NOECHO"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver2
  Echo --------------------------------------------------------------------------
  echo After DSEvalCompair
  Echo --------------------------------------------------------------------------
  pause
:JumbOver2

 call :ColorSet IsIdel

goto :eof


rem ===== DataSetShare ============================================================
:DataSetShare

 call Echo "+++## Start:DataSetShare: ##########################################+++"

 call Echo " -- Step:DataSetShare: Extract List of UIDs---------------------------"
 Call :ItemListGenUID

 call Echo " -- Step:DataSetShare: Get TcPrompt -----------------------------------"
 Call :TcPromptGet :DataSetShare_Next

:DataSetShare_Next
 rem -- #Step: set TC Job Environs
 call :TcSetJobEnviron

 call Echo " -- Step:DataSetShare: Run DataSetShare ----------------------------------"
 call :DataSetShare_Run

 call Echo " -- Step:DataSetShare: Eval Results DataSetShare of Processed Items ------"
 Call :TcDataShare_EvalResult

 call Echo "+++## END:DataShare: ############################################+++"
goto :eof

rem ===== DataShare =============================================================
:DataShare_Run
 rem #Doc:

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug2
   set TC_JOURNAL=FULL
   set TC_SQL_DEBUG=BPT
   set TC_TRACEBACK=1
:JumbOverDebug2

 call :ColorSet IsExecuting3

 set toRun=data_share.exe
 set toRun=%toRun% -site="%TcSiteTarget%"
 set toRun=%toRun% -f=send
 set toRun=%toRun% -filename="%ItemList_DPNE%"
 set toRun=%toRun% -report="%report_DPNE%"
 set toRun=%toRun% -log
 set toRun=%toRun% -g=%JobMgr_TcGroup%
 set toRun=%toRun% -u=%JobMgr_TcUser%
 REM Includes and excluded are defined in TC site preferences
 REM TC_relation_required_on_export and TC_relation_export
 REM set toRun=%toRun% -include=IMAN_UG_altrep
 REM set toRun=%toRun% -include=IMAN_reference
 REM set toRun=%toRun% -include=Custom_BomInfo
 REM set toRun=%toRun% -include=Custom_KostenForm
 REM set toRun=%toRun% -include=IMAN_manifestation
 REM set toRun=%toRun% -include=IMAN_Simulation
 REM set toRun=%toRun% -exclude=IMAN_UG_wave_geometry
 REM set toRun=%toRun% -exclude=IMAN_UG_wave_part_link
 REM set toRun=%toRun% -exclude=IMAN_UG_part_family_link
 REM set toRun=%toRun% -exclude=IMAN_UG_expression
 REM set toRun=%toRun% -exclude=IMAN_UG_wave_part_position
 REM  DATA_SHARE: ***ERROR: No relation type of name "IMAN_UG_wave_part_position" exists
 if /i "%TransferOwnerShip%" neq "ON" goto :JumbOverTransferOwnerShip
   set toRun=%toRun% -transfer
 :JumbOverTransferOwnerShip

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set >>%temp%\zzDebugEnvironInfo.txt
   Echo #Debug:%~0
   Echo BEVOR..: run:Data_Share
   Echo %toRun% -P=***********
   pause
 :JumbOverDebug

 call :ColorSet IsExecuting

 set title_str=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %title_str%

 Echo.                                                                               .
 call :ColorSet IsExecuting
 call Echo "%titleRf_str%"
 call Echo "----------------------------------------------------------------------------"
 Call Echo "Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.................: %JobName%"
 Call Echo "Computer................: %ComputerName%"
 Call Echo "JobDir..................: %temp:~-50%"
 Call Echo "TcSideSource............: %TcSiteId%"
 Call Echo "TcSiteTarget............: %TcSiteTarget%"
 Call Echo "TcUser..................: %JobMgr_TcUser%"
 Call Echo "FMS_HOME................: %FMS_HOME%"
 Call Echo "TC_ROOT.................: %TC_ROOT%"
 Call Echo "TC_DATA.................: %TC_DATA%"
REM  Call Echo "Special Options.........:"
 Echo.

 call :Echo_toRun "NOECHO" "-p=*****"

 rem -- erf. Verzeichniss 'tc_multi' erzeugen
 if not exist "C:\temp\tc_multi" md "C:\temp\tc_multi"
 call Echo "   ##### START DATASHARE #####" "" "NOECHO"

 call %toRun% -p=%JobMgr_TcPw% >>"%CmdOutPut_DPNE%"
 call Echo "   ##### END DATASHARE #####" "" "NOECHO"


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug2
  Echo --------------------------------------------------------------------------
  Echo AFTER..: run data_share
  echo report_DPNE:["%report_DPNE%"]
  type "%report_DPNE%"
  Echo --------------------------------------------------------------------------
  pause
:JumbOverDebug2

goto :eof

rem ===== DataSetShare =============================================================
:DataSetShare_Run
 rem #Doc:

 call :ColorSet IsExecuting3

 set toRun=data_share.exe
 set toRun=%toRun% -site="%TcSiteTarget%"
 set toRun=%toRun% -f=send
 set toRun=%toRun% -filename="%ItemList_DPNE%"
 set toRun=%toRun% -report="%report_DPNE%"
 set toRun=%toRun% -log
 set toRun=%toRun% -g=%JobMgr_TcGroup%
 set toRun=%toRun% -u=%JobMgr_TcUser%
 set toRun=%toRun% -attach
 set toRun=%toRun% -classoffile=Tagstring
rem set toRun=%toRun% -include=IMAN_UG_altrep
rem set toRun=%toRun% -include=IMAN_reference
rem set toRun=%toRun% -include=KBA_BomInfo
rem set toRun=%toRun% -include=KBAKostenForm
 if /i "%TransferOwnerShip%" neq "ON" goto :JumbOverTransferOwnerShip
   set toRun=%toRun% -transfer
 :JumbOverTransferOwnerShip

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set >>%temp%\zzDebugEnvironInfo.txt
   Echo #Debug:%~0
   Echo BEVOR..: run:Data_Share
   Echo %toRun% -P=***********
   pause
 :JumbOverDebug


 call :Echo_toRun "NOECHO" "-p=*****"

 call Echo "   ##### START DATASHARE #####" "" "NOECHO"
 call %toRun% -p=%JobMgr_TcPw% >>"%CmdOutPut_DPNE%"
 call Echo "   ##### END DATASHARE #####" "" "NOECHO"


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug2
  Echo --------------------------------------------------------------------------
  Echo AFTER..: run data_share
  echo report_DPNE:["%report_DPNE%"]
  type "%report_DPNE%"
  Echo --------------------------------------------------------------------------
  pause
:JumbOverDebug2

goto :eof

rem ===== DataSync =============================================================
:DataSync

 call Echo "+++## Start:DataSync: ###########################################+++"
 call :ColorSet IsExecuting3

 call Echo " -- Step:DataSync: Extract List of Ir's ----------------------------"
 Call :ItemListGen

 call Echo " -- Step:DataSync: Get TcPrompt ------------------------------------"
 Call :TcPromptGet :DataSync_Next

:DataSync_Next
 rem -- #Step: set TC Job Environs
 call :TcSetJobEnviron

 set toRun=data_sync.exe -site=CustomSite
 set toRun=%toRun% -u=idsm -p=#idsmpw# -g=dba
 set toRun=%toRun% -filename="%ItemList_DPNE%"
 set toRun=%toRun% -report="%report_DPNE%"
 set toRun=%toRun% -sync
 set toRun=%toRun% -force
 set toRun=%toRun% -update
 set toRun=%toRun% -dmo
 set toRun=%toRun% -all_revisions
 set toRun=%toRun% -verbose
 set toRun=%toRun% -log
 set toRun=%toRun% -exclude=IMAN_reference
 set toRun=%toRun% -exclude=IMAN_UG_part_family_link
 set toRun=%toRun% -efc

 rem 24.02.2012 17:53 -all_revisions ergntzt
 rem 24.02.2012 21:04 Test  2: -exclude=IMAN_reference sieht schon besser aus
 rem 24.02.2012 22:53 Test 3:  -exclude=IMAN_UG_part_family_link
 rem 24.02.2012 22:53 Test 3:  -efc exclude folder contents


 if "%JobMgr_DEBUG%" equ "xON" (
  Echo --------------------------------------------------------------------------
  Echo %toRun%
  Echo --------------------------------------------------------------------------
  pause
 )
 set>"%temp%\zz_info_DataSync_tc8w_tc8r_Environ.txt"
 echo %toRun%>"%temp%\zz_info_DataSync_tc8w_tc8r_Command.txt"
 rem -- Start data_sync
 Echo %title_txt%
 Echo Info: DataSync Output see:["%CmdOutPut_DPNE%"]
REM  %toRun%>>"%CmdOutPut_DPNE%"

 if "%JobMgr_DEBUG%" equ "xON" (
  pause
 )

 call Echo "+++## END:DataSync: #############################################+++"

goto :eof


rem ===== FlipTheSwitch ============================================================
:FlipTheSwitch

 call Echo "+++## Start:FlipTheSwitch: ##########################################+++"

 call Echo " -- Step:FlipTheSwitch: Extract List of Items---------------------------"
 call :ItemListGen

 call Echo " -- Step:FlipTheSwitch: Get TcPrompt -----------------------------------"
 Call :TcPromptGet :FlipTheSwitch_Next

:FlipTheSwitch_Next
 rem -- #Step: set TC Job Environs
 call :TcSetJobEnviron

 call Echo " -- Step:FlipTheSwitch: Run FlipTheSwitch ----------------------------------"
 call :FlipTheSwitch_Run

 call Echo " -- Step:FlipTheSwitch: Eval Results FlipTheSwitch of Processed Items ------"
 Call :TcFlipTheSwitch_EvalResult

 call Echo "+++## END:FlipTheSwitch: ############################################+++"

goto :eof

rem ===== FlipTheSwitch =============================================================
:FlipTheSwitch_Run

 call :ColorSet IsExecuting3

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug2
 set TC_JOURNAL=FULL
 set TC_SQL_DEBUG=BPT
 set TC_TRACEBACK=1
:JumbOverDebug2

 	rem Monitors NxCB_program_exe_NE
  rem  - wartet fuer 5 sec ob ein neuer process startet
 	rem  - mit max 2 Std = 2*60*60=7200 [sec] Laufzeit
 	rem  - mit max 5 min ohne das neue files im temp entstehen oder editiert werden
 	set toMon=%PMon_exeL_DPNE%
  set toMon=%toMon% -w 5000 -p 0
  set toMon=%toMon% --n %FlipTheSwitch_N%
 	set toMon=%toMon% --runtimeLimitSeconds 7200
 	set toMon=%toMon% --killChildProcesses
 	set toMon=%toMon% --fileLastWriteTime "%temp%\*.*;300"
 	set toMon=%toMon% --saveResultsTo %temp%\zzFlipTheSwitch_PMon_log.xml

  set toRun=%FlipTheSwitch_L%
  set toRun=%toRun% -input="%ItemList_DPNE%"
  set toRun=%toRun% -output="%report_DPNE%"
  set toRun=%toRun% -g=%JobMgr_TcGroup%
  set toRun=%toRun% -u=%JobMgr_TcUser%
  set toRun=%toRun% -nodryrun

  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
    set >>%temp%\zzDebugEnvironInfo.txt
    Echo #Debug:%~0
    Echo BEVOR..: run:FlipTheSwitch
    Echo %toRun% -P=***********
    pause
  :JumbOverDebug

 rem -- #Step: Start ProcessMonitor for next comming FlipTheSwitch Process
 start /MIN "JFProcessMonitor" %toMon%

 set toRunForPrint=%toRun:"=%
 call Echo "   - toRun:%toRunForPrint% -p=*****" "" "NOECHO"

 call %toRun% -p=%JobMgr_TcPw% >>"%CmdOutPut_DPNE%"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug2
  Echo --------------------------------------------------------------------------
  Echo AFTER..: run FlipTheSwitch
  echo report_DPNE:["%report_DPNE%"]
  type "%report_DPNE%"
  Echo --------------------------------------------------------------------------
  pause
:JumbOverDebug2

goto :eof


rem ===== ItemList Gen ========================================================
:ItemListGen

 call :ColorSet IsExecuting2
 Echo.
 set toRun="%JobManagerCmdTools_L%"
 set toRun=%toRun% -Action TcMultiSite_2012_02
 set toRun=%toRun% -SubAction DataSync
 set toRun=%toRun% -InputList_DPNE "%ItemList_DPNE%"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug1
  set toRun=%toRun% -verbose -pauseOnEnd
  Echo --------------------------------------------------------------------------
  Echo JobManagerCmdTools.exe
  call Echo "toRun:%toRunForPrint%"
  pause
  Echo --------------------------------------------------------------------------
:JumbOverDebug1

 set toRunForPrint=%toRun:"=%
 call Echo "   - toRun:%toRunForPrint%" "" "NOECHO"
 call %toRun%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug2
  Echo --------------------------------------------------------------------------
  echo ItemList_DPNE:["%ItemList_DPNE%"]
  type "%ItemList_DPNE%"
  Echo --------------------------------------------------------------------------
  pause
:JumbOverDebug2

goto :eof

rem ===== ItemList Gen UID ========================================================
:ItemListGenUID

 call :ColorSet IsExecuting2
 Echo.
 set toRun="%JobManagerCmdTools_L%"
 set toRun=%toRun% -Action JobDataExtract_2013_10
 set toRun=%toRun% -Subaction InputListExtract
 set toRun=%toRun% -inputList_DPNE "%ItemList_DPNE%"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -format "#ObjectPuid#"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug1
  set toRun=%toRun% -verbose -pauseOnEnd
  Echo --------------------------------------------------------------------------
  Echo JobManagerCmdTools.exe
  call Echo "toRun:%toRunForPrint%"
  pause
  Echo --------------------------------------------------------------------------
:JumbOverDebug1

 set toRunForPrint=%toRun:"=%
 call Echo "   - toRun:%toRunForPrint%" "" "NOECHO"
 call %toRun%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug2
  Echo --------------------------------------------------------------------------
  echo ItemList_DPNE:["%ItemList_DPNE%"]
  type "%ItemList_DPNE%"
  Echo --------------------------------------------------------------------------
  pause
:JumbOverDebug2

goto :eof

rem ===== Auswerten DataShare Ergebniss ========================================
:TcDataShare_EvalResult
  rem 20.08.2014 12:48
 set ImportUpdateListDir_DP=#DataRoot_CustomWorkInst_DP#\20-DataBase\22-ItemInfoLists

 call :ColorSet IsExecuting4
 set toRun="%JobManagerCmdTools_L%"
 set toRun=%toRun% -Action TcMultiSite_2012_02
 set toRun=%toRun% -Subaction DataShare
 set toRun=%toRun% -DataShare_Report_DPNE "%report_DPNE%"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobTemp_DP "%temp%"
 set toRun=%toRun% -ImportUpdateListDir_DP "%ImportUpdateListDir_DP%"
 set toRun=%toRun% -TcSiteId "%TcSiteId%"
if /i "%Action%" neq "DataShare" goto :JumbOver1
 set toRun=%toRun% -ImportLogsDir_DP "%ImportLogsDir_DP%"
:JumbOver1


if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 set toRun=%toRun% -verbose -pauseOnEnd
 set toRunForPrint=%toRun:"=%
 Echo --------------------------------------------------------------------------
 Echo #Debug...: %~0
 Echo "toRun...: %toRunForPrint%"
 Echo --------------------------------------------------------------------------
 pause
:JumbOverDebug


 set toRunForPrint=%toRun:"=%
 call Echo "   ##### START EVALUATE RESULT #####" "" "NOECHO"
 call Echo "   - toRun:%toRunForPrint%" "" "NOECHO"
 call %toRun%
 call Echo "   ##### END EVALUATE RESULT #####" "" "NOECHO"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver2
  Echo --------------------------------------------------------------------------
  echo report_DPNE:["%report_DPNE%"]
  type "%report_DPNE%"
  Echo --------------------------------------------------------------------------
  pause
:JumbOver2

 call :ColorSet IsIdel
goto :eof
rem ----------------------------------------------------------------------------

rem ===== Auswerten des FlipTheSwitch Ergebniss ========================================
:TcFlipTheSwitch_EvalResult

 set JobMgrDataOrg_Root_DP_Custom=#12-Data#\JobMgrData

 call :ColorSet IsExecuting4
 set toRun="%JobManagerCmdTools_L%"
 set toRun=%toRun% -Action TcMultiSite_2012_02
 set toRun=%toRun% -Subaction FlipTheSwitch
 set toRun=%toRun% -FlipTheSwitch_Report_DPNE "%report_DPNE%"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobMgrDataOrg_Root_DP "%JobMgrDataOrg_Root_DP_Custom%"
 rem set toRun=%toRun% -ImportUpdateListDir_DP "%ImportUpdateListDir_DP%"
 rem set toRun=%toRun% -TcSiteId "%TcSiteId%"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver1
  set toRun=%toRun% -verbose -pauseOnEnd
  Echo --------------------------------------------------------------------------
  Echo JobManagerCmdTools.exe
  call Echo "toRun:%toRunForPrint%"
  pause
  Echo --------------------------------------------------------------------------
:JumbOver1

 set toRunForPrint=%toRun:"=%
 call Echo "   - toRun:%toRunForPrint%" "" "NOECHO"
 call %toRun%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver2
  Echo --------------------------------------------------------------------------
  echo report_DPNE:["%report_DPNE%"]
  type "%report_DPNE%"
  Echo --------------------------------------------------------------------------
  pause
:JumbOver2

 call :ColorSet IsIdel
goto :eof
rem ----------------------------------------------------------------------------

rem ===== Global Environs ======================================================
:SetGlobalSettings

 rem setzt globale Environs fuer dieses Script
 set ItemList_DPNE=%temp%\1_%Action%_ItemList.txt

 rem -- define data_share Logfiles
 set CmdOutPut_DPNE=%temp%\2_%Action%_CmdOutPut_Log.txt
 set report_DPNE=%temp%\3_%Action%_Report.txt

 rem -- #Doc: erstmal leer machen damit weiter nur def. einstellungen genommen werden
 SET TC_DATA=
 SET TC_ROOT=
 set JobMgr_TcGroup=dba


 rem setzen der Einstellungen in abhaenigkeit von der TcSiteTarget
 if /i "%TcSiteId%" neq "VC_HAMBURG" goto :jumbOverVC_HAMBURG
   REM    call ConnectNetUnc.cmd "UgsShare RB" R: \\PLMServer\ugsshare . . Ugsshare_DiskConnectResult_RB
   REM    Echo Connect Laufwerk:%ConnectNetUnc_to_Info% Status:"%Ugsshare_DiskConnectResult_RB%"
   REM    if /I not "%Ugsshare_DiskConnectResult_RB%"=="OK" goto :Ugsshare_DiskConnectErr
   SET TC_DATA=\\whmtest002\ugsshare$\vchhdata\win32
   SET TC_ROOT=G:\appl\ugs\tc83
   set TcSiteSource=%TcSiteId%
   set TcSiteTarget=TBVC
   rem Path to IDSM Import.Log on IDSM Target Server
   set ImportLogsDir_DP=\\WHMTEST001\UG_TEMP$
:jumbOverVC_HAMBURG

goto :eof

rem ===== TcPrompt =============================================================
:TcPromptGet

 set JobMgr_JumbTo=%~1

 Echo --------------------------------------------------------------------------
 Echo Step: Executing TcPrompt to get "Tc-Environment"
 Echo JobMgr_JumbTo.: %JobMgr_JumbTo%
 set SIDT_DEBUG=0

 rem #Doc: set Standard Prompt
 set TcPromtCmd=%BinPublic_Custom_DP%\TCPromptGet.cmd
 set TcPromtCmdOpt="CAX" "%TcSiteID%" "NX85" "%CmdCur_DPNE%" "%JobMgr_JumbTo%"
 rem #Doc: set Prompt Opt for PLM Sites to PLM
 if /i "%TcSiteId%" equ "PLMEU"    set TcPromtCmdOpt="PLM"   "PLMEU"  "NX85" "%CmdCur_DPNE%" "%JobMgr_JumbTo%"
 if /i "%TcSiteId%" equ "PLMCN"    set TcPromtCmdOpt="PLM"   "PLMCN"  "NX85" "%CmdCur_DPNE%" "%JobMgr_JumbTo%"
 if /i "%TcSiteId%" equ "PLMCEU"   set TcPromtCmdOpt="PLM_C" "PLMCEU" "NX85" "%CmdCur_DPNE%" "%JobMgr_JumbTo%"
 call :ColorSet IsExecuting1
 if not exist "%TcPromtCmd%" goto :TcPromtCmdError

 call %TcPromtCmd% %TcPromtCmdOpt%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   rem Details
   Echo #Debug:%~0
   Echo  Before EXIT %JobMgr_JumbTo%
   set tc
   pause
 :JumbOverDebug
 exit

goto :eof

rem ============================================================================
:Ugsshare_DiskConnectErr
 set ErrLog_DPNE=%temp%\__Err_Ugsshare_DiskConnect.txt
 rem schreibt die erweiterten Infos an einen ErrLogFile
 Echo Err: erf. Netzwerkverb. fuer: %TcSiteId% [%ConnectNetUnc_to_Info%] konnte nicht richtig verbunden werden!!>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 type "%ErrLog_DPNE%"
 Echo !!Einstellungen oder Netzwerkverbindungen pruefen!!
 cmd
 Pause
 goto :eof

rem ===== Echo toRun new 29.07.2013/J.Fes  =====================================
:Echo_toRun
 REM  20.07.2013 12:41 auskommentiert da sonst der Fehler wegen es ^& Zeichens kommt
 call set toRunForPrint=%toRun:&=+%
 call set toRunForPrint=%toRunForPrint:"='%
 if "%~2" neq "" call set toRunForPrint=%toRunForPrint% %~2
 if "%~3" neq "" call set toRunForPrint=%toRunForPrint% %~3
 if "%~4" neq "" call set toRunForPrint=%toRunForPrint% %~4
 call Echo "   - toRun:%toRunForPrint%" "" "%~1"
goto :eof

rem =====TcSetJobEnviron =========================================================
:TcSetJobEnviron

set temp=%CmdCurRoot_DP%\%Action%_tmp

 rem -- TC-Variablen umbiegen -------------------------------------------
 set TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 set IMAN_TMP_DIR=%temp%
 set TC_KEEP_SYSTEM_LOG=TRUE
 set TC_Journalling=OFF
 set TC_Journaling=OFF
 set TC_TRACEBACK=OFF
call Echo
call Echo #Debug:-TC_TMP_DIR-:-[%TC_TMP_DIR%]
call Echo #Debug:-TC_KEEP_SYSTEM_LOG-:-[%TC_KEEP_SYSTEM_LOG%]
 rem 20.02.2013 18:08 umgebogen
 set TC_SHARED_MEMORY_DIR=%CmdCurRoot_DP%\..\TC_SHARED_MEMORY
 if not exist "%TC_SHARED_MEMORY_DIR%" md "%TC_SHARED_MEMORY_DIR%"
REM  Echo #Debug: TC_SHARED_MEMORY_DIR : [%TC_SHARED_MEMORY_DIR%]
REM  pause
goto :eof

rem ===== ErrTcSiteDefsWrong ===================================================
:ErrTcSiteTargetWrong
 set title_txt=%title_strBase% ERR:[TcTargetSite wrong:%TcSiteTarget%][%Date%/%time:~0,8%]
 title %title_txt%
 call Echo "--------------------------------------------------------------------------"
 rem call :ErrLogHeaderWrite
 call Echo "%title_txt%" "%ErrLog_DPNE%"
 call Echo "Recived wrong TcSiteTarget:[%TcSiteTarget%]" "%ErrLog_DPNE%"
 call Echo "." "%ErrLog_DPNE%"
 call Echo "Valid Sites are:" "%ErrLog_DPNE%"
 call Echo " - TBVC (defined since 20.08.2014)" "%ErrLog_DPNE%"
 call Echo "." "%ErrLog_DPNE%"
 call Echo "Please check settings in:" "%ErrLog_DPNE%"
 call Echo " - JobMgr Scripts" "%ErrLog_DPNE%"
 call Echo " - JobServer definition in 'Scripts/Param.' ScriptName: TCSiteCon*" "%ErrLog_DPNE%"
 call Echo "." "%ErrLog_DPNE%"
 call Echo "Job will stop processing no action will continue" "%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 pause
 start " " Notepad.exe "%ErrLog_DPNE%"
 pause
 exit
goto :end

rem ===== ErrActionWrong =======================================================
:ErrActionWrong
 set title_txt=%title_strBase% ERR:[wrong Action:%Action%][%Date%/%time:~0,8%]
 title %title_txt%
 call Echo "--------------------------------------------------------------------------"
 rem call :ErrLogHeaderWrite
 call Echo "%title_txt%" "%ErrLog_DPNE%"
 call Echo "Recived wrong TcSiteCons Action:[%Action%]" "%ErrLog_DPNE%"
 call Echo "." "%ErrLog_DPNE%"
 call Echo "Valid Actions are:" "%ErrLog_DPNE%"
 call Echo " - DataShare" "%ErrLog_DPNE%"
 call Echo " - DataSync" "%ErrLog_DPNE%"
 call Echo "." "%ErrLog_DPNE%"
 call Echo "Please check settings in:" "%ErrLog_DPNE%"
 call Echo " - JobMgr Scripts" "%ErrLog_DPNE%"
 call Echo " - JobServer definition in 'Scripts/Param.' ScriptName: TCSiteCon*" "%ErrLog_DPNE%"
 call Echo "." "%ErrLog_DPNE%"
 call Echo "Job will stop processing no action will continue" "%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 pause
 start " " Notepad.exe "%ErrLog_DPNE%"
 pause
 exit
goto :end

rem ===== TCPromtError =========================================================
:TcPromptErr
REM  %TC_DATA%\tc_profilevars.bat
REM   SET TC_ROOT=D:\ugs\tc83\2tier
REM  SET TC_DATA=

 set title_txt=%title_strBase% ERR:[Get TcPrompt][%Date%/%time:~0,8%]
 title %title_txt%
 call Echo "--------------------------------------------------------------------------"
 rem call :ErrLogHeaderWrite
 call Echo "%title_txt%" "%ErrLog_DPNE%"
 call Echo "TC Prompt not found TC_DATA\tc_profilevars.bat: %TC_DATA%\tc_profilevars.bat" "%ErrLog_DPNE%"
 call Echo "." "%ErrLog_DPNE%"
 call Echo "Values are:" "%ErrLog_DPNE%"
 call Echo " - TC_ROOT:[%TC_ROOT%]" "%ErrLog_DPNE%"
 call Echo " - TC_DATA:[%TC_DATA%]" "%ErrLog_DPNE%"
 call Echo "." "%ErrLog_DPNE%"
 call Echo "Please check settings in:" "%ErrLog_DPNE%"
 call Echo " - JobMgr Scripts" "%ErrLog_DPNE%"
 call Echo " - JobServer definition in 'Scripts/Param.' ScriptName: TCSiteCon*" "%ErrLog_DPNE%"
 call Echo "." "%ErrLog_DPNE%"
 call Echo "Job will stop processing no action will continue" "%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 pause
 start " " Notepad.exe "%ErrLog_DPNE%"
 pause
 exit
 goto :end



rem ============================================================================
:ColorSet
 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 if /I "%1"=="IsExecuting1" set JobColorLast=30
 if /I "%1"=="IsExecuting2" set JobColorLast=20
 if /I "%1"=="IsExecuting3" set JobColorLast=E0
 if /I "%1"=="IsExecuting4" set JobColorLast=B0
 rem Blaugrn Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=30
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="ERR"         set JobColorLast=C0

 set JobColorLast=E0
 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof

rem == ENDE ====================================================================
:end

 cd /D "%SystemDrive%"
 call Echo "--------------------------------------------------------------------------"
 call Echo "CleanUp: %temp%\%userName%2TierTransientVolume"
 rd /s /q "%temp%\%userName%2TierTransientVolume"

 call Echo "--------------------------------------------------------------------------"
 call Echo "Job:%JobName% finished at:%date% %time%"
 call Echo "Info: all files in:"
 call Echo "Dir.: %CmdCurRoot_DP:~-75%"
 call Echo "will be zipt by JobClient and send to JobServer"

if /i "%JobMgr_Test%" neq "ON" goto :JumbOverTest
  Echo --------------------------------------------------------------------------
  Banner Test:End
  pause
  Echo --------------------------------------------------------------------------
:JumbOverTest
if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo --------------------------------------------------------------------------
  Banner Debug:End
  Echo --------------------------------------------------------------------------
  pause
:JumbOverDebug

goto :eof
