@Echo off

 rem ---------------------------------------------------------
 rem JobManagerV2 Script to Purge TC Dataset's
 rem (c) J.Feuerstein 12.08.2015 15:28
 rem
 rem Aenderungs Info:
 rem User    Date/Time (Shift+strg+T)  Infotext:
 rem J.Fes   12.08.2015 15:28          Ersterstellung
 rem J.Fes   12.08.2015 15:28          Testing
 rem ---------------------------------------------------------

 set JobMgr_TcUser=%1
 set JobMgr_TcPw=%2

 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsList.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsList_txt=false
 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsListAllDetails.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsListAllDetails_txt=false
 rem wird im JobScript angegben so wird der File:[JobData1ToProcess_XML] nicht dem JobFile hinzugefuegt.
 set JobAddFile_JobData1ToProcess_xml=true

 set purge_datasets_keep=2
 rem -- JobScriptParametersExtended:
 rem    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen dann leer
 rem             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt leer
 #JobScriptParametersExtended#

 rem -- am Anfang Farbe auf IsIdel setzen
 call :ColorSet IsIdel

 rem Standard Path Variablen
 set JobManagerRoot_DP=#00-ApplRoot_DP#
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set JobScripts_DP=#10-JobScripts_DP#
 set MyApplName_TP=#MyApplName_TP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#


 rem -- JobParameter
 set JobName=#JobName#
 set JobParameter=#JobParameter#
 set JobObjectsPacket_NE=#JobObjectsPacket_NE#
 set JobObjectsPacketAllDetails_NE=#JobObjectsPacketAllDetails_NE#
 rem Root Verzeichniss der Scriptvorlage
 set JobScriptTemplateMinus1_DP=#JobScriptTemplateMinus1_DP#
 set JobScriptTemplate_DP=#JobScriptTemplate_DP#

 rem -- TC Daten
 set TcSiteId=#TcSiteId#
 set CmdCur_Title=#JobName#

 set JobTimeStart=%Date% %time:~0,8%
 set title_str=Job:[%JobName%][%TcSiteId%][Start:%JobTimeStart%][\\%ComputerName%][%JobMgr_TcUser%]
 title %title_str%


 rem ---------------------------------------------------------------------------
 if /i "%JobMgr_Test%" equ "ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Test:ON
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
 )
 if "%JobMgr_Debug%"=="ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Debug:ON
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
 )

 rem ---------------------------------------------------------------------------
 rem Rootpfade setzen
 set CmdCur_DPNE=%~0
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%
 set path=%CmdCurRoot_DP%;%Path%

 rem temp dir Organiesieren
 set temp_DP_org=%temp%
 set temp=%CmdCurRoot_DP%\JobTemp
 if not exist "%temp%" md "%temp%"
 cd /d "%temp%"

 set itemidsfile_DPNE=%CmdCurRoot_DP%\JobTemp\01-itemidsfile.txt
 set purge_datasets_log_DPNE=%CmdCurRoot_DP%\JobTemp\02-purge_datasets_log.txt


 rem -- #Step: JobMgr CmdTools local kopieren ----------------------------------
 rem -- #Doc: Steuert aus welchem Bereich die Tools genommen werden J.Fes 14.02.2013
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer


 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"
 Call Echo "TcUser/Group.......: [%JobMgr_TcUser%/%JobMgr_TcGroup%]"
 Call Echo "Upd. JobMgrCmd BinL: [%BinL_DP%]"
 Call Echo "from...............: [%JobManagerCmdTools_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:5
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.exe"
 rem >nul 2>nul

 rem new 21.01.2014
 set JFProcessMonitorL_exe=%BinL_DP%\JFProcessMonitor.exe
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%BinPublic_DP%" "%BinL_DP%" "JFProcessMonitor.exe"
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo #Debug:%~0 [Start:%toRun%]
  pause
 :JumbOverDebug

 if /I "%JobMgr_Debug%"=="ON" (
  Echo #Debug: Start Explorer at JobDir:[%CmdCurRoot_DP%]
  start "" Explorer "%CmdCurRoot_DP%"
  pause
 )

 rem -- Step: #ToDo:Define TC Prompt  - - - -


 if /i "#TcSiteId#" neq "WHLP10" goto :JumbOver1
   set TcPromtCmd=%SPLM_SHR_DIR%\start_apps\windows\start_nx100.bat
   set TcPromtCmdOpt=de tc_prompt WHLP10 tc101
:JumbOver1

 if     exist "%TcPromtCmd%" call "%TcPromtCmd%" %TcPromtCmdOpt%
 if not exist "%TcPromtCmd%" goto :end

 if /I "%JobMgr_Debug%"=="ON" (
  Echo #Debug: after get TCPrompt Quick
  set TC
  pause
 )


:StartJobProcessing

 call :ColorSet IsExecuting
 Echo %title_str%
 Echo --------------------------------------------------------------------------
 Echo Job Info:
 Echo JobName.............: %JobName%
 Echo Computer............: %ComputerName%
 Echo TempDir.............: %temp%
 Echo TcSide..............: %TcSiteId%
 Echo TcUser..............: %JobMgr_TcUser%
 Echo Job Parameter.......:
 Echo keep N DataSets.....: %purge_datasets_keep%
 Echo Items Liste.........: %itemidsfile_DPNE%
 Echo Purge DS Log........: %purge_datasets_log_DPNE%

 Echo Start...............: %JobTimeStart%
 Echo.


 rem #Step: --- Extract itemidsfile_DPNE content ItemId's ----------------------
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action JobDataExtract_2013_10
 set toRun=%toRun% -SubAction InputListExtract
 set toRun=%toRun% -format #ItemId#
 set toRun=%toRun% -inputList_DPNE "%itemidsfile_DPNE%"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobData1ToProcessDoPrint

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  set toRun=%toRun% -JobParaDoPrint
  set toRun=%toRun% -verbose
  set toRun=%toRun% -pauseOnEnd
  Echo #Debug:%~0
  Echo Start:%toRun%
  pause
 :JumbOverDebug
 call %toRun%

 rem #Step: --- Execute purge datasets via purge_datasets.exe ------------------
 set toRun=purge_datasets.exe
 set toRun=%toRun% -itemidsfile="%itemidsfile_DPNE%"
 set toRun=%toRun% -k=%purge_datasets_keep%
 set toRun=%toRun% -g=dba
 set toRun=%toRun% -u=%JobMgr_TcUser%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo #Debug:%~0
  Echo Start:%toRun% -p=**********
  pause
 :JumbOverDebug
 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 call Banner -k=%purge_datasets_keep%
 Echo Purge Dataset's Protocol:
 Echo  %purge_datasets_log_DPNE%
 call %toRun% -p=%JobMgr_TcPw% >>"%purge_datasets_log_DPNE%"

 rem #Step: --- Run set result's -----------------------------------------------
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "JobDataEdit_2012_09"
 set toRun=%toRun% -SubAction "JobData2ResultsSetProcessValue"
 set toRun=%toRun% -ObjProcessResultCode "0"
 set toRun=%toRun% -ObjProcessState  "D.OK"
 set toRun=%toRun% -ObjProcessResultMsg "[Res:Purge Datasets for Item Done]"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobData2ResultsDoPrint


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo #Debug:%~0
  Echo Start:%toRun%
  pause
 :JumbOverDebug
 call %toRun%


 set JobTimeEnd=%Date% %time:~0,8%
 Echo.
 Echo --------------------------------------------------------------------------
 Echo End.................: %JobTimeEnd%


 if "%JobMgr_Debug%"=="ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Echo #Debug Info: Ende
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
 )
 if /i "%JobMgr_Test%" equ "ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner #Test:End
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
 )

 rem Cleanup - Logfiles
 set temp=%temp_DP_org%
 cd /D "%temp%"
 rd /S /Q "%CmdCurRoot_DP%\JobTemp"

 rem -- Farbe auf JobEnds setzen
 call :ColorSet End
goto :end

rem #### ------------ Standard Subroutines --------------------- ######
rem ============================================================================
:JobParam_List
 setlocal
  set JobParams=%~1
  set NCur=0
 :JobParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%JobParams%") do Call :JobParam_Print "%%i"
  if %NCur% LEQ 10 goto :JobParam_List_PrintNext
 endlocal
 goto :eof

:JobParam_Print
 setlocal
  set JobParaCur=%~1
  if not "%JobParaCur%"=="" Echo                     : -%JobParaCur%
 endlocal
 goto :eof

rem ============================================================================
:ColorSet
 rem -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei

 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 rem Blaugrn Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=30
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof

rem ============================================================================
:end
 cd /d "%temp_DP_org%"
 Echo --------------------------------------------------------------------------
 Echo Info: all files in: [%temp%]
 Echo       will be zipt by JobClient and send to JobServer
