@Echo off
 REM ===========================================================================
 REM Basisscript JobManager V2 fuer den Refile mit NX in der TC Umgebung
 REM (c) J.Feuerstein 24.11.2006
 REM Aenderungs Info:
 REM Date/Time (Alt+D)  Infotext:
 REM 24.11.2006 J.Fes   Ersterstellung 05.09.2013
 REM 14.07.2013 J.Fes   using JobClinet.Cmd Tools
 REM 19.11.2013 J.Fes   integrate UGII_LOAD_OPTIONS + UGII_LOCAL_USER_DEFAULTS
 REM 25.12.2013 J.Fes   result is now returning via: %RfPrgExitCode%
 REM 21.01.2014 J.Fes   add Process Monitoring
 REM 12.02.2014 J.Fes   add ResultClassification_DPNE
 REM 29.04.2014 J.Fes   add JobMgr_RfExtEvalROpt
 REM 29.04.2014 J.Fes   setlocal endlocal partial removed
 REM 02.06.2014 J.Fes   error reporting enhanced
 REM 28.04.2015 J.Fes   integrate refile JobMgr_RfDataSets
 REM ===========================================================================

 Echo **************************************************************************
 Echo * Excuting Refile Script for  PLMJobManager Environ                      *
 Echo * Version: 28.04.2015 addPLM GmbH (c)                                    *
 Echo **************************************************************************

setlocal
 REM -- #Step: Farbe setzen IsIdel
 call :ColorSet IsIdel

 call Echo "--- #Step: Set Up Base ---------------------------------------------------------"

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3
 if not defined JobMgr_TcGroup     set JobMgr_TcGroup=dba
 if not defined JobMgr_RfDataSets  set JobMgr_RfDataSets=OFF


 REM -- Rootpfade setzen -------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 rem -- #Step: JobMgr CmdTools local kopieren ----------------------------------
 rem -- #Doc: Steuert aus welchem Bereich die Tools genommen werden J.Fes 14.02.2013
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer

 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"

 Call Echo "TcUser/Group............: [%JobMgr_TcUser%/%JobMgr_TcGroup%]"
 Call Echo "Upd. JobMgrCmd BinL.....: [%BinL_DP%]"
 Call Echo "from....................: [%JobManagerCmdTools_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:5
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.exe">nul 2>nul

 rem new 21.01.2014
 set JFProcessMonitorL_exe=%BinL_DP%\JFProcessMonitor.exe
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%BinPublic_DP%" "%BinL_DP%" "JFProcessMonitor.exe"


 REM -- temp dir Organiesieren -------------------------------------------------
 rem #New: 11.07.2013 13:43 S.Gue
 set JobTemp1_SO_DP=%CmdCurRoot_DP%\JobTempSO
 set JobTemp2_RO_DP=%CmdCurRoot_DP%\JobTempRO
 set RfLogFile_NE=_Rf20_RefileJob.log
 set RfFailedLog_NE=_Rf21_RefileFailed.log
 set RfCmdJobLog_NE=_Rf23_RefileCmdJob.log

 rem #New 30.11.2013 /J.Fes
 set ExtractJobList_MsgLog_DPNE="%CmdCurRoot_DP%\JobData1_ExtractList.log"
 set EvaluateJobResult_MsgLog_DPNE="%CmdCurRoot_DP%\JobData2_ResultEvaluate.log"

 REM -- define cmd files to set variables --------------------------------------
 set RfSetEnv_cmd=%CmdCurRoot_DP%\RfSetEnv.cmd
 set RfCustomSetEnv_cmd=%CmdCurRoot_DP%\RfCustomSetEnv.cmd

 Rem -- define ResultClassification_DPNE JobMgr --------------------------------
 set ResultClassification_DPNE=%CmdCurRoot_DP%\Resources\RfNxSylog_ResClRules.xml

 REM -- RefilePaketFile festlegen
 set RfInputList_NE=_Rf01_RefileList.txt
 set RfInputList1_SO_DPNE=%JobTemp1_SO_DP%\%RfInputList_NE%
 set RfInputList2_RO_DPNE=%JobTemp2_RO_DP%\%RfInputList_NE%

 REM -- Refile Logfiles fr Owning Site festlegen ------------------------------
 set RfLogFile1_SO_DPNE=%JobTemp1_SO_DP%\%RfLogFile_NE%
 set RfFailedLog1_SO_DPNE=%JobTemp1_SO_DP%\%RfFailedLog_NE%
 set RfCmdJobLog_SO_DPNE=%JobTemp1_SO_DP%\%RfCmdJobLog_NE%

 REM -- Refile Logfiles fr Replica festlegen ----------------------------------
 set RfLogFile2_RO_DPNE=%JobTemp2_RO_DP%\%RfLogFile_NE%
 set RfFailedLog2_RO_DPNE=%JobTemp2_RO_DP%\%RfFailedLog_NE%
 set RfCmdJobLog_RO_DPNE=%JobTemp2_RO_DP%\%RfCmdJobLog_NE%

 rem -- Execute first time RfCustomSetEnv.cmd
 if exist "%RfCustomSetEnv_cmd%" call "%RfCustomSetEnv_cmd%"

 REM -- Option: Control software starten ---------------------------------------
 rem #New: 30.11.2013/J.Fes
 if /I "%JobMgr_use_PLMJobManagerWatchDog%" equ "ON" (
  REM Echo Check Start: PLMJobManagerWatchDog.exe
  Echo --------------------------------------------------------------------------
  call "ProgStart_If_NotRuning.cmd" "PLMJobManagerWatchDog" "%BinPublic_DP%\PLMJobManagerWatchDog_Start.cmd"
 )

 rem #New: 19.06.2014/J.Fes
 if /I "%JobMgr_start_TaskMgr%" equ "ON" (
  REM Echo Check Start: TaskMgr.exe
  Echo --------------------------------------------------------------------------
  call "ProgStart_If_NotRuning.cmd" "TaskMgr" "taskmgr.exe"
 )

 REM new 31.05.2010 21:53
 if /i "%JobMgr_use_TcServerKill%" equ  "ON" (
   call ProgIs_Running.cmd  teamcenter teamcenter_Is_running
   if "%teamcenter_Is_running%" equ "0" (
     REM TcServer Process beenden aber nur wenn TeamCenter nicht aktive ist
     call ProgKill.cmd TcServer "#12-Data#\Refile_TcServerStop_log.txt"
    )
 )

 call Echo "--- #Step: Extract Refile Input List ---------------------------------------"
 call :ExtractRfList

if not exist "%RfInputList1_SO_DPNE%" goto :JumbOver_RfSO
 echo.
 call Echo "--- #Step: Refile Site Owning (SO) -----------------------------------------"
 rem #Doc: JobParameter is to set on this line
 call :ExecuteRefile "%JobTemp1_SO_DP%" "%RfLogFile1_SO_DPNE%" "%RfFailedLog1_SO_DPNE%" "%RfCmdJobLog_SO_DPNE%" "%RfInputList1_SO_DPNE%" "%RfCustomSetEnv_cmd%" "NO"
:JumbOver_RfSO

if not exist "%RfInputList2_RO_DPNE%" goto :JumbOver_RfRO
 echo.
 call Echo "--- #Step: Refile Replica Objects (RO) -------------------------------------"
 call :ExecuteRefile "%JobTemp2_RO_DP%" "%RfLogFile2_RO_DPNE%" "%RfFailedLog2_RO_DPNE%" "%RfCmdJobLog_RO_DPNE%" "%RfInputList2_RO_DPNE%" "%RfCustomSetEnv_cmd%" "YES"
:JumbOver_RfRO

REM New 21.04.2015 S.Gueth
IF /I "%JobMgr_RfDataSets%" EQU "ON" goto :Next
 rem on standard refile do evaluate Rf results
 echo.
 call Echo "--- #Step: Evaluate Refile Results ---------------------------------------------"
 call :RfResEvaluate
:Next

 endlocal& set RfPrgExitCode=%RfPrgExitCode%
goto :end


rem ============================================================================
:ExecuteRefile
 rem #Doc: Main Script to run Refile
 rem #Doc get File Params
 set temp=%~1
 rem #New 15.04.2014 13:48
 set tmp=%temp%
 set HOME=%temp%

 set RfJobLog_DPNE=%~2
 set RfFailedLog_DPNE=%~3
 set RfCmdJobLog_DPNE=%~4
 set RfPaket_DPNE=%~5
 set RfCustomSetEnv_cmd=%~6
 set RfReplica=%~7

 set RfErrLog_DPNE=%temp%\_RfErrLog.txt

 REM -- cut '\' on end
 if "%UGII_BASE_DIR:~-1%" equ "\" set UGII_BASE_DIR=%UGII_BASE_DIR:~0,-1%
 if "%UGII_ROOT_DIR:~-1%" equ "\" set UGII_ROOT_DIR=%UGII_ROOT_DIR:~0,-1%

 REM -- extend search path
 set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%

 set UGII_TMP_DIR=%temp%
 SET UGII_KEEP_SYSTEM_LOG=TRUE
 set UGII_UGSOLIDS_TMP=%UGII_TMP_DIR%

 REM disable eingefuegt 17.08.12 J.Fes/K.S
 set UGII_UGMGR_USE_CACHE=

 REM -- Symetric Multi-Processing (SMP) disable
 REM diabled 07.02.2011
 set UGII_SMP_ENABLE=

 REM -- CGM erstellung deaktiveren eingefuegt 09.02.10 J.fes
 set UGII_IMAGE_CREATE_CGM=
 set UGII_IMAGE_CREATE_CGM_DRAW=
 set UGII_IMAGE_CREATE_CGM_OPTIONS=
 set UGII_IMAGE_CREATE_NAME=
 set UGII_IMAGE_CREATE_ORIGINAL_BACKGROUND=

 REM -- PFM vermeidet fehler beim refile von PFM Parts eingefuegt 29.11.2010 Info erhalten ber IR1814812
 set UGII_UGMGR_ALLOW_PFM_IMPORT_EXPORT=1

 REM -- IMAN-Variablen umbiegen -------------------------------------------
 SET IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 SET IMAN_KEEP_SYSTEM_LOG=TRUE
 SET IMAN_Journalling=OFF
 SET IMAN_journaling=OFF
 SET IMAN_TRACEBACK=OFF
 SET IMAN_Journal_Modules=NONE
 SET API_JOURNAL=NONE
 set APB_SCHEMA=

 REM -- TC-Variablen umbiegen -------------------------------------------
 REM 11.08.10 SQL Debug on for Test's
 SET TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 SET TC_KEEP_SYSTEM_LOG=TRUE
 SET TC_Journalling=OFF
 SET TC_Journaling=OFF
 SET TC_TRACEBACK=OFF

 REM -- define Load_options -----------------------------------------------
 set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\startup\load_options_refile.def

 REM -- define nx_refile.dpv -----------------------------------------------
 SET UGII_LOCAL_USER_DEFAULTS=%CmdCurRoot_DP%\startup\nx_refile.dpv
 set UGII_USER_DIR=%CmdCurRoot_DP%
 set UGII_GROUP_DIR=

 REM -- def: TC LOG -------
 set TC_Administration_Logging=OFF
 set TC_System_Logging=OFF
 set TC_LOG=%TC_TMP_DIR%

 REM -- Use TcNx Debug Variables -------------------------------------------
 if /I "%JobMgr_TcNxDebug%" neq "ON" goto :JumbOver
   Banner TcNxDeb:ON
   set TC_Journalling=ON
   set TC_Journal_Modules=ALL
   set TC_TRACEBACK=ON

   REM -- (Note the small j and single l)
   set TC_journaling=ON
   REM  (Make sure it is N and not ON)
   set TC_POM_JOURNALLING=N
   set TC_Journal_Modules=ALL
   set TC_SQL_DEBUG=BJTP

   REM -- (SUMMARY for shorter list)
   set TC_JOURNAL=FULL
   set TC_JOURNAL_LINE_LIMIT=0
   set TC_DATASET_DEBUG=on
   set JOURNAL_dpat_report=on

   REM -- this variable prints the SOA based server calls timing information into the syslog
   set UGII_UGMGR_MONITOR_NETWORK_CALLS=1
   set UGII_DEBUG=OCC_update_structure
   set TC_SLOW_SQL=-1
   set TC_KEEP_SYSTEM_LOG=true
   set WhereReferencePOMPref=1
   REM !! Attention !!
   REM set UGII_CHECKING_LEVEL=1
:JumbOver

 set PathSearchKey=%temp%
 IF /I "%JobMgr_RfDataSets%" NEQ "ON" goto :Next
   set PathSearchKey=%temp%\*
:Next


 rem 21.01.2014
 rem Monitors NxCB_program_exe_NE
 rem  - mit max 2 Std Laufzeit
 rem  - mit max 6gb Memory usage fr 5 min
 rem  - mit max 5 min ohne das neue files im JobTemp entstehen oder editiert werden
 set toMon=%JFProcessMonitorL_exe%
 set toMon=%toMon% --waitForProcess 15000
 set toMon=%toMon% --processName ugmanager_refile_program
 set toMon=%toMon% --parentProcessId 0
 REM  set toMon=%toMon% --runtimeLimitSeconds 7200
 set toMon=%toMon% --killChildProcesses
 set toMon=%toMon% --fileLastWriteTime "%PathSearchKey%\*.*;600"
 rem #New 23/11/2014 19:21 / J.Fes
 set toMon=%toMon% --fileContainsString "%PathSearchKey%\%username%*.syslog;This is most likely the result of a crash of the Teamcenter server, or the Teamcenter server encountering an unrecoverable error"
 rem set toMon=%toMon% --monitorExistingFiles
 REM  set toMon=%toMon% --memoryUsageHigh 6000;300
 set toMon=%toMon% --saveResultsTo "%temp%\zzJFProcessMonitor_log.xml"
 set toMon=%toMon% --tailTextFile "%PathSearchKey%\*ugmanager_refile_program*.syslog"
 set toMon=%toMon% --titlePrefix "Job:[%JobName%][%TcSiteId%]"

 REM -- set Rf Parameter ----------------
 set RfPrgExitCode=
 set RfPara=#JobParameter#

 REM -- set Rf.Contol defaults ----------
 set TC_SHARED_MEMORY_DIR_Disable=false
 set JobMgr_RfPMon_USE=true
 set JobMgr_fccCheck_USE=true

 REM -- set Rf.Environ
 if exist "%RfSetEnv_cmd%" call "%RfSetEnv_cmd%"
 REM -- set Custom.Environ
 if exist "%RfCustomSetEnv_cmd%" call "%RfCustomSetEnv_cmd%"

 REM -- Refile Programm --------------------------------------------------------
 set refile_program_exe_DPNE=%UGII_BASE_DIR%\UGMANAGER\ugmanager_refile_program.exe

 REM -- Check's
 REM #Doc: 28.10.10 J.Fes if FMS_HOME is not defined it get erros during Rf.AP's
 if not exist "%FMS_HOME%"                 call :ExecuteRf_ERR_Write "Dir.not.f:FMS_HOME"                      "Dir  not found: FMS_HOME"                       "FMS_Home value..........: [%FMS_HOME%]"
 if not exist "%RfSetEnv_cmd%"             call :ExecuteRf_ERR_Write "File.not.f:RfSetEnv.cmd"                 "File not found: RfSetEnv.cmd"                   "RfSetEnv_cmd............: [%RfSetEnv_cmd%]"
 if not exist "%RfCustomSetEnv_cmd%"       call :ExecuteRf_ERR_Write "File.not.f:RfCustomSetEnv.cmd"           "File not found: RfCustomSetEnv.cmd"             "RfCustomSetEnv_cmd......: [%RfCustomSetEnv_cmd%]"
 if not exist "%UGII_LOCAL_USER_DEFAULTS%" call :ExecuteRf_ERR_Write "File.not.f:UGII_LOCAL_USER_DEFAULTS"     "File not found: UGII_LOCAL_USER_DEFAULTS"       "UGII_LOCAL_USER_DEFAULTS: [%UGII_LOCAL_USER_DEFAULTS%]"
 if not exist "%UGII_LOAD_OPTIONS%"        call :ExecuteRf_ERR_Write "File.not.f:UGII_LOAD_OPTIONS"            "File not found: UGII_LOAD_OPTIONS"              "UGII_LOAD_OPTIONS.......: [%UGII_LOAD_OPTIONS%]"
 if not exist "%refile_program_exe_DPNE%"  call :ExecuteRf_ERR_Write "File.not.f:ugmanager_refile_program.exe" "File not found: ugmanager_refile_program.exe"   "refile_program_exe......: [%refile_program_exe_DPNE%]"
 REM -- Run fccCheck
 if /I "%JobMgr_fccCheck_USE%" equ "true" call :fccCheck
 REM -- Exit if Error happend
 if exist "%RfErrLog_DPNE%" call :ExecuteRf_ERR_Show& goto :Rf_end

 rem #New: 30.05.2014 TC_SHARED_MEMORY_DIR
 if /i "%TC_SHARED_MEMORY_DIR_Disable%" neq "true" goto :TC_SHARED_MEMORY_DIR_Enable

:TC_SHARED_MEMORY_DIR_Disable
 rem disable TC_SHARED_MEMORY_DIR, via:
 set TC_NO_TEXTSRV_SHARED_MEMORY=TRUE
 set TC_USE_METADATA_SHARED_MEMORY=FALSE
 set TC_USE_PREFS_SHARED_MEMORY=FALSE
 goto :TC_SHARED_MEMORY_DIR_Next

:TC_SHARED_MEMORY_DIR_Enable
 set TC_SHARED_MEMORY_DIR=%CmdCurRoot_DP%\..\TC_SHARED_MEMORY_%TcSiteId%
 if not exist "%TC_SHARED_MEMORY_DIR%" md "%TC_SHARED_MEMORY_DIR%"
 goto :TC_SHARED_MEMORY_DIR_Next

:TC_SHARED_MEMORY_DIR_Next

 if "%JobMgr_RfDataSets%" neq "OFF" set JobMgr_RfPMon_USE=false
 call :Parse_NE %UGII_LOAD_OPTIONS%        UGII_LOAD_OPTIONS
 call :Parse_NE %UGII_LOCAL_USER_DEFAULTS% UGII_LOCAL_USER_DEFAULTS

 set titleRf_str=Job:[%JobName%][%TcSiteId%][Replica:%RfReplica%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleRf_str%

 Echo.                                                                               .
 call :ColorSet IsExecuting
 Echo %titleRf_str%
 call Echo "----------------------------------------------------------------------------"
 Call Echo "Refile Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.................: %JobName%"
 Call Echo "Computer................: %ComputerName%"
 Call Echo "RfDir...................: %temp:~-50%"
 Call Echo "TcSide..................: #TcSite.SiteInfoWith_SiteId_and_pName#"
 Call Echo "TcUser..................: %JobMgr_TcUser%"
 Call Echo "FMS_HOME................: %FMS_HOME%"
 Call Echo "TC_ROOT.................: %TC_ROOT%"
 Call Echo "TC_DATA.................: %TC_DATA%"
 Call :JobParam_List "Refile Parameter........:" "%RfPara%"
 Call Echo "Special Options.........:"
 Call Echo "RfPart..................: %JobMgr_RfDataSets%"
 Call Echo "RfReplicaParts..........: %RfReplica%"
 Call Echo "RfEvalExtOpt............: %JobMgr_RfExtEvalROpt%"
 Call Echo "RfProc.Monitor..........: %JobMgr_RfPMon_USE%"
 Call Echo "fccCheck................: %JobMgr_fccCheck_USE%"
 Call Echo "TC_SHARED_MEMORY Disable: %TC_SHARED_MEMORY_DIR_Disable%"
 Call Echo "UGII_LOAD_OPTIONS.......: ..\%UGII_LOAD_OPTIONS_NE%"
 Call Echo "UGII_SITE_DIR...........: %UGII_SITE_DIR%"
 Call Echo "UGII_LOCAL_USER_DEF.....: ..\%UGII_LOCAL_USER_DEFAULTS_NE%"

 cd /d "%temp%"
 set >>"%temp%\zzEnvironBevorRefile.txt"

 REM New S.Gueth 17.04.2015 for refiling parts
 IF /I "%JobMgr_RfDataSets%" NEQ "ON" goto :RfPaket
 IF /I "%JobMgr_RfDataSets%" EQU "ON" goto :RfDataSets

:RfPaket
 if /i "%JobMgr_RfPMon_USE%" neq "false" start "PMon Job:[%JobName%][%TcSiteId%]" %toMon%
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Refile Paket Protocol:"
 REM -- hier wird das Refileprogram gestartet --
 call "%refile_program_exe_DPNE%" %RfPara% -i="%RfPaket_DPNE%" -log="%RfJobLog_DPNE%" -out="%RfFailedLog_DPNE%" -u=%JobMgr_TcUser% -p=%JobMgr_TcPw% -g=%JobMgr_TcGroup%
 set RfPrgExitCode=%errorlevel%
goto :Next


:RfDataSets
 rem Execute Refile via Datasets
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Refile DataSets:"

 set RfPrgExitCode=0
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "RefileTC_2012_01"
 set toRun=%toRun% -SubAction "Refile_Part"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobTemp_DP "%temp%"
 set toRun=%toRun% -RfProg_DPNE "%refile_program_exe_DPNE%"
 set toRun=%toRun% -RfPara "'%RfPara%'"
 set toRun=%toRun% -u "%JobMgr_TcUser%"
 set toRun=%toRun% -p "%JobMgr_TcPw%"
 set toRun=%toRun% -g "%JobMgr_TcGroup%"
 set toRun=%toRun% -ShellMaxDurationSEC "-1"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -RfInputList_DPNE "%RfPaket_DPNE%"
 set toRun=%toRun% -JobData2ResultsDoPrint

 if exist "%ResultClassification_DPNE%" set toRun=%toRun% -ResultClassification_DPNE "%ResultClassification_DPNE%"
 if defined ResultClassificationCustom_DPNE set toRun=%toRun% -ResultClassificationCustom_DPNE "%ResultClassificationCustom_DPNE%"
 if defined JobMgr_RfExtEvalROpt set toRun=%toRun% %JobMgr_RfExtEvalROpt%

 IF /i "%JobMgr_Debug%" NEQ "ON" goto :Next
   set toRun=%toRun% -JobParaDoPrint -verbose -pauseOnEnd
   Echo #Debug: Before RfDataSets
   Echo #Debug: toRun........: %toRun%
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_02_RfDataSets.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo %toRun% >>"%Debug_DPNE%"
   pause
 :Next

 call %toRun%

 IF /i "%JobMgr_Debug%" EQU "ON" (
   Echo #Debug: After Refile
   pause
 )
goto :Next

:Next

 call Echo "--- #Res.: RfPrgExitCode.: [%RfPrgExitCode%] ---------------------------------------------"

REM  Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 Call Echo "Rf:End" "" "NOECHO"
 Banner "Rf:End"

 IF /I "%JobMgr_RfDataSets%" EQU "ON" goto :JumbtoRfDataSetsExit
 IF /i "%JobMgr_Debug%" neq "ON" goto :Next
   Echo #Debug: Refile Results Info:
   Echo #Debug: RfPrg........: %refile_program_exe_DPNE%
   Echo #Debug: RfPrgExitCode: %RfPrgExitCode%
   Call :TypeFile "%RfJobLog_DPNE%"     "Rf Job Log:"
   Call :TypeFile "%RfFailedLog_DPNE%"  "Rf Failed Log:"
   pause
:Next

 if defined title_str title %title_str%
 Echo CleanUp......: %temp%\%userName%2TierTransientVolume\..
 rd /S /Q  "%temp%\%userName%2TierTransientVolume" >nul 1>nul 2>nul

 if "%RfPrgExitCode%" equ "0" goto :RfPrgExit_OK

:RfPrgExit_ERR
 set title_str=ERR:%RfPrgExitCode% !! error running ugmanager_refile_program.exe [%Date%/%time:~0,8%] !!
 rem #New 11.11.2015/J.Fes Prevent Issues of 'dead Sessions' in TC.DB
 Echo --------------------------------------------------------------------------
 Echo %title_str%
 Banner RUN.Clearlocks
 Echo Clearlocks -verbose
 call Clearlocks -verbose
 Echo --------------------------------------------------------------------------
 call :ExecuteRf_ERR_Write "RfPrg.End NOT with '0'" ""  "ugmanager_refile_program: Ends with [ErrorLevel:%RfPrgExitCode%]"
 call :ExecuteRf_ERR_Show

:JumbtoRfDataSetsExit
 goto :Rf_end

:RfPrgExit_OK
 Call :ColorSet OK
 REM -- delete alle files not to send to JobServer
 if /I "%JobMgr_TcNxDebug%" neq "ON" (
       if /I "%JobMgr_Debug%" neq "ON" (
          Echo CleanUp......: %temp%\..
          rem 09/09/2014 18:45 J.Fes add %temp%\*.log
          del /S /Q "%PathSearchKey%\apiserver.exe*.*","%PathSearchKey%\*.bak","%PathSearchKey%\*.tmp","%PathSearchKey%\*.prt","%PathSearchKey%\tcserver.*","%PathSearchKey%\tcserver.*.*">nul 1>nul 2>nul
       )
 )
 goto :Rf_end

:Rf_end
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo.
  Echo #Debug:%~0 [Rf:End]
  pause
:JumbOverDebug

goto :eof

REM ============================================================================
:ExtractRfList
 rem #Doc: Extracts the IR lists for Refile input
 rem #New: 15.07.2013

 Call :ColorSet ExtractLi

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "RefileTC_2012_01"
 set toRun=%toRun% -SubAction "EXTRACT"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobTemp1_SO_DP "%JobTemp1_SO_DP%"
 set toRun=%toRun% -JobTemp2_RO_DP "%JobTemp2_RO_DP%"
 set toRun=%toRun% -RfInputList_NE "%RfInputList_NE%"
 set toRun=%toRun% -RfInputList1_SO_DPNE "%RfInputList1_SO_DPNE%"
 set toRun=%toRun% -RfInputList2_RO_DPNE "%RfInputList2_RO_DPNE%"
 set toRun=%toRun% -JobData1ToProcessDoPrint
 REM New 21.04.2015 S.Gueth
 IF /I "%JobMgr_RfDataSets%" == "ON" (
   set toRun=%toRun% -RfListContent DS
 )

 REM New 25.09.2015 J.Fes
 IF /I "%JobMgr_RfListContent%" == "DS" (
   set toRun=%toRun% -RfListContent DS
 )

REM  set toRun=%toRun% -MsgLog_DPNE "%ExtractJobList_MsgLog_DPNE%"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_01_ExtractList.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo #Debug.: BEVOR: [%~0]
   Echo %toRun% >>"%Debug_DPNE%"
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
:JumbOverDebug

 call %toRun%
 set toRun=

goto :eof

rem ============================================================================
:RfResEvaluate
 rem #Doc: Evaluate the refile results
 rem #New: 15.07.2013/J.Fes
 rem #Upd: 02.06.2014/J.Fes

 Call :ColorSet EvalResult

 REM #Doc: if RfErrLog exist and no Rf.Prg did run then Get Err Result
 if exist "%RfErrLog_DPNE%" if "%RfPrgExitCode%" equ "" goto :RfResEvaluate_ERR

:RfResEvaluate
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "RefileTC_2012_01"
 set toRun=%toRun% -SubAction "EVALUATE"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobData2ResultsDoPrint
 rem #New:12.02.2014/J.Fes
 if exist "%ResultClassification_DPNE%" set toRun=%toRun% -ResultClassification_DPNE "%ResultClassification_DPNE%"
 rem #New:05.06.2015/S.Gueth + J.Fes
 if defined ResultClassificationCustom_DPNE set toRun=%toRun% -ResultClassificationCustom_DPNE "%ResultClassificationCustom_DPNE%"
 rem #New:28.04.2014/J.Fes
 if defined JobMgr_RfExtEvalROpt set toRun=%toRun% %JobMgr_RfExtEvalROpt%
 goto :RfResEvaluate_Do

:RfResEvaluate_ERR
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "JobDataEdit_2012_09"
 set toRun=%toRun% -SubAction "JobData2ResultsSetProcessValue"
 set toRun=%toRun% -ObjProcessResultCode "JM-999101"
 set toRun=%toRun% -ObjProcessState  "D.NP"
 set toRun=%toRun% -ObjProcessResultMsg "[Rf:ERR:Job.NP:because %RfErr_MSG_Keys%]"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobData2ResultsDoPrint
 goto :RfResEvaluate_Do

:RfResEvaluate_Do
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_03_EvaluateRefileResult.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo #Debug.: BEVOR: [%~0]
   Echo %toRun% >>"%Debug_DPNE%"
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
:JumbOverDebug

 call %toRun%


goto :eof


REM ####### ------------ Standard Subroutines ---------------------- ###########
REM ============================================================================
:JobParam_List
 setlocal
  set ParmListTitle=%~1
  set JobParams=%~2
  rem " ersetzen durch '
  set JobParams=%JobParams:"='%
  set NCur=0
:JobParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%JobParams%") do Call :JobParam_Print "%%i"
  if %NCur% LEQ 10 goto :JobParam_List_PrintNext
 endlocal
 goto :eof

:JobParam_Print
 setlocal
  set JobParaCur=%~1
  if "%NCur%" equ "1" (
                            Call Echo "%ParmListTitle% -%JobParaCur%"
  ) else (
   if "%JobParaCur%" neq "" Call Echo "                        : -%JobParaCur%"
  )
 endlocal
 goto :eof

REM ============================================================================
:fccCheck
 rem #New 28.06.2013 J.Fes
REM  call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 rem Update 19.06.2014  uses now "%fms_home%\bin\fccstat.exe"
 call "%fms_home%\bin\fccstat.exe" -status>>"%temp%\zzfcc1Status.txt"
 set tc_fccstatus=%errorlevel%

 if "%tc_fccstatus%" equ "0" goto :fccStartOk

  rem jetzt fcc starten
  call "%fms_home%\bin\fccstat.exe" -start>>"%temp%\zzfcc2Start.txt"

  rem fcc preufung nach start
  call "%fms_home%\bin\fccstat.exe" -status>>"%temp%\zzfcc3Status.log"
  set tc_fccstatus=%errorlevel%

  if "%tc_fccstatus%" equ "0" goto :fccStartOk

  Call :ColorSet ERR
  call :ExecuteRf_ERR_Write "fcc.ERR" "fcc cannot be started"
  call :ExecuteRf_ERR_Write "" "" "fcc Status/Start........: Returns [errorlevel:%tc_fccstatus%]"
  call :ExecuteRf_ERR_Write "" "" "please look at 1 Status.: [%temp%\zzfcc1Status.log]"
  call :ExecuteRf_ERR_Write "" "" "please look at 2 Start..: [%temp%\zzfcc2Start.log]"
  call :ExecuteRf_ERR_Write "" "" "please look at 3 Status.: [%temp%\zzfcc3Status.log]"
  call :ExecuteRf_ERR_Write "" "" "#ToDo...................: Please check installation and configuration"
  goto :fccCheckEnd

:fccStartOk
 del "%temp%\zzfcc1Status.log"
 Call Echo "fcc check:..............: OK"
 goto :fccCheckEnd
:fccCheckEnd
goto :eof

REM ============================================================================
:ExecuteRf_ERR_Write
 Call :ColorSet ERR
 Set RfErr_MSG_Key=%~1
 Set RfErr_MSG_Sort=%~2
 Set RfErr_MSG_L1=%~3
 Set RfErr_MSG_L2=%~4
 Set RfErr_MSG_L3=%~5
 Set RfErr_MSG_L4=%~6

 if "%RfErr_MSG_Key%" equ "" goto :Next
 rem add Error Key
 if     defined RfErr_MSG_Keys set RfErr_MSG_Keys=%RfErr_MSG_Keys% %RfErr_MSG_Key%
 if not defined RfErr_MSG_Keys set RfErr_MSG_Keys=%RfErr_MSG_Key%


 set title_str=ERR:%RfErr_MSG_Key% %RfErr_MSG_Sort%
 if "%RfErr_MSG_Sort%" neq "" set title_str=ERR:%RfErr_MSG_Key%

 if not exist "%RfErrLog_DPNE%" Call :ErrLogHeaderWrite

 REM Error in die Datei schreiben!
 call Echo "%title_str%" "%RfErrLog_DPNE%"
:Next
 if "%RfErr_MSG_L1%" neq "" call Echo "%RfErr_MSG_L1%" "%RfErrLog_DPNE%"
 if "%RfErr_MSG_L2%" neq "" call Echo "%RfErr_MSG_L2%" "%RfErrLog_DPNE%"
 if "%RfErr_MSG_L3%" neq "" call Echo "%RfErr_MSG_L3%" "%RfErrLog_DPNE%"
 if "%RfErr_MSG_L4%" neq "" call Echo "%RfErr_MSG_L4%" "%RfErrLog_DPNE%"
REM  Call Echo "." "%RfErrLog_DPNE%"
REM  pause

goto :eof

REM -- -- -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- -- -
:ErrLogHeaderWrite
 call Echo "DateTime: %date% %time%"  "%RfErrLog_DPNE%"
 call Echo "Computer: %ComputerName%" "%RfErrLog_DPNE%"
 call Echo "User....: %UserName%"     "%RfErrLog_DPNE%"
 call Echo "--------------------------------------------------------------------------" "%RfErrLog_DPNE%"
 goto :eof

REM -- -- -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- -- -
:ErrLogFooterWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable RfErrLog_DPNE muss gesetzt sein!!
 Echo."%RfErrLog_DPNE%"
 call Echo "--------------------------------------------------------------------------" "%RfErrLog_DPNE%" "NOECHO"
 call Echo "Environ Info of:\\%ComputerName%" "%RfErrLog_DPNE%" "NOECHO"
 call Echo "." "%RfErrLog_DPNE%" "NOECHO"
 call Echo "-- Path Environ ----------------------------------------------------------" "%RfErrLog_DPNE%" "NOECHO"
 set PATH >>"%RfErrLog_DPNE%"

 call Echo "-- UG* Environ -----------------------------------------------------------" "%RfErrLog_DPNE%" "NOECHO"
 set UG >>"%RfErrLog_DPNE%" 2>nul
 call Echo "-- NX* Environ -----------------------------------------------------------" "%RfErrLog_DPNE%" "NOECHO"
 set NX >>"%RfErrLog_DPNE%" 2>nul
 call Echo "-- IMAN* Environ ---------------------------------------------------------" "%RfErrLog_DPNE%" "NOECHO"
 set IMAN >>"%RfErrLog_DPNE%" 2>nul
 call Echo "-- TC* Environ -----------------------------------------------------------" "%RfErrLog_DPNE%" "NOECHO"
 set TC >>"%RfErrLog_DPNE%" 2>nul
 call Echo "-- All Environ -----------------------------------------------------------" "%RfErrLog_DPNE%" "NOECHO"
 set >>"%RfErrLog_DPNE%" 2>nul
 goto :eof

REM -- -- -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- --  -- -- -
:ExecuteRf_ERR_Show
 set title_str=ERR:Refile on:[\\%ComputerName%][%Date%/%time:~0,8%]!!
 call :ErrLogFooterWrite
 title %title_str%
 Echo --------------------------------------------------------------------------
 Type "%RfErrLog_DPNE%"
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_Debug%" neq "ON" goto :ExecuteRf_ERR_Show_end
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%RfErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo #Hint: Type exit and script continues
 cmd
 :ExecuteRf_ERR_Show_end
goto :eof

REM ============================================================================
:ColorSet
Rem Stand 25.06.2011
 REM call :ColorSet Standard
 REM call :ColorSet IsExecuting
 REM call :ColorSet IsIdel
 REM call :ColorSet End
 REM call :ColorSet Ende
 REM call :ColorSet Ok
 REM call :ColorSet Err

 if /I "%~1" equ "Standard"    set JobColorLast=70
 if /I "%~1" equ "IsExecuting" set JobColorLast=E0
 if /I "%~1" equ "ExtractLi"   set JobColorLast=B0
 if /I "%~1" equ "EvalResult"  set JobColorLast=B1
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 if /I "%~1" equ "Err"         set JobColorLast=C0

 REM set color
 if "%JobColorLast%" neq "" color %JobColorLast%
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
  Echo Description    : %FileDescription%
  Echo Contens of File: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo Info...........: File.notf.:[%FileToType_DPNE%]
 endlocal
 goto :eof

REM ============================================================================
:Parse_NE
 set %2_NE=%~nx1
 goto :eof

REM ============================================================================
:end
