@Echo off
 REM ===========================================================================
 REM Basisscript fr PLM Performance Analyse
 REM (c) J.Feuerstein/S.Gueth 09.07.2015
 rem
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   24.11.2006 00:05   Ersterstellung 24.11.2006
 REM J.Fes   14.07.2013 15:54   Skript umgestellt auf JCT Tools
 REM S.Gue   09.07.2015 08:48   Skript umgestellt PLMPerf mit NxMacro Execute
 REM ===========================================================================
 

 Echo **************************************************************************
 Echo * Excuting PLMPerf Analyse Script                                        *
 Echo * Version: 09.07.2015 addPLM GmbH (c)                                    *
 Echo **************************************************************************

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 REM -- Basiseinstellungen fuer das Verhalten es Scriptes ----------------------
 REM Hier knnen Verschiedene Einstellungen getroffen werden die steuern wie das Script ablaufen soll
 REM      Die mit "#" Gitter eingeschlossenen Variablen werden vom JobServer ersetzt
 
 REM Alle wichtigen Stellen sind mit # gekennzeichnset
 REM #Doc.: steht an allen Dokumentations Stellen
 REM #ToDo: steht an allen Stellen die angepasst werden sollen

 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsList.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsList_txt=false
 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsListAllDetails.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsListAllDetails_txt=false


 REM Debug: [bei Einzel Test's auf=ON] [sonst auf OFF stellen]
 set JobMgr_Debug=OFF
 REM -- JobScriptParametersExtended:
 REM    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen leer
 REM             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt auch leer ist
 #JobScriptParametersExtended#

 REM Disk Connect [default=OFF]
 set JobMgr_use_DiskConnect=OFF

 REM -- #Step: Farbe setzen IsIdel
 call :ColorSet IsIdel

 REM -- Rootpfade setzen -------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 REM -- JobServer Variablen ----------------------------------------------------
 set JobManagerRoot_DP=#00-ApplRoot_DP#
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#

 REM -- JobData ----------------------------------------------------------------
 set JobScripts_DP=#10-JobScripts_DP#
 set JobScripts_Template_DP=#10-JobScripts_Template_DP#
 set JobName=#JobName#
 set JobPacket_NE=#JobPacket_NE#
 set JobParameter=#JobParameter#

 set DataRoot_CustomWorkInst_DP=#DataRoot_CustomWorkInst_DP#

 REM -- uebergabe SiteDef ------------------------------------------------------
 set TcSiteId=#TcSiteId#

 set title_str=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %title_str%

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
  Banner Test:%JobMgr_Test%
 :JumbOver

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo #Debug: --  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Debug:%JobMgr_Debug%
   Echo #Debug: --  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Echo #Debug....: Start Explorer
   Echo #Debug....: JobDir.: [%CmdCurRoot_DP%]
   start "" Explorer "%CmdCurRoot_DP%"
   Echo #Debug: --  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
:JumbOver

 if "%JobMgr_use_DiskConnect%" neq "ON" goto :jumbOverDiskConnect
  REM -- #Opt: connect Disk's
  REM Netzwerklaufwerke richtig verbinden
  set ConnectNetUnc_to_Info=S: \\MyServer\ugsshare
  call ConnectNetUnc.cmd "PLMShare" S: \\MySerrver\PLMShare . . PLMshare_DiskConnectOk
  Echo Connect Disk:%ConnectNetUnc_to_Info% Status:"%PLMshare_DiskConnectOk%"
  if /I not "%PLMshare_DiskConnectOk%" equ "OK" goto :PLMShare_NetConnectERR
:jumbOverDiskConnect


 set PLMPerf_Custom_DP=\\w3\ugsshare\kba_custom_v4\applications_prod\JobManagerV2\05-PLMPerf.Custom

 if not defined PLMPerfViaTaskPlaner set PLMPerfViaTaskPlaner=OFF
 echo PLMPerfViaTaskPlaner: %PLMPerfViaTaskPlaner%

 if /i "%PLMPerfViaTaskPlaner%" equ "ON" (

 REM these settings will be used when running via Taskmanager
 REM do the config in file PLMPerf_for_TaskPlaner.cmd
   call :PLMPerfSetParameter %~1 %~2 %~3 %~4 %~5 %~6 %~7 %~8 %~9
   goto :eof
 ) else (

 REM these settings will be used when running via JobManager
 REM do the config rigth here
 REM for 4tier you have to set the variable  UGII_UGMGR_HTTP_URL
 REM if /i "%ComputerName%" equ "#ComputerName#" call :PLMPerfSetParameter  #ImportConfigName#  #UserCount_Custom#  #MailToUserIfValueGT#  #UGII_UGMGR_HTTP_URL#  #FMS_fccCache_Clear_DO#

    if /i "%ComputerName%" equ "WTCAD112227" call :PLMPerfSetParameter  "NX10_29-WueTc10k-2tier_clc"  "NO"  ""  ""  "ON"
    if /i "%ComputerName%" equ "WTCAD112227" call :PLMPerfSetParameter  "NX10_26-WueTc10k-2tier"  "NO"  ""  ""  ""
    if /i "%ComputerName%" equ "WTCAD112227" call :PLMPerfSetParameter  "NX10_27-WueTc10k-4tier"  "NO"  ""  "http://w515.wue.kba.ag:8085/tc/aiws/aiwebservice"  ""
    if /i "%ComputerName%" equ "WTCAD112227" call :PLMPerfSetParameter  "NX10_31-WueTc10k-4tier_clc"  "NO"  ""  "http://w515.wue.kba.ag:8085/tc/aiws/aiwebservice"  "ON"
    if /i "%ComputerName%" equ "RTCAD112156" call :PLMPerfSetParameter  "NX10_30-RbTc10k-4tier_clc"  "NO"  ""  "http://w515.wue.kba.ag:8285/tc/aiws/aiwebservice"  "ON"
    if /i "%ComputerName%" equ "RTCAD112156" call :PLMPerfSetParameter  "NX10_28-RbTc10k-4tier"  "NO"  ""  "http://w515.wue.kba.ag:8285/tc/aiws/aiwebservice"  ""

    exit
 )



:PLMPerfSetParameter

setlocal

 set ImportConfigName=%~1
 set UserCount_Custom=%~2
 set MailToUserIfValueGT=%~3
 set UGII_UGMGR_HTTP_URL=%~4
 set FMS_fccCache_Clear_DO=%~5
 if /i "%PLMPerfViaTaskPlaner%" equ "ON" (
   set TcSiteId=%~6
   set JobMgr_TcUser=%~7
   set JobMgr_TcPw=%~8
   set ObjectCliName=%~9
 )

 Echo ImportConfigName....: %ImportConfigName%
 Echo UserCount_Custom....: %UserCount_Custom%
 Echo MailToUserIfValueGT.: %MailToUserIfValueGT%
 Echo UGII_UGMGR_HTTP_URL.: %UGII_UGMGR_HTTP_URL%
 if /i "%PLMPerfViaTaskPlaner%" equ "ON" (
   Echo TcSiteId............: %TcSiteId%
   Echo JobMgr_TcUser.......: %JobMgr_TcUser%
   Echo JobMgr_TcPw.........: %JobMgr_TcPw%
   Echo ObjectCliName.......: %ObjectCliName%
 )


 REM -- temp dir Organiesieren -------------------------------------------------
 set tempOrig_DP=%temp%

 Echo --------------------------------------------------------------------------
 Echo Info: Executing TcPrompt to get "Tc-Environment"


 REM #Doc: der nachfolgende Block kann als alternative verwendet werden
 REM #Doc: wenn mehrere Sites mit unterschiedliche TC Prompts verwendet werden muessen

 if /i "%TcSiteId%" neq "tc10k" goto :JumbOver2
   set NXTitle=NX10 PLM Performance
   set NXMacroTemplate_PPNE=NXMacros\NX10_CloseAllParts.macro

   if not defined SPLM_SHR_DIR set SPLM_SHR_DIR=R:
   if not defined UGS_SHR_DIR if defined SPLM_SHR_DIR set UGS_SHR_DIR=%SPLM_SHR_DIR%
   if not defined UGS_SHR_DIR set UGS_SHR_DIR=R:
   set TcPromtCmd=%UGS_SHR_DIR%\start_apps\windows\start_nx100.bat

   if /i "%ComputerName:~,1%" equ "W" set TcPromtCmdOpt=de tc_prompt tc10k tc101 cl_wue
   if /i "%ComputerName:~,1%" equ "R" set TcPromtCmdOpt=de tc_prompt tc10k tc101 cl_rb

REM   set JAVA_HOME=R:\splmshare\common\appl\Java\jre7
REM   set FMS_HOME=R:\splmshare\tcprod\appl\tc101\tccs
:JumbOver2

 if "%JobMgr_Debug%" equ "ON" (
  Echo - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Echo ##Debug.......: [%0]
  Echo befor excuting:
  Echo TCPromtCmd....: %TCPromtCmd%
  Echo TcPromtOpt....: %TCPromtCmdOpt%
  Echo Values:
  Echo FMS_HOME......: %FMS_HOME%
  Echo UGII_ROOT_DIR.: %UGII_ROOT_DIR%
  Echo TC_ROOT.......: %TC_ROOT%
  Echo TC_DATA.......: %TC_DATA%
  Echo - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  pause
 )

 if     exist "%TcPromtCmd%" call "%TcPromtCmd%" %TcPromtCmdOpt%
 if not exist "%TcPromtCmd%" goto :TcPromtCmdError


 REM -- define Load_options and user dpv ---------------------------------------
 set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\startup\load_options.def
 SET UGII_LOCAL_USER_DEFAULTS=%CmdCurRoot_DP%\startup\PLMPerfClient.dpv


 set Job_UGII_SITE_DIR=%CmdCurRoot_DP%\..\PLMPerfSettingL
 robocopy /e /mir /r:2 /w:1 "%UGII_SITE_DIR%" "%Job_UGII_SITE_DIR%" /xf *.men
 rem del /s "%Job_UGII_SITE_DIR%\*.men"
 set UGII_SITE_DIR=%Job_UGII_SITE_DIR%
 set UGII_USER_DIR=%CmdCurRoot_DP%
 set UGII_GROUP_DIR=


 REM -- set UGII_UGMGR_COMMUNICATIONif 4tier mode ------------------------------
 if /I "%UGII_UGMGR_HTTP_URL%" equ "" (
  set UGII_UGMGR_COMMUNICATION=
 ) else (
  set UGII_UGMGR_COMMUNICATION=HTTP
 )


 REM STEP -- SET Nc Tc Env for process
 set time_user_events=yes

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
  Echo #Debug:
  Echo after excuting:
  Echo TcPromtCmd....: [%TcPromtCmd%]
  Echo TcPromtCmdOpt.: [%TcPromtCmdOpt%]
  Echo FMS_HOME......: [%FMS_HOME%]
  pause
:JumbOver

:StartNxMacroExecute
 REM -- PathVariable erweitern
 set path=%CmdCurRoot_DP%;%BinPublic_Custom_DP%;%BinPublic_ClientServer_DP%;%BinPublic_DP%;%Path%

 rem if *__MaxSEC = 0 then process Wait allways = Never stopps searching for titel
 set NXFindCondition10_TitlesNoPart=%NXTitle%;%NXTitle% -;%NXTitle% - [Kein Teil]
 set NXFindCondition10_TitlesNoPart_MaxSEC=0
 set NXFindCondition20_TitleLike=%NXTitle%*
 set NXFindCondition20_TitleLike_MaxSEC=0
 set NXMacroTemplate_DPNE=%CmdCurRoot_DP%\%NXMacroTemplate_PPNE%
 set NXMacroRuns_MaxSEC=0
 set NXAfterAction_WaitTime_Msec=2000


 Call "%CmdCurRoot_DP%\NxPLMPerfClientV2Execute.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
  Banner Test:End
  Echo #TestMode ---------------------------------------------------------------
  Echo #TestMode.........: End of Test
  Echo JobName...........: [%JobName%]
  Echo RfPrgExitCode.....: [%RfPrgExitCode%]
  Echo -------------------------------------------------------------------------
  pause
:JumbOver

endlocal

goto :end


REM ###### ------------ Standard Subroutines ---------------------- ##########
REM ============================================================================
:TcPromtCmdError
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_MissingTcPromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start refile on:\\%ComputerName% missing TcPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TcPromtCmd:=%TcPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_Debug%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
 goto :end


REM ============================================================================
:ErrLogHeaderWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ErrLogFooterWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo.>>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
 Echo.>>"%ErrLog_DPNE%"
 Echo -- Path Environ ---------------------------------------------------------->>"%ErrLog_DPNE%"
 set PATH>>"%ErrLog_DPNE%"

 Echo -- UG* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set UG>>"%ErrLog_DPNE%"
 Echo -- IMAN* Environ --------------------------------------------------------->>"%ErrLog_DPNE%"
 set IMAN>>"%ErrLog_DPNE%"
 Echo -- All Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set>>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ColorSet
Rem Stand 25.06.2011
Rem Examples:
 REM call :ColorSet Standard
 REM call :ColorSet IsExecuting
 REM call :ColorSet IsIdel
 REM call :ColorSet End
 REM call :ColorSet Ende
 REM call :ColorSet Ok
 REM call :ColorSet Err

 REM -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei
 REM -- Farben nach Status setzen
 REM Gelb Schwarz
 if /I "%~1" equ "Standard"    set JobColorLast=E0
 REM 25.06.2011 07:00 Standard eingef. IsExecuting Neu
 if /I "%~1" equ "IsExecuting" set JobColorLast=D0
 REM Blaugrn Schwarz 15.11.2010 07:45 Hellgrau Schwarz
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 REM Hellgrau Schwarz
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 REM Gruen Schwarz
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 REM Rot Schwarz
 if /I "%~1" equ "Err"         set JobColorLast=C0

 REM jetzt die Farbe setzen
 if "%JobColorLast%" neq "" color %JobColorLast%
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
  Echo Description    : %FileDescription%
  Echo Contens of File: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo Info...........: File not exist
 endlocal
 goto :eof

REM ============================================================================
:Wait
 set waitTime=2
 if "%1" neq "" set waitTime=%1
 CHOICE.exe /C:w /N /T:w,%waitTime% "warte %waitTime%[sec] oder [w] druecken fuer weiter: "
 goto :eof

REM ============================================================================
:PLMShare_NetConnectERR
 set ErrLog_DPNE=%temp%\_PLMShare_NetConnect_ERR.txt
 REM schreibt die erweiterten Infos an einen ErrLogFile
 Echo Err: erf. Netzwerkverb. fuer: %TcSiteId% [%ConnectNetUnc_to_Info%] konnte nicht richtig verbunden werden!!>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 type "%ErrLog_DPNE%"
 Echo !!Einstellungen oder Netzwerkverbindungen pruefen!!
 cmd 
 Pause
 goto :eof

REM ============================================================================
:end
 cd /d "%tempOrig_DP%"
 Echo --------------------------------------------------------------------------
 Echo Info: all files in: [%temp%]
 Echo       will be zipt by JobClient and send to JobServer
 REM -- farbe wieder auf standard zurueck setzen
 Call :ColorSet End
