rem ----------------------------------------------------------------------------
rem !! Step Export !!
rem ----------------------------------------------------------------------------
:Step214UGExport

 setlocal
  rem P1 = ExportControlListIn_DPNE
  set ExportControlListIn_DPNE=%1
  set ExportControlListIn_DPNE=%ExportControlListIn_DPNE:~1,-1%
  rem P2 = ExportType uebernehmen
  set ExpoSpApType=%2

  set CurActionTitle=Step214UGExport[%ExpoSpApType%]
  rem Printausgabe
  Call Echo  "%CurActionTitle% start"

  set StepExpo_DP=%temp%\_StepExpo
  if not exist "%StepExpo_DP%" md "%StepExpo_DP%"
  set temp=%StepExpo_DP%

  set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

  rem Step Dateien exportieren lassen
  FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do call :Step214UGExportDoRun "%%i"

  rem Liste der Exportierten Daten mitschreiben
  Dir /N /O:n "%StepExpo_DP%\*.stp">>"%toRunInfo_DPNE%" 2>nul

  rem Exportierte Step Dateien in die Zielverzeichnisse uebertragen Info:hier werden auch die Ergebnisse erstellt
  FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do call :StepExport_MovePartToArchiv "%%i"

  rem Printausgabe
  Call Echo  "%CurActionTitle% end"

 endlocal
 goto :eof

rem ---------------------------------------------------------------------------------
:Step214UGExportDoRun
   rem erzeut einen StepFile
  setlocal

   Call :DataSetSplit %1

   rem entfernt einen bereits laufenden ApiServerProzess
   call "%BinPublic_DP%\ApiServerKill.cmd"

   rem NX Umgebung einstellen
   call :NxSetEnvironForExport

   rem toRun .. fuer UG to Step zusammensetzen
   set StepDef_DPNE=%CurCmdRoot_DP%\ugstep214.def
   Call :StepExportSetFileNames
   rem Beispiel: "D:\UGS\UGNX4\step214ug\step214ug.cmd" "@DB/000204/A" o="C:\TEMP\000204_A.stp" l="C:\TEMP\000204_000\000204_A.log" d="D:\UGS\UGNX4\STEP214UG\ugstep214.def"
   rem STEP203UG bzw STEP214UG unterscheiden sich bezglich der Exportierten Geometrie 3D und Draht Geometrie
   set toRun=call "%UGII_BASE_DIR%\STEP214UG\step214ug.cmd" "%IrCli%"
   set JobParameter=o="%StepExpoFile_DPNE%"
   set JobParameter=%JobParameter% l="%StepExpoLog_DPNE%"
   set JobParameter=%JobParameter% d="%StepDef_DPNE%"
   set JobParameter=%JobParameter% -pim=yes -u=%TceUser% -p=%TceUserPassword%

   rem command vollstndig zusammensetzen
   set toRun=%toRun% %JobParameter%
   echo %toRun%>>%toRunInfo_DPNE%
   rem echo %0
   %toRun%
  endlocal

 goto :eof

rem ---------------------------------------------------------------------------------
:StepExportSetFileNames
   rem setzt die StepExpoFile Namen zusammen Info: es werden die aktuell gesetzten %ItemName%_%RevName% var's verwendet
   set StepFile_NE=%ItemNameNoBlanks%_%RevNameNoBlanks%.stp
   set StepExpoFile_DPNE=%StepExpo_DP%\%StepFile_NE%
   set StepExpoLog_DPNE=%StepExpo_DP%\%ItemNameNoBlanks%_%RevNameNoBlanks%_stp_gen.log
 goto :eof


:StepExport_MovePartToArchiv

  rem schiebt die exportierte Step Datei in das Zielverzeichnis
  setlocal

   call :DataSetSplit %1
   call :StepExportSetFileNames

   if     exist "%StepExpoFile_DPNE%" goto :StepFile_MoveToArchiv
   if not exist "%StepExpoFile_DPNE%" goto :StepFileExportRun_StepFileExpoErr

   :StepFile_MoveToArchiv

    rem Zielverzeichnis des StepFile Files
    call :ExportFileDest_DP_gen StepFile_Dest_DP PrtDest_DP

    rem ## Zieldateiname des StepFile Files evtl mit %ExpoSpApType%
    rem set StepFile_Dest_NE=%ItemNameNoBlanks%_%RevNameNoBlanks%_%ExpoSpApType%.stp
    set StepFile_Dest_NE=%ItemNameNoBlanks%_%RevNameNoBlanks%.stp
    set StepFile_Dest_DPNE=%StepFile_Dest_DP%\%StepFile_Dest_NE%

    rem Zielverzeichnis erzeugen
    if not exist "%StepFile_Dest_DP%" md "%StepFile_Dest_DP%">>"%toRunInfo_DPNE%"
    set StepFileExpoErrLevel=%errorlevel%
    if not exist "%StepFile_Dest_DP%" goto :StepFileExportRun_CreatePathErr

    rem StepFile Datei in das Verzeichnis verschieben
    Echo moving: Exported StepFile File [%ItemName%/%RevName%]
    Echo from: %StepExpoFile_DPNE%
    Echo   to: %StepFile_Dest_DPNE%

    move /Y "%StepExpoFile_DPNE%" "%StepFile_Dest_DPNE%">>"%toRunInfo_DPNE%"
    set StepFileExpoErrLevel=%errorlevel%

    if not "%StepFileExpoErrLevel%"=="0" goto :StepFile_MoveToArchivErr
    if     exist "%StepFile_Dest_DPNE%"  goto :StepFile_MoveToArchivOK
    if not exist "%StepFile_Dest_DPNE%"  goto :StepFile_MoveToArchivErr

    :StepFile_MoveToArchivOK
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=Step-Expo:OK %StepFile_Dest_DPNE%
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "%ResultText%" "" %ItemName% %RevName%
     goto :StepFile_MoveToArchivEnde

    :StepFileExportRun_StepFileExpoErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=Step-Expo:Err StepFile file:[%StepFile_NE%] cound not be exported
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "100" "%ResultText%" "" %ItemName% %RevName%
     goto :StepFile_MoveToArchivEnde

    :StepFileExportRun_CreatePathErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=Step-Expo:Err [OS:%StepFileExpoErrLevel%] user %userName% creating path [%StepFile_Dest_DP%]
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "110" "%ResultText%" "" %ItemName% %RevName%
     goto :StepFile_MoveToArchivEnde

    :StepFile_MoveToArchivErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=Step-Expo:Err [OS:%StepFileExpoErrLevel%] moving part to:[%StepFile_Dest_DPNE%]
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "120" "%ResultText%" "" %ItemName% %RevName%
     goto :StepFile_MoveToArchivEnde

   :StepFile_MoveToArchivEnde

  endlocal
 goto :eof
